package jp.mosp.payroll.bonus.dao;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.payroll.bonus.BonusConst;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.bonus.dto.PhBasisDto;
import jp.mosp.common.common.MospException;

public class PhBasisDao extends PayrollDao {
	
	// e[uyуL[
	public static final String TABLE = "UH_BASIS";
	public static final String KEY_1 = "K_CODE"       ;	// ЈR[h
	public static final String KEY_2 = "EXPECTED_DATE";	// Kp\
	
	// 
	public static final String COL_K_CODE           = "K_CODE"          ;	// ЈR[h
	public static final String COL_EXPECTED_DATE    = "EXPECTED_DATE"   ;	// Kp\
	public static final String COL_APPLIED_DATE     = "APPLIED_DATE"    ;	// Kp
	public static final String COL_K_NAME           = "K_NAME"          ;	// Ј
	public static final String COL_K_KANA           = "K_KANA"          ;	// Јض
	public static final String COL_STATION_CODE     = "STATION_CODE"    ;	// R[h
	public static final String COL_POSITION_CODE    = "POSITION_CODE"   ;	// EʃR[h
	public static final String COL_EMPLOYMENT_TYPE  = "EMPLOYMENT_TYPE" ;	// ٗp敪
	public static final String COL_ENTRANCE_DATE    = "ENTRANCE_DATE"   ;	// Г
	public static final String COL_APPOINTMENT_DATE = "APPOINTMENT_DATE";	// op
	public static final String COL_RETIREMENT_DATE  = "RETIREMENT_DATE" ;	// ގГ
	
	/**
	 * RXgN^
	 */
	public PhBasisDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<PhBasisDto> mappingAll() throws SQLException {
		List<PhBasisDto> all = new ArrayList<PhBasisDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return PhBasisDto UhBasisR[h
	 * @throws SQLException
	 */
	private PhBasisDto mapping() throws SQLException {
		PhBasisDto dto = new PhBasisDto();
		dto.setKCode          (rs.getString(COL_K_CODE          ));	// ЈR[h
		dto.setExpectedDate   (rs.getDate  (COL_EXPECTED_DATE   ));	// Kp\
		dto.setAppliedDate    (rs.getDate  (COL_APPLIED_DATE    ));	// Kp
		dto.setKName          (rs.getString(COL_K_NAME          ));	// Ј
		dto.setKKana          (rs.getString(COL_K_KANA          ));	// Јض
		dto.setStationCode    (rs.getString(COL_STATION_CODE    ));	// R[h
		dto.setPositionCode   (rs.getString(COL_POSITION_CODE   ));	// EʃR[h
		dto.setEmploymentType (rs.getString(COL_EMPLOYMENT_TYPE ));	// ٗp敪
		dto.setEntranceDate   (rs.getDate  (COL_ENTRANCE_DATE   ));	// Г
		dto.setAppointmentDate(rs.getDate  (COL_APPOINTMENT_DATE));	// op
		dto.setRetirementDate (rs.getDate  (COL_RETIREMENT_DATE ));	// ގГ
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PhBasisDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<PhBasisDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @param expectedDate KpN(L[)
	 * @return PhBasisDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PhBasisDto findForKey(
			String  kCode, Date expectedDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, expectedDate);
			executeQuery();
			PhBasisDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ЈR[hf[^擾
	 * @param kCode ЈR[h(L[)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PhBasisDto> findForEmployeeData(
			String  kCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(Αӓ-Јꗗp)
	 * @param kCode       ЈR[h
	 * @param kName       Ј
	 * @param stationCode R[h
	 * @param selfKCode   ЈR[h
	 * @param datalevel   Јf[^x
	 * @param startDate   ЈWvJn
	 * @param endDate     ЈWvI
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 */
	public List<PhBasisDto> findForCondition(
			String kCode,
			String kName,
			String stationCode,
			String selfKCode,
			int    dataLevel,
			Date   startDate,
			Date   endDate
	) throws SQLException, IllegalAccessException {
		index = 1;
		try {
			prepareStatement(getQueryForEmployeeSelect());
			// UH_BASISpt
			setParam(index++, endDate);
			// UH_BASIS
			setParam(index++, kCode + "%");
			setParam(index++, "%" + kName + "%");
			setParam(index++, selfKCode);
			setParam(index++, stationCode);
			setParam(index++, stationCode);
			setParam(index++, dataLevel);
			setParam(index++, stationCode);
			setParam(index++, selfKCode);
			setParam(index++, stationCode);
			setParam(index++, startDate);
			setParam(index++, endDate);
			setParam(index++, startDate);
			setParam(index++, endDate);
			setParam(index++, dataLevel);
			setParam(index++, startDate);
			// s
			executeQuery();
			List<PhBasisDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Nɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @param expectedDate KpN(L[)
	 * @return PhBasisDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PhBasisDto findForDate(
			String  kCode, Date expectedDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append("AND ");
			sb.append(COL_EXPECTED_DATE + " = (");
			sb.append("SELECT MAX(" + COL_EXPECTED_DATE + ") ");
			sb.append("FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append("AND ");
			sb.append(COL_EXPECTED_DATE + " <= ? ");
			sb.append("AND ");
			sb.append(COL_APPLIED_DATE + " IS NOT NULL ");
			sb.append(")");
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			setParam(index++, kCode);
			setParam(index++, expectedDate);
			executeQuery();
			PhBasisDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Nɂf[^擾(Eؖp)
	 * @param kCode ЈR[h(L[)
	 * @param expectedDate KpN(L[)
	 * @return PhBasisDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PhBasisDto> findForLeveJob(
			String  kCode, Date expectedDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append("AND ");
			sb.append(COL_EXPECTED_DATE + " = (");
			sb.append("SELECT MAX(" + COL_EXPECTED_DATE + ") ");
			sb.append("FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append("AND ");
			sb.append(COL_EXPECTED_DATE + " <= ? ");
			sb.append("AND ");
			sb.append(COL_APPLIED_DATE + " IS NOT NULL ");
			sb.append(")");
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			setParam(index++, kCode);
			setParam(index++, expectedDate);
			executeQuery();
			List<PhBasisDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ЈR[hɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PhBasisDto> findForEmployeeAll(
			String kCode
	) throws SQLException, NoSuchFieldException, IllegalAccessException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append("AND ");
			sb.append(COL_APPLIED_DATE + " IS NOT NULL ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ЈR[hɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @return PhBasisDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PhBasisDto findForEmployee(
			String  kCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append("AND ");
			sb.append(COL_EXPECTED_DATE + " = (");
			sb.append("SELECT MAX(" + COL_EXPECTED_DATE + ") ");
			sb.append("FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append("AND ");
			sb.append(COL_APPLIED_DATE + " IS NOT NULL ");
			sb.append(")");
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			setParam(index++, kCode);
			executeQuery();
			PhBasisDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ЈR[hɂ関Kpf[^擾
	 * @param kCode       ЈR[h(L[)
	 * @param isForUpdate UPDATEptO
	 * @return PhBasisDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PhBasisDto findForEmployeeNotApplied(
			String  kCode,
			boolean isForUpdate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append("AND ");
			sb.append(COL_APPLIED_DATE  + " IS NULL ");
			if (isForUpdate) {
				sb.append(getForUpdate());
			}
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			executeQuery();
			PhBasisDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ЈR[hɂKpf[^擾(Kp\)
	 * @param kCode        ЈR[h(L[)
	 * @param expectedDate Kp\(L[)
	 * @return PhBasisDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PhBasisDto findForEmployeeApplied(
			String kCode,
			Date   expectedDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append("AND ");
			sb.append(COL_EXPECTED_DATE + " >= ? ");
			sb.append("AND ");
			sb.append(COL_APPLIED_DATE  + " IS NOT NULL ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			setParam(index++, expectedDate);
			executeQuery();
			PhBasisDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param kCode        ЈR[h(L[)
	 * @param expectedDate Kp\(L[)
	 * @return PhBasisDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PhBasisDto findForUpdate(
			String kCode,
			Date   expectedDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kCode);
			setParam(index++, expectedDate);
			executeQuery();
			PhBasisDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(R[h)(Wvp)
	 * @param stationCode R[h
	 * @param startDate   ΏۏWvJn
	 * @param endDate     ΏۏWvŏI
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 */
	public List<PhBasisDto> findForTotal(
			String stationCode,
			Date   startDate,
			Date   endDate
	) throws SQLException, IllegalAccessException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("FROM ");
		sb.append(getHistoryTable());
		sb.append("WHERE ");
		if (stationCode != null && !stationCode.equals("")) {
			sb.append(COL_STATION_CODE + " IN (");
			sb.append(PmStationDao.getStationQuery());
			sb.append(") ");
			sb.append("AND ");
		}
		sb.append(getSearchEmployeeStatement());
		try {
			prepareStatement(getSelectStatement(getClass()) + sb.toString() + getOrderForPosition());
			setParam(index++, endDate);
			if (stationCode != null && !stationCode.equals("")) {
				setParam(index++, stationCode);
			}
			setParam(index++, startDate);
			executeQuery();
			List<PhBasisDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(f[^ꗗp)
	 * @param stationCode R[h
	 * @param startDate   ΏۏWvJn
	 * @param endDate     ΏۏWvŏI
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 */
	public String findForDataLineUp(
			String stationCode
	) throws  IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(" * ");
		sb.append("FROM ");
		sb.append(getHistoryTable());
		sb.append("WHERE ");
		if (stationCode != null && !stationCode.equals("")) {
			sb.append(COL_STATION_CODE + " IN (");
			sb.append(PmStationDao.getStationQuery());
			sb.append(") ");
			sb.append("AND ");
		}
		sb.append(getSearchEmployeeStatement());
		
		return sb.toString();

	}
	
	/**
	 * ɂf[^擾(NvZp)
	 * @param startDate   Ώ۔NJn
	 * @param endDate     Ώ۔NŏI
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws SQLException 
	 */
	public List<PhBasisDto> findForAdjustData(
			Date startDate,
			Date lastDate
	) throws  IllegalAccessException, SQLException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(" * ");
		sb.append("FROM ");
		sb.append(getHistoryTable());
		sb.append("WHERE ");
		sb.append(COL_ENTRANCE_DATE + " <= ?");
		sb.append(" AND ");
		sb.append(COL_RETIREMENT_DATE + " >= ?");
		sb.append(" OR ");
		sb.append(COL_RETIREMENT_DATE + " IS NULL");
		try {
			prepareStatement(sb.toString());
			setParam(index++, lastDate);
			setParam(index++, lastDate);
			setParam(index++, startDate);
			executeQuery();
			List<PhBasisDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(NvZp(l))
	 * @param kCode       ЈR[h
	 * @param startDate   Ώ۔NJn
	 * @param endDate     Ώ۔NŏI
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws SQLException 
	 */
	public PhBasisDto findForAdjustEmpData(
			String kCode,
			Date startDate,
			Date lastDate
	) throws  IllegalAccessException, SQLException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(" * ");
		sb.append("FROM ");
		sb.append(getHistoryEmpTable());
		sb.append("WHERE ");
		sb.append(COL_ENTRANCE_DATE + " <= ?");
		sb.append(" AND ");
		sb.append(COL_RETIREMENT_DATE + " >= ?");
		sb.append(" OR ");
		sb.append(COL_RETIREMENT_DATE + " IS NULL");
		try {
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			setParam(index++, lastDate);
			setParam(index++, lastDate);
			setParam(index++, startDate);
			executeQuery();
			PhBasisDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	

	/**
	 * ɂf[^擾(R[h)(Ζf[^p)
	 * @param stationCode R[h
	 * @param startDate   ΏۏWvJn
	 * @param endDate     ΏۏWvŏI
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 */
	public List<PhBasisDto> findForReport(
			String stationCode,
			Date   startDate,
			Date   endDate
	) throws SQLException, IllegalAccessException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("FROM ");
		sb.append(getHistoryTable());
		sb.append("WHERE ");
		sb.append("(");
		sb.append(COL_STATION_CODE + " IN ");
		sb.append("(");
		sb.append(PmStationDao.getStationQuery());
		sb.append(") ");
		sb.append("OR ");
		sb.append(COL_K_CODE + " IN ");
		sb.append("(");
		sb.append(PtSupportDao.getTermSupportQuery());		
		sb.append(") ");
		sb.append(") ");
		sb.append("AND ");
		sb.append(getSearchEmployeeStatement());
		try {
			prepareStatement(getSelectStatement(getClass()) + sb.toString() + getOrderForPosition());
			setParam(index++, endDate);
			setParam(index++, stationCode);
			setParam(index++, stationCode);
			setParam(index++, startDate);
			setParam(index++, endDate);
			setParam(index++, startDate);
			setParam(index++, endDate);
			setParam(index++, startDate);
			executeQuery();
			List<PhBasisDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(R[h)(Ў)
	 * @param stationCode R[h
	 * @param startDate   ΏۏWvJn
	 * @param endDate     ΏۏWvŏI
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 */
	public List<PhBasisDto> findForFlesh(
			String stationCode,
			Date   startDate,
			Date   endDate
	) throws SQLException, IllegalAccessException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("FROM ");
		sb.append(getHistoryTable());
		sb.append("WHERE ");
		if (stationCode != null && !stationCode.equals("")) {
			sb.append(COL_STATION_CODE + " IN (");
			sb.append(PmStationDao.getStationQuery());
			sb.append(") ");
			sb.append("AND ");
		}
		sb.append(getSearchEmployeeStatement());
		sb.append("AND ");
		sb.append(getSearchFleshStatement());
		try {
			prepareStatement(getSelectStatement(getClass()) + sb.toString() + getOrderForPosition());
			setParam(index++, endDate);
			if (stationCode != null && !stationCode.equals("")) {
				setParam(index++, stationCode);
			}
			setParam(index++, startDate);
			setParam(index++, startDate);
			setParam(index++, endDate  );
			executeQuery();
			List<PhBasisDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(R[h)(ސE)
	 * @param stationCode R[h
	 * @param startDate   ΏۏWvJn
	 * @param endDate     ΏۏWvŏI
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 */
	public List<PhBasisDto> findForRetire(
			String stationCode,
			Date   startDate,
			Date   endDate
	) throws SQLException, IllegalAccessException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("FROM ");
		sb.append(getHistoryTable());
		sb.append("WHERE ");
		if (stationCode != null && !stationCode.equals("")) {
			sb.append(COL_STATION_CODE + " IN (");
			sb.append(PmStationDao.getStationQuery());
			sb.append(") ");
			sb.append("AND ");
		}
		sb.append(getSearchRetireStatement());
		try {
			prepareStatement(getSelectStatement(getClass()) + sb.toString() + getOrderForPosition());
			setParam(index++, endDate);
			if (stationCode != null && !stationCode.equals("")) {
				setParam(index++, stationCode);
			}
			setParam(index++, startDate);
			setParam(index++, endDate  );
			executeQuery();
			List<PhBasisDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(R[h)(ҁAIp)
	 * @param kCode          ЈR[h({lp)
	 * @param stationCode    R[h
	 * @param attendanceDate Ώۓt(ސEҏp)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 */
	public List<PhBasisDto> findForFellow(
			String kCode,
			String stationCode,
			Date   attendanceDate
	) throws SQLException, IllegalAccessException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("FROM ");
		sb.append(getHistoryTable());
		sb.append("WHERE (");
		sb.append(COL_STATION_CODE + " IN (");
		sb.append(PmStationDao.getStationQuery());
		sb.append(") OR ");
		sb.append(COL_K_CODE + " IN (");
		sb.append(PtSupportDao.getSupportQuery());
		sb.append(")) AND ");
		sb.append(getSearchEmployeeStatement());
		sb.append("AND ");
		sb.append(COL_K_CODE + " <> ? ");
		try {
			prepareStatement(getSelectStatement(getClass()) + sb.toString() + getOrderForPosition());
			setParam(index++, attendanceDate);
			setParam(index++, stationCode);
			setParam(index++, stationCode);
			setParam(index++, attendanceDate);
			setParam(index++, attendanceDate);
			setParam(index++, attendanceDate);
			setParam(index++, kCode);
			executeQuery();
			List<PhBasisDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(sp)
	 * @param stationCode R[h
	 * @param targetDate  Ώۓ
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 */
	public List<PhBasisDto> findForIncompatibility(
			String stationCode,
			Date   targetDate
	) throws SQLException, IllegalAccessException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("FROM ");
			sb.append(getHistoryTable());
			sb.append("WHERE (");
			sb.append(COL_STATION_CODE + " IN (");
			sb.append(PmStationDao.getStationQuery());
			sb.append(") OR ");
			sb.append(COL_K_CODE + " IN (");
			sb.append(PtSupportDao.getSupportQuery());
			sb.append(")) AND ");
			sb.append(getSearchEmployeeStatement());
			prepareStatement(getSelectStatement(getClass()) + sb.toString());
			setParam(index++, targetDate);
			setParam(index++, stationCode);
			setParam(index++, stationCode);
			setParam(index++, targetDate);
			setParam(index++, targetDate);
			setParam(index++, targetDate);
			executeQuery();
			List<PhBasisDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾(l{Kpʗp)
	 * @param expectedDate   Kp\
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PhBasisDto> findForHistoryList(
			Date expectedDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_EXPECTED_DATE + " <= ? ");
			sb.append("AND ");
			sb.append(COL_APPLIED_DATE + " IS NULL ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, expectedDate);
			executeQuery();
			List<PhBasisDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(lo͗p)
	 * @param endDate        WvI
	 * @param retirementFlag ސEtO
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PhBasisDto> findForHumanData(
			Date   endDate,
			String retirementFlag
	) throws SQLException, IllegalAccessException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("FROM ");
			sb.append(getHistoryTable());
			if (retirementFlag != null && retirementFlag.equals(String.valueOf(BonusConst.RETIREMENT_FLAG_ON))) {
				sb.append("WHERE ");
				sb.append(COL_RETIREMENT_DATE + " <= ? ");
			} else if (retirementFlag != null && retirementFlag.equals(String.valueOf(BonusConst.RETIREMENT_FLAG_OFF))) {
				sb.append("WHERE ");
				sb.append(COL_RETIREMENT_DATE + " IS NULL ");
				sb.append("OR ");
				sb.append(COL_RETIREMENT_DATE + " > ? ");
			}
			prepareStatement(getSelectStatement(getClass()) + sb.toString());
			setParam(index++, endDate);
			if (retirementFlag != null && (
					retirementFlag.equals(String.valueOf(BonusConst.RETIREMENT_FLAG_ON)) ||
					retirementFlag.equals(String.valueOf(BonusConst.RETIREMENT_FLAG_OFF))
			)) {
				setParam(index++, endDate);
			}
			executeQuery();
			List<PhBasisDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
	/**
	 * ɂf[^擾(lo͗p)
	 * @param endDate        WvI
	 * @param retirementFlag ސEtO
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PhBasisDto> findForRetireHumanData(
			Date targetDate,
			Date startDate,
			Date endDate
	) throws SQLException, IllegalAccessException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("FROM ");
			sb.append(getHistoryTable());
			sb.append(" WHERE ");
			sb.append("(");
			sb.append(COL_RETIREMENT_DATE + "  >= ? ");
			sb.append(" AND ");
			sb.append(COL_RETIREMENT_DATE + " <= ? ");
			sb.append(") OR (");
			sb.append(COL_ENTRANCE_DATE + "  <= ? ");
			sb.append(" AND ");
			sb.append(COL_RETIREMENT_DATE + "  IS NULL ");
			sb.append(")");
			prepareStatement(getSelectStatement(getClass()) + sb.toString());
			setParam(index++, targetDate);
			setParam(index++, startDate);
			setParam(index++, endDate);
			setParam(index++, endDate);
			executeQuery();
			List<PhBasisDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(^vZ-ΑӊmFp)
	 * @param kCode          ЈR[h
	 * @param kName          Ј
	 * @param kKana          ض
	 * @param stationCode    R[h
	 * @param positionCode   EʃR[h
	 * @param retirementFlag ސEtO
	 * @param startDate      ΏۏWv
	 * @param endDate        ΏۏWvŏI
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException 
	 */
	public List<PhBasisDto> findForHumanList(
			String kCode,
			String kName,
			String kKana,
			String stationCode,
			String positionCode,
			String retirementFlag,
			Date   startDate,
			Date   endDate
	) throws SQLException, IllegalAccessException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("FROM ");
			sb.append(getHistoryTable());
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " LIKE ? ");
			sb.append("AND ");
			sb.append(COL_K_NAME + " LIKE ? ");
			sb.append("AND ");
			sb.append(COL_K_KANA + " LIKE ? ");
			if (stationCode != null && !stationCode.equals("")) {
				sb.append("AND ");
				sb.append(COL_STATION_CODE + " =  ? ");
			}
			if (positionCode != null && !positionCode.equals("")) {
				sb.append("AND ");
				sb.append(COL_POSITION_CODE + " = ? ");
			}
			if (retirementFlag != null && retirementFlag.equals(String.valueOf(BonusConst.RETIREMENT_FLAG_OFF))) {
				sb.append("AND (");
				sb.append(COL_RETIREMENT_DATE + " IS NULL ");
				sb.append("OR ");
				sb.append(COL_RETIREMENT_DATE + " >= ? ");
				sb.append(") ");
			} else if (retirementFlag != null && retirementFlag.equals(String.valueOf(BonusConst.RETIREMENT_FLAG_ON))) {
				sb.append("AND (");
				sb.append(COL_RETIREMENT_DATE + " IS NOT NULL ");
				sb.append("AND ");
				sb.append(COL_RETIREMENT_DATE + " < ? ");
				sb.append(") ");
			}
			prepareStatement(getSelectStatement(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, endDate);
			setParam(index++, kCode + "%");
			setParam(index++, "%" + kName + "%");
			setParam(index++, "%" + kKana + "%");
			if (stationCode != null && !stationCode.equals("")) {
				setParam(index++, stationCode);
			}
			if (positionCode != null && !positionCode.equals("")) {
				setParam(index++, positionCode);
			}
			if (retirementFlag != null && !retirementFlag.equals("")) {
				setParam(index++, startDate);
			}
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ЈR[hɂ関Kpf[^폜
	 * @param expectedDate Kp\
	 * @return List (DTOList)
	 * @throws SQLException
	 */
	public int deleteNotApplied(String kCode) throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append("AND ");
			sb.append(COL_APPLIED_DATE + " IS NULL ");
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(PhBasisDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(PhBasisDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getExpectedDate());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(PhBasisDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getExpectedDate());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^폜
	 * @param kCode 폜ΏێЈR[h
	 * @return int 폜()
	 * @throws SQLException
	 */
	public int deleteForEmployee(String kCode) throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(PhBasisDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode          ());	// ЈR[h
		setParam(index++, dto.getExpectedDate   ());	// Kp\
		setParam(index++, dto.getAppliedDate    ());	// Kp
		setParam(index++, dto.getKName          ());	// Ј
		setParam(index++, dto.getKKana          ());	// Јض
		setParam(index++, dto.getStationCode    ());	// R[h
		setParam(index++, dto.getPositionCode   ());	// EʃR[h
		setParam(index++, dto.getEmploymentType ());	// ٗp敪
		setParam(index++, dto.getEntranceDate   ());	// Г
		setParam(index++, dto.getAppointmentDate());	// Г
		setParam(index++, dto.getRetirementDate ());	// ގГ
		setCommonParams(isInsert);
	}
	
	/**
	 * Αӓ-ЈꗗpΏێЈR[hoSQL擾
	 * @return Αӓ-ЈꗗpΏێЈR[hoSQL
	 * @throws IllegalAccessException 
	 */
	public String getQueryForEmployeeSelect() throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		//sb.append("SELECT " + COL_K_CODE + " ");
		sb.append(getSelectStatement(getClass()));
		sb.append("FROM " + getHistoryTable() + " ");
		sb.append("WHERE ");
		sb.append(COL_K_CODE + " LIKE ? ");
		sb.append("AND ");
		sb.append(COL_K_NAME + " LIKE ? ");
		sb.append("AND ");
		sb.append("(");
		sb.append(	"(");	// 
		sb.append(		COL_K_CODE + " = ? ");
		sb.append(		"AND ");
		sb.append(		COL_STATION_CODE + " IN (" + PmStationDao.getStationQuery() + ") ");
		sb.append	(") ");
		sb.append(	"OR ");
		sb.append(	"(");	// +f[^x
		sb.append(		COL_STATION_CODE + " IN (" + PmStationDao.getStationQuery() + ") ");
		sb.append(		"AND ");
		sb.append(		COL_POSITION_CODE + " IN (" + PmPositionDao.getQueryForLowerLevel() + ") ");
		sb.append	(") ");
		sb.append(	"OR ");
		sb.append(	"(");	// +(Superior)
		sb.append(		COL_STATION_CODE + " IN (" + PmStationDao.getStationQuery() + ") ");
		sb.append(		"AND ");
		sb.append(		COL_K_CODE + " IN (" + PtSuperiorDao.getSuperiorQuery() + ") ");
		sb.append	(") ");
		sb.append(	"OR ");
		sb.append(	"(");	// x+f[^x
		sb.append(		COL_K_CODE + " IN (" + PtSupportDao.getTermSupportQuery() + ") ");
		sb.append(		"AND ");
		sb.append(		COL_POSITION_CODE + " IN (" + PmPositionDao.getQueryForLowerLevel() + ") ");
		sb.append	(")");
		sb.append(") ");
		sb.append("AND ");
		sb.append(getSearchEmployeeStatement());
		return sb.toString();
	}
	
	/**
	 * ΏێЈR[h擾SQL(ΑӕsmFp)
	 * @return ΏێЈR[h擾SQL
	 * @throws IllegalAccessException 
	 */
	public String getQueryForAttendance() throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT " + COL_K_CODE + " ");
		sb.append("FROM ");
		sb.append(getHistoryTable());
		sb.append("WHERE (");
		sb.append(COL_STATION_CODE + " IN (");
		sb.append(PmStationDao.getStationQuery());
		sb.append(") OR ");
		sb.append(COL_K_CODE + " IN (");
		sb.append(PtSupportDao.getSupportQuery());
		sb.append(")) AND ");
		sb.append(getSearchEmployeeStatement());
		return sb.toString();
	}

	/**
	 * f[^SQL擾
	 * @return f[^擾SQL
	 * @throws IllegalAccessException 
	 */
	public String getHistoryTable() throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append("(");
		sb.append(getSelectStatement(getClass()));
		sb.append("FROM ");
		sb.append(TABLE + ", ");
		sb.append("(");
		sb.append(	"SELECT ");
		sb.append(	COL_K_CODE + " AS H_K_CODE, ");
		sb.append(	"MAX(" + COL_EXPECTED_DATE + ") AS H_EXPECTED_DATE " );
		sb.append(	"FROM " + TABLE + " ");
		sb.append(	"WHERE ");
		sb.append(	COL_EXPECTED_DATE + " <= ? ");
		sb.append(	"AND ");
		sb.append(	COL_APPLIED_DATE + " IS NOT NULL ");
		sb.append(	"GROUP BY " + COL_K_CODE + " ");
		sb.append(") HISTORY ");
		sb.append("WHERE ");
		sb.append(COL_K_CODE + " = HISTORY.H_K_CODE ");
		sb.append("AND ");
		sb.append(COL_EXPECTED_DATE + " = HISTORY.H_EXPECTED_DATE");
		sb.append(") " + TABLE +" ");
		return sb.toString();
	}
	
	/**
	 * f[^SQL擾(Ј)
	 * @return f[^擾SQL
	 * @throws IllegalAccessException 
	 */
	public String getHistoryEmpTable() throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append("(");
		sb.append(getSelectStatement(getClass()));
		sb.append("FROM ");
		sb.append(TABLE + ", ");
		sb.append("(");
		sb.append(	"SELECT ");
		sb.append(	COL_K_CODE + " AS H_K_CODE, ");
		sb.append(	"MAX(" + COL_EXPECTED_DATE + ") AS H_EXPECTED_DATE " );
		sb.append(	"FROM " + TABLE + " ");
		sb.append(	"WHERE ");
		sb.append(	COL_K_CODE + " = ? ");
		sb.append(	"AND ");
		sb.append(	COL_EXPECTED_DATE + " <= ? ");
		sb.append(	"AND ");
		sb.append(	COL_APPLIED_DATE + " IS NOT NULL ");
		sb.append(	"GROUP BY " + COL_K_CODE + " ");
		sb.append(") HISTORY ");
		sb.append("WHERE ");
		sb.append(COL_K_CODE + " = HISTORY.H_K_CODE ");
		sb.append("AND ");
		sb.append(COL_EXPECTED_DATE + " = HISTORY.H_EXPECTED_DATE");
		sb.append(") " + TABLE +" ");
		return sb.toString();
	}
	
	/**
	 * ݐEҎ擾pSQL擾
	 * @return ݐEҎ擾pSQL
	 */
	private String getSearchEmployeeStatement() {
		StringBuffer sb = new StringBuffer();
		sb.append("(");
		sb.append(COL_RETIREMENT_DATE + " IS NULL ");
		sb.append("OR ");
		sb.append(COL_RETIREMENT_DATE + " >= ?");
		sb.append(") ");
		return sb.toString();
	}
	
	/**
	 * ݐEҎ擾pSQL擾
	 * @return ݐEҎ擾pSQL
	 */
	private String getSearchFleshStatement() {
		StringBuffer sb = new StringBuffer();
		sb.append("(");
		sb.append(COL_ENTRANCE_DATE + " >= ? ");
		sb.append("AND ");
		sb.append(COL_ENTRANCE_DATE + " <= ?");
		sb.append(") ");
		return sb.toString();
	}
	
	/**
	 * ݐEҎ擾pSQL擾
	 * @return ݐEҎ擾pSQL
	 */
	private String getSearchRetireStatement() {
		StringBuffer sb = new StringBuffer();
		sb.append("(");
		sb.append(COL_RETIREMENT_DATE + " >= ? ");
		sb.append("AND ");
		sb.append(COL_RETIREMENT_DATE + " <= ?");
		sb.append(") ");
		return sb.toString();
	}
	
	/**
	 * EʂɂבւSQL擾
	 * @return EʂɂבւSQL
	 */
	private String getOrderForPosition() {
		StringBuffer sb = new StringBuffer();
		sb.append("ORDER BY ");
		sb.append(COL_POSITION_CODE + ", ");
		sb.append(COL_EMPLOYMENT_TYPE + ", ");
		sb.append(COL_STATION_CODE + ", ");
		sb.append(COL_K_CODE + " ");
		return sb.toString();
	}
	
	/**
	 * NΏۊOf[^p
	 * @return SQL
	 * @throws IllegalAccessException 
	 */
	public String getDeleteAdjustData() throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(COL_K_CODE);
		sb.append(" FROM ");
		sb.append(getHistoryTable());
		sb.append("WHERE ");
		sb.append("(");
		sb.append(COL_ENTRANCE_DATE);
		sb.append(" > ");
		sb.append("?");
		sb.append(") ");
		sb.append(" OR ");
		sb.append(COL_ENTRANCE_DATE);
		sb.append(" <= ");
		sb.append("?");
		sb.append(" AND ");
		sb.append(COL_RETIREMENT_DATE);
		sb.append(" <= ");
		sb.append("?");
		return sb.toString();
	
	}
	
	/**
	 * ɂf[^݃`FbN
	 * @param  targetMode ݊mF[h
	 * @param  targetCode `FbNR[h(L[)
	 * @return PhBasisDto (DTO)
	 * @throws SQLException
	 */
	public int findForExist(String targetMode, String targetCode) throws SQLException {
		int count ;
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT COUNT(*) FROM " + TABLE + " ");
		sb.append("WHERE ");
		if (targetMode.equals("station") ){
			sb.append(COL_STATION_CODE + " = ? ");
			
		} else if (targetMode.equals("position")){
			sb.append(COL_POSITION_CODE + " = ? ");
			
		} else if (targetMode.equals("employment")){
			sb.append(COL_EMPLOYMENT_TYPE + " = ? ");
		}
		sb.append("AND " + COL_APPLIED_DATE + " IS NOT NULL ");
		try {
			index = 1;
			prepareStatement(sb.toString());
			setParam(index++, targetCode);
			executeQuery();
			rs.next();
			count = rs.getInt(1);
		return 	count;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(lǉo͗p)
	 * @param kCode          ЈR[h
	 * @param kName          Ј
	 * @param kKana          ض
	 * @param stationCode    R[h
	 * @param positionCode   EʃR[h
	 * @param retirementFlag ސEtO
	 * @param startDate      Jn
	 * @param endDate        I
	 * @return UhLicenseTypeDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PhBasisDto> findForConditionList(
			String kCode,
			String kName,
			String kKana,
			String stationCode,
			String positionCode,
			String retirementFlag,
			Date startDate,
			Date endDate
	) throws SQLException, IllegalAccessException {
		try {
			PmBasisDao umBasisDao  = new PmBasisDao();
			StringBuffer sb = new StringBuffer();
			index = 1;
			sb.append(getSelectStatement(getClass()) + " ");
			sb.append("FROM ");
			sb.append(TABLE);
			sb.append(" WHERE ");
			sb.append(COL_K_CODE + " IN  ");
			sb.append(" ( ");
			sb.append(umBasisDao.getForAddHumanListSubQuery(stationCode, positionCode, retirementFlag));
			sb.append(" ) ");
			sb.append(" AND ");
			sb.append(COL_EXPECTED_DATE + " >= ? ");
			sb.append(" AND ");
			sb.append(COL_EXPECTED_DATE + " <= ? ");
			prepareStatement(sb.toString());
			setParam(index++, kCode + "%");
			setParam(index++, "%" + kName + "%");
			setParam(index++, "%" + kKana + "%");
			if (stationCode != null && !stationCode.equals("")) {
				setParam(index++, stationCode);
			}
			if (positionCode != null && !positionCode.equals("")) {
				setParam(index++, positionCode);
			}
			setParam(index++, startDate);
			setParam(index++, endDate);
			executeQuery();
			List<PhBasisDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
}
