package jp.mosp.payroll.bonus.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.human.dao.MKihonDao;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.bonus.dto.BonusListDto;

/**
 * ^f[^ꗗ擾@\񋟂B<br><br>
 * {@link BonusListDto}pāADBJavavOԂŃR[hLB<br>
 */
public class BonusListDao extends PayrollDao {
//	 e[uyуL[
	private static final String TABLE_1 = PhBounsDao  .TABLE;
	private static final String TABLE_2 = MKihonDao   .TABLE;

	// 
	public static final String COL_KCODE_1       = TABLE_1 + "." + PhBounsDao.COL_KCODE          ;	// ЈR[h
	public static final String COL_KCODE_2       = TABLE_2 + "." + MKihonDao   .COL_KCODE        ;	// ЈR[h
	public static final String COL_CALC_MONTH    = TABLE_1 + "." + PhBounsDao.COL_CALC_MONTH   ;	// vZN
	public static final String COL_CALC_PAY      = TABLE_1 + "." + PhBounsDao.COL_PAY_DATE   ;	// x
	public static final String COL_PAYMENT_TOTAL = TABLE_1 + "." + PhBounsDao.COL_PAYMENT_TOTAL;	// xz
	public static final String COL_SIMEI         = MKihonDao   .COL_SIMEI        ;	// 
	public static final String COL_FURIGANA      = MKihonDao   .COL_FURIGANA     ;	// ӂ肪
	public static final String COL_JCODE         = MKihonDao   .COL_JCODE        ;	// ƏR[h
	public static final String COL_SCODE         = MKihonDao   .COL_SCODE        ;	// R[h
	public static final String COL_YCODE         = MKihonDao   .COL_YCODE        ;	// ER[h
	public static final String COL_PAYMENT_TOTAL2 = PhBounsDao.COL_PAYMENT_TOTAL        ;	// xz
	
	/**
	 * {@link PayrollDao#PayrollDao(Properties, String, CmAspUserDto, CmUserDto, Connection)}
	 * sB<br>
	 * @param cfg     ݒt@C
	 * @param cmd     R}h
	 * @param aspUser ASP[U[
	 * @param user    [U[
	 * @param conn    DBRlNV
	 */
	public BonusListDao(
			Properties   cfg,
			String       cmd,
			CmAspUserDto aspUser,
			CmUserDto    user,
			Connection   conn
	) {
		super(cfg, cmd, aspUser, user, conn);
		INSERT_DATE = "";
		INSERT_USER = "";
		UPDATE_DATE = "";
		UPDATE_USER = "";
	}
	
	/**
	 * ʂDTOƂĎ擾B<br>
	 * @return R[h(DTO)
	 * @throws SQLException
	 */
	private BonusListDto mapping() throws SQLException {
		BonusListDto dto = new BonusListDto();
		dto.setKCode       (rs.getString(PhBounsDao.COL_KCODE));	// ЈR[h
		dto.setSimei       (rs.getString(COL_SIMEI        ));	// 
		dto.setFurigana    (rs.getString(COL_FURIGANA     ));	// ӂ肪
		dto.setJCode       (rs.getString(COL_JCODE        ));	// ƏR[h
		dto.setSCode       (rs.getString(COL_SCODE        ));	// R[h
		dto.setYCode       (rs.getString(COL_YCODE        ));	// ER[h
		dto.setPaymentTotal(rs.getInt   (COL_PAYMENT_TOTAL2));	// xz
		return dto;
	}
	
	/**
	 * ʂDTOListƂĎ擾B<br>
	 * @return ʃXg
	 * @throws SQLException
	 */
	protected List<BonusListDto> mappingAll() throws SQLException {
		List<BonusListDto> all = new ArrayList<BonusListDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ɂf[^擾B<br>
	 * @param kCode        ЈR[h
	 * @param officeCode   ƏR[h
	 * @param sectionCode  R[h
	 * @param calcMonth    vZN
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<BonusListDto> findForPaymentData(
			String  kCode      ,
			String  officeCode ,
			String  sectionCode,
			Date    calcMonth   
	) throws SQLException, IllegalAccessException {
		try {
			index = 1;
			prepareStatement(getSelectStatement(getClass()) +
					getConditionForBonusList(officeCode, sectionCode, ""));
			setDateParam(index++, calcMonth);
			setParam(index++, kCode + "%");
			setParam(index++, "%%");
			if (officeCode != null && !officeCode.equals("")) {
				setParam(index++, officeCode);
			}
			if (sectionCode != null && !sectionCode.equals("")) {
				setParam(index++, sectionCode);
			}
			// s
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B<br>
	 * @param kCode        ЈR[h
	 * @param kKana        tKi
	 * @param officeCode   ƏR[h
	 * @param sectionCode  R[h
	 * @param positionCode EʃR[h
	 * @param calcMonth    vZN
	 * @param sortKey      \[gL[
	 * @param isAscending  tO
	 * @param limit        ~bg
	 * @param offset       ItZbg
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<BonusListDto> findForPaymentList(
			String  kCode       ,
			String  kKana       ,
			String  officeCode  ,
			String  sectionCode ,
			String  positionCode,
			Date    calcMonth   ,
			String  sortKey     ,
			boolean isAscending ,
			int     limit       ,
			int     offset
	) throws SQLException, IllegalAccessException {
		try {
			index = 1;
			prepareStatement(
					getSelectStatement(getClass()) +
					getConditionForBonusList(officeCode, sectionCode, positionCode) +
					getPageStatement(sortKey, isAscending)
			);
			setDateParam(index++, calcMonth);
			setParam(index++, kCode + "%");
			setParam(index++, "%" + kKana + "%");
			if (officeCode != null && !officeCode.equals("")) {
				setParam(index++, officeCode);
			}
			if (sectionCode != null && !sectionCode.equals("")) {
				setParam(index++, sectionCode);
			}
			if (positionCode != null && !positionCode.equals("")) {
				setParam(index++, positionCode);
			}
			setParam(index++, limit );
			setParam(index++, offset);
			// s
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂ蓾f[^̌擾B<br>
	 * @param kCode        ЈR[h
	 * @param kKana        tKi
	 * @param officeCode   ƏR[h
	 * @param sectionCode  R[h
	 * @param positionCode EʃR[h
	 * @param calcMonth    vZN
	 * @return int 
	 * @throws SQLException
	 */
	public int countForBonusList(
			String kCode       ,
			String kKana       ,
			String officeCode  ,
			String sectionCode ,
			String positionCode,
			Date    calcMonth  
	) throws SQLException {
		try {
			index = 1;
			prepareStatement(
					getSelectCountStatement() + 
					getConditionForBonusList(officeCode, sectionCode, positionCode)
			);
			setDateParam(index++, calcMonth);
			setParam(index++, kCode + "%");
			setParam(index++, "%" + kKana + "%");
			if (officeCode != null && !officeCode.equals("")) {
				setParam(index++, officeCode);
			}
			if (sectionCode != null && !sectionCode.equals("")) {
				setParam(index++, sectionCode);
			}
			if (positionCode != null && !positionCode.equals("")) {
				setParam(index++, positionCode);
			}
			executeQuery();
			int count = 0;
			if (rs.next()) {
				count = rs.getInt(1);
			}
			return count;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ^vZpSQL擾B
	 * @param officeCode   ƏR[h
	 * @param sectionCode  R[h
	 * @param positionCode EʃR[h
	 * @return	^vZpSQL 
	 */
	private static String getConditionForBonusList(
			String officeCode  ,
			String sectionCode ,
			String positionCode
	) {
		StringBuffer sb = new StringBuffer();
		sb.append("FROM ");
		sb.append(TABLE_1 + ", " + TABLE_2 + " ");
		sb.append("WHERE ");
		sb.append(COL_KCODE_1 + " = " + COL_KCODE_2 + " ");
		sb.append(" AND ");
		sb.append(COL_CALC_PAY + " = ? ");
		sb.append(" AND ");
		sb.append(COL_KCODE_1 + " LIKE ? ");
		sb.append(" AND ");
		sb.append(COL_FURIGANA + " LIKE ? ");
		if (officeCode != null && !officeCode.equals("")) {
			sb.append("AND ");
			sb.append(COL_JCODE + " =  ? ");
		}
		if (sectionCode != null && !sectionCode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SCODE + " =  ? ");
		}
		if (positionCode != null && !positionCode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_YCODE + " = ? ");
		}
		return sb.toString();
	}
	
	
	/**
	 * ɂf[^擾B<br>
	 * @param kCode        ЈR[h
	 * @param officeCode   ƏR[h
	 * @param sectionCode  R[h
	 * @param calcMonth    vZN
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<BonusListDto> findForPayment(
			Date    calcMonth   
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			StringBuffer sb = new StringBuffer();
			index = 1;
			sb.append(getSelectStatement(getClass()));
			sb.append("FROM ");
			sb.append(TABLE_1 + ", " + TABLE_2 + " ");
			sb.append("WHERE ");
			sb.append(COL_KCODE_1 + " = " + COL_KCODE_2 + " ");
			sb.append(" AND ");
			sb.append(COL_CALC_PAY + " = ? ");
			prepareStatement(sb.toString());
			setParam(index++, calcMonth);
			// s
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
}
