package jp.mosp.payroll.bonus.action;

import java.io.File;
import java.sql.SQLException;
import java.util.Date;

import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.dom.spreadsheet.SpreadSheet;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.PoiUtility;
import jp.mosp.payroll.base.Bonus;
import jp.mosp.payroll.base.Employee;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.bonus.dao.PdBonAllowanceDao;
import jp.mosp.payroll.bonus.dao.PdBonDeductionDao;
import jp.mosp.payroll.bonus.dao.PdBonSumDao;
import jp.mosp.payroll.bonus.dao.PhBounsDao;
import jp.mosp.payroll.bonus.dao.PmDetailBaDao;
import jp.mosp.payroll.bonus.dao.PmDetailBdDao;
import jp.mosp.payroll.bonus.dao.PmDetailBsDao;
import jp.mosp.payroll.bonus.dto.PhBounsDto;
import jp.mosp.payroll.bonus.vo.BonusCardVo;
import jp.mosp.payroll.payment.vo.PaymentReportVo;

/**
 * ^ׂ̏o͂sB<br><br>
 * ȉ̃R}hB
 * <ul><li>
 * {@link #CMD_REPORT}
 * </li></ul>
 */
public class BonusSlipOutputAction extends PayrollAction {
	
	/**
	 * ^׏o̓R}hB<br><br>
	 * ɂA^ׂExcelŏo͂B<br>
	 */
	public static final String CMD_REPORT = "P2026";
	
	// doSubmit,doSubmitFileKeyfp
	private String kcode;
	private String ymd;
	
	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PayrollAction#PayrollAction()}
	 * </li></ul>
	 */
	public BonusSlipOutputAction() {
		super();
		kcode = "";
		ymd   = "";
		setNeedProcSeq(false);
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new PaymentReportVo();
	}
	
	/**
	 * ANVB<br>
	 * ڍׂ́ANXQƁB<br>
	 */
	public void action() throws Exception {
		// VO擾yѐݒ
		prepareVo();
		if (this.cmd.equals(CMD_REPORT)) {
			// ^׏o
			if (cfg.getProperty(PayrollConst.PPT_PAY_USEXLS) == null) {
				report();
			} else {
				reportXls();
			}
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * [o͏sB<br><br>
	 * @throws Exception 
	 */
	private void report() throws Exception {
		// RlNV擾
		getConnection();
		// doSubmitFileKeydoSubmit̔
		if (key1.equals("") && key2.equals("")) {
			BonusCardVo vo = new BonusCardVo();
			vo.setParams(request);
			kcode = vo.getEscHidKCode();
			ymd   = vo.getEscHidTargetYear() + "/" + vo.getEscHidTargetMonth() + "/" + vo.getEscHidTargetDay();
		} else {
			kcode = key1;
			ymd   = key2;
		}
		// Ј擾
		Employee employee = getEmployee(kcode);
		// ׏擾
		Bonus bonus = getBonus(kcode, MospUtility.getDate(ymd));
		// [쐬
		SpreadSheet ss = SpreadSheet.createFromFile(new File(cfg.getProperty(MospConst.PPT_APP_DOCBASE) + "/template/samp_bonus_slip.ods"));
		Sheet sheet = ss.getSheet(0);
		// wb_[
		int row = 4;
		int col = 1;
		sheet.getCellAt(col     , row).setValue(employee.getSectionCode());	// R[h
		sheet.getCellAt(col + 10, row).setValue(employee.getKCode      ());	// ЈR[h
		sheet.getCellAt(col + 20, row).setValue(employee.getKName      ());	// Ј
		sheet.getCellAt(col + 66, row).setValue(bonus.getPayDate     ());	// x

		// x
		row = 6;
		col = 4;
		String[][] aryAllowance = bonus.getAllowanceArray(true);
		for (int i = 0; i < aryAllowance.length; i++) {
			if (i % 10 == 0 && i != 0) {
				row += 2;
				col  = 4;
			} else if (i != 0) {
				col += 9;
			}
			sheet.getCellAt(col, row    ).setValue(aryAllowance[i][1]);
			sheet.getCellAt(col, row + 1).setValue(new Integer(aryAllowance[i][2]));
		}

		// T
		row = 17;
		col =  4;
		String[][] aryDeduction = bonus.getDeductionArray(true);
		for (int i = 0; i < aryDeduction.length; i++) {
			if (i % 10 == 0 && i != 0) {
				row += 2;
				col  = 4;
			} else if (i != 0) {
				col += 9;
			}
			sheet.getCellAt(col, row    ).setValue(aryDeduction[i][1]);
			sheet.getCellAt(col, row + 1).setValue(new Integer(aryDeduction[i][2]));
		}
		// v
		row = 28;
		col =  4;
		String[][] arySum = bonus.getSumArray(true);
		for (int i = 0; i < arySum.length; i++) {
			if (i % 10 == 0 && i != 0) {
				row += 2;
				col  = 4;
			} else if (i != 0) {
				col += 9;
			}
			sheet.getCellAt(col, row    ).setValue(arySum[i][1]);
			sheet.getCellAt(col, row + 1).setValue(new Integer(arySum[i][2]));
		}
		// o͓eݒ
		String fileName =
			MospUtility.getYear (bonus.getHeader().getPayDate()) + PayrollConst.FILE_NAME_SEPARATOR +
			MospUtility.getMonth(bonus.getHeader().getPayDate()) + PayrollConst.FILE_NAME_SEPARATOR +
			MospUtility.getDay(bonus.getHeader().getPayDate()) + PayrollConst.FILE_NAME_SEPARATOR +
			bonus.getKCode()                          + PayrollConst.FILE_NAME_SEPARATOR +
			PayrollConst.FILE_BONUS_SLIP_OO;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, ss);
	}
	
	/**
	 * [o͏sB<br><br>
	 * @throws Exception 
	 */
	private void reportXls() throws Exception {
		// RlNV擾
		getConnection();
		// doSubmitFileKeydoSubmit̔
		if (key1.equals("") && key2.equals("")) {
			BonusCardVo vo = new BonusCardVo();
			vo.setParams(request);
			kcode = vo.getEscHidKCode();
			ymd   = vo.getEscHidTargetYear() + "/" + vo.getEscHidTargetMonth() + "/" + vo.getEscHidTargetDay();
		} else {
			kcode = key1;
			ymd   = key2;
		}
		// Ј擾
		Employee employee = getEmployee(kcode);
		// ׏擾
		Bonus bonus = getBonus(kcode, MospUtility.getDate(ymd));
		// [쐬
		PoiUtility poi = new PoiUtility();
		poi.crtNewDocR(0, cfg.getProperty(MospConst.PPT_APP_DOCBASE) + "/template/samp_bonus_slip.xls");
		poi.prtItem(4,  1, employee.getSectionCode());	// R[h
		poi.prtItem(4, 11, employee.getKCode      ());	// ЈR[h
		poi.prtItem(4, 21, employee.getKName      ());	// Ј
		poi.prtItem(4, 67, bonus.getPayDate     ());	// x

		// x
		int row = 6;
		int col =  4;
		String[][] aryAllowance = bonus.getAllowanceArray(true);
		for (int i = 0; i < aryAllowance.length; i++) {
			if (i % 10 == 0 && i != 0) {
				row += 2;
				col  = 4;
			} else if (i != 0) {
				col += 9;
			}
			poi.prtItem(row    ,  col, aryAllowance[i][1]);
			poi.prtItem(row + 1,  col, Integer.parseInt(aryAllowance[i][2]));
		}
		// T
		row = 17;
		col =  4;
		String[][] aryDeduction = bonus.getDeductionArray(true);
		for (int i = 0; i < aryDeduction.length; i++) {
			if (i % 10 == 0 && i != 0) {
				row += 2;
				col  = 4;
			} else if (i != 0) {
				col += 9;
			}
			poi.prtItem(row    ,  col, aryDeduction[i][1]);
			poi.prtItem(row + 1,  col, Integer.parseInt(aryDeduction[i][2]));
		}
		// v
		row = 28;
		col =  4;
		String[][] arySum = bonus.getSumArray(true);
		for (int i = 0; i < arySum.length; i++) {
			if (i % 10 == 0 && i != 0) {
				row += 2;
				col  = 4;
			} else if (i != 0) {
				col += 9;
			}
			poi.prtItem(row    ,  col, arySum[i][1]);
			poi.prtItem(row + 1,  col, Integer.parseInt(arySum[i][2]));
		}
		
		// o͓eݒ
		String fileName =
			MospUtility.getYear (bonus.getCalcMonth()) + PayrollConst.FILE_NAME_SEPARATOR +
			MospUtility.getMonth(bonus.getCalcMonth()) + PayrollConst.FILE_NAME_SEPARATOR +
			bonus.getKCode()                          + PayrollConst.FILE_NAME_SEPARATOR +
			PayrollConst.FILE_BONUS_SLIP;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, poi.getWorkbook());
	}

	/**
	 * ܗ^`[CX^X擾Aݒ肷B<br><br>
	 * kCodeAcalcDateL[Ƃċ^擾A{@link #bonus}Ɋi[B
	 * @param kCode     ЈR[h
	 * @param calcMonth vZN
	 * @return ^`[
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	protected Bonus getBonus(
			String kCode, Date payDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		PhBounsDto header = new PhBounsDao(
				cfg, cmd, aspUser, user, conn).findForKey(kCode, payDate);
		if (header == null) {
			return null;
		}else{
			return new Bonus(
					header,
					new PmDetailBaDao(cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()),
					new PmDetailBdDao(cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()),
					new PmDetailBsDao(cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()),
					new PdBonAllowanceDao(cfg, cmd, aspUser, user, conn).find(kCode, payDate),
					new PdBonDeductionDao(cfg, cmd, aspUser, user, conn).find(kCode, payDate),
					new PdBonSumDao      (cfg, cmd, aspUser, user, conn).find(kCode, payDate)
			);

		}
	}

}

