package jp.mosp.payroll.bonus.action;

import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;

import jp.mosp.payroll.bonus.dao.BonusListDao;
import jp.mosp.payroll.bonus.dao.PhBounsDao;
import jp.mosp.payroll.bonus.dto.BonusListDto;
import jp.mosp.payroll.bonus.BonusConst;
import jp.mosp.payroll.bonus.vo.BonusListVo;
import jp.mosp.payroll.dao.PtCurrentDao;
import jp.mosp.payroll.dto.PtCurrentDto;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.human.dao.MKihonDao;

/**
 * ܗ^f[^ꗗʂɂ鏈sB<br><br>
 * ȉ̃R}hB
 * <ul><li>
 * {@link #CMD_SHOW}
 * </li><li>
 * {@link #CMD_SEARCH}
 * </li><li>
 * {@link #CMD_RE_SEARCH}
 * </li><li>
 * {@link #CMD_SORT}
 * </li><li>
 * {@link #CMD_PAGE}
 * </li></ul>
 */
public class BonusListAction extends PayrollAction {

	/**
	 * ʕ\R}hB<br><br>
	 * ܗ^vZ̔N擾A\B<br>
	 * ܗ^vZ̔NȂꍇ́AVXeN\B<br>
	 */
	public static final String CMD_SHOW = "P2021";

	/**
	 * R}hB<br><br>
	 * w肳ꂽŋ^f[^̌sAꗗ\B<br>
	 */
	public static final String CMD_SEARCH = "P2022";

	/**
	 * ČR}hB<br><br>
	 * ۑꂽŋ^f[^̌sAꗗ\B<br>
	 */
	public static final String CMD_RE_SEARCH = "P2023";

	/**
	 * \[gR}hB<br><br>
	 * w肳ꂽŋ^f[^̕בւsAꗗ\B<br>
	 */
	public static final String CMD_SORT = "P2024";

	/**
	 * y[WR}hB<br><br>
	 * w肳ꂽŋ^f[^̃y[WJsAꗗ\B<br>
	 */
	public static final String CMD_PAGE = "P2025";

	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PayrollAction#PayrollAction()}
	 * </li></ul>
	 */
	public BonusListAction() {
		super();
	}

	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new BonusListVo();
	}

	/**
	 * ANVB<br>
	 * ڍׂ́ANXQƁB<br>
	 */
	public void action() throws Exception {
		// VO擾yѐݒ
		prepareVo();
		if (this.cmd.equals(CMD_SHOW)) {
			// ʕ\
			show();
		} else if (this.cmd.equals(CMD_SEARCH)) {
			// 
			search();
		} else if (this.cmd.equals(CMD_RE_SEARCH)) {
			// Č
			reSearch();
		} else if (this.cmd.equals(CMD_SORT)) {
			// \[g
			sort();
		} else if (this.cmd.equals(CMD_PAGE)) {
			// y[W
			page();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * ʕ\sB<br><br>
	 * @throws Exception 
	 */
	private void show() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		BonusListVo vo = (BonusListVo)getVo();
		// VXet擾
		Date sysDate = new Date();
		// vZ擾
		Date calcCurrent = getCalcCurrent();
		// v_EACeݒ
		vo.setPitYear		(getYearArrayLong(MospUtility.getYear(calcCurrent)));
		vo.setPitMonth		(getMonthArray());
		vo.setPitDay		(getDayArray());
		vo.setPitOffice		(getOfficeArray());
		vo.setPitSection	(getSectionArrayAll());
		vo.setPitPosition	(getPositionArray());
		// vZmF
		if (calcCurrent == null) {
			// VOtB[hݒ
			vo.setPltYear	(MospUtility.getYear	(sysDate));
			vo.setPltMonth	(MospUtility.getMonth	(sysDate));
			vo.setPltDay	(MospUtility.getDay		(sysDate));
			return;
		}
		// VOtB[hݒ
		vo.setTxtKCode	("");
		vo.setTxtKKana	("");
		vo.setPltYear	(MospUtility.getYear	(calcCurrent));
		vo.setPltMonth	(MospUtility.getMonth	(calcCurrent));
		vo.setPltDay	(MospUtility.getDay		(calcCurrent));
		// Xg擾
		getList();
	}

	/**
	 * sB
	 * @throws Exception 
	 */
	private void search() throws Exception {
		// VO擾
		BonusListVo vo = (BonusListVo)getVo();
		// p[^擾
		vo.setParams(request);
		// Xg擾
		getList();
	}

	/**
	 * 	ČsB
	 * @throws Exception 
	 */
	private void reSearch() throws Exception {
		// Xg擾
		getList();
	}

	/**
	 * \[gsB
	 * @throws Exception 
	 */
	private void sort() throws Exception {
		// VO擾
		BonusListVo vo = (BonusListVo)getVo();
		// \[gݒ
		vo.setSortKey(key1);
		vo.setSelectIndex(1);
		// Xg擾
		getList();
	}

	/**
	 * y[WsB
	 * @throws Exception 
	 */
	private void page() throws Exception {
		// VO擾
		BonusListVo vo = (BonusListVo)getVo();
		// y[Wݒ
		vo.setSelectIndex(Integer.parseInt(key1));
		// Xg擾
		getList();
	}

	/**
	 * Xg擾B
	 * @throws Exception 
	 */
	private void getList() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		BonusListVo vo = (BonusListVo)getVo();
		// ܗ^x擾
		Date targetMonth = getDate(vo.getPltYear(), vo.getPltMonth(), vo.getPltDay());
		vo.setLblTargetMonth(MospUtility.getDateString(targetMonth, PayrollConst.FORMAT_DATE));
		// DAO
		BonusListDao dao = new BonusListDao(cfg, cmd, aspUser, user, conn);
		// 擾
		vo.setCountAllData(dao.countForBonusList(
				vo.getTxtKCode   (),
				vo.getTxtKKana   (),
				vo.getPltOffice  (),
				vo.getPltSection (),
				vo.getPltPosition(),
				targetMonth
		));
		// 
		List<BonusListDto> list = dao.findForPaymentList(
				vo.getTxtKCode   (),
				vo.getTxtKKana   (),
				vo.getPltOffice  (),
				vo.getPltSection (),
				vo.getPltPosition(),
				targetMonth        ,
				getSortKey       (),
				vo.getIsAscending(),
				vo.getDataPerPage(),
				vo.getOffset     ()
		);
		// ̎擾pz擾
		String[][] aryOffice   = getOfficeArrayAll  ();
		String[][] arySection  = getSectionArrayAll ();
		String[][] aryPosition = getPositionArrayAll();
		// R[hϊ
		for (Iterator<BonusListDto> it = list.iterator(); it.hasNext();) {
			BonusListDto dto = it.next();
			dto.setOfficeName  (getCodeName(dto.getJCode(), aryOffice  ));
			dto.setSectionName (getCodeName(dto.getSCode(), arySection ));
			dto.setPositionName(getCodeName(dto.getYCode(), aryPosition));
		}
		// VOɐݒ
		vo.setFields(list);
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getCount() == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}

	/**
	 * \[gL[擾B<br>
	 * @return \[gL[
	 */
	private String getSortKey() {
		// VO擾
		BonusListVo vo = (BonusListVo)getVo();
		// IL[擾
		String selectKey = vo.getSelectKey();
		// \[gL[擾
		String sortKey = PhBounsDao.TABLE + "." + PhBounsDao.COL_KCODE;
		if (selectKey == null) {
			// 
		} else if (selectKey.equals("2")) {
			sortKey = MKihonDao.COL_FURIGANA;
		} else if (selectKey.equals("3")) {
			sortKey = MKihonDao.COL_JCODE;
		} else if (selectKey.equals("4")) {
			sortKey = MKihonDao.COL_SCODE;
		} else if (selectKey.equals("5")) {
			sortKey = MKihonDao.COL_YCODE;
		} else if (selectKey.equals("6")) {
			sortKey = PhBounsDao.COL_PAYMENT_TOTAL;
		}
		return sortKey;
	}

	
	/**---- eBonusActionŎiʉj:p֌Włꍇ͍폜 ----**/
	
	/**
	 * vZ擾
	 * @return vZ
	 * @throws Exception
	 */
	protected Date getCalcCurrent() throws Exception {
		// DAO
		PtCurrentDao dao = new PtCurrentDao(cfg, cmd, aspUser, user, conn);
		dao.initDao(cfg, cmd, aspUser, user, conn);
		PtCurrentDto dto = dao.findForKey(
							PayrollConst.OFFICE_ALL,
							PayrollConst.CALC_BONUS,
							getCurrent(PayrollConst.OFFICE_ALL, PayrollConst.CALC_PAYMENT));
		if (dto != null) {
			return dto.getCalcDate();
		}
		return new Date();
	}

	/**
	 * Nv_E擾(OBonusConstŎw)
	 * @param year N
	 * @return Nv_Epz
	 */
	protected String[][] getYearArrayLong(int year) {
		return getYearArray(year,
				BonusConst.TIME_YEAR_FORMER, BonusConst.TIME_YEAR_FURTHER);
	}
	
	/**
	 * Nv_E擾
	 * @param year N
	 * @return Nv_Epz
	 */
	protected String[][] getYearArray(int year, int former, int further) {
		String[][] aryYear = new String[former + further + 1][2];
		int i = 0;
		int index = 0;
		for (i = year - former; i < year; i++) {
			aryYear[index][0] = String.valueOf(i);
			aryYear[index][1] = String.valueOf(i);
			index++;
		}
		aryYear[index][0] = String.valueOf(year);
		aryYear[index][1] = String.valueOf(year);
		index++;
		for (i = year + 1; i <= year + further; i ++) { 
			aryYear[index][0] = String.valueOf(i);
			aryYear[index][1] = String.valueOf(i);
			index++;
		}
		return aryYear;
	}
	
}
