package jp.mosp.payroll.bonus.action;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.mosp.common.common.BaseVo;
import jp.mosp.payroll.base.Bonus;
import jp.mosp.payroll.base.Employee;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.bonus.BonusConst;
import jp.mosp.payroll.bonus.dao.PdBonAllowanceDao;
import jp.mosp.payroll.bonus.dao.PdBonDeductionDao;
import jp.mosp.payroll.bonus.dao.PdBonSumDao;
import jp.mosp.payroll.bonus.dao.PhBounsDao;
import jp.mosp.payroll.bonus.dao.PmDetailBaDao;
import jp.mosp.payroll.bonus.dao.PmDetailBdDao;
import jp.mosp.payroll.bonus.dao.PmDetailBsDao;
import jp.mosp.payroll.bonus.dto.PhBounsDto;
import jp.mosp.payroll.bonus.dto.PmDetailBaDto;
import jp.mosp.payroll.bonus.dto.PmDetailBdDto;
import jp.mosp.payroll.bonus.dto.PmDetailBsDto;
import jp.mosp.payroll.bonus.vo.BonusCardVo;
import jp.mosp.payroll.dao.CmPaymentMeansDao;
import jp.mosp.payroll.dao.PtCurrentDao;
import jp.mosp.payroll.dto.CmPaymentMeansDto;
import jp.mosp.payroll.dto.DetailDto;
import jp.mosp.payroll.dto.PtCurrentDto;
import jp.mosp.system.dao.MKaisyaDao;
import jp.mosp.system.dto.MKaisyaDto;

import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

public class BonusCardAction extends PayrollAction {

	// R}h
	private static final String CMD_BONUS_CARD_SHOW           = "P2011";
	private static final String CMD_BONUS_CARD_REGSIT         = "P2012";
	private static final String CMD_BONUS_CARD_SELECT         = "P2013";
	private static final String CMD_BONUS_CARD_TAX            = "P2014";
	private static final String CMD_BONUS_CARD_TOTAL          = "P2015";
	private static final String CMD_BONUS_CARD_SELECT_ANOTHER = "P2016";
	
	private boolean BounsDataFlg = false;
	
	// vZp
	public		int	sumAllowance	= 0;
	public		int	sumDeduction	= 0;
	public		int	sumDatail		= 0;

	protected int bank1Amount		= 0;	// s1Uz
	protected int bank2Amount		= 0;	// s2Uz
	protected int cashAmount		= 0;	// xz

	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PayrollAction#PayrollAction()}
	 * </li></ul>
	 */
	public BonusCardAction() {
		super();
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new BonusCardVo();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		
		Employee employee;

		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// VO̎擾yѐݒ
		prepareVo();
		BonusCardVo vo =  (BonusCardVo)getVo();
		vo = (BonusCardVo)getStoredVo(vo.getClassName());
		if (vo == null || cmd.equals(CMD_BONUS_CARD_SHOW)) {
			vo = new BonusCardVo();
			storeVo(vo.getClassName(), vo);
		}

		// VOyуtH[hURL̐ݒ
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();
		setVo(vo);
		setUrl(vo.getRetUrl());

		//\׍ڃe[uɍږݒ肷B
		vo.aryPltCalcStatus  = BonusConst.getCalcStatusArray();
		vo.aryStation = getStationArrayAll();

		setAryDetailName();
		
		vo.setParams(request);
		if (vo.getPltYear() == null) {
			setYearMonth(vo, getCalcCurrent(),true);
		} else {
			setYearMonth(vo, getCalcCurrent(),false);
		}
		if (!key1.equals("") && key1 != null) {
			vo.setHidKCode(key1);
			vo.setTxtChangeKCode(key1);
		} else {
			vo.setHidKCode(vo.getTxtChangeKCode());
		}

		Date targetMonth = MospUtility.getDate(	vo.getHidTargetYear() +	'/' + 
									vo.getHidTargetMonth() + '/' +vo.getHidTargetDay());
			// R}h̏
		if (cmd.equals(CMD_BONUS_CARD_SHOW)) {
			setYearMonth  (vo, getCalcCurrent(),true);
			// ʕ\
			show(vo);
		} else if (cmd.equals(CMD_BONUS_CARD_SELECT)) {
			// l擾
			employee = getEmployee(vo.getTxtChangeKCode());
			if(null == employee){
				vo.clearPayData();
				String errMessage = MospUtility.getMessage(msg, "WU2103", ""); /* Message WU2103:Јf[^܂B */
				setNextCmd(CMD_BONUS_CARD_SHOW);
				addErrMessage(errMessage);
				throw new MospException(BonusConst.EX_RETIRED, errMessage);
			}else{
				// I
				if (vo.getPltYear() == null) {
					setYearMonth(vo, getCalcCurrent(),true);
				} else {
					setYearMonth(vo, getCalcCurrent(),false);
				}
				if (!key1.equals("") && key1 != null) {
					vo.setHidKCode(key1);
					vo.setTxtChangeKCode(key1);
				} else {
					vo.setHidKCode(vo.getTxtChangeKCode());
				}
				show(vo.getTxtChangeKCode(), targetMonth , employee);
			}
		} else if (cmd.equals(CMD_BONUS_CARD_SELECT_ANOTHER)) {
			/*** bi ***/
			String errMessage = MospUtility.getMessage(msg, "WU1120", "");
			addErrMessage(errMessage);
			throw new MospException(BonusConst.EX_NOT_CURRENT, errMessage);

		} else if (cmd.equals(CMD_BONUS_CARD_REGSIT)) {
			// l擾
			employee = getEmployee(vo.getTxtChangeKCode());
			if(null == employee){
				String errMessage = MospUtility.getMessage(msg, "WU2103", ""); /* Message WU2103:Јf[^܂B */
				setNextCmd(CMD_BONUS_CARD_SHOW);
				addErrMessage(errMessage);
				throw new MospException(BonusConst.EX_RETIRED, errMessage);
			}else{
				// o^
				regist( employee, targetMonth );
			}
		} else if (cmd.equals(CMD_BONUS_CARD_TAX)) {
			// vZ
			calculate(vo.getTxtChangeKCode() ,  targetMonth);
		} else if (cmd.equals(CMD_BONUS_CARD_TOTAL)) {
			// xv
			cardTotal(vo.getTxtChangeKCode() ,  targetMonth);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	/**
	 * VKo^ʕ\
	 * @param vo ΏVO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	public void show(BonusCardVo vo) throws Exception {
		// Ώ۔Nݒ
		setTargetMonth(vo);
	}
	
	/**
	 * Ώ۔NAxݒ
	 * @param vo          ΏVO
	 * @param targetMonth ݒN
	 * @throws Exception
	 */
	public void setTargetMonth(BonusCardVo vo) throws Exception {
		vo.setPayDay( vo.getPltYear(), vo.getPltMonth(), vo.getPltDay());
		vo.setTargetMonth( vo.getPltYear(), vo.getPltMonth());
	}
	
	
	/**
	 * ʕ\sB<br><br>
	 * @param ΏێЈR[h
	 * @param Ώ۔N
	 * @throws Exception 
	 */
	private void show(String kCode, Date targetMonth , Employee employee) throws Exception {
		// VO擾
		BonusCardVo vo = (BonusCardVo)getVo();
			// ܗ^擾
			Bonus bonus = getBonus(kCode, targetMonth);
			// VOtB[hݒ
			vo.setFields(employee, bonus);
	}
	
	
	/**
	 * ܗ^`[CX^X擾Aݒ肷B<br><br>
	 * kCodeAcalcDateL[Ƃċ^擾A{@link #payment}Ɋi[B
	 * @param kCode     ЈR[h
	 * @param calcMonth vZN
	 * @return ^`[
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	protected Bonus getBonus(
			String kCode, Date payDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		PhBounsDto header = new PhBounsDao(
				cfg, cmd, aspUser, user, conn).findForKey(kCode, payDate);
		if (header == null) {
			return null;
		}else{
			return new Bonus(
					header,
					new PmDetailBaDao(cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()),
					new PmDetailBdDao(cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()),
					new PmDetailBsDao(cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()),
					new PdBonAllowanceDao(cfg, cmd, aspUser, user, conn).find(kCode, payDate),
					new PdBonDeductionDao(cfg, cmd, aspUser, user, conn).find(kCode, payDate),
					new PdBonSumDao      (cfg, cmd, aspUser, user, conn).find(kCode, payDate)
			);

		}
	}

	/**
	 * o^sB<br><br>
	 * @throws Exception 
	 */
	private void regist(Employee employee , Date targetMonth) throws Exception {
		sumDatail		= 0;	// xz
		bank1Amount		= 0;	// s1Uz
		bank2Amount		= 0;	// s2Uz
		cashAmount		= 0;	// xz

		
		BonusCardVo vo = (BonusCardVo)getVo();
		
		// ܗ^擾
		Bonus bonus = getBonus(vo.getTxtChangeKCode(), targetMonth);
		
		if(vo.arySum[0][2].equals("") || vo.arySum[0][2].equals("0")){
			String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_BONUS_CALC_NG, "");
			addErrMessage(errMessage);
			throw new MospException(BonusConst.EX_NOT_CURRENT, errMessage);
		}else{
			sumDatail = (Integer.valueOf( vo.arySum[3][2])) + 
			            (Integer.valueOf( vo.arySum[4][2])) + 
			            (Integer.valueOf( vo.arySum[5][2]));
			if(sumDatail == 0){
				String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_BONUS_FIX_NG, "");
				addErrMessage(errMessage);
				throw new MospException(BonusConst.EX_NOT_CURRENT, errMessage);
			}
		}
		
		if(sumDatail != 0){
			if(null == bonus){
				bonus = new Bonus();
				BounsDataFlg = true;
				//p[^ݒ
				for (int i = 0; i < vo.arySum.length; i++) {
					if (vo.arySum[i][2].equals("")) {
						String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_BONUS_CALC_NG, "");
						addErrMessage(errMessage);
						throw new MospException(BonusConst.EX_NOT_CURRENT, errMessage);
					}
				}
				vo.setDtoFields2(employee, bonus, targetMonth);
			
			} else {
				// p[^ݒ
				vo.setDtoFields(bonus);
			}
			//vvZ
			calcTotal(getEmployee(vo.getTxtChangeKCode()), bonus);
			// o^
			registPayment(bonus);
			// R~bg
			commit();
			// bZ[Wݒ
			setMessage(MospUtility.getMessage(msg, "IC0001", ""));
			// ʕ\
			show( vo.getTxtChangeKCode(), targetMonth, employee);
		}

	
	}

	
	/**
	 * הz擾B
	 * @param list             擾ΏۃXg
	 * @param checkDisplayType 0󎚋敪mFv
	 * @return הz
	 */
	protected String[][] getAryDetail(List<?> list, boolean checkDisplayType) {
		String[][] aryDetail = new String[list.size()][3];
		for (int i = 0; i < list.size(); i++) {
			DetailDto dto = (DetailDto)list.get(i);
			aryDetail[i][0] = dto.getDetailCode();
			aryDetail[i][1] = dto.getDetailAbbr();
			aryDetail[i][2] = "0";
			if (dto instanceof PmDetailBsDto) {
				aryDetail[i][2] = String.valueOf(((PmDetailBsDto)dto).getAmount());
			}
			if (checkDisplayType && dto.getDisplayType() == PayrollConst.DETAIL_DISP_NONE) {
				if (String.valueOf(aryDetail[i][2]).equals("0")) {
					aryDetail[i][1] = "";
					aryDetail[i][2] = "";
				}
			}
		}
		return aryDetail;
	}
	
	/**
	 * R[h擾(M_KAISYA)
	 * @return R[hXg
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[][] getStationArrayAll() throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MKaisyaDao mKaisyaDao = new MKaisyaDao();
		
		mKaisyaDao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List< MKaisyaDto > listStation = mKaisyaDao.findAll();
		// z̍쐬
		String[][] aryStation = new String[listStation.size()][2];
		for (int i = 0; i < listStation.size(); i++) {
			aryStation[i][0] = listStation.get(i).getId();
			aryStation[i][1] = listStation.get(i).getKaiMei();
		}
		return aryStation;
	}
	
	/**
	 * Nݒ
	 * @param vo          ݒΏVO
	 * @param calcCurrent vZ
	 */
	private void setYearMonth(BonusCardVo vo, Date calcCurrent,boolean isSetPulldown) {
		// v_E擾
		vo.aryPltYear  = getYearArray(MospUtility.getYear(calcCurrent));
		vo.aryPltMonth = getMonthArray();
		vo.aryPltDay   = getDayArray();
		if (isSetPulldown) {
			// Nݒ
			vo.setPltYear(vo.getHidTargetYear());
			vo.setPltMonth(vo.getHidTargetMonth());
			vo.setPltDay(vo.getHidTargetDay());
		} else {
			//Nݒ
			vo.setPltYear(vo.getHidTargetYear());
			vo.setPltMonth(vo.getHidTargetMonth());
			vo.setPltDay(vo.getHidTargetDay());
		}
	}

	/**
	 * Nv_E擾(O1N)
	 * @param year N
	 * @return Nv_Epz
	 */
	protected String[][] getYearArray(int year) {
		String[][] aryYear = new String[3][2];
		aryYear[0][0] = String.valueOf(year - 1);
		aryYear[0][1] = String.valueOf(year - 1);
		aryYear[1][0] = String.valueOf(year);
		aryYear[1][1] = String.valueOf(year);
		aryYear[2][0] = String.valueOf(year + 1);
		aryYear[2][1] = String.valueOf(year + 1);
		return aryYear;
	}

	/**
	 * vZ擾
	 * @return vZ
	 * @throws Exception
	 */
	protected Date getCalcCurrent() throws Exception {
		// DAO
		PtCurrentDao dao = new PtCurrentDao(cfg, cmd, aspUser, user, conn);
		dao.initDao(cfg, cmd, aspUser, user, conn);
		PtCurrentDto dto = dao.findForKey(
							PayrollConst.OFFICE_ALL,
							PayrollConst.CALC_BONUS,
							getCurrent(PayrollConst.OFFICE_ALL, PayrollConst.CALC_PAYMENT));
		if (dto != null) {
			return dto.getCalcDate();
		}
		return new Date();
	}

	/**
	 * ʖׂ̍ږ̎擾Ɛݒ
	 * @return vZ
	 * @throws Exception
	 */
	protected void setAryDetailName() throws Exception{

		BonusCardVo vo = (BonusCardVo)getVo();

		// DAO
		PmDetailBaDto baDto;
		PmDetailBdDto bdDto;
		PmDetailBsDto bsDto;
		PmDetailBaDao baDao = new PmDetailBaDao(cfg, cmd, aspUser, user, conn);
		PmDetailBdDao bdDao = new PmDetailBdDao(cfg, cmd, aspUser, user, conn);
		PmDetailBsDao bsDao = new PmDetailBsDao(cfg, cmd, aspUser, user, conn);
		
		// xږ̐ݒ
		for (int i = 0; i < vo.aryAllowance.length ; i++) {
			baDto = baDao.findForKey( vo.aryAllowance[i][0]);
			if(null != baDto){
				if(baDto.getDeleteFlag() == 0){
					vo.aryAllowance[i][1] = baDto.getDetailName();
					vo.aryAllowance[i][2] = "0";
				}
			}
		}
		// Tږ̐ݒ
		for (int i = 0; i < vo.aryDeduction.length ; i++) {
			bdDto = bdDao.findForKey( vo.aryDeduction[i][0]);
			if(null != bdDto){
				if(bdDto.getDeleteFlag() == 0){
					vo.aryDeduction[i][1] = bdDto.getDetailName();
					vo.aryDeduction[i][2] = "0";
				}
			}
		}

		// xzږ̐ݒ
		for (int i = 0; i < vo.arySum.length ; i++) {
			bsDto = bsDao.findForKey( vo.arySum[i][0]);
			if(null != bsDto){
				if(bsDto.getDeleteFlag() == 0){
					vo.arySum[i][1] = bsDto.getDetailName();
					vo.arySum[i][2] = "0";
				}
			}
		}
	}
	
	/**
	 * vvZB
	 * @param employee Ј
	 * @param payment  ^`[
	 */
	protected void calcTotal(Employee employee, Bonus bonus) {
		bonus.calcSocInsTotal();
		bonus.calcTaxation();
		bonus.setIncomeTax(bonus.getDeductionAmount(BonusConst.DTL_BON_DEDUCTION_06));
		bonus.calcAllowance();
		bonus.calcDeduction();
		bonus.calcPaymentTotal();
		calcDivideAccounts(employee, bonus);
	}

	/**
	 * esւ̐UzyьxzvZB
	 * @param employee Ј
	 * @param payment  ^`[
	 */
	private void calcDivideAccounts(Employee employee, Bonus bonus) {
		// ϐ錾
		int bank1Amount = 0;
		int bank2Amount = 0;
		int cashAmount  = 0;
		// x@擾(x@Aԏ)
		List<CmPaymentMeansDto> list = employee.getPaymentMeans();
		// xz擾
		int total = bonus.getPaymentTotal();
		// x񖈂̏
		int currentAmount = total;
		for (Iterator<CmPaymentMeansDto> it = list.iterator(); it.hasNext();) {
			CmPaymentMeansDto dto = it.next();
			// Uz擾
			int amount = getdividedAmount(dto, total, currentAmount);
			// Uzݒ
			if (dto.getPaymentMeans().equals(PayrollConst.PAYMENT_MEANS_ACCOUNT)) {
				// Ȕꍇ
				if (dto.getMeansSequence() == PayrollConst.PAYMENT_MEANS_SEQ_1
						|| dto.getMeansSequence() == PayrollConst.PAYMENT_MEANS_SEQ_3) {
					bank1Amount += amount;
				} else {
					bank2Amount += amount;
				}
			} else {
				// UȊO()̏ꍇ
				cashAmount += amount;
			}
			// czvZ
			currentAmount -= amount;
		}
		// czɐݒ
		cashAmount += currentAmount;
		// ^ݒ
		bonus.setBank1PayAmount(bank1Amount);
		bonus.setBank2PayAmount(bank2Amount);
		bonus.setCashPayAmount (cashAmount );
	}

	/**
	 * Uxz擾
	 * @param dto           x@DTO
	 * @param totalAmount   Uz
	 * @param currentAmount Uz(cz)
	 */
	private int getdividedAmount(
			CmPaymentMeansDto dto, int totalAmount, int currentAmount
	) {
		// x񂪐ݒ肳ĂȂꍇ
		if (dto == null) {
			return 0;
		}
		// Sz̏ꍇ
		if (dto.getAmountType().equals(PayrollConst.AMOUNT_TYPE_ALL)) {
			return currentAmount;
		}
		// cz̏ꍇ
		if (dto.getAmountType().equals(PayrollConst.AMOUNT_TYPE_REST)) {
			return currentAmount;
		}
		// Uxz
		int dividingAmount = 0;
		// z敪̏
		if (dto.getAmountType().equals(PayrollConst.AMOUNT_TYPE_AMOUNT)) {
			// z̏ꍇ
			dividingAmount = dto.getFixedAmount();
		} else if (dto.getAmountType().equals(PayrollConst.AMOUNT_TYPE_RATIO)) {
			// 藦̏ꍇ
			// Uz * U / 100
			dividingAmount = (int)MospUtility.round(
					dto.getFixedAmount() / 100 * totalAmount, 0, BigDecimal.ROUND_HALF_UP);
		}
		// Uzȏ̏ꍇ
		if (dividingAmount > currentAmount) {
			dividingAmount = currentAmount;
		}
		return dividingAmount;
	}

	/**
	 * ܗ^o^B<br><br>
	 * @param payment ^
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 * @throws MospException 
	 */
	private void registPayment(
			Bonus bonus
	) throws SQLException, NoSuchFieldException, IllegalAccessException, MospException {
		// DAO
		PhBounsDao      phBounsDao      = new PhBounsDao     (cfg, cmd, aspUser, user, conn);
		PdBonAllowanceDao pdBonAllowanceDao = new PdBonAllowanceDao(cfg, cmd, aspUser, user, conn);
		PdBonDeductionDao pdBonDeductionDao = new PdBonDeductionDao(cfg, cmd, aspUser, user, conn);
		PdBonSumDao       pdBonTotalDao     = new PdBonSumDao      (cfg, cmd, aspUser, user, conn);
		// ܗ^wb_[XV
		if (BounsDataFlg == false){
			phBounsDao.update(bonus.getHeader(), true);
		} else {
			phBounsDao.insert(bonus.getHeader(), true);
		}
		// ܗ^׍폜
		pdBonAllowanceDao.delete(bonus.getKCode(), bonus.getCalcMonth());
		pdBonDeductionDao.delete(bonus.getKCode(), bonus.getCalcMonth());
		pdBonTotalDao    .delete(bonus.getKCode(), bonus.getCalcMonth());
		// ܗ^דo^
		pdBonAllowanceDao.insert(bonus.getAllowanceList());
		pdBonDeductionDao.insert(bonus.getDeductionList());
		pdBonTotalDao    .insert(bonus.getSumList      ());
	}

	/**
	 * ܗ^̌vZsB<br><br>
	 * @param kCode       vZΏێЈR[h
	 * @param targetMonth vZΏ۔N
	 * @throws Exception
	 */
	protected void calculate(String kCode, Date targetPaydate) throws Exception {
		BonusCardVo vo = (BonusCardVo)getVo();

		// DAO

		// l擾
		Employee employee = getEmployee(kCode);
		if(null == employee){
			String errMessage = MospUtility.getMessage(msg, "WU2103", ""); /* Message WU2103:Јf[^܂B */
			setNextCmd(CMD_BONUS_CARD_SHOW);
			addErrMessage(errMessage);
			throw new MospException(BonusConst.EX_RETIRED, errMessage);
		}else{

			// גlvZ
			calcDetails(vo);
			// ܗ^
//			adjustPayment(employee, payment, mapParams);
			// @TvZ
//			calcLegalDeduction(employee, payment);
			// vvZ
//			calcTotal(employee, vo);
			// אݒ
//			updateList(vo , false);
		}
	}


	/**
	 * גľvZsB<br><br>
	 * @param kCode       lCX^X̃|C^
	 * @param targetMonth vZΏ۔N
	 * @throws Exception
	 */
	protected void calcDetails(BonusCardVo vo) throws Exception {
		// vZp[NGȀ
		sumAllowance	= 0;
		sumDeduction	= 0;
		sumDatail		= 0;

		// xڂ̌vZ
		for (int i = 0; i < vo.aryAllowance.length ; i++) {
			sumAllowance += Integer.valueOf(vo.aryAllowance[i][2]);
		}
		// Tڂ̌vZ
		for (int i = 0; i < vo.aryDeduction.length ; i++) {
			sumDeduction += Integer.valueOf(vo.aryDeduction[i][2]);
		}

		// xzڂ̐ݒ
		vo.arySum[0][2] =  String.valueOf(sumAllowance);
		vo.arySum[1][2] =  String.valueOf(sumDeduction);  
		if( sumAllowance < sumDeduction){
			String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_BONUS_TATAL_OVER , "");
			addErrMessage(errMessage);
		}
		sumDatail = sumAllowance - sumDeduction;
		vo.arySum[2][2] =  String.valueOf(sumDatail);
	}	


	/**
	 * ܗ^̌vZsB<br><br>
	 * @param kCode       vZΏێЈR[h
	 * @param targetMonth vZΏ۔N
	 * @throws Exception
	 */
	protected void cardTotal(String kCode, Date targetPaydate) throws Exception {
		// 
		bank1Amount = 0;
		bank2Amount = 0;
		cashAmount  = 0;
		BonusCardVo vo = (BonusCardVo)getVo();

		// DAO&DTȌ
		CmPaymentMeansDao cmPaymentMeansDao = new CmPaymentMeansDao();
		cmPaymentMeansDao.initDao(cfg, cmd, aspUser, user, conn);
		List<CmPaymentMeansDto> cmPaymentMeansDto_l = 
			cmPaymentMeansDao.findForEmployeeAllowance(kCode, BonusConst.ALLOWANCE_TYPE_BONUS); 
			
		// x@擾(x@Aԏ)
		// x񖈂̏
		if( vo.arySum[2][2].equals("") || vo.arySum[2][2].equals("0")){
			String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_BONUS_CALC_NG , "");
			addErrMessage(errMessage);
			throw new MospException(BonusConst.EX_NOT_CURRENT, errMessage);
		}else{
			int currentAmount =    Integer.valueOf(vo.arySum[2][2]);
			if(currentAmount < 0){
				cashAmount = currentAmount; 
			}else{	
				for (Iterator<CmPaymentMeansDto> it = cmPaymentMeansDto_l.iterator(); it.hasNext();) {
					CmPaymentMeansDto dto = it.next();
					// Uz擾
					int amount = getdividedAmount(dto, currentAmount, currentAmount);
					// Uzݒ
					if (dto.getPaymentMeans().equals(BonusConst.PAYMENT_MEANS_ACCOUNT)) {
						// Ȕꍇ
						if (dto.getMeansSequence() == BonusConst.PAYMENT_MEANS_SEQ_1
								|| dto.getMeansSequence() == BonusConst.PAYMENT_MEANS_SEQ_3) {
							bank1Amount += amount;
						} else {
							bank2Amount += amount;
						}
					} else {
						// UȊO()̏ꍇ
						cashAmount += amount;
					}
					// czvZ
					currentAmount -= amount;
				}
				// czɐݒ
				cashAmount += currentAmount;
			}
			
			for (int i = 0; i < vo.arySum.length ; i++) {
				if(vo.arySum[i][0].equals("BS011")){
						vo.arySum[i][2] = String.valueOf(bank1Amount);
				}else if(vo.arySum[i][0].equals("BS012")){
					vo.arySum[i][2] = String.valueOf(bank2Amount);					
				}else if(vo.arySum[i][0].equals("BS013")){
					vo.arySum[i][2] = String.valueOf(cashAmount);					
				}
			}
		}
	}

}

