package jp.mosp.payroll.base;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.mosp.common.common.MospException;
import jp.mosp.express.ExpressUtility;
import jp.mosp.payroll.bonus.dto.PmDetailBsDto;
import jp.mosp.payroll.dto.DetailDto;

/**
 * ^vZ֘A`[̌ƂȂNXB<br><br>
 */
public abstract class PayrollSlipBonus {
	/**
	 * ׏擾B
	 * @param detailCode ׃R[h
	 */
	protected DetailDto getDetailDto(List<?> list, String detailCode) {
		for (Iterator<?> it = list.iterator(); it.hasNext();) {
			DetailDto dto = (DetailDto)it.next();
			if (dto.getDetailCode().equals(detailCode)) {
				return dto;
			}
		}
		return null;
	}
	
	/**
	 * ׃Xgݒ肷B
	 * @param aryDetail ݒΏۖהz
	 * @return ׃Xg
	 */
	protected void setDetails(List<?> listDetail, String[][] aryDetail) {
		for (Iterator<?> it = listDetail.iterator(); it.hasNext();) {
			DetailDto dto = (DetailDto)it.next();
			for (int i = 0; i < aryDetail.length; i++) {
				if (dto.getDetailCode().equals(aryDetail[i][0])) {
					setDetailAmount(dto, Float.parseFloat(aryDetail[i][2]));
					break;
				}
			}
		}
	}
	
	/**
	 * גl擾B
	 * @param list 擾ΏۃXg
	 * @param detailCode 擾Ώۖ׃R[h
	 * @return גl
	 */
	protected float getDetailAmount(List<?> list, String detailCode) {
		for (Iterator<?> it = list.iterator(); it.hasNext();) {
			DetailDto dto = (DetailDto)it.next();
			if (dto.getDetailCode().equals(detailCode)) {
				if (dto instanceof PmDetailBsDto) {
					PmDetailBsDto detailBsDto = (PmDetailBsDto)dto;
					return detailBsDto.getAmount();
				}
			}
		}
		return 0;
	}
	
	/**
	 * הz擾B
	 * @param list             擾ΏۃXg
	 * @param checkDisplayType 0󎚋敪mFv
	 * @return הz
	 */
	protected String[][] getAryDetail(List<?> list, boolean checkDisplayType) {
		String[][] aryDetail = new String[list.size()][3];
		for (int i = 0; i < list.size(); i++) {
			DetailDto dto = (DetailDto)list.get(i);
			aryDetail[i][0] = dto.getDetailCode();
			aryDetail[i][1] = dto.getDetailAbbr();
			aryDetail[i][2] = "0";
			if (dto instanceof PmDetailBsDto) {
				aryDetail[i][2] = String.valueOf(((PmDetailBsDto)dto).getAmount());
			}
			if (checkDisplayType && dto.getDisplayType() == PayrollConst.DETAIL_DISP_NONE) {
				if (String.valueOf(aryDetail[i][2]).equals("0")) {
					aryDetail[i][1] = "";
					aryDetail[i][2] = "";
				}
			}
		}
		return aryDetail;
	}
	
	/**
	 * גlݒ肷B
	 * @param list       ׏
	 * @param listAmount גlXg
	 */
	protected void setDetailsAmount(List<?> list, List<?> listAmount) {
		for (Iterator<?> it = list.iterator(); it.hasNext();){
			DetailDto dto = (DetailDto)it.next();
			for (Iterator<?> itAmount = listAmount.iterator(); itAmount.hasNext();) {
				DetailDto dtoAmount = (DetailDto)itAmount.next();
				if (dto.getDetailCode().equals(dtoAmount.getDetailCode())) {
					if (dtoAmount instanceof PmDetailBsDto) {
						setDetailAmount(dto, ((PmDetailBsDto)dtoAmount).getAmount());
						break;
					}
				}
			}
		}
	}
	
	/**
	 * גlvZB
	 * @param listDetail ׃Xg
	 * @param mapParams  p[^Map
	 * @throws MospException 
	 */
	protected void calcDetails(List<?> listDetail, Map<String, String> mapParams) throws MospException {
		for (Iterator<?> it = listDetail.iterator(); it.hasNext();){
			DetailDto dto = (DetailDto)it.next();
			setDetailAmount(dto, calcExpr(dto.getExpression(), mapParams));
		}
	}
	
	/**
	 * גlvZB
	 * @param detailDto DTO
	 * @param mapParams p[^Map
	 * @throws MospException 
	 */
	protected void setDetailAmount(DetailDto detailDto, float amount) {
		if (detailDto instanceof PmDetailBsDto) {
			PmDetailBsDto dto = (PmDetailBsDto)detailDto;
			dto.setAmount((int)amount);
			return;
		}
		
	}
	
	/**
	 * ׂB
	 * @param Ώۖ׃Xg
	 */
	protected void initDetails(List<?> list, String kCode, Date calcDate) {
		for (Iterator<?> it = list.iterator(); it.hasNext();){
			initDetail((DetailDto)it.next(), kCode, calcDate);
		}
	}
	
	/**
	 * ׂB
	 * @param Ώۖ
	 */
	private void initDetail(DetailDto dto, String kCode, Date calcDate) {
		dto.setKCode   (kCode   );
		dto.setCalcDate(calcDate);
		if (dto instanceof PmDetailBsDto) {
			((PmDetailBsDto)dto).setAmount(0);
			return;
		}
	}
	
	/**
	 * vZvZB<br>
	 * @param expression vZ
	 * @param mapParams  p[^
	 * @return vZl
	 * @throws MospException 
	 */
	protected float calcExpr(
			String expression, Map<String, String> mapParams
	) throws MospException {
		return ExpressUtility.calculate(
				expression, mapParams, new HashMap<String, String[][]>());
	}
}
