package jp.mosp.payroll.base;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.bonus.dto.PhBounsDto;
import jp.mosp.payroll.bonus.dto.PmDetailBaDto;
import jp.mosp.payroll.bonus.dto.PmDetailBdDto;
import jp.mosp.payroll.bonus.dto.PmDetailBsDto;
import jp.mosp.payroll.dto.DetailDto;


public class Bonus extends PayrollSlipBonus {
	/**
	 * ^wb_[B<br>
	 */
	private PhBounsDto header;
	
	/**
	 * x׏B<br>
	 */
	private List<PmDetailBaDto> allowance;
	
	/**
	 * T׏B<br>
	 */
	private List<PmDetailBdDto> deduction;
	
	/**
	 * v׏B<br>
	 */
	private List<PmDetailBsDto> sum;

	/**
	 * CX^XsB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link }
	 * </li></ul>
	 */
	public Bonus() {
		super();
	}

	
	/**
	 * CX^X𐶐AtB[hݒ肷B<br>
	 * @param header    ^wb_[
	 * @param time      ΑӖ׏
	 * @param allowance x׏
	 * @param deduction T׏
	 * @param breakdown 󖾍׏
	 * @param sum       v׏
	 */
	public Bonus(
			PhBounsDto         header         ,
			List<PmDetailBaDto   > allowance      ,
			List<PmDetailBdDto   > deduction      ,
			List<PmDetailBsDto> sum 
			) {
		this.header    = header   ;
		this.allowance = allowance;
		this.deduction = deduction;
		this.sum       = sum      ;
		initDetails();
	}
	
	
	/**
	 * CX^X𐶐AtB[hݒ肷B<br>
	 * @param header          ^wb_[
	 * @param time            ΑӖ׏
	 * @param allowance       x׏
	 * @param deduction       T׏
	 * @param breakdown       󖾍׏
	 * @param sum             v׏
	 * @param amountTime      ΑӖ׏
	 * @param amountAllowance x׏
	 * @param amountDeduction T׏
	 * @param amountBreakdown 󖾍׏
	 * @param amountSum       v׏
	 */
	public Bonus(
			PhBounsDto         header         ,
			List<PmDetailBaDto   > allowance      ,
			List<PmDetailBdDto   > deduction      ,
			List<PmDetailBsDto> sum            ,
			List<PmDetailBsDto> amountAllowance,
			List<PmDetailBsDto> amountDeduction,
			List<PmDetailBsDto> amountSum      
	) {
		this.header    = header   ;
		this.allowance = allowance;
		this.deduction = deduction;
		this.sum       = sum      ;
		initDetails();
		setDetailsAmount(allowance, amountAllowance);
		setDetailsAmount(deduction, amountDeduction);
		setDetailsAmount(sum      , amountSum      );
	}
	
	/**
	 * ׂB
	 */
	private void initDetails() {
		initDetails(allowance, getKCode(), getCalcMonth());
		initDetails(deduction, getKCode(), getCalcMonth());
		initDetails(sum      , getKCode(), getCalcMonth());
	}
	
	/**
	 * גlvZB
	 * @param mapParams p[^Map
	 * @throws MospException 
	 */
	public void calcDetails(Map<String, String> mapParams) throws MospException {
		calcDetails(allowance, mapParams);
		calcDetails(deduction, mapParams);
		calcDetails(sum      , mapParams);
	}
	
	/**
	 * גlݒ肷B
	 * @param aryTime      ΑӖגl
	 * @param aryAllowance xגl
	 * @param aryDeduction Tגl
	 * @param aryBreakdown 󖾍גl
	 * @param arySum       vגl
	 */
	public void setDetails(
			String[][] aryTime     ,
			String[][] aryAllowance,
			String[][] aryDeduction,
			String[][] aryBreakdown,
			String[][] arySum
	) {
		setDetails(allowance, aryAllowance);
		setDetails(deduction, aryDeduction);
		setDetails(sum      , arySum      );
	}
	
	/**
	 * גlݒ肷B
	 * @param aryTime      ΑӖגl
	 * @param aryAllowance xגl
	 * @param aryDeduction Tגl
	 * @param aryBreakdown 󖾍גl
	 * @param arySum       vגl
	 */
	public void setDetails2(
			String[][] aryTime     ,
			String[][] aryAllowance,
			String[][] aryDeduction,
			String[][] aryBreakdown,
			String[][] arySum,
			Employee employee,
			Date targetMonth
	) {
		PhBounsDto header2 = new PhBounsDto();
		header2.setKCode(employee.getKCode());
		header2.setCalcMonth(targetMonth);
		header2.setPayDate(targetMonth);
		header2.setSlipCode("B***");
		//}{l
		header2.setDependent(employee.getDependent());
		//for (int i = 0; i < arySum.length; i++){
		//	if (arySum[i][0].equals("BS001")){
		//		header2.setAllowanceTotal(Integer.valueOf(arySum[i][2]));
		//		continue;
		//	}
		//	if (arySum[i][0].equals("BS002")){
		//		header2.setDeductionTotal(Integer.valueOf(arySum[i][2]));
		//		continue;
		//	}
		//	if (arySum[i][0].equals("BS003")){
		//		header2.setPaymentTotal(Integer.valueOf(arySum[i][2]));
		//		continue;
		//	}
			
		//}
		header = header2;
		allowance = getAryAllowance(aryAllowance, employee, targetMonth);
		deduction = getAryDeduction(aryDeduction, employee, targetMonth);
		sum = getArySum(arySum, employee, targetMonth);
	}
	
	/**
	 * xגlݒ肷B
	 * @param aryAllowance xגl
	 * @retuen List<PmDetailBaDto>
	 */
	private List<PmDetailBaDto> getAryAllowance(String[][] aryAllowance, Employee employee, Date targetMonth) {
		List<PmDetailBaDto> allowance = new ArrayList<PmDetailBaDto>(aryAllowance.length);
		for (int i = 0; i < aryAllowance.length; i++){
			PmDetailBaDto dto = new PmDetailBaDto();
			dto.setKCode(employee.getKCode());
			dto.setCalcDate(targetMonth);
			dto.setDetailCode(aryAllowance[i][0]);
			dto.setAmount(Integer.valueOf(aryAllowance[i][2]));
			allowance.add(i, dto);
		}
		return allowance;
	}
	
	/**
	 * xגlݒ肷B
	 * @param aryDeduction xגl
	 * @retuen List<PmDetailBaDto>
	 */
	private List<PmDetailBdDto> getAryDeduction(String[][] aryDeduction, Employee employee, Date targetMonth) {
		List<PmDetailBdDto> deduction = new ArrayList<PmDetailBdDto>(aryDeduction.length);
		for (int i = 0; i < aryDeduction.length; i++){
			PmDetailBdDto dto = new PmDetailBdDto();
			dto.setKCode(employee.getKCode());
			dto.setCalcDate(targetMonth);
			dto.setDetailCode(aryDeduction[i][0]);
			dto.setAmount(Integer.valueOf(aryDeduction[i][2]));
			deduction.add(i, dto);
		}
		return deduction;
	}
	
	/**
	 * xגlݒ肷B
	 * @param aryDeduction xגl
	 * @retuen List<PmDetailBaDto>
	 */
	private List<PmDetailBsDto> getArySum(String[][] arySum, Employee employee, Date targetMonth) {
		List<PmDetailBsDto> sum = new ArrayList<PmDetailBsDto>(arySum.length);
		for (int i = 0; i < arySum.length; i++){
			PmDetailBsDto dto = new PmDetailBsDto();
			dto.setKCode(employee.getKCode());
			dto.setCalcDate(targetMonth);
			dto.setDetailCode(arySum[i][0]);
			dto.setAmount(Integer.valueOf(arySum[i][2]));
			sum.add(i, dto);
		}
		return sum;
	}
	
	/**
	 * xגlݒ肷B
	 * @param detailCode ׃R[h
	 * @param amount גl
	 */
	public void setAllowanceAmount(String detailCode, int amount) {
		setDetailAmount(getDetailDto(allowance, detailCode), amount);
	}
	
	/**
	 * Tגlݒ肷B
	 * @param detailCode ׃R[h
	 * @param amount גl
	 */
	public void setDeductionAmount(String detailCode, int amount) {
		setDetailAmount(getDetailDto(deduction, detailCode), amount);
	}
	
	/**
	 * vגlݒ肷B
	 * @param detailCode ׃R[h
	 * @param amount גl
	 */
	public void setSumAmount(String detailCode, int amount) {
		setDetailAmount(getDetailDto(sum, detailCode), amount);
	}
	
	/**
	 * xגl擾B
	 * @param detailCode ׃R[h
	 * @return גl
	 */
	public int getAllowanceAmount(String detailCode) {
		return (int)getDetailAmount(allowance, detailCode);
	}
	
	/**
	 * Tגl擾B
	 * @param detailCode ׃R[h
	 * @return גl
	 */
	public int getDeductionAmount(String detailCode) {
		return (int)getDetailAmount(deduction, detailCode);
	}
	
	/**
	 * vגl擾B
	 * @param detailCode ׃R[h
	 * @return גl
	 */
	public int getSumAmount(String detailCode) {
		return (int)getDetailAmount(sum, detailCode);
	}
	
	/**
	 * ЈR[hݒ肷B
	 * @param kCode ݒ肷ЈR[h
	 */
	public void setKCode(String kCode) {
		header.setKCode(kCode);
	}
	
	/**
	 * ЈR[h擾B<br>
	 * @return ЈR[h
	 */
	public String getKCode() {
		return header.getKCode();
	}
	
	/**
	 * vZNݒ肷B<br>
	 * @param calcDate ݒ肷vZN
	 */
	public void setCalcDate(Date calcDate) {
		header.setCalcMonth(calcDate);
	}
	
	/**
	 * vZN擾B<br>
	 * @return vZN
	 */
	public Date getCalcMonth() {
		return header.getCalcMonth();
	}
	
	/**
	 * xݒ肷B<br>
	 * @param payDate ݒ肷x
	 */
	public void setPayDate(Date payDate) {
		header.setPayDate(payDate);
	}
	
	/**
	 * `[R[hݒ肷B<br>
	 * @param slipCode ݒ肷`[R[h
	 */
	public void setSlipCode(String slipCode) {
		header.setSlipCode(slipCode);
	}
	
	/**
	 * ^wb_[擾B
	 * @return גl
	 */
	public PhBounsDto getHeader() {
		return header;
	}
	
	/**
	 * xהz擾B
	 * @param checkDisplayType 0󎚋敪mFv
	 * @return הz
	 */
	public String[][] getAllowanceArray(boolean checkDisplayType) {
		return getAryDetail(allowance, checkDisplayType);
	}
	
	/**
	 * Tהz擾B
	 * @param checkDisplayType 0󎚋敪mFv
	 * @return הz
	 */
	public String[][] getDeductionArray(boolean checkDisplayType) {
		return getAryDetail(deduction, checkDisplayType);
	}
	
	/**
	 * vהz擾B
	 * @param checkDisplayType 0󎚋敪mFv
	 * @return הz
	 */
	public String[][] getSumArray(boolean checkDisplayType) {
		return getAryDetail(sum, checkDisplayType);
	}
	
	/**
	 * x׃Xg擾B
	 * @return ׃Xg
	 */
	public List<PmDetailBaDto> getAllowanceList() {
		return allowance;
	}
	
	/**
	 * T׃Xg擾B
	 * @return ׃Xg
	 */
	public List<PmDetailBdDto> getDeductionList() {
		return deduction;
	}
	
	/**
	 * v׃Xg擾B
	 * @return ׃Xg
	 */
	public List<PmDetailBsDto> getSumList() {
		return sum;
	}
	
	/**
	 * vZN擾B<br>
	 * @return vZN
	 */
	public String getCalcMonthStr() {
		return MospUtility.getDateString(getCalcMonth(), PayrollConst.FORMAT_YEAR_MONTH_DAY);
	}
	
	/**
	 * x擾B
	 * @return x
	 */
	public String getPayDate() {
		return MospUtility.getDateString(header.getPayDate(), PayrollConst.FORMAT_DATE);
	}
	
	/**
	 * ېőΏۊz擾B
	 * @return ېőΏۊz
	 */
	public int getTaxation() {
		return header.getTaxation();
	}

	/**
	 * ٗpیΏۊz擾B
	 * @return ٗpیΏۊz
	 */
	public int getInsureUnemploy() {
		return header.getInsureUnemploy();
	}

	/**
	 * Љیv擾B
	 * @return Љیv
	 */
	public int getSocInsTotal() {
		return header.getSocInsTotal();
	}

	/**
	 * }{̐擾B
	 * @return }{̐
	 */
	public int getDependent() {
		return header.getDependent();
	}
	
	/**
	 * Ŋz擾B
	 * @return Ŋz
	 */
	public int getIncomeTax() {
		return header.getIncomeTax();
	}
	
	/**
	 * xz擾B
	 * @return xz
	 */
	public int getAllowanceTotal() {
		return header.getAllowanceTotal();
	}
	
	/**
	 * Tz擾B
	 * @return Tz
	 */
	public int getDeductionTotal() {
		return header.getDeductionTotal();
	}
	
	/**
	 * xz擾B
	 * @return xz
	 */
	public int getPaymentTotal() {
		return header.getPaymentTotal();
	}
	
	/**
	 * ʋΎ蓖ݒ肷B
	 * @param amount ʋΎ蓖
	 */
	public void setCommutation(int amount) {
		setDetailAmount(getDetailDto(allowance, PayrollConst.DTL_COMMUTATION), amount);
	}
	
	/**
	 * Nیݒ肷B
	 * @param amount Nی
	 */
	public void setHealthInsurance(int amount) {
		setDetailAmount(getDetailDto(deduction, PayrollConst.DTL_HEALTH_INS), amount);
	}
	
	/**
	 * یݒ肷B
	 * @param amount ی
	 */
	public void setNursingInsurance(int amount) {
		setDetailAmount(getDetailDto(deduction, PayrollConst.DTL_NURSING_INS), amount);
	}
	
	/**
	 * Nݒ肷B
	 * @param amount N
	 */
	public void setPensionInsurance(int amount) {
		setDetailAmount(getDetailDto(deduction, PayrollConst.DTL_PENSION_INS), amount);
	}
	
	/**
	 * Nݒ肷B
	 * @param amount N
	 */
	public void setPensionFund(int amount) {
		setDetailAmount(getDetailDto(deduction, PayrollConst.DTL_PENSION_FUND), amount);
	}
	
	/**
	 * ٗpیݒ肷B
	 * @param amount ٗpی
	 */
	public void setEmployeeInsurance(int amount) {
		setDetailAmount(getDetailDto(deduction, PayrollConst.DTL_EMPLOYEE_INS), amount);
	}
	
	/**
	 * łݒ肷B
	 * @param amount ݒ肷鏊
	 */
	public void setIncomeTax(int amount) {
		setDetailAmount(getDetailDto(deduction, PayrollConst.DTL_INCOME_TAX), amount);
		header.setIncomeTax(amount);
	}
	
	/**
	 * Złݒ肷B
	 * @param amount ݒ肷Z
	 */
	public void setResidenceTax(int amount) {
		setDetailAmount(getDetailDto(deduction, PayrollConst.DTL_RESIDENCE_TAX), amount);
	}
	
	/**
	 * s1Uzݒ肷B
	 * @param amount ݒ肷s1Uz
	 */
	public void setBank1PayAmount(int amount) {
		setDetailAmount(getDetailDto(sum, PayrollConst.DTL_SUM_BANK1), amount);
	}
	
	/**
	 * s2Uzݒ肷B
	 * @param amount ݒ肷s2Uz
	 */
	public void setBank2PayAmount(int amount) {
		setDetailAmount(getDetailDto(sum, PayrollConst.DTL_SUM_BANK2), amount);
	}
	
	/**
	 * xzݒ肷B
	 * @param amount ݒ肷s1Uz
	 */
	public void setCashPayAmount(int amount) {
		setDetailAmount(getDetailDto(sum, PayrollConst.DTL_SUM_CASH), amount);
	}
	
	/**
	 * ЉیvvZB
	 */
	public void calcSocInsTotal() {
		long sum = 
			getAllowanceAmount(PayrollConst.DTL_HEALTH_INS  ) +
			getAllowanceAmount(PayrollConst.DTL_NURSING_INS ) +
			getAllowanceAmount(PayrollConst.DTL_PENSION_INS ) +
			getAllowanceAmount(PayrollConst.DTL_PENSION_FUND) +
			getAllowanceAmount(PayrollConst.DTL_EMPLOYEE_INS);
		setSumAmount(PayrollConst.DTL_SUM_SOC_INS, (int)sum);
		header.setSocInsTotal((int)sum);
	}
	
	/**
	 * xzvZB
	 */
	public void calcAllowance() {
		long sum = 0L;
		for (Iterator<PmDetailBaDto> it = allowance.iterator(); it.hasNext();) {
			sum += it.next().getAmount();
		}
		sum = sum < 0 ? 0 : sum;
		setSumAmount(PayrollConst.DTL_SUM_ALLOWANCE, (int)sum);
		header.setAllowanceTotal((int)sum);
	}
	
	/**
	 * TzvZB
	 */
	public void calcDeduction() {
		long sum = 0L;
		for (Iterator<PmDetailBdDto> it = deduction.iterator(); it.hasNext();) {
			sum += it.next().getAmount();
		}
		sum = sum < 0 ? 0 : sum;
		setSumAmount(PayrollConst.DTL_SUM_DEDUCTION, (int)sum);
		header.setDeductionTotal((int)sum);
	}
	
	/**
	 * xzvZB
	 */
	public void calcPaymentTotal() {
		long sum = 0L;
		sum = getAllowanceTotal() - getDeductionTotal();
		setSumAmount(PayrollConst.DTL_SUM_TOTAL, (int)sum);
		header.setPaymentTotal((int)sum);
	}
	
	/**
	 * ٗpیΏۊzvZB
	 */
	public void calcUnemployInsuration() {
		long insureUnemploy = 0L;
		for (Iterator<PmDetailBaDto> it = allowance.iterator(); it.hasNext();) {
			PmDetailBaDto dto = it.next();
			if (dto.getUeInsType() == PayrollConst.DETAIL_UE_ADD) {
				insureUnemploy += dto.getAmount();
				continue;
			}
		}
		insureUnemploy = insureUnemploy > 0 ? insureUnemploy : 0;
		header.setInsureUnemploy((int)insureUnemploy);
	}
	
	/**
	 * ېőΏۊzvZB
	 */
	public void calcTaxation() {
		long taxation = 0L;
		for (Iterator<PmDetailBaDto> it = allowance.iterator(); it.hasNext();) {
			PmDetailBaDto dto = it.next();
			if (dto.getTaxationType() == PayrollConst.DETAIL_TAX_ADD) {
				taxation += dto.getAmount();
				continue;
			}
		}
		taxation = taxation > 0 ? taxation : 0;
		setSumAmount(PayrollConst.DTL_SUM_TAXATION, (int)taxation);
		header.setTaxation((int)taxation);
	}
	
	/**
	 * }{̐ݒ肷B
	 * @param dependent ݒ肷}{̐
	 */
	public void setDependent(byte dependent) {
		header.setDependent(dependent);
	}
	
	/**
	 * ЉیT̋z擾B
	 * @return ЉیT̋z
	 */
	public int getAfterDeduction() {
		int afterDeduction = getTaxation() - getSocInsTotal();
		return afterDeduction > 0 ? afterDeduction : 0;
	}
	
	/**
	 * Pݒ荀ڂ擾B
	 * @return Pݒ荀ڔz
	 */
	public String[][] getUnitItem() {
		List<DetailDto> list = new ArrayList<DetailDto>();
		for (int i = 0; i < allowance.size(); i++) {
			DetailDto dto = allowance.get(i);
			if (dto.getInputType() == PayrollConst.DETAIL_IN_UNIT) {
				list.add(dto);
			}
		}
		for (int i = 0; i < deduction.size(); i++) {
			DetailDto dto = deduction.get(i);
			if (dto.getInputType() == PayrollConst.DETAIL_IN_UNIT) {
				list.add(dto);
			}
		}
		for (int i = 0; i < sum.size(); i++) {
			DetailDto dto = sum.get(i);
			if (dto.getInputType() == PayrollConst.DETAIL_IN_UNIT) {
				list.add(dto);
			}
		}
		return getAryDetail(list, false);
	}
}
