package jp.mosp.payroll.base;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;


import jp.mosp.common.bean.OdsBean;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.PoiUtility;
import jp.mosp.common.dao.CmCodeDao;
import jp.mosp.common.dao.MosPConfDao;
import jp.mosp.common.dto.CmCodeDto;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.common.part.DatePart;
import jp.mosp.human.dao.MKojinDao;
import jp.mosp.human.dto.MKihonDto;
import jp.mosp.human.dto.MKojinDto;
import jp.mosp.legal.LegalConst;
import jp.mosp.legal.LegalUtility;
import jp.mosp.payroll.bonus.dao.PdBonAllowanceDao;
import jp.mosp.payroll.bonus.dao.PdBonDeductionDao;
import jp.mosp.payroll.bonus.dao.PdBonSumDao;
import jp.mosp.payroll.bonus.dao.PhBounsDao;
import jp.mosp.payroll.bonus.dto.PhBounsDto;
import jp.mosp.payroll.dao.CdAdjustmentDao;
import jp.mosp.payroll.dao.CdSocInsuranceDao;
import jp.mosp.payroll.dao.CmIncomeTaxDao;
import jp.mosp.payroll.dao.CmMidwayEnterDao;
import jp.mosp.payroll.dao.CmSocInsuranceDao;
import jp.mosp.payroll.dao.MKihonPayrollDao;
import jp.mosp.payroll.dao.PdPayAllowanceDao;
import jp.mosp.payroll.dao.PdPayDeductionDao;
import jp.mosp.payroll.dao.PdPaySumDao;
import jp.mosp.payroll.dao.PdPayTimeDao;
import jp.mosp.payroll.dao.PhPaymentDao;
import jp.mosp.payroll.dao.PtCurrentDao;
import jp.mosp.payroll.dto.CdAdjustmentDto;
import jp.mosp.payroll.dto.CmCompanyDto;
import jp.mosp.payroll.dto.CmIncomeTaxDto;
import jp.mosp.payroll.dto.CmMidwayEnterDto;
import jp.mosp.payroll.dto.PhPaymentDto;
import jp.mosp.payroll.dto.PtCurrentDto;
import jp.mosp.system.dao.MSyozokuDao;
import jp.mosp.system.dao.MYakusyokuDao;
import jp.mosp.system.dto.MSyozokuDto;
import jp.mosp.system.dto.MYakusyokuDto;

public abstract class AdjustmentAction extends CalculateAction {
	
	// tB[h
	protected int    adjustYear;
	protected Date   startAdjDate  ;
	protected Date   lastDate  ;

	protected String targetData;
	protected int    adjTargetMonth;
	
	protected Date targetBefDate;
	protected Date targetAffDate;
	
	boolean isCalcAdjust = true;
	
	private   int socInsDeduction  = 0;	// Љی^̍T
	
	protected PdPayAllowanceDao	pdPayAllowanceDao;	// ^T׃f[^
	protected PdPayDeductionDao	pdPayDeductionDao;	// ^x׃f[^
	protected PdBonAllowanceDao	pdBonAllowanceDao;	// ܗ^T׃f[^
	protected PdBonDeductionDao	pdBonDeductionDao;	// ܗ^x׃f[^
	
	protected CdAdjustmentDao		cdAdjustmentDao ;	// Nf[^
	protected CdAdjustmentDto		cdAdjustmentDto ;	// Nf[^
	protected CmIncomeTaxDao		cmIncomeTaxDao  ;	// l}X^ŕ 
	protected CmIncomeTaxDto		cmIncomeTaxDto  ;	// l}X^ŕ
	protected MKihonPayrollDao		mKihonPayrollDao;	// l{
	protected CmMidwayEnterDao		cmMidwayEnterDao;	// l}X^rЕ
	protected CmMidwayEnterDto		cmMidwayEnterDto;	// l}X^rЕ
	protected PhPaymentDao			phPaymentDao;		// ^wb_[
	protected PhPaymentDto			phPaymentDto;		// ^wb_[
	protected PhBounsDao			phBonusDao;			// ܗ^wb_[
	protected PhBounsDto			phBonusDto;			// ܗ^wb_[
	protected MKojinDao			mKojinDao;			// lǗ      
	protected MKojinDto			mKojinDto;			// lǗ    

	protected CmSocInsuranceDao	cmSocInsuranceDao;	// l}X^Љی  

	
	protected PdPaySumDao  pdPaySumDao;				// ^׍v
	protected PdPayTimeDao pdPayTimeDao;
	protected PdBonSumDao  pdBonSumDao;				// ܗ^׍v
	
	
	// vZΏۋ^f[^擾
	protected List<PhPaymentDto> listPaymentData;
	// vZΏۏܗ^f[^擾
	protected List<PhBounsDto> listBonusData;
	protected CmCompanyDto cmCompanyDto;
	
	/**
	 * NvZɕKvȍڂ̍vvZ
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	protected void calcNeedAdjust(
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// 
		socInsDeduction = 0;
		// ^f[^vݒ
		setTotalPaymentData();
		// ܗ^f[^vݒ
		setTotalBonusData();
		// rAf[^ݒ
		setMidwayAdjustIncomeData();
		// Љی^̍Tݒ
		setPayInsDeduction();
		// NŊzݒ(NvZɂ㏑)
		cdAdjustmentDto.setFinalIncomeTax(cdAdjustmentDto.getIncomeTaxSum());
	}
	
	/**
	 * NvZ
	 * @throws Exception 
	 */
	protected void adjustIncomeTax() throws Exception {
		// ^T̋^̋zݒ
		setIncomePaymentData();
		if (isCalcAdjust) {
			// **@Nf[^e[u擾͓̂͂ĂO@**
			// zҁA}{AbяQғ̍Tz̍vݒ
			setLegalTotalDeduction();
			// ېŋ^z
			setTaxedIncome();
			// ZoNŊzݒ
			setCalcIncomeTax();
			if (isCalcAdjust) {
				// NNŊzݒ
				setAdjustIncomeTax();
				// N藦TŊzݒ
				setDeductedIncomeTax();
				// NŊzݒ
				setFinalIncomeTax();
				// ŏC
				addIncomeTaxData();
				// Ώۃf[^m菈
				addTotalData();
			}
		}
		// vZ_ŔNvZΏۊOƔfꂽꍇ̓Xe[^XΏۊO
		if (!isCalcAdjust) {
			// 
			isCalcAdjust = true;
			// Xe[^Xݒ(NvZΏۊO)
			cdAdjustmentDto.setAdjustStatus(PayrollConst.ADJU_STATUS_OOT);
		} else {
			// Xe[^Xݒ(NvZς)
			cdAdjustmentDto.setAdjustStatus(PayrollConst.ADJU_STATUS_FIX);
		}
	}
	
	/**
	 * Ώۃf[^AݒNݒ
	 * @throws Exception
	 */
	protected void setTargetData() throws Exception {
		// ݒe[uΏۃf[^ݒ擾
		targetData      = getConfValue(PayrollConst.CONF_ID_ADJ_TRGT, PayrollConst.CONF_CD_ADJ_TRGT);

		// CM_CONFe[u"ADJ_TRGT"ݒ肳ĂȂꍇ͔NΏۃf[^F^ƂB
		if(targetData.equals("")){
			targetData = PayrollConst.ADJ_PAYMENT_TARGET;
		}
		// ΏۊԐݒ
		setTargetPeriod();
	}
	
	/**
	 * f[^쐬(Ώۃf[^^̏ꍇ)
	 * @throws Exception
	 */
	protected void setTargetPaymentData() throws Exception {
		if (targetData.equals(PayrollConst.ADJ_PAYMENT_TARGET)) {
			// ^f[^ݒ
			phPaymentDto = phPaymentDao.findForKey(kCode, targetAffDate);
		} else if (targetData.equals(PayrollConst.ADJ_BONUS_TARGET)) {
			// ܗ^()
			setTargetBonusData();
		}
	}
	
	/**
	 * f[^쐬(Ώۃf[^ܗ^̏ꍇ)
	 */
	protected void setTargetBonusData() {
		// 
	}

	/**
	 * ^f[^vݒ
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	private void setTotalPaymentData() throws SQLException, IllegalAccessException, NoSuchFieldException {
		// vZΏۋ^f[^擾
		List<PhPaymentDto> listPaymentData = phPaymentDao.findForConditionDate(
				kCode,targetBefDate, targetAffDate
		);
		// ݒ菀
		int taxation = 0;
		int socInsurance = 0;
		int incomeTax = 0;
		
		for (int i = 0; i < listPaymentData.size(); i++) {
			PhPaymentDto dto = listPaymentData.get(i);
			// ^A蓖z擾
			taxation     += dto.getTaxation();
			// ^A蓖ЉیTz擾
//			socInsurance += dto.calcSocialInsurance();
			socInsurance += dto.getSocInsTotal();
			// ^A蓖Ŋz
			incomeTax    += dto.getIncomeTax();
		}
		// NΏۋ^ŏ
		if (targetData.equals(PayrollConst.ADJ_PAYMENT_TARGET) && phPaymentDto != null) {
			incomeTax -= phPaymentDto.getIncomeTax();
		}
		// ^A蓖zݒ
		cdAdjustmentDto.setPaymentAllowance(taxation);
		// ЉیTzݒ
		socInsDeduction += socInsurance;
		// ^A蓖Ŋzݒ
		cdAdjustmentDto.setPaymentIncomeTax(incomeTax);
	}
	
	/**
	 * ܗ^f[^vݒ
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	protected void setTotalBonusData() throws SQLException, IllegalAccessException, NoSuchFieldException {
		// vZΏۏܗ^f[^擾
		List<PhBounsDto> listBonusData = phBonusDao.findForConditionDate(kCode, startAdjDate, lastDate);
		// ݒ菀
		int taxation = 0;
		int socInsurance = 0;
		int incomeTax = 0;
		for (int i = 0; i < listBonusData.size(); i++) {
			PhBounsDto dto = listBonusData.get(i);
			// ܗ^z
			taxation     += dto.getAllowanceTotal();
			// ܗ^ЉیTz
			socInsurance += dto.getInsureMoney();
			// ܗ^Ŋz
			incomeTax    += dto.getIncomeTax();
		}
		// ܗ^zݒ
		cdAdjustmentDto.setBonusAllowance(taxation);
		// ЉیTzݒ
		socInsDeduction += socInsurance;
		// ܗ^Ŋzݒ
		cdAdjustmentDto.setBonusIncomeTax(incomeTax);
	}
	
	/**
	 * rAf[^ݒ
	 */
	protected void setMidwayAdjustIncomeData() {
		// ݒ菀
		int taxation = 0;
		int socInsurance = 0;
		int incomeTax = 0;
		// z = xz - ېŒz
		taxation = cdAdjustmentDto.getAllowanceAdjustment() - cdAdjustmentDto.getTaxFreeAdjustment();
		// ЉیTz = Љیz
		socInsurance = cdAdjustmentDto.getSocInsAdjustment();
		// Ŋz = Œz
		incomeTax = cdAdjustmentDto.getTaxIncAdjustment();
		// Ώ۔NrЊmF
		if (checkMidwayEnter()) {
			// OΖzZ
			taxation     += cmMidwayEnterDto.getFormerIncome();
			// OΖЉیzZ
			socInsurance += cmMidwayEnterDto.getFormerInsurance();
			// OΖ揊ŊzZ
			incomeTax    += cmMidwayEnterDto.getFormerTax();
		}
		// rAz
		cdAdjustmentDto.setMidwayAdjustIncome(taxation);
		// ЉیTzݒ
		socInsDeduction += socInsurance;
		// rAŊz
		cdAdjustmentDto.setMidwayAdjustTax(incomeTax);
	}
	
	/**
	 * Љی^̍Tzݒ
	 */
	protected void setPayInsDeduction() {
		int payInsDeduction = socInsDeduction;
		cdAdjustmentDto.setPayInsDeduction(payInsDeduction);
	}
	
	/**
	 * rЊmF
	 * @return rЊmFtO(true:rЁAfalse:rł͂Ȃ)
	 */
	protected boolean checkMidwayEnter() {
		// 
		boolean isMidway = false;
		if (cmMidwayEnterDto != null) {
			// rЋ敪urЁvłAГΏ۔N̏ꍇtrue
			if (cmMidwayEnterDto.getMidwayType().equals(LegalConst.MIDWAY_ENTER)) {
				// ДN
//				int entYear = MospUtility.getYear(mKihonDto.getNyDate() );
				int entYear = mKihonDto.getNyDate();
				if (entYear == this.adjustYear) {
					isMidway = true;
				}
			}
		}
		return isMidway;
	}
	
	/**
	 * ^T̋^̋zݒ
	 * @throws MospException
	 */
	protected void setIncomePaymentData() throws MospException {
		// ݒ菀
		int adjustedIncomeTax = 0;
		// N^z
		int adjustPayment =  LegalUtility.setAdjustPayment(
							      cdAdjustmentDto.getPaymentAllowance  ()
								, cdAdjustmentDto.getBonusAllowance    ()
								, cdAdjustmentDto.getMidwayAdjustIncome()
							);
		// NvZmF
		isCalcAdjust =  LegalUtility.checkAdjustPayment(adjustPayment);
		if (!isCalcAdjust) {
			// NvZsȂ̂0~ݒ
			// ΏۊOG[ݒ
			String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_TARGET, PayrollConst.NAM_CALC_ADJUSTMENT + PayrollConst.KEY_SEPARATOR + kCode);
			addErrMessage(errMessage);
			adjustedIncomeTax = 0;
		} else {
			adjustedIncomeTax =  LegalUtility.setIncomePaymentData(adjustPayment);
		}
		// ݒ
		cdAdjustmentDto.setAfterDeductIncome(adjustedIncomeTax);
	}
	
	/**
	 * zҁA}{AbяQғ̍Tz̍vݒ
	 */
	protected void setLegalTotalDeduction() {
		int deduction = 0;
		// bTz擾
		deduction +=  LegalUtility.getAdjustBasisDeduction();
		// ݒ肪Ȃꍇ0
		if (cmIncomeTaxDto == null) {
			deduction += 0;
		} else {
			// zҍTz擾
			deduction +=  LegalUtility.getSpouseIntendType(cmIncomeTaxDto.getSpouseIntendType());
			// }{Tz
			deduction +=  LegalUtility.getDependentDeduction(
					cmIncomeTaxDto.getGeneralDependent (),
					cmIncomeTaxDto.getSpecificDependent(),
					cmIncomeTaxDto.getElderlyDependent (),
					cmIncomeTaxDto.getLiveWithEldRel   (),
					cmIncomeTaxDto.getLiveWithHandiGe  (),
					cmIncomeTaxDto.getLiveWithHandiSp  (),
					cmIncomeTaxDto.getLiveWithHandiEl  (),
					cmIncomeTaxDto.getLiveWithHandiEr  ()
			);
			// QғAǕwAΘJw̍Tz擾
			deduction +=  LegalUtility.getHandicapDeduction(
					  cmIncomeTaxDto.getSelfWidowType   ()
  					, cmIncomeTaxDto.getSelfHandicapType()
					, cmIncomeTaxDto.getSelfStudentType ()
					, cmIncomeTaxDto.getSpecificHandicap()
					, cmIncomeTaxDto.getGeneralHandicap ()
			);
		}

		cdAdjustmentDto.setDependentsDeduction(deduction);
	}
	
	/**
	 * {l֘A擾
	 * @param 
	 * @return {l֘A
	 * @throws sO
	 */
	public int countSelfTypes(CmIncomeTaxDto cmIncomeTaxDto) {
		int selfTypes = 0;
		// {l敪2ʏQAʏQȂ1
		String selfHandicapType = cmIncomeTaxDto.getSelfHandicapType();
		if (selfHandicapType != null && !selfHandicapType.equals("")) {
			selfTypes += 1;
		}
		// {l敪1Ǖw(v)AʉǕwȂ1
		String selfWidowType = cmIncomeTaxDto.getSelfWidowType();
		if (selfWidowType != null && !selfWidowType.equals("")) {
			selfTypes += 1;
		}
		// {l敪3ΘJwȂ1
		String selfStudentType = cmIncomeTaxDto.getSelfStudentType();
		if (selfStudentType != null && !selfStudentType.equals("")) {
			selfTypes += 1;
		}
		return selfTypes;
	}
	
	/**
	 * ېŋ^z擾
	 */
	protected void setTaxedIncome() {
		// ېŋ^z
		int calcTaxedIncome = 0;
		// ōTz̍vz
		int incomeDeduction = cdAdjustmentDto.getPayInsDeduction   ()	// Љی^̍T
							+ cdAdjustmentDto.getSocialInsDeduction ()	// \ɂЉی̍T
							+ cdAdjustmentDto.getMutualAidDeduction ()	// \ɂ鏬K͊Ƌϓ|̍T
							+ cdAdjustmentDto.getLifeInsDeduction   ()	// ی̍Tz
							+ cdAdjustmentDto.getDamageInsDeduction ()	// Qی̍Tz
							+ cdAdjustmentDto.getSpouseSpDeduction  ()	// zғʍTz
							+ cdAdjustmentDto.getDependentsDeduction(); // zҍTzA}{TzAbTzyяQғ̍Tz̍vz


		// ېŋ^zݒ(1000؎)
		calcTaxedIncome = (int)round(cdAdjustmentDto.getAfterDeductIncome() - incomeDeduction, - 3, BigDecimal.ROUND_DOWN);
		calcTaxedIncome = calcTaxedIncome < 0 ? 0 : calcTaxedIncome;
		// ېŋ^zݒ
		cdAdjustmentDto.setCalcTaxedIncome(calcTaxedIncome);
	}
	
	/**
	 * ZoNŊzݒ
	 * @throws MospException
	 */
	protected void setCalcIncomeTax() throws MospException {
		isCalcAdjust = LegalUtility.checkCalcTaxedIncome(cdAdjustmentDto.getCalcTaxedIncome());
		// ېŋ^z16920000ȏȂNvZΏۊO
		if (!isCalcAdjust) {
			// ΏۊOG[
			String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_TARGET, PayrollConst.NAM_CALC_ADJUSTMENT + PayrollConst.KEY_SEPARATOR + kCode);
			addErrMessage(errMessage);
			cdAdjustmentDto.setCalcIncomeTax(0);
			return;
		}
		int calcIncomeTax = LegalUtility.getCalcIncomeTax(cdAdjustmentDto.getCalcTaxedIncome());
		cdAdjustmentDto.setCalcIncomeTax(calcIncomeTax);
	}
	
	/**
	 * NNŊzݒ
	 */
	protected void setAdjustIncomeTax() {
		// NNŊzݒ
		int adjustedIncomeTax = 0;
		// NNŊz = ZoNŊz - ZؓzʍTz
		adjustedIncomeTax = cdAdjustmentDto.getCalcIncomeTax() - cdAdjustmentDto.getHouseLoanDeduction();
		// }CiX̏ꍇ0ɖ߂
		if (adjustedIncomeTax < 0) {
			adjustedIncomeTax = 0;
		}
		// ݒ
		cdAdjustmentDto.setAdjustedIncomeTax(adjustedIncomeTax);
	}
	
	/**
	 * N藦TŊzݒ
	 */
	protected void setDeductedIncomeTax() {
		// N藦TŊzݒ
		int deductedIncomeTax = LegalUtility.getDeductedIncomeTax(cdAdjustmentDto.getAdjustedIncomeTax());
		cdAdjustmentDto.setDeductedIncomeTax(deductedIncomeTax);
	}
	
	/**
	 * NŊzݒ
	 */
	protected void setFinalIncomeTax() {
		// NŊzݒ菀
		int finalIncomeTax = 0;
		// NŊz = NNŊz@- N藦TzŊz
		// NŊz擾(100~؎)
		finalIncomeTax = (int)round(cdAdjustmentDto.getAdjustedIncomeTax() - cdAdjustmentDto.getDeductedIncomeTax(), -2, BigDecimal.ROUND_DOWN);
		// ݒ
		cdAdjustmentDto.setFinalIncomeTax(finalIncomeTax);	
	}
	
	/**
	 * Ώۃf[^Őݒ
	 */
	private void addIncomeTaxData() {
		int incomeTax = 0;
		// ōv
		int totalIncAdjsut = cdAdjustmentDto.getPaymentIncomeTax() + cdAdjustmentDto.getBonusIncomeTax() + cdAdjustmentDto.getMidwayAdjustTax();
		if (targetData.equals(PayrollConst.ADJ_PAYMENT_TARGET)) {
			incomeTax = cdAdjustmentDto.getFinalIncomeTax() - totalIncAdjsut;
			// Őݒ
			phPaymentDto.setIncomeTax(incomeTax);
		} else if (targetData.equals(PayrollConst.ADJ_BONUS_TARGET)) {
			// 
		}
	}
	
	/**
	 * Ώۃf[^m菈
	 * @throws Exception
	 */
	private void addTotalData() throws Exception {
		if (targetData.equals(PayrollConst.ADJ_PAYMENT_TARGET)) {
			// ^Ώۃf[^m菈
			calcTotal(false);
			// XV
			phPaymentDao.update(phPaymentDto, true);
		} else if (targetData.equals(PayrollConst.ADJ_BONUS_TARGET)) {
			// ܗ^Ώۃf[^m菈
			calcBonusTotal();
		}
	}
	
	/**
	 * Nݒ
	 * @param adjustYear N
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 * @throws MospException 
	 */
	protected void confirmAdjustYear(
			int adjustYear
	) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		// NmF
		if (adjustYear != getAdjustYear()) {
			// NsO
			String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_DIF_ADJUST_YEAR, "");
			addErrMessage(errMessage);
			throw new MospException(PayrollConst.EX_DIF_ADJUST_YEAR, errMessage);
		}
		this.adjustYear = adjustYear;
		startAdjDate    = getStartDateOfYear(adjustYear);
		lastDate        = getLastDateOfYear(adjustYear);
	}
	
	/**
	 * Ώۃf[^^݊mF
	 * @param currentDto
	 * @throws Exception 
	 */
	protected boolean cheackTrgtPeriodPayData()
		throws Exception {
		boolean isTargetPeriod = true;
		// bZ[W\
		String mes1 = "";
		String mes2 = "";
		// 11̋^DTO݂Ȃꍇ
		if (phPaymentDto == null) {
			isTargetPeriod = false;
			// Ώۃf[^ݒG[o͊mF
			if(checkNoTargetError()) {
				// Ώۃf[^mF
				if (targetData.equals(PayrollConst.ADJ_PAYMENT_TARGET)) {
					// ^
					mes1 = String.valueOf(adjTargetMonth);
					mes2 = PayrollConst.NAM_DATA_M_PAYROLL;
				} else {
					// ܗ^
				}
				// 11̋^݂Ȃꍇ̓G[
				String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_ADJ_NO_TARGET_DATA,
						mes1 + PayrollConst.KEY_SEPARATOR + mes2 + PayrollConst.KEY_SEPARATOR + kCode);
				addErrMessage(errMessage);
			}
		}
		
		return isTargetPeriod;
	}
	
	private boolean checkNoTargetError() {
		Date TsDate;

		// rΏ۔Nݒ
		// Ώ۔N12/1
		Date retireDate = getFirstDateOfMonth(String.valueOf(MospUtility.getYear(lastDate)),
											 String.valueOf(MospUtility.getMonth(lastDate)));
		if (mKihonDto != null) {
			// ސENULL̐l
			if(mKihonDto.getTsDate() == 0) {
				return true;
			}
			// ސEΏ۔N12/1ȍ~
			TsDate = DatePart.convIntegerDateToDate(mKihonDto.getTsDate());
			if(TsDate.after(retireDate)) {
				return true;
			}

			// rΏ۔N11/1ɐݒ
			retireDate = addMonth(retireDate, -1);
			
			// ސE11/1ȑO̐l
			if(TsDate.before(retireDate)) {
				// bZ[Wsv
				return false;
			}
		} else {
			// bZ[Wv
			return true;
		}
		return true;
	}
	
	/**
	 * ΏۊԐݒ
	 * @param currentDto
	 * @throws Exception
	 */
	protected void setTargetPeriod() throws Exception {
		// Kp擾(^Kp)
		String applyMonth;
		applyMonth = getConfValue(PayrollConst.CONF_ID_PAY_ITBL, PayrollConst.CONF_CD_ADJUST_PAY);
		if(applyMonth.equals("")){
			applyMonth = "1"; // ꃖPʂƂ
		}
		// Ώ۔Nݒ
		adjTargetMonth = PayrollConst.TIME_ADJ_PAY_MONTH - Integer.parseInt(applyMonth);
		// ̏C(11^)
		targetAffDate = getYearMonth(String.valueOf(this.adjustYear), String.valueOf(adjTargetMonth));
		// ΏۑON擾
		targetBefDate = addMonth(targetAffDate, -adjTargetMonth);
	}
	
	/**
	 * ߊz͕sz擾
	 * @param dto 擾ΏDTO
	 * @return ߊz͕sz
	 */
	protected int getTaxGap(CdAdjustmentDto dto) {
		return dto.getFinalIncomeTax() - dto.getPaymentIncomeTax() -
				dto.getBonusIncomeTax() - dto.getMidwayAdjustTax();
	}
	
	/**
	 * f[^쏀
	 * @throws SQLException 
	 * @throws ClassNotFoundException 
	 */
	protected void prepareDao() throws ClassNotFoundException, SQLException {
		getConnection();
		mKihonPayrollDao	= new MKihonPayrollDao(); 

		pdPayDeductionDao	= new PdPayDeductionDao(cfg, cmd, aspUser, user, conn); 

		pdPayAllowanceDao	= new PdPayAllowanceDao( cfg, cmd, aspUser, user, conn );// ^T׃f[^
		pdPayDeductionDao	= new PdPayDeductionDao( cfg, cmd, aspUser, user, conn );	// ^x׃f[^
		pdBonAllowanceDao	= new PdBonAllowanceDao( cfg, cmd, aspUser, user, conn );	// ܗ^T׃f[^
		pdBonDeductionDao	= new PdBonDeductionDao( cfg, cmd, aspUser, user, conn );	// ܗ^x׃f[^
		
		cdAdjustmentDao		= new CdAdjustmentDao ();
		phPaymentDao		= new PhPaymentDao(cfg, cmd, aspUser, user, conn);
		cmIncomeTaxDao		= new CmIncomeTaxDao  ();
		cmMidwayEnterDao	= new CmMidwayEnterDao();
		phBonusDao			= new PhBounsDao(cfg, cmd, aspUser, user, conn);
		mKojinDao			= new MKojinDao();
		cmSocInsuranceDao	= new CmSocInsuranceDao(); 

		pdPaySumDao			= new PdPaySumDao(cfg, cmd, aspUser, user, conn);		// ^׍v
		pdPayTimeDao		= new PdPayTimeDao(cfg, cmd, aspUser, user, conn);		// ^׍v
		pdBonSumDao			= new PdBonSumDao(cfg, cmd, aspUser, user, conn);		// ܗ^׍v

		cdSocInsuranceDao	= new CdSocInsuranceDao();								// ЉیvZf[^		
		
		mKihonPayrollDao.initDao(cfg, cmd, aspUser, user, conn);
		cdAdjustmentDao .initDao(cfg, cmd, aspUser, user, conn);
		phPaymentDao    .initDao(cfg, cmd, aspUser, user, conn);
		cmIncomeTaxDao  .initDao(cfg, cmd, aspUser, user, conn);
		cmMidwayEnterDao.initDao(cfg, cmd, aspUser, user, conn);
		mKojinDao.initDao(cfg, cmd, aspUser, user, conn);
		cmSocInsuranceDao.initDao(cfg, cmd, aspUser, user, conn);
		cdSocInsuranceDao.initDao(cfg, cmd, aspUser, user, conn);					// ЉیvZf[^
	}
	
	/**
	 * NvZΏێҊmF
	 * @return NvZΏێ҃tO(true:ΏێҁAfalse:Ώێ)@
	 */
	protected boolean checkIsCalcAdjData() {
		Date TsDate;
		// 
		boolean isCreate = true;
		// r
		String year  = String.valueOf(MospUtility.getYear(lastDate));
		String month = String.valueOf(MospUtility.getMonth(lastDate));
		// Ώ۔N12/1
		Date compEntranceDate = getFirstDateOfMonth(year, month);
		// Ώ۔N1/1
		Date compRetDate = startAdjDate;
		// 񂪂Ȃꍇ
		if (mKihonDto == null) {
			isCreate = false;
			return isCreate;
		}

		// ГΏ۔N12/1O
		TsDate = DatePart.convIntegerDateToDate(mKihonDto.getNyDate());
		if (TsDate.compareTo(compEntranceDate) <= 0 ) {
			// ގГ󔒂͑Ώ۔N1/1ȍ~̎Ј
			if (mKihonDto.getNyDate() == 0 || TsDate.compareTo(compRetDate) >= 0) {
				isCreate = true;
			}
		} else {
			// 12/1ȍ~ȂΏ
			isCreate = false;
		}
		return isCreate;
	}
	
	/**
	 * N敪mF
	 * @return mF(trueFNAfalseFNȊO)
	 * @throws Exception 
	 */
	public boolean confirmAdjustType() throws Exception {
		// N敪mF
		if (cmIncomeTaxDto != null) {
			// N敪:Nsv
			if (cmIncomeTaxDto.getAdjustmentType().equals(LegalConst.ADJUSTMENT_NOT_NEED)) {
				// Nsv̓G[o͂ȂvZ͍sȂ
				return false;
			}
			// N敪:N
			if (cmIncomeTaxDto.getAdjustmentType().equals(LegalConst.ADJUSTMENT_NEEDED)) {
				// vZΏێҊmF
				if(checkIsCalcAdjData()) {
					// Ώێ
					// 11f[^݊mF
					if(!cheackTrgtPeriodPayData()) {
						// Ώۃf[^݂Ȃꍇ
						return false;
					}
				} else {
					// Ώێ
					return false;
				}
				
			}
			// N敪:ݒ
			if (cmIncomeTaxDto.getAdjustmentType().equals("")) {
				// ݒ̏ꍇ̓G[o
				addErrMessage(MospUtility.getMessage(msg, PayrollConst.MSG_NO_ADJUST_TYPE , kCode));
				// Ώێ
				return false;
			}
			
		} else {
			// Ώێ
			return false;
		}
		return true;
	}
	
	/**
	 * Nf[^쐬ΏێҊmF
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws MospException 
	 */
	public boolean checkCreateAdjustData(boolean needMessage) throws IllegalAccessException, SQLException, MospException {
		// Nf[^쐬ΏێҊmF
		int int_startAdjDate	= DatePart.convDateToInteger( startAdjDate );
		int int_lastDate		= DatePart.convDateToInteger( lastDate );   
		MKihonDto dto = mKihonPayrollDao.findForAdjustEmpData(kCode, int_startAdjDate, int_lastDate);
		if (dto == null) {
			if (needMessage) {
				// f[^쐬ΏۊȌꍇ̓G[
				String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_TARGET, PayrollConst.NAM_NO_DATA_ADJUSTMENT + PayrollConst.KEY_SEPARATOR + kCode);
				addErrMessage(errMessage);
			}
			return false;
		}
		return true;
	}
	
	/**
	 * NԐݒ(vZΏۊO)
	 */
	public void setAdjustOotStatus() {
		cdAdjustmentDto.setAdjustStatus(PayrollConst.ADJU_STATUS_OOT);
	}
	
	/**
	 * Ώۃf[^ōČvZ
	 * @param isRegist@XV(true:XVAfalse:XVȂ)
	 * @throws Exception
	 */
	public void calcTargetIncomeTax(boolean isRegist) throws Exception {
		// Ώۃf[^^
		if (targetData.equals(PayrollConst.ADJ_PAYMENT_TARGET)) {
			if (phPaymentDto != null) {
				// Ώۃf[^ݒ
				targetMonth = targetAffDate;
				// Ώۃf[^^
				setIncomeTax();
				if (isRegist) {
					phPaymentDao.update(phPaymentDto, false);
				}
			}
		} else if (targetData.equals(PayrollConst.ADJ_BONUS_TARGET)) {
			// Ώۃf[^ܗ^
			if (phBonusDto != null) {
				// Ώۃf[^ݒ
				targetMonth = targetAffDate;
				// ܗ^Ώۃf[^m菈
				setBonusIncomeTax();
			}
		}
	}
	
	/**
	 * NN擾
	 * @return vZ
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	protected int getAdjustYear() throws SQLException, IllegalAccessException, NoSuchFieldException {
		// DAO
		PtCurrentDao dao = new PtCurrentDao(cfg, cmd, aspUser, user, conn);
//		PtCurrentDto dto = dao.findForKey(PayrollConst.CURRENT_ADJUST);
		PtCurrentDto dto = dao.findLatest(PayrollConst.CURRENT_ADJUST, PayrollConst.CALC_ADJUST, PayrollConst.CURRENT_START);
		//		if (dto == null) {
//			dto = dao.findForKey(PayrollConst.CURRENT_CALC);
//		}
		if (dto == null) {
			return MospUtility.getYear(new Date());
		}
		return MospUtility.getYear(dto.getCalcDate());
	}

	/**
	 * N
	 * @param date   t
	 * @param amount 
	 * @return t
	 */
	protected Date addYear(Date date, int amount) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.YEAR, amount);
		return cal.getTime();
	}
	
	/**
	 * R[h擾(M_SYOZOKU)
	 * @return R[hXg
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[][] getStationArrayAll() throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MSyozokuDao  dao = new MSyozokuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MSyozokuDto> listStation = dao.findAll();
		// z̍쐬
		String[][] aryStation = new String[listStation.size()][2];
		for (int i = 0; i < listStation.size(); i++) {
			aryStation[i][0] = listStation.get(i).getSCode();
			aryStation[i][1] = listStation.get(i).getSName();
		}
		return aryStation;
	}
	
	/**
	 * ER[h擾(M_YAKUSYOKU)
	 * @return ER[hXg
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[][] getPositionArrayAll() throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MYakusyokuDao dao = new MYakusyokuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MYakusyokuDto> listPosition = dao.findAll();
		// z̍쐬
		String[][] aryPosition = new String[listPosition.size()][2];
		for (int i = 0; i < listPosition.size(); i++) {
			aryPosition[i][0] = listPosition.get(i).getYCode();
			aryPosition[i][1] = listPosition.get(i).getYName();
		}
		return aryPosition;
	}

	/**
	 * R[hXg擾(CM_CODE)
	 * @param tId R[h敪
	 * @return R[hXg
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	@Override
	protected String[][] getCodeArray(String tId) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// DAO̐錾
		CmCodeDao dao = new CmCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̎擾
		List<CmCodeDto> list = dao.findForCondition(tId);
		// f[^̐`
		String[][] array = new String[list.size()][2];
		for (int i = 0; i < list.size(); i++) {
			CmCodeDto dto = list.get(i);
			array[i][0] = dto.getTCode();
			array[i][1] = dto.getTName();
		}
		return array;
	}

	/**
	 * ݒ胊Xg擾(UM_CONF)
	 * @param confId ݒ敪
	 * @return ݒ胊Xg
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	protected List<MosPConfDto> getConfList(
			String confId
	) throws SQLException, IllegalAccessException, NoSuchFieldException  {
		// DAO̐錾
		MosPConfDao dao = new MosPConfDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̎擾
		return dao.findForCondition(confId);
	}

	/**
	 * POI[o̓f[^`FbNo(String)
	 * @param poi oPOICX^XID
	 * @param rr oexcels
	 * @param cc oexcelJ
	 * @param sdata@o͕
	 * @throws Exception 
	 */
	public  void prtItem_chk(PoiUtility poi, int rr, int cc, String sdata) throws Exception{
		if(null != sdata){
			poi.prtItem(rr, cc, sdata);
		}
	}

	/**
	 * POI[o̓f[^`FbNo(Integer)
	 * @param poi oPOICX^XID
	 * @param rr oexcels
	 * @param cc oexcelJ
	 * @param sdata@o͐l
	 * @throws Exception 
	 */
	public  void prtItem_chk(PoiUtility poi, int rr, int cc, Integer sdata) throws Exception{
		if(null != sdata){
			poi.prtItem(rr, cc, sdata);
		}
	}

	/**
	 * POI[o̓f[^`FbNo(Float)
	 * @param poi oPOICX^XID
	 * @param rr oexcels
	 * @param cc oexcelJ
	 * @param sdata@o͐l
	 * @throws Exception 
	 */
	public  void prtItem_chk(PoiUtility poi, int rr, int cc, Float sdata) throws Exception{
		if(null != sdata){
			poi.prtItem(rr, cc, sdata);
		}
	}
	
	/**
	 * ODS[o̓f[^`FbNo
	 * @param odsBean oODSCX^XID
	 * @param arg0 oODSJ
	 * @param arg1 oODSs
	 * @param sdata@o͕
	 * @throws Exception 
	 */
	public  void setValue_chk(OdsBean odsBean, int arg0, int arg1, Object arg2){
		if(null != arg2){
			odsBean.setValue(arg0, arg1, arg2);
		}
		
	}
	
}
