/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.action;

import jp.mosp.common.CommonConst;

import jp.mosp.common.action.KintaiCompileAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.CalculatePart;
import jp.mosp.common.part.PartManager;

import jp.mosp.kintai.dao.MYukyuDao;
import jp.mosp.kintai.dto.MYukyuDto;

import jp.mosp.payroll.dao.CompileAmendmentDao;
import jp.mosp.payroll.dao.MKintaiKeisanDao;
import jp.mosp.payroll.dto.CompileAmendmentDto;
import jp.mosp.payroll.dto.MKintaiDto;
import jp.mosp.payroll.dto.MKintaiKeisanDto;
import jp.mosp.payroll.vo.AttendanceCalculateEndCardVo;

public class AttendanceCalculateEndCardAction extends KintaiCompileAction {

	// R}h
	private static final String CMD_CARD_SHOW 	= "P1060";
	private static final String CMD_CARD_UPDATE 	= "P1061";

	/**
	 * RXgN^
	 */
	public AttendanceCalculateEndCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// VO̎擾
		AttendanceCalculateEndCardVo vo = new AttendanceCalculateEndCardVo();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DTO̎擾
		MKintaiKeisanDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof MKintaiKeisanDto ? (MKintaiKeisanDto)obj : null;
		// R}h̏
		if (cmd.equals(CMD_CARD_SHOW)) {
			vo.setDefaultValues();
			// \
			dto = show(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_CARD_UPDATE)) {
			// XV
			dto = update(vo);
			// [hݒ
			vo.setMode(AttendanceCalculateEndCardVo.MODE_IMPOSSIBLE);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * ݒ荀ڌ
	 * @param vo VoCX^X
	 * @throws Exception
	 */
	private MKintaiKeisanDto show(AttendanceCalculateEndCardVo vo) throws Exception {
		// DTȌ
		MKintaiKeisanDto dto = PartManager.calculate(partInfo()).findForCalc();
		if (chkExistDto(dto)) {
			// dtoAdtoVoɃZbgB
			vo.setFields(dto);
			// vZ̏ꍇ
			if (CalculatePart.isCalculateFinish(dto)) {
				String sikyuym = dto.getKTNen() + CommonConst.STR_UNDER_SEPARATOR + dto.getKTTuki();
				// bZ[WpvZN
				vo.addErrMessage(MospUtility.getMessage(msg, CommonConst.MSG_ALREADY_CALCULATE, sikyuym));
				// [hݒ
				vo.setMode(AttendanceCalculateEndCardVo.MODE_IMPOSSIBLE);
			} else {
				// [hݒ
				vo.setMode(AttendanceCalculateEndCardVo.MODE_UPDATE);
			}
		} else {
			// INZbg
			vo.setLblKTnen(String.valueOf(MospUtility.getYear(util.getSystemDate())));
			vo.setLblKTtuki(String.valueOf(MospUtility.getMonth(util.getSystemDate())));
			// vZ񖳂
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
			// [hݒ
			vo.setMode(AttendanceCalculateEndCardVo.MODE_IMPOSSIBLE);
		}
		return dto;
	}

	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @throws Exception
	 */
	private MKintaiKeisanDto update(AttendanceCalculateEndCardVo vo) throws Exception {
		// DAȌ
		MKintaiKeisanDao dao = new MKintaiKeisanDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// DTȌ
		// XVOdto݂邩ǂ`FbN
		MKintaiKeisanDto dto = dao.findForUpdate();
		if (chkExistDto(dto)) {
			dto.setKKanryou(CommonConst.NUM_ATTENDANCE_CALCULATE_FLAG_ON);
			// XV
			dao.update(dto);
			// DTO̍Ď擾
			MKintaiKeisanDto retDto = dao.findForKey(String.valueOf(dto.getKTNen()));
			chkUpdate(retDto);
			/*						
			 *  	2009/09/24	m.yoshida	vZI\Ή
			 */
			// dtoVoɃZbgB
			vo.setFields(retDto);
			// Sꗗ擾
			String[][] arySections = getSectionArrayAll();
			// R~bgtO
			boolean[] flagArraySection = new boolean[arySections.length];
			for (int i = 0; i < arySections.length; i++) {
				// ݐЎЈꗗ
				String[] aryAllusers = getBasisArray(arySections[i][0], getCalcAttendance());
				boolean[] flagArrayUsers = new boolean[aryAllusers.length];
				for (int j = 0; j < aryAllusers.length; j++) {
					// LJz
					flagArrayUsers[j] = registPaidHolidayCarryForward(aryAllusers[j], vo, retDto);
				}
				// JztO
				boolean isCarryForward = true;
				for (int j = 0; j < flagArrayUsers.length; j++) {
					if (!flagArrayUsers[j]) {
						isCarryForward = false;
						break;
					}
				}
				if (isCarryForward) {
					flagArraySection[i] = true;
				} else {
					flagArraySection[i] = false;
				}
			}
			// JzItO
			boolean isAllCarryForward = true;
			for (int k = 0; k < flagArraySection.length; k++) {
				if (!flagArraySection[k]) {
					isAllCarryForward = false;
					break;
				}
			}
			if (isAllCarryForward) {
				// bZ[Wݒ
				vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
				// R~bg
				commit();				
			} else {
				// vZsbZ[W
				vo.setMessage(MospConst.LOG_MSG_1022);
			}
		} else {
			// vZ񖳂
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
		return dto;
	}

	/**
	 * LJz
	 * @throws Exception
	 */
	private boolean registPaidHolidayCarryForward(
			String kCode,
			AttendanceCalculateEndCardVo vo,
			MKintaiKeisanDto dto
	) throws Exception {
		// Lݒ擾
		boolean isCarryForward = false;
		// Jz
		int CFMonth = Integer.parseInt(getPaidHolidayInfo()[0]);
		// Jz
		int CFDays = Integer.parseInt(getPaidHolidayInfo()[1]);
		// Jz敪
		String CFFlag = getPaidHolidayInfo()[2];
		// p[^̏
		// OciNxj
		double remainLastThis = 0;
		// OciONxj
		double remainLastPrev = 0;
		// gp
		double use = 0;
		// x
		int payment = 0;
		// j
		double waste = 0;
		// ciNxj
		double remainThisThis = 0;
		// ciONxj
		double remainThisPrev = 0;	
		// DAȌ
		MYukyuDao mYukyuDao = new MYukyuDao();
		mYukyuDao.initDao(cfg, cmd, aspUser, user, conn);
		// ΑӏWv
		String sikyuym = dto.getKTNen() + CommonConst.STR_SEPARATOR + dto.getKTTuki();
		MKintaiDto mKintaiDto = kintaiDao().findForKey(kCode, sikyuym);
		if (chkExistDto(mKintaiDto)) {
			// ΑӏWv
			CompileAmendmentDao cAmendmentDao = new CompileAmendmentDao();
			cAmendmentDao.initDao(cfg, cmd, aspUser, user, conn);
			CompileAmendmentDto cAmendmentDto = cAmendmentDao.findForCondition(
					kCode,
					sikyuym,
					getBelongSectionCode(kCode)
			);
			// ΑӏF@\LmF
			if (isAttendanceApprovalFunction()) {
				// FL
				//if (!checkApproval(cAmendmentDto, getCalcAttendance())) {
				/*				
				 * 		2009/11/24	m.yoshida	vZIΉ
				 */	
				if (!checkApproval(cAmendmentDto, getCalcMonth())) {
					// Ff[^ݏꍇ
					vo.addErrMessage(MospUtility.getMessage(msg, CommonConst.MSG_EXIST_NOT_APPROVED, getKName(kCode)));
					return false;
				}
			}
			// ΑӏWvgpL擾
			use = mKintaiDto.getYukyu();
			// ̗L񌟍
			String currentDate = util.convIntegerToStringDate(dto.getKSNen(), dto.getKSTuki(), dto.getKShi());
			MYukyuDto currentDto = mYukyuDao.findForKey(kCode, currentDate);
			if (!chkExistDto(currentDto)) {
				currentDto = new MYukyuDto();
				currentDto.setKCode(kCode);
				currentDto.setKyuyoYMD(Integer.parseInt(currentDate));
			}
			// ̗Lx̐ݒ
			payment = currentDto.getSyutoku();
			waste = currentDto.getHaiki();
			remainThisThis = currentDto.getTZanT();
			remainThisPrev = currentDto.getTZanZ();
			// O̗L񌟍
			String formerDate  = String.valueOf(util.convDateToInteger(
					util.addMonth(util.getDate(dto.getKSNen(), dto.getKSTuki(), dto.getKShi()), -1)));
			MYukyuDto formerDto = mYukyuDao.findForFormer(kCode, formerDate);
			if (!chkExistDto(formerDto)) {
				formerDto = new MYukyuDto();
			}
			// O̗L̐ݒ
			remainLastThis = formerDto.getTZanT();
			remainLastPrev = formerDto.getTZanZ();
			// Jzꍇ
			if (CFMonth == MospUtility.getMonth(getCalcPayment())) {
				// Jz敪
				// N̂
				if (CFFlag.equals(CommonConst.NAM_COMMON_FLAG_OFF)) {
					// pXV
					// OXNxjB
					if (remainLastPrev < use) {
						use = Math.abs(remainLastPrev - use);
						waste = 0;
					} else {
						waste = remainLastPrev - use;
						use = 0;
					}
					// OONx𓖌ONxɈړB
					remainThisPrev = remainLastThis;
				}
				// vŌJz
				else if (CFFlag.equals(CommonConst.NAM_COMMON_FLAG_ON)) {
					// OvČJzJzB
					if ((remainLastPrev + remainLastThis) >= CFDays) {
						waste = (remainLastPrev + remainLastThis) - CFDays;
					} else {
						waste = 0;
					}
					remainThisPrev = remainLastPrev + remainLastThis - waste;
				}
				// Α擾
				double yearOfService = getYearsOfService(kCode);
				// ΑLx擾
				String[][] aryPaidHolidayDays = getPaidHolidayArray();
				for (int i = 0; i < aryPaidHolidayDays.length; i++) {
					if (yearOfService >= Integer.parseInt(aryPaidHolidayDays[i][0])) {
						payment = Integer.parseInt(aryPaidHolidayDays[i][1]);
					}
				}
				remainThisThis += payment;
				//LXV
				if (use <= remainThisPrev) {
					remainThisPrev -= use;
				} else {
					// 
					use -= remainThisPrev;
					remainThisPrev = 0;
					remainThisThis -= use;
				}				
			} else {
				//L擾XV
				remainThisThis += remainLastThis;
				remainThisPrev += remainLastPrev;
				//LXV
				if (use <= remainThisPrev) {
					remainThisPrev -= use;
				} else {
					// 
					use -= remainThisPrev;
					remainThisPrev = 0;
					remainThisThis -= use;
				}
			}
			// DTOɃZbg
			currentDto.setZZanT(remainLastThis);
			currentDto.setZZanZ(remainLastPrev);
			currentDto.setSyoka(mKintaiDto.getYukyu());
			currentDto.setSyutoku(payment);
			currentDto.setHaiki(waste);
			currentDto.setTZanT(remainThisThis);
			currentDto.setTZanZ(remainThisPrev);
			// o^
			if (mYukyuDao.findForUpdate(kCode, currentDate) == null) {
				// o^
				mYukyuDao.insert(currentDto);
			} else {
				// XV
				mYukyuDao.update(currentDto);
			}
			// XV`FbN
			chkUpdate(mYukyuDao.findForKey(kCode, currentDate));
			isCarryForward = true;
		} else {
			// ΑӏWvf[^Ȃꍇ
			vo.addErrMessage(MospUtility.getMessage(msg, CommonConst.MSG_NO_ATTENDANCE_COMPILED, getKName(kCode)));
		}
		return isCarryForward;
	}

}
