/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;

import jp.mosp.human.dto.MKihonDto;

public class EmployeeApprovalListVo extends MosPVo {

	private static final long serialVersionUID = -2944600739302499938L;

	// URLACSS
	private static final String RETURN_URL = "/jsp/kintai/employeeApprovalList.jsp";
	private static final String EXTRA_JS   = "/pub/kintai/js/employeeApprovalList.js";
	private static final String EXTRA_CSS  = "/pub/kintai/css/employeeApprovalList.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_EMPLOYEE_APPROVAL;

	// p[^	
	public static final String PRM_PLT_YEAR  = "pltYear";
	public static final String PRM_PLT_MONTH = "pltMonth";

	// tB[hyѐ
	public static final String NAM_K_CODE = CommonConst.NAM_K_CODE;

	public static final int	LEN_K_CODE = CommonConst.LEN_K_CODE;
	public static final int	LEN_K_NAME = CommonConst.LEN_K_NAME;

	// tB[h
	private String[] arySelectDate;
	private String[] aryKCode;
	private String[] aryKName;
	private String[] arySection;
	private String[] aryPosition;

	private String lblKCode;
	private String lblKName;
	private String lblSectionName;
	private String pltSelectYear;
	private String pltSelectMonth;

	// v_EXg
	public String[][] arySectionAll;
	public String[][] aryPositionAll;

	public String[][] aryPltYear;
	public String[][] aryPltMonth;

	// \[gL[
	public final String KEY_K_CODE        = "keyKCode";
	public final String KEY_K_NAME        = "keyKName";
	public final String KEY_SECTION       = "keySection";
	public final String KEY_POSITION      = "keyPosition";

	/**
	 * RXgN^
	 */
	public EmployeeApprovalListVo() {
		super();		
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		arySelectDate	= new String[0];
		aryKCode        = new String[0];
		aryKName        = new String[0];
		arySection      = new String[0];
		aryPosition     = new String[0];
		setFormerKey(KEY_K_CODE);
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		pltSelectYear  = request.getParameter(PRM_PLT_YEAR );
		pltSelectMonth = request.getParameter(PRM_PLT_MONTH);
	}

	/**
	 * tB[hݒ
	 * @param list ЈXg
	 */
	public void setFields(List list) {
		// Xg̐ݒ
		this.list = list;
		// f[^̎擾
		count = list.size();
		// z̏
		arySelectDate	= new String[count];
		aryKCode        = new String[count];
		aryKName        = new String[count];
		arySection      = new String[count];
		aryPosition     = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator it = list.iterator();
		while (it.hasNext()) {
			MKihonDto dto = (MKihonDto)it.next();
			arySelectDate[i] 	= escapeHTML(pltSelectYear	+ CommonConst.FILE_NAME_SEPARATOR + pltSelectMonth);
			aryKCode[i]   		= escapeHTML(dto.getKCode());
			aryKName[i]   		= escapeHTML(dto.getSimei());
			arySection[i] 		= getCodeName(dto.getSCode(), arySectionAll);
			aryPosition[i] = "";
			for (int j = 0; j < aryPositionAll.length; j++) {
				if (aryPositionAll[j][0].equals(dto.getYCode())
						&& aryPositionAll[j][2].equals(dto.getTokyu())) {
					aryPosition[i] = escapeHTML(aryPositionAll[j][1]);
					break;
				}
			}
			i++;
		}
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	// ANZT\bh
	public String[] getEscArySelectDate	() { return arySelectDate.clone()	; }
	public String[] getEscAryKCode		() { return aryKCode.clone()		; }
	public String[] getEscAryKName		() { return aryKName.clone()		; }
	public String[] getEscArySection	() { return arySection.clone()		; }
	public String[] getEscAryPosition	() { return aryPosition.clone()		; }

	public String getEscLblKCode		() { return escapeHTML(lblKCode)		; }
	public String getEscLblKName		() { return escapeHTML(lblKName)		; }
	public String getEscLblSectionName	() { return escapeHTML(lblSectionName)	; }

	public String getPltSelectMonth	() { return pltSelectMonth	; }
	public String getPltSelectYear	() { return pltSelectYear	; }

	public void setLblKCode		(String lblKCode		){ this.lblKCode 		= lblKCode		; }
	public void setLblKName		(String lblKName		){ this.lblKName 		= lblKName		; }
	public void setLblSectionName	(String lblSectionName	){ this.lblSectionName 	= lblSectionName; }
	public void setPltSelectMonth	(String pltSelectMonth	){ this.pltSelectMonth 	= pltSelectMonth; }
	public void setPltSelectYear	(String pltSelectYear	){ this.pltSelectYear 	= pltSelectYear	; }

}
