/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.human.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;

import jp.mosp.human.dto.MKihonDto;

public class HumanKihonCardVo extends HumanCardVo {

	private static final long serialVersionUID = 4153484055869768269L;

	// URLACSS
	private static final String RETURN_URL = "/jsp/human/humanKihon.jsp";
	private static final String EXTRA_JS   = "/pub/human/js/humanKihon.js";
	private static final String EXTRA_CSS  = "/pub/human/css/humanKihon.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_HUMAN_KIHON;

	// p[^
	public static final String PRM_TXT_K_CODE				= "txtKCode"			;
	public static final String PRM_TXT_K_NAME				= "txtKName"			;
	public static final String PRM_TXT_K_KANA				= "txtKKana"			;
	public static final String PRM_PLT_OFFICE				= "pltOffice"			;
	public static final String PRM_PLT_SECTION				= "pltSection"			;
	public static final String PRM_PLT_POSITION			= "pltPosition"			;
	public static final String PRM_PLT_RETIREMENT			= "pltRetirement"		;	
	public static final String PRM_PLT_ENTRANCE_YEAR		= "pltEntranceYear"		;
	public static final String PRM_PLT_ENTRANCE_MONTH		= "pltEntranceMonth"	;
	public static final String PRM_PLT_ENTRANCE_DAY		= "pltEntranceDay"		;
	public static final String PRM_PLT_RETIREMENT_YEAR		= "pltRetirementYear"	;
	public static final String PRM_PLT_RETIREMENT_MONTH	= "pltRetirementMonth"	;
	public static final String PRM_PLT_RETIREMENT_DAY		= "pltRetirementDay"	;
	public static final String PRM_TXT_E_MAIL 				= "txtEMail"			;

	public static final String PRM_HID_K_NAME				= "hidKName"			;
	public static final String PRM_HID_K_KANA				= "hidKKana"			;
	public static final String PRM_HID_OFFICE				= "hidOffice"			;
	public static final String PRM_HID_SECTION				= "hidSection"			;
	public static final String PRM_HID_POSITION			= "hidPosition"			;
	public static final String PRM_HID_RETIREMENT			= "hidRetirement"		;
	public static final String PRM_HID_ENTRANCE_YEAR		= "hidEntranceYear"		;
	public static final String PRM_HID_ENTRANCE_MONTH		= "hidEntranceMonth"	;
	public static final String PRM_HID_ENTRANCE_DAY		= "hidEntranceDay"		;
	public static final String PRM_HID_RETIREMENT_YEAR		= "hidRetirementYear"	;
	public static final String PRM_HID_RETIREMENT_MONTH	= "hidRetirementMonth"	;
	public static final String PRM_HID_RETIREMENT_DAY		= "hidRetirementDay"	;
	public static final String PRM_HID_E_MAIL				= "hidEMail"			;

	// tB[hyѐ
	public static final String NAM_MAKE_NEW_DATA			= CommonConst.NAM_MAKE_NEW_DATA		;
	public static final String NAM_K_CODE					= CommonConst.NAM_K_CODE			;
	public static final String NAM_K_NAME					= CommonConst.NAM_K_NAME			;
	public static final String NAM_K_KANA					= CommonConst.NAM_K_KANA			;
	public static final String NAM_OFFICE					= CommonConst.NAM_OFFICE			;
	public static final String NAM_SECTION					= CommonConst.NAM_STATION			;
	public static final String NAM_POSITION				= CommonConst.NAM_POSITION1			;
	public static final String NAM_RETIREMENT_TYPE 		= CommonConst.NAM_RETIREMENT_TYPE	;
	public static final String NAM_ENTRANCE_DATE			= CommonConst.NAM_ENTRANCE_DATE		;
	public static final String NAM_RETIREMENT_DATE			= CommonConst.NAM_RETIREMENT_DATE	;
	public static final String NAM_RETIREMENT_DATE_YEAR	= CommonConst.NAM_RETIREMENT_DATE + CommonConst.MSG_YEAR;
	public static final String NAM_RETIREMENT_DATE_MONTH	= CommonConst.NAM_RETIREMENT_DATE + CommonConst.MSG_MONTH;
	public static final String NAM_RETIREMENT_DATE_DAY		= CommonConst.NAM_RETIREMENT_DATE + CommonConst.MSG_DAY;
	public static final String NAM_E_MAIL					= CommonConst.NAM_EMAIL				;

	public static final int	LEN_K_CODE					= CommonConst.LEN_K_CODE			;
	public static final int	LEN_K_NAME					= CommonConst.LEN_K_NAME			;
	public static final int	LEN_K_KANA					= CommonConst.LEN_K_NAME			;
	public static final int	LEN_E_MAIL					= 50								;

	// ҏW[htO
	public static final int MODE_INSERT		= 0;
	public static final int MODE_UPDATE		= 1;

	// ҏW[h
	public static final String NAM_MODE_INSERT	 = CommonConst.NAM_HU_MODE_INSERT;
	public static final String NAM_MODE_UPDATE	 = CommonConst.NAM_HU_MODE_UPDATE;

	// tB[h	
	private String txtKCode				;
	private String txtKName				;
	private String txtKKana				;
	private String pltOffice			;
	private String pltSection			;
	private String pltPosition			;
	private String pltRetirement		;
	private String pltEntranceYear		;
	private String pltEntranceMonth		;
	private String pltEntranceDay		;
	private String pltRetirementYear	;
	private String pltRetirementMonth	;
	private String pltRetirementDay		;
	private String txtEMail				;

	// tB[h(\̂)
	private String lblOffice			;
	private String lblSection			;
	private String lblPosition			;
	private String lblRetirement		;
	private String lblEntranceDate		;
	private String lblRetirementDate	;
	private String lblEMail				;

	// tB[h(ύXmFp)
	private String hidKName				;
	private String hidKKana				;
	private String hidOffice			;
	private String hidSection			;
	private String hidPosition			;
	private String hidRetirement		;
	private String hidEntranceYear		;
	private String hidEntranceMonth		;
	private String hidEntranceDay		;
	private String hidRetirementYear	;
	private String hidRetirementMonth	;
	private String hidRetirementDay		;
	private String hidEMail				;

	// ҏW[h(0FVKo^A1FXV)
	private int mode;

	// v_EXg
	public String[][] aryPltOfficeAll;
	public String[][] aryPltOffice;
	public String[][] aryPltSectionAll;
	public String[][] aryPltSection;
	public String[][] aryPltPositionAll;
	public String[][] aryPltPosition;
	public String[][] aryPltRetirement;
	public String[][] aryPltYear;
	public String[][] aryPltMonth;
	public String[][] aryPltDay;

	/**
	 * RXgN^
	 */
	public HumanKihonCardVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		super.setParams(request);
		if (request.getParameter(PRM_TXT_K_CODE) != null) {
			txtKCode = request.getParameter(PRM_TXT_K_CODE);
		}
		txtKName			= request.getParameter(PRM_TXT_K_NAME			);
		txtKKana			= request.getParameter(PRM_TXT_K_KANA			);
		pltOffice			= request.getParameter(PRM_PLT_OFFICE			);
		pltSection			= request.getParameter(PRM_PLT_SECTION			);
		pltPosition			= request.getParameter(PRM_PLT_POSITION         );
		pltRetirement		= request.getParameter(PRM_PLT_RETIREMENT		);
		pltEntranceYear		= request.getParameter(PRM_PLT_ENTRANCE_YEAR	);
		pltEntranceMonth	= request.getParameter(PRM_PLT_ENTRANCE_MONTH	);
		pltEntranceDay		= request.getParameter(PRM_PLT_ENTRANCE_DAY		);
		pltRetirementYear	= request.getParameter(PRM_PLT_RETIREMENT_YEAR	);
		pltRetirementMonth	= request.getParameter(PRM_PLT_RETIREMENT_MONTH	);
		pltRetirementDay	= request.getParameter(PRM_PLT_RETIREMENT_DAY	);
		txtEMail			= request.getParameter(PRM_TXT_E_MAIL			);
	}

	/**
	 * tB[hݒ
	 * @param dto	ΏDTO
	 * @throws MospException 
	 */
	public void setFields(MKihonDto dto) throws MospException {
		// f[^̐ݒ
		txtKCode = dto.getKCode();
		txtKName = dto.getSimei();
		txtKKana = dto.getFurigana();
		pltOffice 			= dto.getJCode();
		pltSection 			= dto.getSCode();
		pltPosition 		= dto.getYCode() + CommonConst.STR_TIME_SEPARATOR + dto.getTokyu();
		pltRetirement 		= dto.getKnKubun();
		if (dto.getNyDate() > 0) {
			pltEntranceYear		= util.convIntegerDateToArray(dto.getNyDate())[0];
			pltEntranceMonth	= util.convIntegerDateToArray(dto.getNyDate())[1];
			pltEntranceDay		= util.convIntegerDateToArray(dto.getNyDate())[2];			
		}
		if (dto.getTsDate() > 0) {
			pltRetirementYear	= util.convIntegerDateToArray(dto.getTsDate())[0];
			pltRetirementMonth	= util.convIntegerDateToArray(dto.getTsDate())[1];
			pltRetirementDay	= util.convIntegerDateToArray(dto.getTsDate())[2];
		}
		txtEMail = dto.getEmail();

		lblKCode = dto.getKCode();
		lblKName = dto.getSimei();
		lblKKana = dto.getFurigana();
		for (int j = 0; j < aryPltOfficeAll.length; j++) {
			if (aryPltOfficeAll[j][0].equals(dto.getJCode())) {
				lblOffice = escapeHTML(aryPltOfficeAll[j][1]);
				break;
			}
		}
		for (int j = 0; j < aryPltSectionAll.length; j++) {
			if (aryPltSectionAll[j][0].equals(dto.getSCode())) {
				lblSection = escapeHTML(aryPltSectionAll[j][1]);
				break;
			}
		}
		for (int j = 0; j < aryPltPositionAll.length; j++) {
			if (aryPltPositionAll[j][0].equals(dto.getYCode())
					&& aryPltPositionAll[j][2].equals(dto.getTokyu())) {
				lblPosition = escapeHTML(aryPltPositionAll[j][1]);
				break;
			}
		}
		for (int j = 0; j < aryPltRetirement.length; j++) {
			if (aryPltRetirement[j][0].equals(dto.getKnKubun())) {
				lblRetirement = escapeHTML(aryPltRetirement[j][1]);
				break;
			}
		}
		if (dto.getNyDate() > 0) {
			lblEntranceDate = util.convIntegerDateToJPDate(dto.getNyDate());
		}
		if (dto.getTsDate() > 0) {
			lblRetirementDate = util.convIntegerDateToJPDate(dto.getTsDate());
		}
		lblEMail = dto.getEmail();

		hidKName = dto.getSimei();
		hidKKana = dto.getFurigana();
		hidOffice = dto.getJCode();
		hidSection = dto.getSCode();
		hidPosition = dto.getYCode() + CommonConst.STR_TIME_SEPARATOR + dto.getTokyu();
		hidRetirement = dto.getKnKubun();
		if (dto.getNyDate() > 0) {
			hidEntranceYear 	= util.convIntegerDateToArray(dto.getNyDate())[0];
			hidEntranceMonth 	= util.convIntegerDateToArray(dto.getNyDate())[1];
			hidEntranceDay 		= util.convIntegerDateToArray(dto.getNyDate())[2];
		}
		if (dto.getTsDate() > 0) {
			hidRetirementYear 	= util.convIntegerDateToArray(dto.getTsDate())[0];
			hidRetirementMonth 	= util.convIntegerDateToArray(dto.getTsDate())[1];
			hidRetirementDay 	= util.convIntegerDateToArray(dto.getTsDate())[2];
		}
		hidEMail = dto.getEmail();
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto	ΏDTO
	 */
	public void setDtoFields(MKihonDto dto) {
		dto.setKCode(txtKCode);
		dto.setSimei(txtKName);
		dto.setFurigana(txtKKana);
		dto.setSCode(pltSection);
		dto.setYCode(pltPosition.split(CommonConst.STR_TIME_SEPARATOR)[0]);
		if (pltPosition.endsWith(CommonConst.STR_TIME_SEPARATOR)) {
			dto.setTokyu("");
		} else {
			dto.setTokyu(pltPosition.split(CommonConst.STR_TIME_SEPARATOR)[1]);
		}
		dto.setJCode(pltOffice);
		/*						
		 *  	2009/07/02	m.yoshida	tϊΉ
		 */
		// Г
		if (pltEntranceYear.length() == 0
				&& pltEntranceMonth.length() == 0
				&& pltEntranceDay.length() == 0
		) {
			dto.setNyDate(0);
		} else {
			dto.setNyDate(util.convStringDateToInteger(pltEntranceYear,pltEntranceMonth, pltEntranceDay));			
		}
		/*						
		 *  	2009/07/02	m.yoshida	tϊΉ
		 */
		// ގГ
		if (pltRetirementYear.length() == 0
				&& pltRetirementMonth.length() == 0
				&& pltRetirementDay.length() == 0
		) {
			dto.setTsDate(0);
		} else {
			dto.setTsDate(util.convStringDateToInteger(pltRetirementYear, pltRetirementMonth, pltRetirementDay));			
		}
		dto.setKnKubun(pltRetirement);
		dto.setEmail(txtEMail);
		// ΑNij
		dto.setKinzoku(util.getMonthRemainder(util.getSystemDate(),
				util.getYearMonth(pltEntranceYear, pltEntranceMonth)));

		// VKo^̂m_kihoñftHglZbg
		if (mode == MODE_INSERT) {
			dto.setKyKubun("");
			dto.setTxKubun("1");
			dto.setTxKubunx("");
			dto.setKmKubun("1");
			dto.setPtKubun("1");
			dto.setShKubun("1");
			dto.setSiwakeCd("99999");
			dto.setHaigusya("0");
			dto.setFuyosu(0);
			dto.setYukyu(0);
			dto.setNenrei(0);
			dto.setKenpoNo("");
			dto.setKohoNo("");
			dto.setKUser("");
			dto.setPassw("");
			dto.setNinsyo("");
			dto.setDataLvl(0);
			dto.setProgLevel(0);
		}
	}

	/**
	 * tB[h
	 */
	@Override
	public void initFields() {
		super.initFields();
		txtKCode            = "";
		txtKName            = "";
		txtKKana            = "";
		pltOffice			= "";
		pltSection          = "";
		pltPosition         = "";
		pltRetirement		= "";
		pltEntranceYear     = "";
		pltEntranceMonth    = "";
		pltEntranceDay      = "";
		pltRetirementYear   = "";
		pltRetirementMonth  = "";
		pltRetirementDay    = "";
		txtEMail			= "";

		lblKCode            = "";
		lblKName            = "";
		lblKKana            = "";
		lblOffice			= "";
		lblSection          = "";
		lblPosition         = "";
		lblRetirement		= "";
		lblEntranceDate     = "";
		lblRetirementDate   = "";
		lblEMail			= "";

		hidKName            = "";
		hidKKana            = "";
		hidOffice			= "";
		hidSection          = "";
		hidPosition         = "";
		hidRetirement		= "";
		hidEntranceYear     = "";
		hidEntranceMonth    = "";
		hidEntranceDay      = "";
		hidRetirementYear   = "";
		hidRetirementMonth  = "";
		hidRetirementDay    = "";
		hidEMail			= "";

	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtKCode, NAM_K_CODE , PRM_TXT_K_CODE);
		// R[hmF
		checkCode(txtKCode, NAM_K_CODE , PRM_TXT_K_CODE);
		// mF
		checkLength(txtKCode	, LEN_K_CODE	, NAM_K_CODE	, PRM_TXT_K_CODE);
		checkLength(txtKName	, LEN_K_NAME	, NAM_K_NAME	, PRM_TXT_K_NAME);
		checkLength(txtKKana	, LEN_K_KANA	, NAM_K_KANA	, PRM_TXT_K_KANA);
		checkLength(txtEMail	, LEN_E_MAIL	, NAM_E_MAIL	, PRM_TXT_E_MAIL);
		// tmF
		checkDate(getIntParam(pltEntranceYear), getIntParam(pltEntranceMonth), getIntParam(pltEntranceDay),
				NAM_ENTRANCE_DATE, PRM_PLT_ENTRANCE_YEAR);
		// ސE`FbN
		if (pltRetirement.equals(String.valueOf(CommonConst.RETIREMENT_FLAG_ON))) {
			checkDate(getIntParam(pltRetirementYear), getIntParam(pltRetirementMonth), getIntParam(pltRetirementDay),
					NAM_RETIREMENT_DATE, PRM_PLT_RETIREMENT_YEAR);			
			checkDateBeforeAfter(getDate(pltEntranceYear, pltEntranceMonth, pltEntranceDay),
					getDate(pltRetirementYear, pltRetirementMonth, pltRetirementDay), false,
					NAM_ENTRANCE_DATE, NAM_RETIREMENT_DATE,
					PRM_PLT_RETIREMENT_YEAR, PRM_PLT_RETIREMENT_MONTH, PRM_PLT_RETIREMENT_DAY);
		}
		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh
	public String getTxtKCode			() { return txtKCode			; }

	public String getTxtKName			() { return txtKName			; }
	public String getTxtKKana			() { return txtKKana			; }
	public String getPltOffice			() { return pltOffice			; }
	public String getPltSection			() { return pltSection			; }
	public String getPltPosition		() { return pltPosition			; }
	public String getPltRetirement		() { return pltRetirement		; }
	public String getPltEntranceYear	() { return pltEntranceYear		; }
	public String getPltEntranceMonth	() { return pltEntranceMonth	; }
	public String getPltEntranceDay		() { return pltEntranceDay		; }
	public String getPltRetirementYear	() { return pltRetirementYear	; }
	public String getPltRetirementMonth	() { return pltRetirementMonth	; }
	public String getPltRetirementDay	() { return pltRetirementDay	; }
	public String getTxtEMail			() { return txtEMail			; }

	public String getEscTxtKCode			() { return escapeHTML(txtKCode				); }

	public String getEscTxtKName			() { return escapeHTML(txtKName				); }
	public String getEscTxtKKana			() { return escapeHTML(txtKKana				); }
	public String getEscTxtEMail			() { return escapeHTML(txtEMail				); }

	public String getEscLblOffice			() { return escapeHTML(lblOffice			); }
	public String getEscLblSection			() { return escapeHTML(lblSection			); }
	public String getEscLblPosition			() { return escapeHTML(lblPosition			); }
	public String getEscLblRetirement		() { return escapeHTML(lblRetirement		); }	
	public String getEscLblEntranceDate		() { return escapeHTML(lblEntranceDate		); }
	public String getEscLblRetirementDate	() { return escapeHTML(lblRetirementDate	); }
	public String getEscLblEMail			() { return escapeHTML(lblEMail				); }

	public String getEscHidKName			() { return escapeHTML(hidKName				); }
	public String getEscHidKKana			() { return escapeHTML(hidKKana				); }
	public String getEscHidOffice			() { return escapeHTML(hidOffice			); }
	public String getEscHidSection			() { return escapeHTML(hidSection			); }
	public String getEscHidPosition			() { return escapeHTML(hidPosition			); }
	public String getEscHidRetirement		() { return escapeHTML(hidRetirement		); }
	public String getEscHidEntranceYear		() { return escapeHTML(hidEntranceYear		); }
	public String getEscHidEntranceMonth	() { return escapeHTML(hidEntranceMonth		); }
	public String getEscHidEntranceDay		() { return escapeHTML(hidEntranceDay		); }
	public String getEscHidRetirementYear	() { return escapeHTML(hidRetirementYear	); }
	public String getEscHidRetirementMonth	() { return escapeHTML(hidRetirementMonth	); }
	public String getEscHidRetirementDay	() { return escapeHTML(hidRetirementDay		); }
	public String getEscHidEMail			() { return escapeHTML(hidEMail				); }

	public void setTxtKCode			(String txtKCode        ) { this.txtKCode			= txtKCode			; }
	public void setPltEntranceYear		(String pltEntranceYear ) { this.pltEntranceYear	= pltEntranceYear	; }
	public void setPltEntranceMonth	(String pltEntranceMonth) { this.pltEntranceMonth	= pltEntranceMonth	; }
	public void setPltEntranceDay		(String pltEntranceDay  ) { this.pltEntranceDay		= pltEntranceDay	; }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() {return mode; }

}
