package jp.mosp.human.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;


import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.human.vo.HumanCalcVo;
import jp.mosp.legal.LegalConst;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.dao.CmBankDao;
import jp.mosp.payroll.dao.CmBranchDao;
import jp.mosp.payroll.dao.CmCompanyDao;
import jp.mosp.payroll.dto.CmBankDto;
import jp.mosp.payroll.dto.CmBranchDto;
import jp.mosp.payroll.dto.CmCommutationDto;
import jp.mosp.payroll.dto.CmIncomeTaxDto;
import jp.mosp.payroll.dto.CmMidwayEnterDto;
import jp.mosp.payroll.dto.CmPaymentMeansDto;
import jp.mosp.payroll.dto.CmResidenceTaxDto;
import jp.mosp.payroll.dto.CmSocInsuranceDto;
import jp.mosp.payroll.dto.CmUnitAmountDto;

public class HumanCalcAction extends PayrollHumanAction {

	// R}h
	public  static final String CMD_HUMAN_CALC_SELECT = "U4150";
	private static final String CMD_HUMAN_CALC_INSERT = "U4151";
	private static final String CMD_HUMAN_CALC_UPDATE = "U4152";
	public  static final String CMD_HUMAN_CALC_TAB    = "U4153";

	/**
	 * RXgN^
	 */
	public HumanCalcAction() {
		super();
	}

	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new HumanCalcVo();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// HUMANmF
		confirmHumanAuth();
		// VO擾yѐݒ
		prepareVo();
		HumanCalcVo vo = (HumanCalcVo)getVo();
		// s}X^AxX}X^f[^쐬
		convFinanceData(cfg.getProperty(MospConst.PPT_APP_DOCBASE) + PayrollConst.JS_FINANCE, false);
		// v_Eݒ
		setPulldown(vo);

		// R}h̏
		if (cmd.equals(CMD_HUMAN_CALC_SELECT)) {
			// p[^擾
			vo.setParams(request);
			// {^eݒ
			setListButton(vo);
			if (!vo.getTxtChangeKCode().equals("")) {
				// \(ЈR[hŏ)
				select(vo);
			} else {
				setNextCmd("U4120");
			}
			// ZbVDTOZbg
			//session.setAttribute(MospConst.ATT_DTO, aryDto);
		} else if (cmd.equals(CMD_HUMAN_CALC_INSERT)) {
			// p[^擾
			vo.setParams(request);
			// {^eݒ
			setListButton(vo);
			// XV
			regist(vo, false);
			// 
			select(vo);
			// ZbVDTOZbg
			//session.setAttribute(MospConst.ATT_DTO, aryDto);
		} else if (cmd.equals(CMD_HUMAN_CALC_UPDATE)) {
			// p[^擾
			vo.setParams(request);
			// {^eݒ
			setListButton(vo);
			// XV
			regist(vo, false);
			// 
			select(vo);
			// ZbVDTOZbg
			//session.setAttribute(MospConst.ATT_DTO, aryDto);
		} else if (cmd.equals(CMD_HUMAN_CALC_TAB)) {
			// p[^擾
			vo.setParams(request);
			// {^eݒ
			setListButton(vo);
			// ݒ
			vo.setHidCalcCurrentTab(key2);
			vo.setTxtChangeKCode(key1);
			// \(ЈR[hŏ)
			select(vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	
	/**
	 * v_Eݒ
	 * @param vo ΏVO
	 * @throws Exception
	 */
	public void setPulldown(HumanCalcVo vo) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// v_Eݒ
		if (vo.aryPltCoBank != null) {
			return;
		}
		vo.aryPltEra       = getCodeArray(PayrollConst.TID_JAPANESE     );
		vo.aryPltShortYear = getYearArray(1, 0, PayrollConst.TIME_SHOWA_LONG);
		vo.aryPltMonth     = getMonthArray();
		vo.aryPltDay       = getDayArray();
		vo.aryPltCoBank    = getCoBankArray();
		vo.aryPltAccountType       = getCodeArray(PayrollConst.TID_ACCOUNT_TYPE );
		vo.aryPltPaymentMeans      = getCodeArray(PayrollConst.TID_PAYMENT_MEANS);
		vo.aryPltAmountType        = PayrollConst.getAmountTypeArray()           ;
		vo.aryPltAmountTypeForRest = PayrollConst.getAmountTypeArrayForRest()    ;
		vo.aryPltPaymentInterval   = getCodeArray(PayrollConst.TID_PAY_INTERVAL );
		vo.aryPltLumpMonthlyType   = getCodeArray(PayrollConst.TID_LUMP_TYPE    );
		vo.aryPltPenDependentType  = LegalConst.PENSION_INSURED_ARRAY         ;
		vo.aryPltIncomeTaxType     = LegalConst.INCOME_TAX_ARRAY              ;
		vo.aryPltAdjustmentType    = LegalConst.ADJUSTMENT_ARRAY              ;
		vo.aryPltHandicapType      = LegalConst.HANDICAP_ARRAY                ;
		vo.aryPltWidowType         = LegalConst.WIDOW_ARRAY                   ;
		vo.aryPltStudentType       = LegalConst.STUDENT_ARRAY                 ;
		vo.aryPltSpouseIntendType  = LegalConst.SPOUSE_INTEND_ARRAY           ;
		vo.aryPltLiveWithType      = LegalConst.LIVE_WITH_ARRAY               ;
		vo.aryPltSpouseType        = LegalConst.SPOUSE_ARRAY                  ;
		vo.aryPltDependentType     = LegalConst.DEPENDENT_ARRAY               ;
		vo.aryPltPensionType       = LegalConst.PENSION_ARRAY                 ;
		vo.aryPltParttimeType      = LegalConst.PARTTIME_ARRAY                ;
		vo.aryPltEmployeeType      = LegalConst.EMPLOYEE_ARRAY                ;
		vo.aryPltCalcInsType       = LegalConst.CALC_INS_ARRAY                ;
		vo.aryPltNursingInsType    = LegalConst.NURSING_INS_ARRAY             ;
		vo.aryPltCalcUnemployType  = LegalConst.CALC_UNEMPLOY_ARRAY           ;
		vo.aryPltBonusHealthType   = LegalConst.BONUS_HEALTH_ARRAY            ;
		vo.aryPltBounsPensionType  = LegalConst.BONUS_PENSION_ARRAY           ;
		vo.aryPltHealthLostType    = LegalConst.HEALTH_LOST_ARRAY             ;
		vo.aryPltPensionLostType   = LegalConst.PENSION_LOST_ARRAY            ;
		vo.aryPltUnemployLostType  = LegalConst.UNEMPLOY_LOST_ARRAY           ;
		vo.aryPltMidwayType        = LegalConst.MIDWAY_ENTER_ARRAY            ;
		
		// aݒ擾
		vo.listConf = getConfList(PayrollConst.CONF_ID_JP_IMP_CAL);
		// JSɏnzݒ
		//vo.setJSArray();
		
	}
	
	/**
	 * f[^\
	 * @param vo ΏVO
	 * @throws Exception
	 */
	public void select(HumanCalcVo vo) throws Exception {
		// \(ЈR[hŏ)
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// IЈl^擾
		getSelectedEmployeeBasis(vo);
		// l^擾
		findHumanCalcInfo(vo.getLblKCode(), false);
		// lǗ擾
		findHumanPersonnelInfo(vo.getLblKCode(), false);
		// x@AAtKiݒ
		getHolderName(vo);
		// VO
		vo.initFields();
		vo.setTxtChangeKCode(vo.getLblKCode());
		// یݒ
		CmCompanyDao cmCompanyDao = new CmCompanyDao();
		cmCompanyDao.initDao(cfg, cmd, aspUser, user, conn);
		vo.setPremiumRatio(cmCompanyDao.findAll());
		// lݒ
		vo.setFields(
				cmSocInsuranceDto,
				cmResidenceTaxDto, 
				cmIncomeTaxDto   ,
				cmMidwayEnterDto ,
				listPaymentMeans ,
				listCommutation  ,
				listUnitAmount   ,
				aryUnitType
		);
		// sݒ
		setFinanceName(vo);
		// rݒ
		String editor = setExclusive(PayrollConst.EXC_HUMAN_CA_PE, user.getUserId(), vo.getLblKCode());
		if (editor != null) {
			addErrMessage(MospUtility.getMessage(msg, PayrollConst.MSG_EXCLUSIVE, editor));
		}
		setNeedExclusive(true);
	}

	/**
	 * f[^}
	 * @param vo       ΏVO
	 * @param isInsert }tO
	 * @throws Exception
	 */
	public void regist(HumanCalcVo vo, boolean isInsert) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// p[^̑ÓmF
		vo.validate();
		// l{擾
		getSelectedEmployeeBasis(vo);
		// l^擾
		findHumanCalcInfo(vo.getLblKCode(), true);
		// ݊mF
		if (isInsert) {
			//chkDuplicate(umBasisDao.findForKey(uhBasisDto.getKCode()), vo);
		}
		// DTO
		
		CmSocInsuranceDto            upCmSocInsuranceDto = new CmSocInsuranceDto           ();
		CmResidenceTaxDto            upCmResidenceTaxDto = new CmResidenceTaxDto           (); 
		CmIncomeTaxDto               upCmIncomeTaxDto    = new CmIncomeTaxDto              ();
		CmMidwayEnterDto			 upCmMidwayEnterDto  = new CmMidwayEnterDto				();
		
		ArrayList<CmPaymentMeansDto> listUpPaymentMeans  = new ArrayList<CmPaymentMeansDto>();
		ArrayList<CmCommutationDto > listUpCommutation   = new ArrayList<CmCommutationDto >();
		ArrayList<CmUnitAmountDto  > listUpUnitAmount    = new ArrayList<CmUnitAmountDto  >();

		vo.setDtoFields(
				upCmSocInsuranceDto,
				upCmResidenceTaxDto, 
				upCmIncomeTaxDto   ,
				upCmMidwayEnterDto,
				listUpPaymentMeans ,
				listUpCommutation  ,
				listUpUnitAmount
		);
		// vZmF
		/*
		if (!isAfterCalc(vo.getExpectedDate())) {
			String errMessage = MospUtility.getMessage(msg, UnicConst.MSG_APPLY_BEFORE_CALC, "");
			addErrMessage(errMessage);
			throw new MospException(UnicConst.EX_APPLY_BEFORE_CALC, errMessage);
		}
		*/
		// f[^XV
		// Nی
		if (cmSocInsuranceDao.findForKey(
				upCmSocInsuranceDto.getKCode(), upCmSocInsuranceDto.getInsExpectedDate()) == null
		) {
			cmSocInsuranceDao.insert(upCmSocInsuranceDto);
		} else {
			// o^e`FbN
			if (vo.checkInsuranceDtoFields(cmSocInsuranceDto, upCmSocInsuranceDto)) {
				// r
				cmSocInsuranceDao.findForUpdate(upCmSocInsuranceDto.getKCode());
				// XV
				cmSocInsuranceDao.update(upCmSocInsuranceDto);
				
			}
		}
		// Z
		if (cmResidenceTaxDao.findForKey(
				upCmResidenceTaxDto.getKCode(), upCmResidenceTaxDto.getResExpectedDate()) == null
		) {
			cmResidenceTaxDao.insert(upCmResidenceTaxDto);
		} else {
			// o^e`FbN
			if (vo.checkResidenceTaxDtoFields(cmResidenceTaxDto, upCmResidenceTaxDto)) {
				// r
				cmResidenceTaxDao.findForUpdate(upCmResidenceTaxDto.getKCode());
				// XV
				cmResidenceTaxDao.update(upCmResidenceTaxDto);
			}
		}
		// 
		if (cmIncomeTaxDao.findForKey(
				upCmIncomeTaxDto.getKCode(), upCmIncomeTaxDto.getIncExpectedDate()) == null
		) {
			cmIncomeTaxDao.insert(upCmIncomeTaxDto);
		} else {
			// o^e`FbN
			if (vo.checkIncomeTaxDtoFields(cmIncomeTaxDto, upCmIncomeTaxDto)) {
				// r
				cmIncomeTaxDao.findForUpdate(upCmIncomeTaxDto.getKCode());
				// XV
				cmIncomeTaxDao.update(upCmIncomeTaxDto);
			}
		}
		// o^e`FbN
		if (vo.checkPaymentMeansDtoFields(listPaymentMeans, listUpPaymentMeans)) {
			// x@
			// tKiA`ЈƓłȂ̃f[^͓o^ȂB
			listUpPaymentMeans = vo.chkRegistPaymentData(listUpPaymentMeans);
			// x@폜
			cmPaymentMeansDao.deleteForEmployee(vo.getLblKCode());
			for (Iterator<CmPaymentMeansDto> it = listUpPaymentMeans.iterator(); it.hasNext();) {
				CmPaymentMeansDto cmPaymentMeansDto = it.next();
				cmPaymentMeansDao.insert(cmPaymentMeansDto);
			}
			
		}
		// o^e`FbN
		if (vo.checkCommutationDtoFields(listCommutation, listUpCommutation)) {
			// ʋΎ蓖
			cmCommutationDao.deleteForEmployee(vo.getLblKCode());
			for (Iterator<CmCommutationDto> it = listUpCommutation.iterator(); it.hasNext();) {
				CmCommutationDto cmCommutationDto = it.next();
				cmCommutationDao.insert(cmCommutationDto);
			}
			
		}
		// o^e`FbN
		if (vo.checkUnitAmountDtoFields(listUnitAmount, listUpUnitAmount)) {
			// vZP
			cmUnitAmountDao.deleteForEmployee(vo.getLblKCode());
			for (Iterator<CmUnitAmountDto> it = listUpUnitAmount.iterator(); it.hasNext();) {
				CmUnitAmountDto cmUnitAmountDto = it.next();
				cmUnitAmountDao.insert(cmUnitAmountDto);
			}
		}

		// r
		if ( cmMidwayEnterDao.findForKey(
				upCmMidwayEnterDto.getKCode() ) == null
		) {
			cmMidwayEnterDao.insert(upCmMidwayEnterDto);
		} else {
			// o^e`FbN
			if (vo.checkCmMidwayEnterDtoFields(cmMidwayEnterDto, upCmMidwayEnterDto)) {
				// XV
				cmMidwayEnterDao.update(upCmMidwayEnterDto);
			}
		}
		
		// DTOĎ擾
		findHumanCalcInfo(vo.getLblKCode(), false);

		// R~bg
		commit();
		// [hݒ
		vo.setMode(HumanCalcVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_INSERT, ""));
	}
	
	/**
	 * AtKi擾
	 * @param vo@ΏVO
	 */
	protected void getHolderName(HumanCalcVo vo) {
		// ݒ菀
		ArrayList<CmPaymentMeansDto> listAddPaymentMeans = new ArrayList<CmPaymentMeansDto>();
		for (int i = 0; i < PayrollConst.PAYMENT_MEANS_COUNT; i++) {
			// x@Xg݂Ȃꍇ
			if (listPaymentMeans.size() == 0) {
				// DTO
				CmPaymentMeansDto cmPaymentMeansDto = setPaymentMeansData(vo, i);
				// Xgɒǉ
				listAddPaymentMeans.add(cmPaymentMeansDto);
				continue;
			}
			// 擾Xg
			for (int j = 0; j < listPaymentMeans.size(); j++) {
				CmPaymentMeansDto cmPaymentMeansDto = listPaymentMeans.get(j);
				// AԂƈvADDXgɐݒ
				if (i == cmPaymentMeansDto.getMeansSequence()) {
					// Xgɒǉ
					listAddPaymentMeans.add(cmPaymentMeansDto);
					break;
				}
				// Ō܂ňvȂꍇ͖`ǉDTOݒ
				if (j == listPaymentMeans.size() - 1) {
					// DTO
					cmPaymentMeansDto = setPaymentMeansData(vo, i);
					// Xgɒǉ
					listAddPaymentMeans.add(cmPaymentMeansDto);
				}
			}
		}
		// ݒ𔽉f
		listPaymentMeans = listAddPaymentMeans;
	}
	
	/**
	 * x@ݒ
	 * @param vo@ΏVO
	 * @param idx@A
	 * @return
	 */
	protected CmPaymentMeansDto setPaymentMeansData(HumanCalcVo vo,int idx) {
		// DTO
		CmPaymentMeansDto cmPaymentMeansDto = new CmPaymentMeansDto();
		cmPaymentMeansDto.setKCode(vo.getLblKCode());
		cmPaymentMeansDto.setMeansSequence(idx);
		cmPaymentMeansDto.setHolderName(vo.getEscLblKName());
		cmPaymentMeansDto.setHolderKana(vo.getEscLblKKana());
		cmPaymentMeansDto.setPaidBankCode  ("");
		cmPaymentMeansDto.setPaidBranchCode("");
		return cmPaymentMeansDto;
	}
	
	private void setFinanceName( HumanCalcVo vo)
	throws SQLException, IllegalAccessException, NoSuchFieldException
{
	if (listPaymentMeans.size() == 0) {
		return;
	}
	// DAȌ
	CmBankDao cmBankDao = new CmBankDao();
	cmBankDao.initDao(cfg, cmd, aspUser, user, conn);
	// DAȌ
	CmBranchDao cmBranchDao = new CmBranchDao();
	cmBranchDao.initDao(cfg, cmd, aspUser, user, conn);
	vo.lblPaidBankName = new String[listPaymentMeans.size()];
	vo.lblPaidBranchName = new String[listPaymentMeans.size()];
	for (int i = 0; i < listPaymentMeans.size(); i++) {
		CmPaymentMeansDto cmPaymentMeansDto = listPaymentMeans.get(i); 
		CmBankDto cmBankDto = cmBankDao.findForKey(cmPaymentMeansDto.getPaidBankCode());
		if (cmBankDto != null) {
			vo.lblPaidBankName[i] = cmBankDto.getBankName();
		} else {
			vo.lblPaidBankName[i] = cmPaymentMeansDto.getPaidBankCode();
		}
		CmBranchDto cmBranchDto = cmBranchDao.findForKey(cmPaymentMeansDto.getPaidBankCode(), cmPaymentMeansDto.getPaidBranchCode());
		if (cmBranchDto != null) {
			vo.lblPaidBranchName[i] = cmBranchDto.getBranchName();
		} else {
			vo.lblPaidBranchName[i] = cmPaymentMeansDto.getPaidBranchCode();
		}
		
	}
	
	
}
	


}
