/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.vo;

import java.security.NoSuchAlgorithmException;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

public class MosPPasswordVo extends MosPVo {

	private static final long serialVersionUID = -7284219341360162310L;

	// URLAJSt@CACSSt@C
	private static final String RETURN_URL = "/jsp/common/mosPPassword.jsp";
	private static final String EXTRA_JS   = "/pub/common/js/mosPPassword.js";
	private static final String EXTRA_CSS  = "/pub/common/css/mosPPassword.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_CHANGE_PASSWORD;

	// 萔
	public static final int MODE_SHOW 			= 0;
	public static final int MODE_FORCE_UPDATE 	= 1;

	// p[^
	public static final String PRM_TXT_OLD_PASSWORD 	= "txtOldPassword";
	public static final String PRM_TXT_NEW_PASSWORD 	= "txtNewPassword";
	public static final String PRM_TXT_CONFIRM_PASS 	= "txtConfirmPass";
	public static final String PRM_HDN_OLD_PASSWORD 	= "hdnOldPassword";
	public static final String PRM_HDN_NEW_PASSWORD 	= "hdnNewPassword";
	public static final String PRM_HDN_CONFIRM_PASS 	= "hdnConfirmPass";
	public static final String PRM_HID_USER_ID 		= "hidUserId";

	// tB[h
	private String cmdMenu;
	private String hdnOldPassword;
	private String hdnNewPassword;
	private String hdnConfirmPass;

	// [h
	private int mode;

	// tB[hyѐ
	public static final String NAM_PASSWORD		= CommonConst.NAM_PASSWORD		;
	public static final String NAM_OLD_PASSWORD	= CommonConst.NAM_OLD_PASSWORD	;
	public static final String NAM_NEW_PASSWORD	= CommonConst.NAM_NEW_PASSWORD	;
	public static final String NAM_CONFIRM_PASS	= CommonConst.NAM_CONFIRM_PASS	;
	public static final String NAM_CHECK_PASS_ID	= CommonConst.MSG_CHECK_PASS_ID	;
	public static final int    LEN_PASSWORD     	= CommonConst.LEN_PASSWORD		;
	public static final int    LEN_MIN_PASSWORD 	= CommonConst.LEN_MIN_PASSWORD	;

	/**
	 * RXgN^
	 */
	public MosPPasswordVo() {
		super();
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
		setRetUrl(RETURN_URL);
		mode = 0;
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		hdnOldPassword = request.getParameter(PRM_HDN_OLD_PASSWORD);
		hdnNewPassword = request.getParameter(PRM_HDN_NEW_PASSWORD);
		hdnConfirmPass = request.getParameter(PRM_HDN_CONFIRM_PASS);
	}

	/**
	 * tB[h̑ÓmF
	 * @param currentPassword ݂̃pX[h
	 * @throws NoSuchAlgorithmException
	 * @throws MospException
	 */
	public void validate(String currentPassword) throws NoSuchAlgorithmException, MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(hdnOldPassword, NAM_OLD_PASSWORD, PRM_TXT_OLD_PASSWORD);
		checkRequired(hdnNewPassword, NAM_NEW_PASSWORD, PRM_TXT_NEW_PASSWORD);
		checkRequired(hdnConfirmPass, NAM_CONFIRM_PASS, PRM_TXT_CONFIRM_PASS);
		// 񒷊mF
		checkLength  (hdnOldPassword, LEN_PASSWORD, NAM_OLD_PASSWORD, PRM_TXT_OLD_PASSWORD);
		checkLength  (hdnNewPassword, LEN_PASSWORD, NAM_NEW_PASSWORD, PRM_TXT_NEW_PASSWORD);
		checkLength  (hdnConfirmPass, LEN_PASSWORD, NAM_CONFIRM_PASS, PRM_TXT_CONFIRM_PASS);
		// pX[hmF
		checkPassword(MospUtility.getDigest(hdnOldPassword), currentPassword, PRM_TXT_OLD_PASSWORD);
		// ύXpX[hmF
		checkCompare(hdnNewPassword, hdnConfirmPass, 0, NAM_PASSWORD, PRM_TXT_NEW_PASSWORD, PRM_TXT_CONFIRM_PASS);
		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");		
		return sb.toString();
	}

	// ANZT\bh
	public String getHdnOldPassword() { return hdnOldPassword; }
	public String getHdnNewPassword() { return hdnNewPassword; }
	public String getHdnConfirmPass() { return hdnConfirmPass; }
	public void setHdnOldPassword(String hdnOldPassword) { this.hdnOldPassword = hdnOldPassword; }
	public void setHdnNewPassword(String hdnNewPassword) { this.hdnNewPassword = hdnNewPassword; }
	public void setHdnConfirmPass(String hdnConfirmPass) { this.hdnConfirmPass = hdnConfirmPass; }
	public String getCmdMenu() { return cmdMenu; }
	public void setCmdMenu(String cmdMenu) { this.cmdMenu = cmdMenu; }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

}
