package jp.mosp.common.part;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.KanaConvertUtility;
import jp.mosp.common.common.MospUtility;

/**
 * StringɊւPartNX
 * @author yoshida
 * 	@version	0.0.1
 */
public class StringPart {

	/*		z֘A		*/

	/**
	 * 񎟌zꎟz֕ϊ
	 * @param ary Ώۓ񎟌z
	 * @param d INo.
	 * @return Iꎟz
	 * @throws Exception
	 */	
	public static String[] separateArrayList(String[][] ary, int d) {
		String[] aryName = new String[ary.length];
		for (int i = 0; i < ary.length; i++) {
			aryName[i] = ary[i][d];
		}
		return aryName;
	}

	/**
	 * z񓯎m̌
	 * @param frontarray Ons2
	 * @param behindarray ns2
	 * @return	String[][]	z
	 */
	public static String[][] combineArray(String[][] frontarray, String[][] behindarray) {
		String[][] result = new String[frontarray.length + behindarray.length][2];
		System.arraycopy(frontarray, 0, result, 0, frontarray.length);
		System.arraycopy(behindarray, 0, result, frontarray.length, behindarray.length);			
		return result;
	}

	/**
	 * z񓯎m̌
	 * @param frontarray Ons2
	 * @param centerarray ns2
	 * @param behindarray ns2
	 * @return	String[][]	z
	 */
	public static String[][] combineArray(String[][] frontarray, String[][] centerarray, String[][] behindarray) {
		String[][] result = combineArray(combineArray(frontarray, centerarray), behindarray);
		return result;
	}

	/**
	 * z񓯎m̌
	 * @param list
	 * @return
	 */
	public static String[][] combineArray(List<String[][]> list) {
		String[][] result = new String[0][2];
		for (Iterator iter = list.iterator(); iter.hasNext();) {
			String[][] array = (String[][]) iter.next();
			result = combineArray(result, array);
		}
		return result.clone();
	}

	/**
	 * L^Xg
	 * @return [0]cA[1]cL
	 */
	public static String[][] getExistenceArray() {
		String[][] result = new String[2][2];
		result[0][0] = CommonConst.NAM_COMMON_FLAG_OFF;
		result[0][1] = CommonConst.NAM_COMMON_NASI;
		result[1][0] = CommonConst.NAM_COMMON_FLAG_ON;
		result[1][1] = CommonConst.NAM_COMMON_ARI;
		return result;
	}

	/**
	 * L^Xg
	 * @return [0]cA[1]cL
	 */
	public static String[][] getExistenceShortArray() {
		String[][] result = new String[2][2];
		result[0][0] = CommonConst.NAM_COMMON_FLAG_OFF;
		result[0][1] = CommonConst.NAM_MISSING_INPUT_OFF_OPT;
		result[1][0] = CommonConst.NAM_COMMON_FLAG_ON;
		result[1][1] = CommonConst.NAM_MISSING_INPUT_ON;
		return result;
	}

	/**
	 * z`FbN
	 * @param ary1		Ώ۔zP
	 * @param ary2		Ώ۔zQ
	 * @return
	 * <p>
	 * z񂪈ꏏłtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean checkArraysEquals(String[] ary1, String[] ary2) {
		if (Arrays.equals(ary1, ary2)) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * ꎟzList
	 * @param array
	 * @return
	 */
	public static List<String> arrayToList(String[] array) {
		List<String> list = new ArrayList<String>();
		for (int i = 0; i < array.length; i++) {
			list.add(array[i]);
		}
		return list;
	}

	/**
	 * z񁨃J}؂̕
	 * @param array		Ώۈꎟz
	 * @return
	 */
	public static String convArrayToFormattedByComma(String[] array) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < array.length; i++) {
			sb.append(array[i]);
			if (i != array.length -1) {
				sb.append(CommonConst.STR_UNDER_SEPARATOR);
			}
		}			
		return sb.toString();
	}

	/**
	 * z񎟌ϊ
	 * @param ary1D		ϊꎟz
	 * @return	ϊ񎟌z
	 */
	public static String[][] convArrayDimension(String[] ary1D) {
		String[][] array = new String[1][2];
		array[0][0] = "";
		array[0][1] = "";
		if (ary1D != null) {
			array[0][0] = ary1D[0];
			array[0][1] = ary1D[1];
		}
		return array;
	}

	/**
	 * z񎟌ϊ
	 * @param ary2D		ϊ񎟌z
	 * @return	ϊꎟz
	 */
	public static String[] convArrayDimension(String[][] ary2D) {
		String[] array = new String[2];
		array[0] = "";
		array[1] = "";
		if (ary2D != null) {
			array[0] = ary2D[0][0];
			array[1] = ary2D[0][1];
		}
		return array;
	}

	/**
	 * ꎟz񐶐
	 * @param str1		ΏۗvfP
	 * @param str2		ΏۗvfQ
	 * @return@z
	 */
	public static String[] createArray(String str1, String str2) {
		return new String[]{ str1, str2 };
	}

	/**
	 * 󔒃v_E擾
	 * @return  󔒃v_Epz
	 */
	public static String[][] getBlankArray() {
		String[][] array = new String[1][2];
		array[0][0] = "";
		array[0][1] = "";
		return array;
	}

	/**
	 * 󔒔z񐶐
	 * @param arraySize		z
	 * @return	󔒔z
	 */
	public static String[][] getBlankArray(int arraySize) {
		String[][] array = new String[arraySize][2];
		for (int i = 0; i < array.length; i++) {
			array[i][0] = "";
			array[i][1] = "";
		}
		return array;
	}

	/**
	 * ݐE/ސEXg擾
	 * @return ݐE/ސEXg
	 */
	public static String[][] getRetirementFlagArrayAll() {
		// z̍쐬
		return addArrayFirstRowSpace(getRetirementFlagArray());
	}

	/**
	 * ݐE/ސEXg擾i󗓖j
	 * @return ݐE/ސEXg
	 */
	public static String[][] getRetirementFlagArray() {
		// z̍쐬
		String[][] aryRetirementFlag = new String[3][2];
		aryRetirementFlag[0][0] = String.valueOf(CommonConst.RETIREMENT_FLAG_OFF);
		aryRetirementFlag[0][1] = CommonConst.NAM_RETIREMENT_OFF;
		aryRetirementFlag[1][0] = String.valueOf(CommonConst.RETIREMENT_FLAG_LEAVE);
		aryRetirementFlag[1][1] = CommonConst.NAM_RETIREMENT_LEAVE;
		aryRetirementFlag[2][0] = String.valueOf(CommonConst.RETIREMENT_FLAG_ON);
		aryRetirementFlag[2][1] = CommonConst.NAM_RETIREMENT_ON;
		return aryRetirementFlag;
	}

	/**
	 * ̎擾
	 * @param code  擾ΏۃR[h
	 * @return R[h
	 */
	public static String getCodeName(String code, String[][] array) {
		String codeName = code;
		if (array == null) {
			return codeName;
		}
		for (int i = 0; i < array.length; i++) {
			if (code.equals(array[i][0])) {
				codeName = array[i][1];
				break;
			}
		}
		return codeName;
	}

	/**
	 * R[h擾
	 * @param name  擾ΏۃR[h
	 * @param array  擾Ώ۔z
	 * @return R[h
	 */
	public static String getCodeValue(String name, String[][] array) {
		String codeValue = name;
		if (array == null) {
			return codeValue;
		}
		for (int i = 0; i < array.length; i++) {
			if (name.equals(array[i][1])) {
				codeValue = array[i][0];
				break;
			}
		}
		return codeValue;
	}

	/**
	 * Nv_E擾
	 * @param year N
	 * @return Nv_Epz
	 */
	public static String[][] getYearArray(int year) {
		String[][] aryYear = new String[3][2];
		aryYear[0][0] = String.valueOf(year - 1);
		aryYear[0][1] = String.valueOf(year - 1);
		aryYear[1][0] = String.valueOf(year);
		aryYear[1][1] = String.valueOf(year);
		aryYear[2][0] = String.valueOf(year + 1);
		aryYear[2][1] = String.valueOf(year + 1);
		return aryYear;
	}

	/**
	 * Nv_E擾
	 * @param year N
	 * @param former ߋ
	 * @param further 
	 * @return Nv_Epz
	 */
	public static String[][] getYearArray(int year, int former, int further) {
		String[][] aryYear = new String[former + further + 1][2];
		int i = 0;
		int index = 0;
		for (i = year - former; i < year; i++) {
			aryYear[index][0] = String.valueOf(i);
			aryYear[index][1] = String.valueOf(i);
			index++;
		}
		aryYear[index][0] = String.valueOf(year);
		aryYear[index][1] = String.valueOf(year);
		index++;
		for (i = year + 1; i <= year + further; i ++) { 
			aryYear[index][0] = String.valueOf(i);
			aryYear[index][1] = String.valueOf(i);
			index++;
		}
		return aryYear;
	}

	/**
	 * v_E擾
	 * @return v_Epz
	 */
	public static String[][] getMonthArray() {
		String[][] aryMonth = new String[12][2];
		for (int i = 0; i < 12; i++) {
			aryMonth[i][0] = String.valueOf(i + 1);
			aryMonth[i][1] = String.valueOf(i + 1);
		}
		return aryMonth;
	}

	/**
	 * v_E擾
	 * @return v_Epz
	 */
	public static String[][] getDayArray() {
		String[][] aryDay = new String[31][2];
		for (int i = 0; i < 31; i++) {
			aryDay[i][0] = String.valueOf(i + 1);
			aryDay[i][1] = String.valueOf(i + 1);
		}
		return aryDay;
	}

	/**
	 * ԃv_E擾
	 * @param hour          Jn
	 * @param minute        Jn
	 * @param count         f[^
	 * @param interval      f[^Ԋu()
	 * @param isValueMinute ݒtO(trueFvalue͕PʁAfalseFvalue͎ԕ)
	 * @return ԃv_Epz
	 */
	public static String[][] getTimeArray(int hour, int minute, int count, int interval, boolean isValueMinute) {
		String[][] aryTime = new String[count][2];
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.HOUR_OF_DAY, hour);
		cal.set(Calendar.MINUTE, minute);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		for (int i = 0; i < count; i++) {
			if (isValueMinute) {
				aryTime[i][0] = String.valueOf(cal.get(Calendar.HOUR_OF_DAY) * 60 + cal.get(Calendar.MINUTE));
			} else {
				aryTime[i][0] = MospUtility.getDateString(cal.getTime(), CommonConst.FORMAT_TIME_SHORT);
			}
			aryTime[i][1] = MospUtility.getDateString(cal.getTime(), CommonConst.FORMAT_TIME_SHORT);
			cal.add(Calendar.MINUTE, interval);
		}
		return aryTime;
	}

	/**
	 * lv_E擾
	 * @param start		Jnl
	 * @param end		Il
	 * @param interval	Ԋu
	 * @return lv_Epz
	 */
	public static String[][] getCountArray(int start, int end, int interval) {
		int count = (end - start) / interval + 1;
		int value = start;
		String[][] aryCount = new String[count][2];
		for (int i = 0; i < count; i++) {
			aryCount[i][0] = String.valueOf(value);
			aryCount[i][1] = String.valueOf(value);
			value += interval;
		}
		return aryCount;
	}

	/**
	 * v_Es
	 * @param target Ώۃv_Ez
	 * @param value Ώۍsl
	 * @return v_E
	 */
	public static String[][] removeArrayRow(String[][] target, String value) {
		int count = target.length;
		for (int i = 0; i < target.length; i++) {
			if (target[i][0].equals(value)) {
				--count;
			}
		}
		String[][] aryNew = new String[count][2];
		count = 0;
		for (int i = 0; i < target.length; i++) {
			if (target[i][0].equals(value)) {
				continue;
			}
			aryNew[count][0] = target[i][0];
			aryNew[count][1] = target[i][1];
			++count;
		}
		return aryNew;
	}

	/**
	 * v_E̐擪sɋ󔒂ǉ
	 * @param target Ώۃv_Ez
	 * @return ǉv_E
	 */
	public static String[][] addArrayFirstRowSpace(String[][] target) {
		return addArrayFirstRowValue(target, "", "");
	}

	/**
	 * v_E̐擪sɔCӂ̒lǉ
	 * @param target Ώۃv_Ez
	 * @param code ΏۍsR[h
	 * @param value Ώۍs\l
	 * @return aryNew	z
	 */
	public static String[][] addArrayFirstRowValue(String[][] target, String code, String value) {
		String[][] aryNew = new String[target.length + 1][2];
		for (int i = 0; i < aryNew.length; i++) {
			if (i == 0) {
				aryNew[0][0] = code;
				aryNew[0][1] = value;
			} else {
				aryNew[i][0] = target[i - 1][0];
				aryNew[i][1] = target[i - 1][1];
			}
		}
		return aryNew;
	}

	/**
	 * v_E̍ŏIsɔCӂ̒lǉ
	 * @param target Ώۃv_Ez
	 * @param code ΏۍsR[h
	 * @param value Ώۍs\l
	 * @return aryNew	z
	 */
	public static String[][] addArrayLastRowValue(String[][] target, String code, String value) {
		String[][] aryNew = new String[target.length + 1][2];
		for (int i = 0; i < aryNew.length; i++) {
			if (i == aryNew.length -1) {
				aryNew[i][0] = code;
				aryNew[i][1] = value;
			} else {
				aryNew[i][0] = target[i][0];
				aryNew[i][1] = target[i][1];
			}
		}
		return aryNew;
	}

	/*		֘A	*/

	/**
	 * StringNullA`FbN
	 * @param str		ΏString
	 * @return
	 * <p>Null͒0̏ꍇtrueAłȂꍇfalse</p>
	 */
	public static boolean isNull(String str) {
		try {
			if (str == null || str.length() == 0) {
				return true;
			}
		} catch (NullPointerException e) {
			return true;
		}
		return false;
	}

	/**
	 * StringNotNull`FbN
	 * @param str		ΏString
	 * @return
	 * <p>Null͒0ȊȌꍇtrueAłȂꍇfalse</p>
	 */
	public static boolean isNotNull(String str) {
		return !isNull(str);
	}

	/**
	 * nCt\bh
	 * @param code Ώۃf[^
	 * @param hyphen nCt
	 * @return z<br>
	 * nCtƃnCt̊ԂɉꍇA
	 * zɁu""vB
	 * 
	 */
	public static String[] divideByHyphen(String code, int hyphen) {
		String[] base = code.split(CommonConst.FILE_NAME_SEPARATOR);
		String[] ar = new String[hyphen + 1];
		for (int i = 0; i < base.length; i++) {
			ar[i] = base[i];
		}
		for (int i = 0; i < ar.length; i++) {
			if (ar[i] == null) {
				ar[i] = "";
			}
		}
		return ar;
	}

	/**
	 * nCt\bh
	 * @param code Ώۃf[^
	 * @return z<br>
	 * nCtƃnCt̊ԂɉꍇA
	 * zɁu""vB<br>
	 * nCtŕ񂪏IꍇAnCt̑O̕܂łA
	 * zɂB
	 */
	public static String[] divideByHyphen(String code) {
		String[] base = code.split(CommonConst.FILE_NAME_SEPARATOR);
		String[] ar = new String[base.length];
		for (int i = 0; i < base.length; i++) {
			ar[i] = base[i];
		}
		for (int i = 0; i < ar.length; i++) {
			if (ar[i] == null) {
				ar[i] = "";
			}
		}
		return ar;
	}

	/**
	 * s\
	 * @param aStr sΏە
	 * @return s㕶
	 */
	public static String brHTML(String aStr) {
		char c;
		String strTarget = aStr != null ? aStr : "";
		StringBuffer returnStr = new StringBuffer();
		int length = strTarget.length();
		for (int i = 0; i < length; i++) {
			c = strTarget.charAt(i); 
			if (c == '\n') {
				returnStr = returnStr.append("<br>");
			} else if (c == '<') {
				returnStr = returnStr.append("&lt;");
			} else if(c == '>') {
				returnStr = returnStr.append("&gt;");
			} else if(c == '&') {
				returnStr = returnStr.append("&amp;");
			} else if(c == '"') {
				returnStr = returnStr.append("&quot;");
			} else if(c == '\'') {
				returnStr = returnStr.append("&#39;");
			} else {
				returnStr = returnStr.append(c);
			}
		}
		return new String(returnStr);
	}

	/**
	 * [t̐琮֕ϊ
	 * @param number [t
	 * @return 
	 */
	public static String removeZero(String number) {
		return String.valueOf(Integer.parseInt(number));
	}

	/**
	 * [t̐֕ϊ
	 * @param number
	 * @return String	i0~9ji00~09j
	 */
	public static String addZero(int number) {
		StringBuffer sb = new StringBuffer();
		if (number < 10) {
			sb.append(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		}
		sb.append(number);
		return sb.toString();
	}

	/**
	 * [t̐֕ϊ
	 * @param number
	 * @return String	i0~9ji00~09j
	 */
	public static String addZero(String number) {
		StringBuffer sb = new StringBuffer();
		if (number.length() < 2) {
			sb.append(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		}
		sb.append(number);
		return sb.toString();
	}

	/**
	 * X֔ԍ\bh
	 * @param	code X֔ԍ
	 * @return O3
	 */
	public static String divideYubinCodeForward(String code) {
		String[] ar = code.split(CommonConst.STR_SEPARATOR);
		if (ar.length > 0) {
			return ar[0];
		} else {
			return "";
		}	
	}

	/**
	 * X֔ԍ\bh
	 * @param	code X֔ԍ
	 * @return 4
	 */
	public static String divideYubinCodeBackward(String code) {
		String[] ar = code.split(CommonConst.STR_SEPARATOR);
		if (ar.length > 1) {
			return ar[1];
		} else {
			return "";
		}
	}

	/**
	 * J}\bh
	 * @param code Ώۃf[^
	 * @param comma J}
	 * @return z<br>
	 * J}ƃJ}̊ԂɉꍇA
	 * zɁu""vB
	 * 
	 */
	public static String[] divideByComma(String code, int comma) {
		String[] base = code.split(CommonConst.KEY_SEPARATOR);
		String[] ar = new String[comma + 1];
		for (int i = 0; i < base.length; i++) {
			ar[i] = base[i];
		}
		for (int i = 0; i < ar.length; i++) {
			if (ar[i] == null) {
				ar[i] = "";
			}
		}
		return ar;
	}

	/**
	 * J}\bh
	 * @param code Ώۃf[^
	 * @return z<br>
	 * J}ƃJ}̊ԂɉꍇA
	 * zɁu""vB
	 */
	public static String[] divideByComma(String code) {
		String[] base = code.split(CommonConst.KEY_SEPARATOR);
		String[] ar = new String[base.length];
		for (int i = 0; i < base.length; i++) {
			ar[i] = base[i];
		}
		for (int i = 0; i < ar.length; i++) {
			if (ar[i] == null) {
				ar[i] = "";
			}
		}
		return ar;
	}

	/**
	 * J}\bh
	 * @param array		Ώ۔z
	 * @return	string	
	 */
	public static String combineByComma(String[] array) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < array.length; i++) {
			sb.append(array[i]);
			if (i < array.length - 1) {
				sb.append(CommonConst.KEY_SEPARATOR);
			}			
		}
		return sb.toString();
	}

	/**
	 * XbV\bh
	 * @param code		ΏۃR[h
	 * @return@z
	 */
	public static String[] divideBySlash(String code) {
		String[] base = code.split(CommonConst.SEPARATOR_DATE);
		String[] ar = new String[base.length];
		for (int i = 0; i < base.length; i++) {
			ar[i] = base[i];
		}
		for (int i = 0; i < ar.length; i++) {
			if (ar[i] == null) {
				ar[i] = "";
			}
		}
		return ar;
	}

	/**
	 * XbV\bh
	 * @param code		ΏۃR[h
	 * @param slash		XbV
	 * @return@z
	 */
	public static String[] divideBySlash(String code, int slash) {
		String[] base = code.split(CommonConst.SEPARATOR_DATE);
		String[] ar = new String[slash + 1];
		for (int i = 0; i < base.length; i++) {
			ar[i] = base[i];
		}
		for (int i = 0; i < ar.length; i++) {
			if (ar[i] == null) {
				ar[i] = "";
			}
		}
		return ar;
	}

	/**
	 * nullɏlZbg
	 * @param obj
	 * @param init
	 * @return	string ϊ
	 */
	public static String convNullToInitialValue(Object obj, String init) {
		String value = init;
		if (obj == null) {
			return value;
		} else {
			return (String)obj;
		}
	}
	/**
	 * 𕪊
	 * @param Sspl1
	 * @param Sspl2
	 * @param Sspl3
	 * @return	
	 */
	public static String splitStrings(String Sspl1, String Sspl2, int Sspl3) {
		if (Sspl1.length() > 0){
			if (Sspl1.indexOf(Sspl2) != -1)  {
				int i = Sspl1.indexOf(Sspl2);
				if (Sspl3 == 0) {
					return Sspl1.substring(0,i);
				} else {
					return Sspl1.substring(i+1,Sspl1.length());
				}
			} else {
				return Sspl1;
			}
		} else {
			return "";
		}
	}

	/**
	 * 𔼊pJi֓
	 * @param input		Ώۉ
	 * @return	pJiϊ㕶
	 */
	public static String toHankakuKana(String input) {
		return KanaConvertUtility.convZenkakuToHankaku(KanaConvertUtility.convHiraGanaToHankaku(input));
	}

	/**
	 * SpXy[X𔼊pXy[X֕ϊ
	 * @param input		SpXy[X܂܂镶
	 * @return	SpXy[X𔼊pXy[X֕ϊ̕
	 */
	public static String to1byteSpace(String input) {
		StringBuffer sb = new StringBuffer();
		String[] aryInput = input.split("@");
		for (int i = 0; i < aryInput.length; i++) {
			sb.append(aryInput[i]);
			if (i != aryInput.length -1) {
				sb.append(CommonConst.NAM_COMMON_HALF_KANA_SPACE);
			}
		}
		return sb.toString();
	}

	/*	tOϊ	*/

	/**
	 * tOϊiStringbooleanj
	 * @param target ΏString
	 * @param trueflag trueԂ
	 * @param falseflag falseԂ
	 * @return  ǂłȂꍇfalse
	 */
	public static boolean convFlagToBoolean(String target, String trueflag, String falseflag) {
		if (target.equals(trueflag)) {
			return true;
		} else if (target.equals(falseflag)) {
			return false;
		} else {
			return false;
		}
	}

	/**
	 * tOϊiStringbooleanj
	 * @param target ΏString
	 * @param trueflag trueԂ
	 * @return 
	 */
	public static boolean convFlagToBoolean(String target, String trueflag) {
		if (target.equals(trueflag)) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * tOϊiintbooleanj
	 * @param target Ώint
	 * @param trueflag trueԂ
	 * @return 
	 */
	public static boolean convFlagToBoolean(int target, int trueflag) {
		if (target == trueflag) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * tOϊibooleanStringj
	 * @param isTrue 	truȅꍇString
	 * @param isFalse	falsȅꍇString
	 * @param flag 		true or false
	 * @return	String 	ʖ
	 */
	public static String returnStringFlag(String isTrue, String isFalse, boolean flag) {
		if (flag) {
			return isTrue;
		} else {
			return isFalse;
		}
	}

	/**
	 * tOϊibooleanStringj
	 * @param flag 	true or false
	 * @return truecOFFAfalsecON
	 */
	public static String returnTrueIsOff(boolean flag) {
		if (flag) {
			return CommonConst.NAM_COMMON_FLAG_OFF;
		} else {
			return CommonConst.NAM_COMMON_FLAG_ON;
		}
	}

	/**
	 * tOϊibooleanStringj
	 * @param flag 	true or false
	 * @return truecONAfalsecOFF
	 */
	public static String returnTrueIsOn(boolean flag) {
		if (flag) {
			return CommonConst.NAM_COMMON_FLAG_ON;
		} else {
			return CommonConst.NAM_COMMON_FLAG_OFF;
		}
	}

}
