package jp.mosp.common.part;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.mosp.common.CommonConst;

import jp.mosp.common.dto.CmAuthorityDto;
import jp.mosp.common.dto.CmComponentDto;
import jp.mosp.common.dto.HumanBasisDtoInterface;

import jp.mosp.system.dao.MSyozokuDao;
import jp.mosp.system.dto.MSyozokuDto;

/**
 * ɊւPartNX
 * @author yoshida
 *	@version	0.0.1
 */
public class SectionPart extends BasePart {

	/**
	 * RXgN^
	 */
	public SectionPart() {
		super();
	}

	/**
	 * RXgN^
	 * @param partInfo
	 */
	public SectionPart(PartInfo partInfo) {
		super(partInfo);
	}

	/**
	 * M_SYOZOKUe[upDAO擾
	 * @return	ςMSyozokuDaoCX^X
	 * @throws Exception
	 */
	public MSyozokuDao getMSyozokuDao() throws Exception {
		return (MSyozokuDao)getPreparedDao(MSyozokuDao.class.getCanonicalName());
	}

	/**
	 * 擾(M_SYOZOKU)
	 * @param sCode 擾ΏۏR[h
	 * @return (MSyozokuDto)
	 * @throws Exception 
	 */
	public MSyozokuDto getSectionInfo(
			String sCode
	) throws Exception {
		// ̎擾
		return getMSyozokuDao().findForKey(sCode);
	}

	/**
	 * 擾(M_SYOZOKU)
	 * @param sCode 擾ΏۏR[h
	 * @return 
	 * @throws Exception 
	 */
	public String getSectionName(
			String sCode
	) throws Exception {
		String sName = "";
		MSyozokuDto dto = getSectionInfo(sCode);
		if (dto != null) {
			sName = dto.getSName();
		}
		return sName;
	}

	/**
	 * R[h擾
	 * @param kCode 擾ΏێЈR[h
	 * @return R[h
	 * @throws Exception
	 */
	public String getBelongSectionCode(
			String kCode
	) throws Exception {
		String strStationCode = "";
		// l{擾
		HumanBasisDtoInterface mKihonDto = human().getBasisInfo(kCode);
		if (VariousPart.chkExistObject(mKihonDto)) {
			strStationCode = mKihonDto.getSCode();
			// 擾
			if (strStationCode.length() > 0) {
				MSyozokuDto dto = getMSyozokuDao().findForKey(strStationCode);
				if (VariousPart.chkExistDto(dto)) {
					strStationCode = dto.getSCode();
				} else {
					strStationCode = "";
				}
			}
		}
		return strStationCode;
	}

	/**
	 * R[h擾(M_SYOZOKU)
	 * @return R[hXg
	 * @throws Exception 
	 */
	public String[][] getSectionArrayAll() throws Exception {
		// ̎擾
		List<MSyozokuDto> listSection = getMSyozokuDao().findAll();
		// z̍쐬
		String[][] arySection = new String[listSection.size()][2];
		for (int i = 0; i < listSection.size(); i++) {
			arySection[i][0] = listSection.get(i).getSCode();
			arySection[i][1] = listSection.get(i).getSName();
		}
		return arySection;
	}

	/**
	 * R[h擾(p\ĉ)(M_SYOZOKU)
	 * @return R[hXg
	 * @throws Exception
	 */
	public String[][] getSectionArrayForManager() throws Exception {
		// ̎擾
		List<MSyozokuDto> listSection = getMSyozokuDao().findForCondition(
				getBelongSectionCode(human().getBasisInfoOfUser().getKCode())
		);
		// z̍쐬
		String[][] aryStation = new String[listSection.size()][2];
		for (int i = 0; i < listSection.size(); i++) {
			aryStation[i][0] = listSection.get(i).getSCode();
			aryStation[i][1] = listSection.get(i).getSName();
		}
		return aryStation;
	}

	/**
	 * R[h擾(p\cɂω)(M_SYOZOKU)
	 * @return R[hXg
	 * @throws Exception
	 */
	public String[][] getSectionArrayForHuman() throws Exception {
		// ̎擾
		List<MSyozokuDto> listSection;
		// 쌠mF		
		if (authority().hasHumanAuth()) {
			listSection = getMSyozokuDao().findAll();
		} else {
			listSection = getMSyozokuDao().findForCondition(
					getBelongSectionCode(human().getBasisInfoOfUser().getKCode())
			);		
		}
		// z̍쐬
		String[][] aryStation = new String[listSection.size()][2];
		for (int i = 0; i < listSection.size(); i++) {
			aryStation[i][0] = listSection.get(i).getSCode();
			aryStation[i][1] = listSection.get(i).getSName();
		}
		return aryStation;
	}

	/**
	 * R[h擾(͈͂ɂω)(M_SYOZOKU)
	 * @return R[hXg
	 * @throws Exception
	 */
	public String[][] getSectionScopeArrayForPayroll() throws Exception {
		CmComponentDto cmComponentDto = new CmComponentDto();
		String userAuth = user.getAuthority();
		CmAuthorityDto cmAuthorityDto = authority().findForKey(userAuth);
		String [][] ary = null ;
		if (cmAuthorityDto != null) {
			cmComponentDto = component().findForKey(cmAuthorityDto.getPayroll());
		}
		// ftHg̐ݒ
		if (userAuth.equals(CommonConst.AUTHORITY_CALCULATE)) {
			cmComponentDto.setManage(VariousPart.getManageCode()[2]);
		} else if (userAuth.equals(CommonConst.AUTHORITY_PAYROLL)) {
			cmComponentDto.setManage(VariousPart.getManageCode()[0]);
		}
		// v_Eݒ
		if (cmComponentDto.getManage() == VariousPart.getManageCode()[0]) {
			ary = getSectionArrayForManager();			
		} else if (cmComponentDto.getManage() == VariousPart.getManageCode()[1]) {
			ary = getSectionArrayAll();
		} else {
			ary = StringPart.addArrayFirstRowValue(
					getSectionArrayAll(),
					CommonConst.NAM_COMMON_STRING_INITIAL_VALUE,
					CommonConst.NAM_ALL_SECTION);
		}
		return ary;
	}

	/**
	 * Xg擾(M_SYOZOKU)
	 * @return R[hXg
	 * @throws Exception
	 */
	public Map<String, MSyozokuDto> getSectionMap() throws Exception {
		// ̎擾
		List<MSyozokuDto> listSection = getMSyozokuDao().findAll();
		// z̍쐬
		HashMap<String, MSyozokuDto> map = new HashMap<String, MSyozokuDto>();
		for (int i = 0; i < listSection.size(); i++) {
			map.put(listSection.get(i).getSCode(), listSection.get(i));
		}
		return map;
	}

	/**
	 * SR[hz擾
	 * @return	R[hz
	 * @throws Exception
	 */
	public String[] getSectionCodeArrayAll() throws Exception {
		List<MSyozokuDto> listSection = getMSyozokuDao().findAll();
		String[] arySectionCode = new String[listSection.size()];
		int i = 0;
		for (Iterator iter = listSection.iterator(); iter.hasNext();) {
			MSyozokuDto dto = (MSyozokuDto) iter.next();
			arySectionCode[i] = dto.getSCode();
			i++;
		}
		return arySectionCode;
	}

}
