package jp.mosp.common.part;

import java.sql.SQLException;
import java.util.List;

import jp.mosp.common.dao.MosPConfDao;
import jp.mosp.common.dto.MosPConfDto;

/**
 * ݒe[uɊւPartNX
 * @author yoshida
 * 	@version	0.0.1
 */
public class MosPConfPart extends BasePart {

	/**
	 * RXgN^
	 */
	public MosPConfPart() {
		super();
	}

	/**
	 * RXgN^
	 * @param partInfo
	 */
	public MosPConfPart(PartInfo partInfo) {
		super(partInfo);
	}

	/**
	 * CM_CONFe[upDAO擾
	 * @return	ςMosPConfDaoCX^X
	 * @throws Exception
	 */
	private MosPConfDao getMosPConfDao() throws Exception {
		return (MosPConfDao)getPreparedDao(MosPConfDao.class.getCanonicalName());
	}

	/**
	 * ݒ胊Xg擾(MOSP_CONF)
	 * @param confId ݒ敪
	 * @return ݒ胊Xg
	 * @throws Exception
	 */
	public String[][] getConfArray(String confId) throws Exception {
		// f[^̎擾
		List<MosPConfDto> list = getMosPConfDao().findForCondition(confId);
		// f[^̐`
		String[][] array = new String[list.size()][2];
		for (int i = 0; i < list.size(); i++) {
			MosPConfDto dto = list.get(i);
			array[i][0] = dto.getConfCode();
			array[i][1] = dto.getConfValue();
		}
		return array;
	}

	/**
	 * ݒl擾(MOSP_CONF)
	 * @param confId   ݒ敪
	 * @param confCode ݒR[h
	 * @return ݒl
	 * @throws Exception
	 */
	public String getConfValue(String confId, String confCode) throws Exception {
		// f[^̎擾
		MosPConfDto dto = getMosPConfDao().findForKey(confId, confCode);
		if (dto == null) {
			return "";
		}
		return dto.getConfValue();
	}

	/**
	 * ݒ胊Xg擾(MOSP_CONF)
	 * @param confId ݒ敪
	 * @return ݒ胊Xg
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	public List<MosPConfDto> getConfList(String confId) throws Exception {
		// f[^̎擾
		return getMosPConfDao().findForCondition(confId);
	}

}
