package jp.mosp.common.part;

import java.sql.SQLException;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;

import jp.mosp.system.dao.MCodeDao;
import jp.mosp.system.dto.MCodeDto;

/**
 * MosP̃R[hɊւPartNX
 * @author yoshida
 *	@version	0.0.2
 */
public class MosPCodePart extends BasePart {

	/**
	 * RXgN^
	 */
	public MosPCodePart() {
		super();
	}

	/**
	 * RXgN^
	 * @param partInfo	
	 */
	public MosPCodePart(PartInfo partInfo) {
		super(partInfo);
	}

	/**
	 * MCodeDao擾
	 * @return			MCodeDaoCX^X
	 * @throws Exception
	 */
	public MCodeDao getMCodeDao() throws Exception {
		return (MCodeDao)getPreparedDao(MCodeDao.class.getCanonicalName());
	}

	/**
	 * @param tid
	 * @param tcode
	 * @return
	 * @throws Exception
	 */
	public MCodeDto findForKey(String tid, String tcode) throws Exception {
		return getMCodeDao().findForKey(tid, tcode);
	}

	/**
	 * @param tid
	 * @param tcode
	 * @return
	 * @throws Exception
	 */
	public MCodeDto findForDto(String tid) throws Exception {
		return getMCodeDao().findForDto(tid);
	}

	/**
	 * @param tid
	 * @param tcode
	 * @return
	 * @throws Exception
	 */
	public List<MCodeDto> findForCondition(String tid, String tcode) throws Exception {
		return getMCodeDao().findForCondition(tid, tcode);
	}

	/**
	 * @param tid
	 * @param tcode
	 * @return
	 * @throws Exception
	 */
	public String findTchange(String tid, String tcode) throws Exception {
		MCodeDto dto = findForKey(tid, tcode);
		if (VariousPart.chkExistDto(dto)) {
			return dto.getTChange();
		}
		return "";
	}

	/**
	 * @param tid
	 * @param tcode
	 * @return
	 * @throws Exception
	 */
	public String findTchange(String tid) throws Exception {
		MCodeDto dto = findForDto(tid);
		if (VariousPart.chkExistDto(dto)) {
			return dto.getTChange();
		}
		return "";
	}

	/**
	 * R[h敪擾(M_CODE)
	 * @return R[h敪Xg
	 * @throws MospException 
	 * @throws ClassNotFoundException 
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	public String[][] getMosPCodeArray() throws Exception {
		// R[h敪̎擾(distinctf[^)
		List<MCodeDto> list = getMCodeDao().findAllTId();     
		String[][] aryCode = new String[list.size()][2];
		// Sting̔zɊi[
		for (int i = 0; i < list.size(); i++) {
			String tId = list.get(i).getTId();
			aryCode[i][0] = tId;
			aryCode[i][1] = tId;
		}
		return aryCode;
	}

	/**
	 * R[h敪擾(M_CODE)
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * @param tid R[hID
	 * @throws MospException 
	 * @throws ClassNotFoundException 
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	public String[][] getMosPCodeArray(String tid) throws Exception {
		// R[h̎擾
		List<MCodeDto> list = getMCodeDao().findForCondition(tid);     
		String[][] aryCode = new String[list.size()][2];
		// Sting̔zɊi[
		for (int i = 0; i < list.size(); i++) {
			aryCode[i][0] = list.get(i).getTCode();
			aryCode[i][1] = list.get(i).getTName();
		}
		return aryCode;
	}

	/**
	 * R[h敪擾(M_CODE)
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * 			[2]tchange
	 * @param tid R[hID
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	public String[][] getMosPCodeArray(String tid, String tcode) throws Exception {
		// R[h̎擾
		List<MCodeDto> list = findForCondition(tid, tcode);     
		String[][] aryCode = new String[list.size()][3];
		// Sting̔zɊi[
		for (int i = 0; i < list.size(); i++) {
			aryCode[i][0] = list.get(i).getTCode();
			aryCode[i][1] = list.get(i).getTName();
			aryCode[i][2] = list.get(i).getTChange();
		}
		return aryCode;
	}

	/**
	 * R[h敪擾(M_CODE)
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * 			[2]tchange
	 * @param tid R[hID
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	public String[] getMosPCode(String tid, String tcode) throws Exception {
		// R[h̎擾
		MCodeDto dto = findForKey(tid, tcode);     
		String[] aryCode = new String[3];
		// Sting̔zɊi[
		if (dto != null) {
			for (int i = 0; i < 3; i++) {
				aryCode[0] = dto.getTCode();
				aryCode[1] = dto.getTName();
				aryCode[2] = dto.getTChange();
			}
		}
		return aryCode;
	}

	/**
	 * R敪擾(M_CODE)
	 * @param tid R[hID
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	public String[][] getReasonCodeArray(String tid) throws Exception {
		// R[h̎擾
		List<MCodeDto> list = getMCodeDao().findForReason(tid);     
		String[][] aryCode = new String[list.size()][2];
		// Sting̔zɊi[
		for (int i = 0; i < list.size(); i++) {
			aryCode[i][0] = list.get(i).getTCode();
			aryCode[i][1] = list.get(i).getTName();
		}
		return aryCode;
	}


	/**
	 * R[h敪擾(M_CODE)
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * 			[2]tchange
	 * @param tid R[hID
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 * @throws MospException 
	 * @throws ClassNotFoundException 
	 */
	public String[] getMosPCode(String tid) throws Exception {
		// R[h̎擾
		MCodeDto dto = findForDto(tid);     
		String[] aryCode = new String[3];
		// Sting̔zɊi[
		for (int i = 0; i < 3; i++) {
			aryCode[0] = dto.getTCode();
			aryCode[1] = dto.getTName();
			aryCode[2] = dto.getTChange();
		}
		return aryCode;
	}

	/**
	 * LxɎx
	 * @return [0]cΑNA[1]cx
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public String[][] getPaidHolidayArray() throws Exception {
		List<MCodeDto> listCode = getPaidHolidayList();
		String[][] aryPaidHolidayDays = new String[listCode.size()][2];
		for (int i = 0; i < aryPaidHolidayDays.length; i++) {
			aryPaidHolidayDays[i][0] = listCode.get(i).getTCode();
			aryPaidHolidayDays[i][1] = listCode.get(i).getTChange();
		}
		return aryPaidHolidayDays;
	}

	/**
	 * LxɎx񃊃Xg擾
	 * @return LxɎx񃊃Xg
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MCodeDto> getPaidHolidayList() throws Exception {
		return getMCodeDao().findForHoliday(CommonConst.NAM_PAID_HOLIDAY + CommonConst.NAM_SUPPLY);
	}

	/**
	 * ΑӏF@\󋵎擾(M_CODE)
	 * @return	boolean 	ΑӏF@\̗L
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 * @throws MospException 
	 * @throws ClassNotFoundException 
	 */
	public boolean isAttendanceApprovalFunction() throws Exception {
		// R[h̎擾
		MCodeDto dto = findForKey(CommonConst.TID_APPROVAL_FUNCTION, CommonConst.TCD_ATTENDANCE_APPROVAL);     
		if (dto == null) {
			return false;
		} else {
			if (dto.getTName().equals(CommonConst.NAM_COMMON_FLAG_ON)) {
				return false;
			} else if (dto.getTName().equals(CommonConst.NAM_COMMON_FLAG_OFF)) {
				return true;
			} else {
				return false;
			}
		}
	}

	/**
	 * pX[hL
	 * @return	int		pX[hL
	 * @throws Exception
	 */
	public int getPasswordTerm() throws Exception {
		int days = 0;
		// R[h̎擾
		MCodeDto dto = findForDto(CommonConst.TID_PASSWORD_TERM);
		if (dto != null) {
			days = Integer.parseInt(dto.getTChange());
		}
		return days;
	}

	/**
	 * LJz
	 * @return	String[]	LJz
	 * <p>
	 * [0]...JzA
	 * [1]...JzA
	 * [2]...Jz敪
	 * </p>
	 * @throws Exception 
	 */
	public String[] getPaidHolidayInfo() throws Exception {
		String[] aryInfo = new String[3];
		// Jz
		aryInfo[0] = String.valueOf(getCarriedForwardMonth());
		// Jz
		aryInfo[1] = String.valueOf(getCarriedForwardDays());
		// Jz敪
		aryInfo[2] = getCarriedForwardType();
		return aryInfo;
	}

	/**
	 * Jz
	 * @return	Jz
	 * @throws Exception
	 */
	public int getCarriedForwardMonth() throws Exception {
		return NumberPart.getIntParam(findTchange(
				CommonConst.NAM_PAID_HOLIDAY,
				CommonConst.NAM_CARRIED_FORWARD + CommonConst.NAM_MONTH)
		);
	}

	/**
	 * Jz
	 * @return	Jz
	 * @throws Exception
	 */
	public int getCarriedForwardDays() throws Exception {
		return NumberPart.getIntParam(findTchange(
				CommonConst.NAM_PAID_HOLIDAY,
				CommonConst.NAM_CARRIED_FORWARD + CommonConst.NAM_NUMBER_OF_DAYS)
		);
	}

	/**
	 * Jz敪
	 * @return	Jz敪
	 * @throws Exception
	 */
	public String getCarriedForwardType() throws Exception {
		return findTchange(
				CommonConst.NAM_PAID_HOLIDAY,
				CommonConst.NAM_CARRIED_FORWARD + CommonConst.NAM_COMMON_TYPE
		);
	}

	/**
	 * xɗRz擾
	 * @since	0.0.2
	 * @return	xɗRz
	 * @throws Exception
	 */
	public String[][] getHolidayReasonArray() throws Exception {
		return getReasonCodeArray(CommonConst.TID_LEAVE_REASON);
	}

}
