package jp.mosp.common.part;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.KintaiCommonDtoInterface;
import jp.mosp.kintai.dao.MScheduleDao;
import jp.mosp.kintai.dao.MSyukkinboDao;
import jp.mosp.kintai.dto.MScheduleDto;
import jp.mosp.kintai.dto.MSyukkinboDto;

/**
 * ΑӂɊւPartNX
 * @author yoshida
 * 	@version	0.0.2
 */
public class KintaiCommonPart extends BasePart {

	/**
	 * RXgN^
	 */
	public KintaiCommonPart() {
		super();
	}

	/**
	 * RXgN^
	 * @param partInfo
	 */
	public KintaiCommonPart(PartInfo partInfo) {
		super(partInfo);
	}

	/**
	 * ςݗ\pDAO擾
	 * @return	ςMScheduleDaoCX^X
	 * @throws Exception
	 */
	public MScheduleDao getMScheduleDao() throws Exception {
		return (MScheduleDao) getPreparedDao(MScheduleDao.class.getCanonicalName());
	}

	/**
	 * ςݏoΕpDAO擾
	 * @return	ςMSyukkinboDaoCX^X
	 * @throws Exception
	 */
	public MSyukkinboDao getMSyukkinboDao() throws Exception {
		return (MSyukkinboDao) getPreparedDao(MSyukkinboDao.class.getCanonicalName());
	}

	/**
	 * xof
	 * <p>	2009/06/24	m.yoshida	ǉ		</p>
	 * @param code		Ώې\
	 * @return
	 * <p>
	 * xΖȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isWorkOnHoliday(String code) {
		return CommonConst.NUM_WORK_ON_HOLIDAY_FLAG_ON.equals(code);
	}

	/**
	 * Oxf
	 * <p>	2009/06/24	m.yoshida	ǉ		</p>
	 * @param code		Ώې\
	 * @return
	 * <p>
	 * xΖȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isStartHalfHoliday(String code) {
		return CommonConst.NUM_START_HALF_HOLIDAY_FLAG_ON.equals(code);
	}

	/**
	 * 㔼xf
	 * <p>	2009/06/24	m.yoshida	ǉ		</p>
	 * @param code		Ώې\
	 * @return
	 * <p>
	 * xΖȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isQuitHalfHoliday(String code) {
		return CommonConst.NUM_QUIT_HALF_HOLIDAY_FLAG_ON.equals(code);
	}

	/**
	 * xɁALxftO
	 * <p>	2009/06/24	m.yoshida	ǉ		</p>
	 * @param kinmu			ΏۋΖ`ԃR[h
	 * @return
	 * <p>
	 * xɁALxꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isHoliday(String kinmu) {
		return CommonConst.ATTENDANCE_TYPE_HOLIDAY.equals(kinmu);
	}

	/**
	 * TxftO
	 * <p>	2009/06/24	m.yoshida	ǉ	</p>
	 * @param kinmu			ΏۋΖ`ԃR[h
	 * @return
	 * <p>
	 * TxꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isWeekHoliday(String kinmu) {
		return CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY.equals(kinmu);
	}

	/**
	 * xof
	 * <p>	2009/06/24	m.yoshida	ǉ		</p>
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * xo΂ȂtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	public static boolean isWorkOnHoliday(KintaiCommonDtoInterface dto) {
		if (VariousPart.chkExistObject(dto)) {
			return isWorkOnHoliday(dto.getKyusyuKb());
		}
		return false;
	}

	/**
	 * Oxf
	 * <p>	2009/06/24	m.yoshida	ǉ		</p>
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * OxȂtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	public static boolean isStartHalfHoliday(KintaiCommonDtoInterface dto) {
		if (VariousPart.chkExistObject(dto)) {
			return isStartHalfHoliday(dto.getSHankyuKb());
		}
		return false;
	}

	/**
	 * 㔼xf
	 * <p>	2009/06/24	m.yoshida	ǉ		</p>
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * 㔼xȂtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	public static boolean isQuitHalfHoliday(KintaiCommonDtoInterface dto) {
		if (VariousPart.chkExistObject(dto)) {
			return isQuitHalfHoliday(dto.getTHankyuKb());
		}
		return false;
	}

	/**
	 * xɁALxftO
	 * <p>	2009/06/24	m.yoshida	ǉ		</p>
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * o΁E\낪xɁALxꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isHoliday(KintaiCommonDtoInterface dto) {
		if (VariousPart.chkExistObject(dto)) {
			return isHoliday(dto.getKinmu());
		}
		return false;
	}

	/**
	 * TxftO
	 * <p>	2009/06/24	m.yoshida	ǉ		</p>
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * o΁E\낪TxꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isWeekHoliday(KintaiCommonDtoInterface dto) {
		if (VariousPart.chkExistObject(dto)) {
			return isWeekHoliday(dto.getKinmu());
		}
		return false;
	}

	/**
	 * Ζ\ftO
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param dto			ΏDTO
	 * @return
	 * <p>
	 * Ζ\ȋΖ`Ԃ̏ꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	public static boolean isAvailableWorkType(KintaiCommonDtoInterface dto) {
		if (VariousPart.chkExistObject(dto)) {
			return !isHoliday(dto) 	&& !isWeekHoliday(dto);
		}
		return false;
	}

	/**
	 * [鎞ԊJn
	 * @return	[鎞ԊJnij
	 * @throws MospException
	 * @throws Exception
	 */
	public int getLateNightStart() throws MospException, Exception {
		// M_CODEl擾
		String conf = mospcode().findTchange(
				CommonConst.TID_WORK_SYSTEM,
				CommonConst.TCD_LATE_NIGHT
		);
		return TimePart.convStringTimeToIntegerTime(conf.split(CommonConst.STR_SLASH_SEPARATOR)[0]);
	}

	/**
	 * [鎞ԏI
	 * @return	[鎞ԏIij
	 * @throws MospException
	 * @throws Exception
	 */
	public int getLateNightEnd() throws MospException, Exception {
		// M_CODEl擾
		String conf = mospcode().findTchange(
				CommonConst.TID_WORK_SYSTEM,
				CommonConst.TCD_LATE_NIGHT
		);
		return TimePart.convStringTimeToIntegerTime(conf.split(CommonConst.STR_SLASH_SEPARATOR)[1]);
	}

	/**
	 * xɎԎ擾
	 * @return	xɎԁij
	 * @throws MospException
	 * @throws Exception
	 */
	public int getAllHolidayTimes() throws MospException, Exception {
		String conf = mospcode().findTchange(
				CommonConst.TID_WORK_SYSTEM,
				CommonConst.TCD_HOLIDAY_HOURS
		);
		return TimePart.convStringTimeToIntegerTime(conf.split(CommonConst.STR_SLASH_SEPARATOR)[0]);
	}

	/**
	 * xɎԎ擾
	 * @return	xɎԁij
	 * @throws MospException
	 * @throws Exception
	 */
	public int getHalfHolidayTimes() throws MospException, Exception {
		String conf = mospcode().findTchange(
				CommonConst.TID_WORK_SYSTEM,
				CommonConst.TCD_HOLIDAY_HOURS
		);
		return TimePart.convStringTimeToIntegerTime(conf.split(CommonConst.STR_SLASH_SEPARATOR)[1]);
	}

	/**
	 * o^PʎԎ擾
	 * @return	o^Pʎԁij
	 * @throws MospException
	 * @throws Exception
	 */
	public int getInputUnitTimes() throws MospException, Exception {
		return NumberPart.getIntParam(mospcode().findTchange(
				CommonConst.TID_INPUT_UNIT_TIMES,
				CommonConst.TCD_MINUTES)
		);
	}

	/**
	 * vZtO擾
	 * @return	vZtO
	 * @throws MospException
	 * @throws Exception
	 */
	public boolean isAutoCalc() throws MospException, Exception {
		String autoCalc = mospcode().findTchange(
				CommonConst.TID_WORK_SYSTEM,
				CommonConst.TCD_AUTOMATIC_CALCULATION
		);
		if (String.valueOf(MospConst.DELETE_FLAG_OFF).equals(autoCalc)) {
			return true;
		}
		return false;
	}

	/**
	 * ԏJ
	 * @return	ԏJ
	 * @throws MospException
	 * @throws Exception
	 */
	public double getPrescribedDays() throws MospException, Exception {
		return NumberPart.getDoubleParam(mospcode().findTchange(
				CommonConst.TID_STATUTORY_MONTH,
				CommonConst.TCD_STATUTORY_DAYS)
		);
	}

	/**
	 * ԏJ
	 * @return	ԏJ
	 * @throws MospException
	 * @throws Exception
	 */
	public double getPrescribedHours() throws MospException, Exception {
		return NumberPart.getDoubleParam(mospcode().findTchange(
				CommonConst.TID_STATUTORY_MONTH,
				CommonConst.TCD_STATUTORY_HOUR)
		);
	}

	/**
	 * J
	 * @return	J
	 * @throws MospException
	 * @throws Exception
	 */
	public double getPrescribedHoursPerDay() throws MospException, Exception {
		return NumberPart.getDoubleParam(mospcode().findTchange(
				CommonConst.TID_STATUTORY,
				CommonConst.TCD_STATUTORY_HOUR)
		);
	}

	/**
	 * ֋xftO
	 * @since	0.0.2
	 * @param kinmu				ΏۋΖ`ԃR[h
	 * @param kkRiyuu			ΏۋxɗRR[h
	 * @param aryHolidayReason	xɗRz
	 * @return
	 * <p>
	 * Ζ`ԃR[hƋxɗRR[h֋xꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isSubstituteHoliday(
			String kinmu,
			String kkRiyuu,
			String[][] aryHolidayReason
	) {
		if (isHoliday(kinmu) && aryHolidayReason[4][0].equals(kkRiyuu)) {
			return true;
		}
		return false;
	}

	/**
	 * ֋xftO
	 * @since	0.0.2
	 * @param dto				ΏDTO
	 * @param aryHolidayReason	xɗRz
	 * @return
	 * <p>
	 * Ζ`ԃR[hƋxɗRR[h֋xꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isSubstituteHoliday(
			KintaiCommonDtoInterface dto,
			String[][] aryHolidayReason
	) {
		if (VariousPart.chkExistObject(dto)) {
			return isSubstituteHoliday(dto.getKinmu(), dto.getKKRiyuu(), aryHolidayReason);
		}
		return false;
	}

	/**
	 * LxftO
	 * @since	0.0.2
	 * @param kinmu					ΏۋΖ`ԃR[h
	 * @param kkRiyuu				ΏۋxɗRR[h
	 * @param aryHolidayReason		xɗRz
	 * @return
	 * <p>
	 * Ζ`ԃR[hƋxɗRR[hLxxɂꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isAllHoliday(
			String kinmu,
			String kkRiyuu,
			String[][] aryHolidayReason
	) {
		if (isHoliday(kinmu) && aryHolidayReason[0][0].equals(kkRiyuu)) {
			return true;
		}
		return false;
	}

	/**
	 * LxftO
	 * @since	0.0.2
	 * @param dto				ΏDTO
	 * @param aryHolidayReason	xɗRz
	 * @return
	 * <p>
	 * Ζ`ԃR[hƋxɗRR[hLxxɂꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isAllHoliday(
			KintaiCommonDtoInterface dto,
			String[][] aryHolidayReason
	) {
		if (VariousPart.chkExistObject(dto)) {
			return isAllHoliday(dto.getKinmu(), dto.getKKRiyuu(), aryHolidayReason);
		}
		return false;
	}

	/**
	 * oΕpݒ
	 * <p>	2009/07/01	m.yoshida	ǉ	</p>
	 * @since	0.0.2
	 * @param dto MScheduleDto
	 * @return mSyukkinboDto MSyukkinboDto
	 * @throws Exception
	 */
	public static MSyukkinboDto copyScheduleToSyukkinbo(MScheduleDto dto) throws Exception {
		MSyukkinboDto mSyukkinboDto = new MSyukkinboDto();
		mSyukkinboDto.setKCode		(dto.getKCode()		);
		mSyukkinboDto.setHizuke		(dto.getHizuke()	);
		mSyukkinboDto.setNen		(dto.getNen()		);
		mSyukkinboDto.setTuki		(dto.getTuki()		);
		mSyukkinboDto.setHi			(dto.getHi()		);
		mSyukkinboDto.setSyozoku	(dto.getSyozoku()	);
		mSyukkinboDto.setNinsyo		(dto.getNinsyo()	);
		mSyukkinboDto.setSyJikoku	(dto.getSyJikoku()	);
		mSyukkinboDto.setKinmu		(dto.getKinmu()		);
		mSyukkinboDto.setSHankyuKb	(dto.getSHankyuKb()	);
		mSyukkinboDto.setKyusyuKb	(dto.getKyusyuKb()	);
		mSyukkinboDto.setTiRiyuu	(dto.getTiRiyuu()	);
		mSyukkinboDto.setTiComent	(dto.getTiComent()	);
		mSyukkinboDto.setTiSyoumei	(dto.getTiSyoumei()	);
		mSyukkinboDto.setTiJikan	(dto.getTiJikan()	);
		mSyukkinboDto.setSyTimes	(dto.getSyTimes()	);
		mSyukkinboDto.setTaJikoku	(dto.getTaJikoku()	);
		mSyukkinboDto.setKinmuJi	(dto.getKinmuJi()	);
		mSyukkinboDto.setKyukeiJi	(dto.getKyukeiJi()	);
		mSyukkinboDto.setTHankyuKb	(dto.getTHankyuKb()	);
		mSyukkinboDto.setSoRiyuu	(dto.getSoRiyuu()	);
		mSyukkinboDto.setSoComent	(dto.getSoComent()	);
		mSyukkinboDto.setSoSyoumei	(dto.getSoSyoumei()	);
		mSyukkinboDto.setSoJikan	(dto.getSoJikan()	);
		mSyukkinboDto.setZaJikan	(dto.getZaJikan()	);
		mSyukkinboDto.setKsJikan	(dto.getKsJikan()	);
		mSyukkinboDto.setSnJikan	(dto.getSnJikan()	);
		mSyukkinboDto.setSyokuji	(dto.getSyokuji()	);
		mSyukkinboDto.setCyoku1		(dto.getCyoku1()	);
		mSyukkinboDto.setCyoku2		(dto.getCyoku2()	);
		mSyukkinboDto.setCyoku3		(dto.getCyoku3()	);
		mSyukkinboDto.setHoka1		(dto.getHoka1()		);
		mSyukkinboDto.setHoka2		(dto.getHoka2()		);
		mSyukkinboDto.setHoka3		(dto.getHoka3()		);
		mSyukkinboDto.setHoka4		(dto.getHoka4()		);
		mSyukkinboDto.setHoka5		(dto.getHoka5()		);
		mSyukkinboDto.setTaTimes	(dto.getTaTimes()	);
		mSyukkinboDto.setKKRiyuu	(dto.getKKRiyuu()	);
		mSyukkinboDto.setDaiKyuJyu	(dto.getDaiKyuJyu()	);
		mSyukkinboDto.setKKComent	(dto.getKKComent()	);
		mSyukkinboDto.setKKSyoumei	(dto.getKKSyoumei()	);
		mSyukkinboDto.setKKJikan	(dto.getKKJikan()	);
		mSyukkinboDto.setKKTimes	(dto.getKKTimes()	);
		mSyukkinboDto.setSnRiyuu	(dto.getSnRiyuu()	);
		mSyukkinboDto.setSnComent	(dto.getSnComent()	);
		mSyukkinboDto.setSnTimes	(dto.getSnTimes()	);
		mSyukkinboDto.setUpdtTimes	(dto.getUpdtTimes()	);
		mSyukkinboDto.setNijiKyu	(dto.getNijiKyu()	);
		mSyukkinboDto.setWarimasi1	(dto.getWarimasi1()	);
		mSyukkinboDto.setZKinmu		(dto.getZKinmu()	);
		return mSyukkinboDto;
	}

}
