package jp.mosp.common.part;

import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.human.dao.MKihonDao;
import jp.mosp.human.dto.MKihonDto;

/**
 * lɊւPartNX
 * @author yoshida
 *	@version	0.0.2
 */
public class HumanPart extends BasePart {

	/**
	 * RXgN^
	 */
	public HumanPart() {
		super();
	}

	/**
	 * RXgN^
	 * @param partInfo
	 */
	public HumanPart(PartInfo partInfo) {
		super(partInfo);
	}

	/**
	 * M_KIHONe[upDAO擾
	 * @return	ςMKihonDaoCX^X
	 * @throws Exception
	 */
	public MKihonDao getMKihonDao() throws Exception {
		return (MKihonDao)getPreparedDao(MKihonDao.class.getCanonicalName());
	}

	/**
	 * l{擾(M_KIHON)
	 * @param kCode 擾ΏێЈR[h
	 * @return l{(UmBasisDto)
	 * @throws Exception 
	 */
	public MKihonDto getBasisInfo(
			String kCode
	) throws Exception {
		// ̎擾
		return getMKihonDao().findForKey(kCode);
	}

	/**
	 * Ј擾(M_KIHON)
	 * @param kCode 擾ΏێЈR[h
	 * @return Ј
	 * @throws Exception 
	 */
	public String getKName(
			String kCode
	) throws Exception {
		MKihonDto dto = getBasisInfo(kCode);
		if (dto == null) {
			return kCode;
		}
		return dto.getSimei();
	}

	/**
	 * ЈR[h擾(M_KIHON)()
	 * @param sectionCode R[h
	 * @return ЈR[hXg
	 * @throws Exception 
	 */
	public String[] getBasisArray(
			String sectionCode
	) throws Exception {
		Date todayDate = DatePart.getSystemDate();
		// ̎擾
		List<MKihonDto> listKihon = getMKihonDao().findForSection(
				sectionCode,
				DatePart.convDateToInteger(todayDate),
				DatePart.convDateToInteger(calculate().getEndDate(todayDate))
		);
		// z̍쐬
		String[] aryKihon = new String[listKihon.size()];
		for (int i = 0; i < listKihon.size(); i++) {
			aryKihon[i] = listKihon.get(i).getKCode();
		}
		return aryKihon;
	}

	/**
	 * ЈR[h擾(M_KIHON)
	 * @return ЈR[hXg
	 * @throws Exception 
	 */
	public String[][] getBasisArrayAll() throws Exception {
		// ̎擾
		List<MKihonDto> listKihon = getMKihonDao().findAll();
		// z̍쐬
		String[][] aryKihon = new String[listKihon.size()][2];
		for (int i = 0; i < listKihon.size(); i++) {
			aryKihon[i][0] = listKihon.get(i).getKCode();
			aryKihon[i][1] = listKihon.get(i).getSimei();
		}
		return aryKihon;
	}

	/**
	 * ЈR[h擾(M_KIHON)
	 * @return ЈR[hXg
	 * @throws Exception 
	 */
	public String[][] getBasisArrayForApproval() throws Exception {
		// ̎擾
		List<MKihonDto> listKihon = getMKihonDao().findForAuth(
				CommonConst.AUTHORITY_MANAGER,
				CommonConst.AUTHORITY_SENIORS,
				DatePart.convDateToInteger(DatePart.getSystemDate())
		);
		// z̍쐬
		String[][] aryKihon = new String[listKihon.size()][2];
		for (int i = 0; i < listKihon.size(); i++) {
			aryKihon[i][0] = listKihon.get(i).getKCode();
			aryKihon[i][1] = listKihon.get(i).getSimei();
		}
		return aryKihon;
	}

	/**
	 * ЈR[hAR[h擾(M_KIHON)
	 * @return ЈR[hXg
	 * @throws Exception 
	 */
	public String[][] getBasisArrayAllWithSectionCode() throws Exception {
		// ̎擾
		List<MKihonDto> listKihon = getMKihonDao().findAll();
		// z̍쐬
		String[][] aryKihon = new String[listKihon.size()][2];
		for (int i = 0; i < listKihon.size(); i++) {
			aryKihon[i][0] = listKihon.get(i).getKCode();
			aryKihon[i][1] = section().getBelongSectionCode(listKihon.get(i).getKCode());
		}
		return aryKihon;
	}

	/**
	 * ЈR[hAR[h擾(M_KIHON)
	 * @since	0.0.2
	 * @return ЈR[hXg
	 * @throws Exception 
	 */
	public String[][] getBasisArrayAllWithOfficeCode() throws Exception {
		// ̎擾
		List<MKihonDto> listKihon = getMKihonDao().findAll();
		// z̍쐬
		String[][] aryKihon = new String[listKihon.size()][2];
		for (int i = 0; i < listKihon.size(); i++) {
			aryKihon[i][0] = listKihon.get(i).getKCode();
			aryKihon[i][1] = office().getBelongOfficeCode(listKihon.get(i).getKCode());
		}
		return aryKihon;
	}

	/**
	 * IЈЈR[hꗗ擾(M_KIHON)
	 * @param kCode		ΏێЈR[h
	 * @return	ЈR[hXg
	 * @throws Exception
	 */
	public String[][] getBasisArrayForBelongSection(String kCode) throws Exception {
		// 
		List<MKihonDto> listMKihon = getMKihonDao().findForCondition(
				section().getBelongSectionCode(kCode),
				getBasisInfo(kCode).getJCode(),
				getBasisInfo(kCode).getKCode(),
				mospuser().getUserInfoForKCode(kCode).getDataLevel(),
				DatePart.convDateToInteger(DatePart.getSystemDate())
		);
		String[][] aryBasis = new String[listMKihon.size()][2];
		for (int i = 0; i < aryBasis.length; i++) {
			aryBasis[i][0] = listMKihon.get(i).getKCode();
			aryBasis[i][1] = listMKihon.get(i).getSimei();
		}
		return aryBasis;
	}

	/**
	 * ΑNij擾
	 * @param kCode
	 * @return y.m<br>͂̂܂
	 * 				[] 262.02N
	 * @throws Exception 
	 */
	public double getYearsOfService(
			String kCode
	) throws Exception {
		MKihonDto dto = getBasisInfo(kCode);
		int difference = 0;
		if (dto != null) {
			difference = DatePart.getMonthRemainder(
					DatePart.getSystemDate(),
					DatePart.convIntegerDateToDate(dto.getNyDate())
			);			
		}
		double yearsOfService = difference /12 + difference %12 /100;
		return yearsOfService;
	}

	/**
	 * ސEf
	 * @param kCode		ΏێЈR[h
	 * @return
	 * <p>
	 * ސȄꍇBtrueAłȂꍇfalseB
	 * </p>
	 * @throws Exception
	 */
	public boolean isRetiredEmployee (String kCode) throws Exception {
		MKihonDto dto = getBasisInfo(kCode);
		if (VariousPart.chkExistDto(dto)) {
			// ސE敪ސEAސEt{ȌꍇB
			if (dto.getKnKubun().equals(String.valueOf(CommonConst.RETIREMENT_FLAG_ON))
					&& (dto.getTsDate() > 0
							&& dto.getTsDate() < DatePart.convDateToInteger(DatePart.getSystemDate())
					)
			) {
				return true;
			}
		} else {
			return true;
		}
		return false;
	}

	/**
	 * ݐEЈ擾
	 * @param kCode		ΏێЈR[h
	 * @return			ݐEЈ
	 * @throws Exception
	 */
	public MKihonDto getAvailableUserInfo(String kCode) throws Exception {
		MKihonDto dto = getBasisInfo(kCode);
		if (VariousPart.chkExistDto(dto)) {
			// ސE敪ސȄꍇB
			if (isRetiredEmployee(kCode)) {
				return null;
			}
			// ސE敪xȄꍇB
			if (dto.getKnKubun().equals(String.valueOf(CommonConst.RETIREMENT_FLAG_LEAVE))) {
				return null;
			}
		}
		return dto;
	}

	/**
	 * OCЈ{擾
	 * @return	OCЈ{
	 * @throws Exception
	 */
	public MKihonDto getBasisInfoOfUser() throws Exception {
		return getBasisInfo(user.getKCode());
	}

}
