package jp.mosp.common.part;

import java.sql.SQLException;
import java.util.List;

import jp.mosp.common.dao.CmComponentDao;
import jp.mosp.common.dto.CmComponentDto;

/**
 * j[ɊւPartNX
 * @author yoshida
 * 	@version	0.0.2
 */
public class ComponentPart extends BasePart {

	/**
	 * RXgN^
	 */
	public ComponentPart() {
		super();
	}

	/**
	 * RXgN^
	 * @param partInfo
	 */
	public ComponentPart(PartInfo partInfo) {
		super(partInfo);
	}

	/**
	 * CM_COMPONENTe[upDAO擾
	 * @return	ςCmComponentDaoCX^X
	 * @throws Exception
	 */
	public CmComponentDao getCmComponentDao() throws Exception {
		return (CmComponentDao)getPreparedDao(CmComponentDao.class.getCanonicalName());
	}

	/**
	 * j[\擾
	 * @param compcode		ΏۃR}hjbgR[h
	 * @param division		ΏەރR[h
	 * @return	j[\
	 * @throws Exception
	 */
	public CmComponentDto findForDto(String compcode, String division) throws Exception {
		return getCmComponentDao().findForDto(compcode, division);
	}

	/**
	 * j[\擾
	 * @param compcode		ΏۃR}hjbgR[h
	 * @return				j[\
	 * @throws Exception
	 */
	public CmComponentDto findForKey(String compcode) throws Exception {
		return getCmComponentDao().findForKey(compcode);
	}

	/**
	 * j[\擾
	 * @param compcode		ΏۃR}hjbgR[h
	 * @return				j[\
	 * @throws Exception
	 */
	public CmComponentDto findForComponent(String compcode) throws Exception {
		return getCmComponentDao().findForComponent(compcode);
	}

	/**
	 * ޕʌ敪擾(CM_COMPONENT)
	 * @since	0.0.2
	 * @param division 
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	public String[][] getDivisionAuthArray(String division) throws Exception {
		// R[h̎擾
		List<CmComponentDto> list = getCmComponentDao().findForAvailable(division);     
		String[][] aryCode = new String[list.size()][2];
		// Sting̔zɊi[
		for (int i = 0; i < list.size(); i++) {
			aryCode[i][0] = list.get(i).getCompCode();
			aryCode[i][1] = list.get(i).getCompName();
		}
		return aryCode;
	}

	/**
	 * ޕʌ敪擾(CM_COMPONENT)
	 * @since	0.0.2
	 * @param division 
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	public String[][] getDivisionAuthAllArray(String division) throws Exception {
		// R[h̎擾
		List<CmComponentDto> list = getCmComponentDao().findForCondition(division);     
		String[][] aryCode = new String[list.size()][2];
		// Sting̔zɊi[
		for (int i = 0; i < list.size(); i++) {
			aryCode[i][0] = list.get(i).getCompCode();
			aryCode[i][1] = list.get(i).getCompName();
		}
		return aryCode;
	}

}
