package jp.mosp.common.part;

import java.sql.SQLException;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.dao.CmCodeDao;
import jp.mosp.common.dto.CmCodeDto;

/**
 * ʃR[hɊւPartNX
 * @author yoshida
 *	@version	0.0.1
 */
public class CmCodePart extends BasePart {

	/**
	 * RXgN^
	 */
	public CmCodePart() {
		super();
	}

	/**
	 * RXgN^
	 * @param partInfo
	 */
	public CmCodePart(PartInfo partInfo) {
		super(partInfo);
	}

	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	public CmCodeDao getCmCodeDao() throws Exception {
		return (CmCodeDao)getPreparedDao(CmCodeDao.class.getCanonicalName());
	}

	/**
	 * R[hXg擾(CM_CODE)
	 * @param tId R[h敪
	 * @return R[hXg
	 * @throws Exception 
	 */
	public String[][] getCodeArray(String tId) throws Exception {
		// f[^̎擾
		List<CmCodeDto> list = getCmCodeDao().findForCondition(tId);
		// f[^̐`
		String[][] array = new String[list.size()][2];
		for (int i = 0; i < list.size(); i++) {
			CmCodeDto dto = list.get(i);
			array[i][0] = dto.getTCode();
			array[i][1] = dto.getTName();
		}
		return array;
	}

	/**
	 * R[h敪擾(CM_CODE)
	 * @return R[h敪Xg
	 * @throws Exception 
	 */
	public String[][] getCodeArray() throws Exception {
		// R[h敪̎擾(distinctf[^)
		List<CmCodeDto> list = getCmCodeDao().findAllTId();     
		String[][] aryCode = new String[list.size()][2];
		// Sting̔zɊi[
		for (int i = 0; i < list.size(); i++) {
			String tId = list.get(i).getTId();
			aryCode[i][0] = tId;
			aryCode[i][1] = getCodeTypeName(tId);
		}
		return aryCode;
	}

	/**
	 * R[h敪̎擾(CM_CODE)
	 * @param	tId R[h敪
	 * @return	tId R[h敪
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	public String getCodeTypeName(String tId) {
		if (tId.equals(CommonConst.TID_AUTHORITY)) {
			return CommonConst.TNM_AUTHORITY;
		} else {
			return tId;
		}
	}

	/**
	 * az
	 * @return	az
	 * @throws Exception
	 */
	public String[][] getJPCalendarGengo() throws Exception {
		String[][] array = CommonConst.getJpCalendarGengo();
		String[][] aryGengo = getCodeArray(CommonConst.TID_JAPANESE);
		if (aryGengo.length > array.length) {
			array = aryGengo;
		}
		return array;
	}

}
