/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
//import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.sql.SQLException;

import org.apache.commons.csv.CSVParser;
import org.apache.commons.fileupload.FileItem;

import jp.mosp.common.common.BaseAction;
import jp.mosp.common.common.BaseDto;
import jp.mosp.common.common.LogUtility;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.common.part.BasePart;

import jp.mosp.common.part.DatePart;
import jp.mosp.common.part.PartInfo;
import jp.mosp.common.part.PartManager;
import jp.mosp.common.part.VariousPart;
import jp.mosp.common.vo.ExclusiveVo;

import jp.mosp.human.dto.MKihonDto;

import jp.mosp.system.dto.MKaisyaDto;
import jp.mosp.system.dto.MSyozokuDto;
import jp.mosp.system.dto.MWorkTypeDto;
import jp.mosp.system.dto.MYakusyokuDto;

/**
 * MosP̃x[XƂȂActionNX
 * @author yoshida
 *	@version	0.1.1
 */
public abstract class MosPAction extends BaseAction {

	// r֘AtB[h
	private boolean needExclusive;
	private List<ExclusiveVo>    listExclusive;

	// tB[h
	protected MKihonDto mKihon;

	protected BufferedReader br;

	protected CommonUtility util;

	/**
	 * RXgN^
	 */
	public MosPAction() {
		super();
		setCheckAuth(false);
		setNeedExclusive(false);
		util = new CommonUtility();
	}

	/**
	 * ANV㏈
	 * @throws SQLException
	 */
	@Override
	protected void afterAction() throws SQLException {
		super.afterAction();
		if (!needExclusive) {
			if (user != null) {
				deleteExclusive(user.getUserId());
			}
		}
	}

	/**
	 * CmAspUserDto̐
	 */
	protected void createAspUser() {
		aspUser = new CmAspUserDto();
		aspUser.setAspUserId(cfg.getProperty(MospConst.PPT_ASP_ASPUSER));
		aspUser.setAspName(cfg.getProperty(MospConst.PPT_ASP_ASPNAME));
		aspUser.setDbDriver(cfg.getProperty(MospConst.PPT_ASP_DBDRIVER));
		aspUser.setDbUrl(cfg.getProperty(MospConst.PPT_ASP_DBURL));
		aspUser.setDbUser(cfg.getProperty(MospConst.PPT_ASP_DBUSER));
		aspUser.setDbPass(cfg.getProperty(MospConst.PPT_ASP_DBPASS));
	}

	/**
	 * St@Cp۔f
	 */
	protected void setUseLogo() {
		boolean useLogoFlag = false;
		String useLogo = cfg.getProperty(CommonConst.PPT_USE_LOGO);
		StringBuffer filepath = new StringBuffer();
		filepath.append(cfg.getProperty(MospConst.PPT_APP_DOCBASE));
		filepath.append(System.getProperty("file.separator"));
		filepath.append("pub");
		filepath.append(System.getProperty("file.separator"));
		filepath.append(CommonConst.FILE_LOGO);
		if (useLogo != null 
				&& useLogo.length() != 0 
				&& Boolean.parseBoolean(useLogo) 
				&& new File(filepath.toString()).exists()
		) {
			useLogoFlag = true;
		}
		cfg.setProperty(CommonConst.PPT_USE_LOGO, String.valueOf(useLogoFlag));
	}

	/**
	 * VOCX^X擾
	 * @return	VO
	 * <p>
	 * MosP̋@\pčꍇÃ\bhI[o[Ch邱ƂŁA
	 * MosPVopꂼVOCX^X̂擾B
	 * </p>
	 */
	protected MosPVo getInitVo() {
		return null;
	}

	/**
	 * PartClass
	 * @since	0.1.0
	 */
	private PartInfo partInfo;

	/**
	 * PartInfoCX^X̐
	 * <p>	xꍇAg܂킷B	</p>
	 * @return	PartInfoCX^X
	 * @throws SQLException 
	 * @throws ClassNotFoundException 
	 * @since	0.1.0
	 */
	protected PartInfo partInfo() throws ClassNotFoundException, SQLException {
		if (!VariousPart.chkExistObject(partInfo)) {
			// DBRlNV擾
			if (conn == null) {
				getConnection();
			}
			partInfo = PartManager.createPartInfo(cfg, cmd, aspUser, user, conn);
		}
		return partInfo;
	}

	/**
	 * 폜tOXg擾
	 * @return 폜tOXg
	 */
	protected String[][] getDeleteArray() {
		return VariousPart.getDeleteArray();
	}

	/**
	 * KptOXg擾
	 * @return 폜tOXg
	 */
	protected String[][] getApplicableFlagArray() {
		return VariousPart.getApplicableFlagArray();
	}

	/**
	 * ݒ胊Xg擾(MOSP_CONF)
	 * @param confId ݒ敪
	 * @return ݒ胊Xg
	 * @throws Exception
	 */
	protected String[][] getConfArray(String confId) throws Exception {
		return PartManager.mospconf(partInfo()).getConfArray(confId);
	}

	/**
	 * ݒl擾(MOSP_CONF)
	 * @param confId   ݒ敪
	 * @param confCode ݒR[h
	 * @return ݒl
	 * @throws Exception
	 */
	protected String getConfValue(String confId, String confCode) throws Exception {
		return PartManager.mospconf(partInfo()).getConfValue(confId, confCode);
	}

	/**
	 * ݒ胊Xg擾(MOSP_CONF)
	 * @param confId ݒ敪
	 * @return ݒ胊Xg
	 * @throws Exception 
	 */
	protected List<MosPConfDto> getConfList(
			String confId
	) throws Exception  {
		return PartManager.mospconf(partInfo()).getConfList(confId);
	}

	/**
	 * [U[擾
	 * @param userId Ώۃ[U[ID
	 * @throws Exception 
	 */
	protected void getInfo(
			String userId
	) throws Exception {
		mKihon 		= PartManager.human(partInfo()).getBasisInfo(user.getKCode());
	}

	/**
	 * l{擾(M_KIHON)
	 * @param kCode 擾ΏێЈR[h
	 * @return l{(UmBasisDto)
	 * @throws Exception 
	 */
	protected MKihonDto getBasisInfo(
			String kCode
	) throws Exception {
		return PartManager.human(partInfo()).getBasisInfo(kCode);
	}

	/**
	 * Ј擾(M_KIHON)
	 * @param kCode 擾ΏێЈR[h
	 * @return Ј
	 * @throws Exception 
	 */
	protected String getKName(
			String kCode
	) throws Exception {
		return PartManager.human(partInfo()).getKName(kCode);
	}

	/**
	 * ЈR[h擾(M_KIHON)()
	 * @param sectionCode R[h
	 * @return ЈR[hXg
	 * @throws Exception 
	 */
	protected String[] getBasisArray(
			String sectionCode
	) throws Exception {
		return PartManager.human(partInfo()).getBasisArray(sectionCode);
	}

	/**
	 * ЈR[h擾(M_KIHON)(wN)
	 * @param sectionCode R[h
	 * @param targetMonth IN
	 * @return ЈR[hXg
	 * @throws Exception 
	 */
	protected String[] getBasisArray(
			String sectionCode,
			Date targetMonth
	) throws Exception {
		return PartManager.human(partInfo()).getBasisArray(sectionCode);
	}

	/**
	 * ЈR[h擾(M_KIHON)
	 * @return ЈR[hXg
	 * @throws Exception 
	 */
	protected String[][] getBasisArrayAll() throws Exception {
		return PartManager.human(partInfo()).getBasisArrayAll();
	}

	/**
	 * ЈR[h擾(M_KIHON)
	 * @return ЈR[hXg
	 * @throws Exception 
	 */
	protected String[][] getBasisArrayForApproval() throws Exception {
		return PartManager.human(partInfo()).getBasisArrayForApproval();
	}

	/**
	 * ЈR[hAR[h擾(M_KIHON)
	 * @return ЈR[hXg
	 * @throws Exception 
	 */
	protected String[][] getBasisArrayAllWithSectionCode() throws Exception {
		return PartManager.human(partInfo()).getBasisArrayAllWithSectionCode();
	}


	/**
	 * ЈR[hAƏR[h擾(M_KIHON)
	 * @return ЈR[hXg
	 * @throws Exception 
	 */
	protected String[][] getBasisArrayAllWithOfficeCode() throws Exception {
		return PartManager.human(partInfo()).getBasisArrayAllWithOfficeCode();
	}

	/**
	 * IЈЈR[hꗗ擾(M_KIHON)
	 * @param kcode		ΏێЈR[h
	 * @return	ЈR[hXg
	 * @throws Exception
	 */
	protected String[][] getBasisArrayForBelongSection(String kcode) throws Exception {
		return PartManager.human(partInfo()).getBasisArrayForBelongSection(kcode);
	}

	/**
	 * ΑNij擾
	 * @param kCode
	 * @return y.m<br>͂̂܂
	 * 				[] 262.02N
	 * @throws Exception 
	 */
	protected double getYearsOfService(
			String kCode
	) throws Exception {
		return PartManager.human(partInfo()).getYearsOfService(kCode);
	}

	/**
	 * ݐEЈ擾
	 * @param kCode		ΏێЈR[h
	 * @return			ݐEЈ
	 * @throws Exception
	 */
	protected MKihonDto getAvailableUserInfo(String kCode) throws Exception {
		return PartManager.human(partInfo()).getAvailableUserInfo(kCode);
	}

	/**
	 * ސEf
	 * @param kCode		ΏێЈR[h
	 * @return
	 * <p>
	 * ސȄꍇBtrueAłȂꍇfalseB
	 * </p>
	 * @throws Exception
	 */
	protected boolean isRetiredEmployee (String kCode) throws Exception {
		return PartManager.human(partInfo()).isRetiredEmployee(kCode);
	}

	/**
	 * R[hXg擾(CM_CODE)
	 * @param tId R[h敪
	 * @return R[hXg
	 * @throws Exception 
	 */
	@Override
	protected String[][] getCodeArray(String tId) throws Exception {
		return PartManager.cmcode(partInfo()).getCodeArray(tId);
	}

	/**
	 * R[h敪擾(CM_CODE)
	 * @return R[h敪Xg
	 * @throws Exception 
	 */
	protected String[][] getCodeArray() throws Exception {
		return PartManager.cmcode(partInfo()).getCodeArray();
	}

	/**
	 * R[h敪̎擾(CM_CODE)
	 * @param	tId R[h敪
	 * @return	tId R[h敪
	 * @throws MospException 
	 */
	protected String getCodeTypeName(String tId) throws Exception {
		return PartManager.cmcode(partInfo()).getCodeTypeName(tId);
	}

	/**
	 * R[hXg擾(CM_AUTHORITY)
	 * @return R[hXg
	 * @throws Exception 
	 */
	protected String[][] getArrangeAuthArray() throws Exception {
		return PartManager.authority(partInfo()).getArrangeAuthArray();
	}

	/**
	 * SR[hXg擾(CM_AUTHORITY)
	 * @return R[hXg
	 * @throws Exception 
	 */
	protected String[][] getArrangeAuthArrayAll() throws Exception {
		return PartManager.authority(partInfo()).getArrangeAuthArrayAll();
	}

	/**
	 * R[h敪擾(M_CODE)
	 * @return R[h敪Xg
	 * @throws Exception 
	 */
	protected String[][] getMosPCodeArray() throws Exception {
		return PartManager.mospcode(partInfo()).getMosPCodeArray();
	}

	/**
	 * R[h敪擾(M_CODE)
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * @param tid R[hID
	 * @throws Exception 
	 */
	protected String[][] getMosPCodeArray(String tid) throws Exception {
		return PartManager.mospcode(partInfo()).getMosPCodeArray(tid);
	}

	/**
	 * R[h敪擾(M_CODE)
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * 			[2]tchange
	 * @param tid R[hID
	 * @throws Exception 
	 */
	protected String[][] getMosPCodeArray(String tid, String tcode) throws Exception {
		return PartManager.mospcode(partInfo()).getMosPCodeArray(tid, tcode);
	}

	/**
	 * R[h敪擾(M_CODE)
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * 			[2]tchange
	 * @param tid R[hID
	 * @throws Exception 
	 */
	protected String[] getMosPCode(String tid, String tcode) throws Exception {
		return PartManager.mospcode(partInfo()).getMosPCode(tid, tcode);
	}

	/**
	 * R敪擾(M_CODE)
	 * @param tid R[hID
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * @throws Exception 
	 */
	protected String[][] getReasonCodeArray(String tid) throws Exception {
		return PartManager.mospcode(partInfo()).getReasonCodeArray(tid);
	}

	/**
	 * R[h敪擾(M_CODE)
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * 			[2]tchange
	 * @param tid R[hID
	 * @throws Exception 
	 */
	protected String[] getMosPCode(String tid) throws Exception {
		return PartManager.mospcode(partInfo()).getMosPCode(tid);
	}

	/**
	 * [U[擾(CM_USER)
	 * @param userId 擾Ώۃ[U[ID
	 * @return [U[(CmUserDto)
	 * @throws Exception 
	 */
	protected CmUserDto getUserInfo(
			String userId
	) throws Exception {
		return PartManager.mospuser(partInfo()).getUserInfo(userId);
	}

	/**
	 * [U[擾(MOSP_USER)
	 * @param kcode		擾ΏێЈR[h
	 * @return [U[(CmUserDto)
	 * @throws Exception 
	 */
	protected CmUserDto getUserInfoForKCode(String kcode) throws Exception {
		return PartManager.mospuser(partInfo()).getUserInfoForKCode(kcode);
	}

	/**
	 * MANAGERmF
	 * @return TRAINERL(trueFLAfalseF)
	 * @throws Exception
	 */
	protected boolean hasManagerAuth() throws Exception {
		return PartManager.authority(partInfo()).hasManagerAuth();
	}


	/**
	 * MANAGERmF
	 * @throws Exception
	 */
	protected void confirmManagerAuth() throws Exception {
		if (!hasManagerAuth()) {
			throw new MospException(MospConst.EX_AUTHORITY);
		}
	}

	/**
	 * PAYROLLmF
	 * @return PAYROLLL(trueFLAfalseF)
	 * @throws Exception
	 */
	protected boolean hasPayrollAuth() throws Exception {
		return PartManager.authority(partInfo()).hasPayrollAuth();
	}

	/**
	 * PAYROLLmF
	 * @throws Exception
	 */
	protected void confirmPayrollAuth() throws Exception {
		if (!hasPayrollAuth()) {
			throw new MospException(MospConst.EX_AUTHORITY);
		}
	}

	/**
	 * HUMANmF
	 * @return PAYROLLL(trueFLAfalseF)
	 * @throws Exception
	 */
	protected boolean hasHumanAuth() throws Exception {
		return PartManager.authority(partInfo()).hasHumanAuth();
	}

	/**
	 * HUMANmF
	 * @throws Exception
	 */
	protected void confirmHumanAuth() throws Exception {
		if (!hasHumanAuth()) {
			throw new MospException(MospConst.EX_AUTHORITY);
		}
	}

	/**
	 * CALCULATEmF
	 * @return CALCULATEL(trueFLAfalseF)
	 * @throws Exception
	 */
	protected boolean hasCalculateAuth() throws Exception {
		return PartManager.authority(partInfo()).hasCalculateAuth();
	}

	/**
	 * CALCULATEmF
	 * @throws Exception
	 */
	protected void confirmCalculateAuth() throws Exception {
		if (!hasCalculateAuth()) {
			throw new MospException(MospConst.EX_AUTHORITY);
		}
	}

	/**
	 * SYSTEMmF
	 * @return SYSTEML(trueFLAfalseF)
	 * @throws Exception 
	 */
	protected boolean hasSystemAuth() throws Exception {
		return PartManager.authority(partInfo()).hasSystemAuth();
	}

	/**
	 * SYSTEMmF
	 * @throws Exception 
	 */
	protected void confirmSystemAuth() throws Exception {
		if (!hasSystemAuth()) {
			throw new MospException(MospConst.EX_AUTHORITY);
		}
	}

	/**
	 * Ə擾(M_KAISYA)
	 * @param jCode 擾ΏێƏR[h
	 * @return Ə(MKaisyaDto)
	 * @throws Exception 
	 */
	protected MKaisyaDto getOfficeInfo(
			String jCode
	) throws Exception {
		return PartManager.office(partInfo()).getOfficeInfo(jCode);
	}

	/**
	 * ƏR[h擾(M_KAISYA)
	 * @return ƏR[hXg
	 * @throws Exception 
	 */
	protected String[][] getOfficeArrayAll() throws Exception {
		return PartManager.office(partInfo()).getOfficeArrayAll();
	}

	/**
	 * ƏR[h擾(p\̂)(M_KAISYA)
	 * @return ƏR[hXg
	 * @throws Exception
	 */
	protected String[][] getOfficeArray() throws Exception {
		return PartManager.office(partInfo()).getOfficeArray();
	}

	/**
	 * ƏR[h擾î݁j(M_KAISYA)
	 * @param kCode 擾ΏێЈR[h
	 * @return ƏR[h
	 * @throws Exception
	 */
	protected String getBelongOfficeCode(String kCode) throws Exception {
		return PartManager.office(partInfo()).getBelongOfficeCode(kCode);
	}

	/**
	 * 擾(M_SYOZOKU)
	 * @param sCode 擾ΏۏR[h
	 * @return (MSyozokuDto)
	 * @throws Exception 
	 */
	protected MSyozokuDto getSectionInfo(
			String sCode
	) throws Exception {
		return PartManager.section(partInfo()).getSectionInfo(sCode);
	}

	/**
	 * 擾(M_SYOZOKU)
	 * @param sCode 擾ΏۏR[h
	 * @return 
	 * @throws Exception 
	 */
	protected String getSectionName(
			String sCode
	) throws Exception {
		return PartManager.section(partInfo()).getSectionName(sCode);
	}

	/**
	 * R[h擾
	 * @param kCode 擾ΏێЈR[h
	 * @return R[h
	 * @throws Exception
	 */
	protected String getBelongSectionCode(
			String kCode
	) throws Exception {
		return PartManager.section(partInfo()).getBelongSectionCode(kCode);
	}

	/**
	 * R[h擾(M_SYOZOKU)
	 * @return R[hXg
	 * @throws Exception 
	 */
	protected String[][] getSectionArrayAll() throws Exception {
		return PartManager.section(partInfo()).getSectionArrayAll();
	}

	/**
	 * R[h擾(p\ĉ)(M_SYOZOKU)
	 * @return R[hXg
	 * @throws Exception
	 */
	protected String[][] getSectionArrayForManager() throws Exception {
		return PartManager.section(partInfo()).getSectionArrayForManager();
	}

	/**
	 * R[h擾(p\cɂω)(M_SYOZOKU)
	 * @return R[hXg
	 * @throws Exception
	 */
	protected String[][] getSectionArrayForHuman() throws Exception {
		return PartManager.section(partInfo()).getSectionArrayForHuman();
	}

	/**
	 * R[h擾(͈͂ɂω)(M_SYOZOKU)
	 * @return R[hXg
	 * @throws Exception
	 */
	protected String[][] getSectionScopeArrayForPayroll() throws Exception {
		return PartManager.section(partInfo()).getSectionScopeArrayForPayroll();
	}

	/**
	 * Xg擾(M_SYOZOKU)
	 * @return R[hXg
	 * @throws Exception
	 */
	protected Map<String, MSyozokuDto> getSectionMap() throws Exception {
		return PartManager.section(partInfo()).getSectionMap();
	}

	/**
	 * Ζ`ԃR[h擾(CM_WORKTYPE)
	 * @return Ζ`ԃR[hXg
	 * @throws Exception 
	 */
	protected String[][] getWorkTypeArrayNotDeleted() throws Exception {
		return PartManager.worktype(partInfo()).getWorkTypeArrayNotDeleted();
	}

	/**
	 * Ζ`ԃR[h擾(CM_WORKTYPE)iTxtj
	 * @return Ζ`ԃR[hXg
	 * @throws Exception 
	 */
	protected String[][] getWorkTypeArrayWithWeekHoliday() throws Exception {
		return PartManager.worktype(partInfo()).getWorkTypeArrayWithWeekHoliday();
	}

	/**
	 * Ζ`ԃR[h擾(CM_WORKTYPE)
	 * @return Ζ`ԃR[hXg
	 * @throws Exception 
	 */
	protected String[][] getWorkTypeArrayAll() throws Exception {
		return PartManager.worktype(partInfo()).getWorkTypeArrayAll();
	}

	/**
	 * Ζ`ԃR[h擾(CM_WORKTYPE)
	 * @return Ζ`ԃR[hXg
	 * @throws Exception 
	 */
	protected String[][] getWorkTypeArrayAllWithWeekHoliday() throws Exception {
		return PartManager.worktype(partInfo()).getWorkTypeArrayAllWithWeekHoliday();
	}

	/**
	 * Ζ`ԏ擾(CM_WORKTYPE)
	 * @return Ζ`ԃR[hXg
	 * @throws Exception 
	 */
	protected String[][] getWorkTypeDataArray() throws Exception {
		return PartManager.worktype(partInfo()).getWorkTypeDataArray();
	}

	/**
	 * Ζ`ԃXg擾(CM_WORKTYPE)
	 * @return Ζ`ԃXg
	 * @throws Exception 
	 */
	protected Map<String, MWorkTypeDto> getWorkTypeMap() throws Exception {
		return PartManager.worktype(partInfo()).getWorkTypeMap();
	}

	/**
	 * ER[h擾(M_YAKUSYOKU)
	 * @return ER[hXg
	 * @throws Exception 
	 */
	protected String[][] getPositionArrayAll() throws Exception {
		return PartManager.position(partInfo()).getPositionArrayAll();
	}

	/**
	 * ER[h擾(L̂)(M_YAKUSYOKU)
	 * @return ER[hXg
	 * @throws Exception 
	 */
	protected String[][] getPositionArray() throws Exception {
		return PartManager.position(partInfo()).getPositionArray();
	}

	/**
	 * ER[h擾(̂)(M_YAKUSYOKU)
	 * @return ER[hXg
	 * @throws Exception 
	 */
	protected String[][] getPositionTitleArray() throws Exception {
		return PartManager.position(partInfo()).getPositionTitleArray();
	}

	/**
	 * ER[h擾(v_Ep)(M_YAKUSYOKU)
	 * @return ER[hXg
	 * @throws Exception 
	 */
	protected String[][] getPositionPltArray() throws Exception {
		return PartManager.position(partInfo()).getPositionPltArray();
	}

	/**
	 * EXg擾(M_YAKUSYOKU)
	 * @return EXg
	 * @throws Exception 
	 */
	protected Map<String, MYakusyokuDto> getPositionMap() throws Exception {
		return PartManager.position(partInfo()).getPositionMap();
	}

	/**
	 * E擾(M_YAKUSYOKU)
	 * @param kcode		ΏێЈR[h
	 * @return dto		ΏێЈE
	 * @throws Exception 
	 */
	protected MYakusyokuDto getHoldingPositionInfo(
			String kCode
	) throws Exception {
		return PartManager.position(partInfo()).getHoldingPositionInfo(kCode);
	}

	/**
	 * E̎擾(t)
	 * @param kCode		ΏێЈR[h
	 * @return	ΏێЈE
	 * @throws Exception 
	 */
	protected String getPositionName(String kCode) throws Exception {
		return PartManager.position(partInfo()).getPositionName(kCode);
	}

	/**
	 * ΑӒ擾
	 * @return	Date	Ώ۔N
	 * @throws Exception
	 */
	protected Date getCalcMonth() throws Exception {
		return PartManager.calculate(partInfo()).getCalcMonth();
	}

	/**
	 * ΑӌvZ擾
	 * @return yyyymm vZN
	 * @throws Exception
	 */
	protected Date getCalcAttendance() throws Exception {
		return PartManager.calculate(partInfo()).getCalcAttendance();
	}

	/**
	 * WvJn擾
	 * @param targetMonth Ώی
	 * @return WvJn
	 * @throws Exception
	 */
	protected Date getStartDate(Date targetMonth) throws Exception {
		return PartManager.calculate(partInfo()).getStartDate(targetMonth);
	}

	/**
	 * WvI擾
	 * @param targetMonth Ώی
	 * @return WvI
	 * @throws Exception
	 */
	protected Date getEndDate(Date targetMonth) throws Exception {
		return PartManager.calculate(partInfo()).getEndDate(targetMonth);
	}

	/**
	 * Wv擾
	 * @param targetDate Ώۓ
	 * @return Wv
	 * @throws Exception
	 */
	protected Date getCurrentDate(Date targetDate) throws Exception {
		return PartManager.calculate(partInfo()).getCurrentDate(targetDate);
	}

	/**
	 * ^xΏ۔N擾
	 * @param targetDate Ώۓ
	 * @return	iΑӏWvji^xj
	 * @throws Exception
	 */
	protected Date getCalcPayment(Date targetDate) throws Exception {
		return PartManager.calculate(partInfo()).getCalcPayment(targetDate);
	}

	/**
	 * ^x擾
	 * @return	Date	Ώ۔N
	 * @throws Exception
	 */
	protected Date getCalcPayment() throws Exception {
		return PartManager.calculate(partInfo()).getCalcPayment();
	}

	/**
	 * \pJnN
	 * <p>2009/01/20	m.yoshida	ǉ</p>
	 * @param targetDate	Ώ۔N	
	 * @return \pJnN
	 * @throws Exception
	 */
	protected Date getStartDateForList(Date targetDate) throws Exception {
		return PartManager.calculate(partInfo()).getStartDateForList(targetDate);
	}

	/**
	 * \pIN
	 * <p>2009/01/20	m.yoshida	ǉ</p>
	 * @param targetDate	Ώ۔N
	 * @return \pJnN
	 * @throws Exception
	 */
	protected Date getEndDateForList(Date targetDate) throws Exception {
		return PartManager.calculate(partInfo()).getEndDateForList(targetDate);
	}

	/**
	 * L[l擾(L[)
	 * @param keyIndex L[CfbNX
	 * @return L[l
	 */
	protected String getKeyValue(int keyIndex) {
		return VariousPart.getKeyValue(key2, keyIndex);
	}

	/**
	 * ԍ擾()
	 * @param date1 It
	 * @param date2 Jnt
	 * @return ԍ(date1 - date2)
	 * @throws Exception
	 */
	protected long getTimeRemainder(Date date1, Date date2) {
		return VariousPart.getTimeRemainder(date1, date2);
	}

	/**
	 * r擾
	 * @param exclusiveType r敪
	 * @param userId        Ώۃ[U[ID
	 * @return ҏW҃R[h(ҏW҂ȂA܂͎̏ꍇnull)
	 * ServletContext𗘗p邽߁AJVMł͕̓ۏႵȂB
	 */
	@SuppressWarnings("unchecked")
	protected String getExclusive(int exclusiveType, String userId) {
		listExclusive = (List<ExclusiveVo>)ctx.getAttribute(CommonConst.ATT_EXCLUSIVE);
		ExclusiveVo exclusiveVo;
		if (listExclusive == null) {
			return null;
		}
		for (int i = listExclusive.size() - 1; i >= 0; i--) {
			exclusiveVo = (ExclusiveVo)listExclusive.get(i);
			if (exclusiveVo.getExclusiveType() == exclusiveType) {
				if (exclusiveVo.getUserId().equals(userId)) {
					// ̔rf[^폜
					listExclusive.remove(i);
					continue;
				}
				return exclusiveVo.getUserId();
			}
		}
		return null;
	}

	/**
	 * rݒ
	 * @param exclusiveType r敪
	 * @param userId        Ώۃ[U[ID
	 * @param target        ҏWΏ
	 * @return ҏW҃R[h(ҏW҂ȂA܂͎̏ꍇnull)
	 * ServletContext𗘗p邽߁AJVMł͕̓ۏႵȂB
	 */
	@SuppressWarnings("unchecked")
	protected String setExclusive(int exclusiveType, String userId, String target) {
		listExclusive = (List<ExclusiveVo>)ctx.getAttribute(CommonConst.ATT_EXCLUSIVE);
		ExclusiveVo exclusiveVo;
		String editor = null;
		if (listExclusive == null) {
			listExclusive = new ArrayList<ExclusiveVo>();
			ctx.setAttribute(CommonConst.ATT_EXCLUSIVE, listExclusive);
		}
		deleteExclusive(userId);
		for (int i = listExclusive.size() - 1; i >= 0; i--) {
			exclusiveVo = (ExclusiveVo)listExclusive.get(i);
			if (exclusiveVo.getExclusiveType() == exclusiveType && exclusiveVo.getTarget().equals(target)) {
				editor = exclusiveVo.getUserId();
			}
		}
		addList(listExclusive, new ExclusiveVo(exclusiveType, userId, target));
		return editor;
	}

	/**
	 * r폜
	 * @param userId Ώۃ[U[ID
	 * ServletContext𗘗p邽߁AJVMł͕̓ۏႵȂB
	 */
	@SuppressWarnings("unchecked")
	protected void deleteExclusive(String userId) {
		listExclusive = (List<ExclusiveVo>)ctx.getAttribute(CommonConst.ATT_EXCLUSIVE);
		ExclusiveVo exclusiveVo;
		if (listExclusive == null) {
			return;
		}
		for (int i = listExclusive.size() - 1; i >= 0; i--) {
			exclusiveVo = (ExclusiveVo)listExclusive.get(i);
			if (getTimeRemainder(new Date(), exclusiveVo.getDate()) * 60 > Integer.parseInt(cfg.getProperty(MospConst.PPT_APP_INTERVAL))) {
				// ZbVێԈȏoĂrf[^폜
				listExclusive.remove(i);
			} else if (exclusiveVo.getUserId().equals(userId)) {
				// ̔rf[^폜
				listExclusive.remove(i);
			}
		}
	}

	/**
	 * t@C쐬
	 * @param upfile
	 * @return file
	 * @throws Exception
	 */
	protected File getUploadFile(FileItem upfile) throws Exception {
		// It@C擾
		File file = new File(upfile.getFieldName());
		// t@Cւ̏o
		upfile.write(file);
		return file;
	}

	/**
	 * t@C쐬(CSV)
	 * @param filCsv
	 * @return CSVt@Ce
	 * @throws Exception
	 */
	protected File getCSVFileData(FileItem filCsv) throws Exception {
		// It@C擾
		File csvData = new File(filCsv.getFieldName());
		// t@Cւ̏o
		filCsv.write(csvData);
		return csvData;
	}

	/**
	 * CSVf[^p[X
	 * @param filCsv
	 * @return CSVt@Ce
	 * @throws Exception
	 */
	protected CSVParser parseCSVData(File filCsv) throws Exception {
		br = new BufferedReader(new InputStreamReader(
				new FileInputStream(filCsv), Charset.forName("JISAutoDetect"))
		);
		CSVParser csvParseData = new CSVParser(br);
		return csvParseData;
	}

	/**
	 * CSVwb_[쐬
	 * @param csvtarget
	 * @return wb_z
	 * @throws MospException
	 */
	protected String[] getCSVHeadData(CSVParser csvtarget) throws MospException {
		String[] line;
		try {
			line = csvtarget.getLine();
		} catch (IOException e) {
			// `G[
			String errMessage = MospUtility.getMessage(msg, CommonConst.MSG_INVALID_HEAD_TYPE,"");
			addErrMessage(errMessage);
			throw new MospException(MospConst.EX_PARAMS_INVALID);
		}
		return line;
	}

	/**
	 * CSVf[^쐬
	 * @param csvtarget
	 * @param idx
	 * @return@f[^z
	 * @throws MospException
	 */
	protected String[] getCSVData(CSVParser csvtarget, int idx) throws MospException {
		String[] line;
		try {
			line = csvtarget.getLine();
		} catch (IOException e) {
			// `G[
			String errMessage = MospUtility.getMessage(msg, CommonConst.MSG_INVALID_DATA_TYPE,String.valueOf(idx + 1));
			addErrMessage(errMessage);
			throw new MospException(MospConst.EX_PARAMS_INVALID);
		}
		return line;
	}

	/**
	 * f[^݊mF
	 * @param dto mFΏDTO
	 * @return boolean	ΏDTOݗL
	 * @throws MospException
	 */
	protected boolean chkExistDto(BaseDto dto) {
		return VariousPart.chkExistDto(dto);
	}

	/**
	 * f[^݊mF
	 * @param obj mFΏObject
	 * @return boolean	ΏObjectݗL
	 * @throws MospException
	 */
	protected boolean chkExistObject(Object obj) {
		return VariousPart.chkExistObject(obj);
	}

	/**
	 * jݒ
	 * @param dayOfWeek j
	 * @return j
	 */
	protected String getDayOfWeek(int dayOfWeek) {
		return VariousPart.getDayOfWeek(dayOfWeek);
	}

	/**
	 * ԃtH[}bg
	 * @param hour 
	 * @return ()
	 */
	protected String getHourString(double hour) {
		return VariousPart.getHourString(hour);
	}

	/**
	 * LJz
	 * @return	String[]	LJz
	 * <p>
	 * [0]...JzA
	 * [1]...JzA
	 * [2]...Jz敪
	 * </p>
	 * @throws Exception 
	 */
	protected String[] getPaidHolidayInfo() throws Exception {
		return PartManager.mospcode(partInfo()).getPaidHolidayInfo();
	}

	/**
	 * LxɎx
	 * @return [0]cΑNA[1]cx
	 * @throws Exception 
	 */
	protected String[][] getPaidHolidayArray() throws Exception {
		return PartManager.mospcode(partInfo()).getPaidHolidayArray();
	}

	/**
	 * o͔͈̓v_EXg
	 * @return	String[][]	o͔͈͔z
	 */
	protected String[][] getOutputScopeArray() {
		return VariousPart.getOutputScopeArray();
	}

	/**
	 * ΑӏF@\󋵎擾(M_CODE)
	 * @return	boolean 	ΑӏF@\̗L
	 * @throws Exception 
	 */
	protected boolean isAttendanceApprovalFunction() throws Exception {
		return PartManager.mospcode(partInfo()).isAttendanceApprovalFunction();
	}

	/**
	 * pX[hL
	 * @return	int		pX[hL
	 * @throws Exception
	 */
	protected int getPasswordTerm() throws Exception {
		return PartManager.mospcode(partInfo()).getPasswordTerm();
	}

	/**
	 * tB[h̓̃f[^擾
	 *  0 : t@CID
	 *  1 : Ǘԍ
	 *  2 : tB[hID
	 *  3 : tB[h
	 */
	protected String getEFnameItem(String csvString, int i) {
		return VariousPart.getEFnameItem(csvString, i);
	}

	/**
	 * YtOz
	 * @return YtOz
	 */
	protected String[][] getCorrespondFlagArray() {
		return VariousPart.getCorrespondFlagArray();
	}

	/**
	 * az
	 * @return	az
	 * @throws Exception
	 */
	protected String[][] getJPCalendarGengo() throws Exception {
		return PartManager.cmcode(partInfo()).getJPCalendarGengo();
	}

	/**
	 * E蓖敪v_EXgiL{^Pj
	 * @return E蓖敪z
	 */
	protected String[][] getPositionAllowanceType1() {
		return VariousPart.getPositionAllowanceType1();
	}

	/**
	 * E蓖敪v_EXgiL{ŒPj
	 * @return E蓖敪z
	 */
	protected String[][] getPositionAllowanceType2() {
		return VariousPart.getPositionAllowanceType2();
	}

	/**
	 * E蓖敪v_EXgiL{^P{ŒPj
	 * @return E蓖敪z
	 */
	protected String[][] getPositionAllowanceType3() {
		return VariousPart.getPositionAllowanceType3();
	}

	/**
	 * DTOꐫ`FbN
	 * @param formerDto		ΏDTO
	 * @param currentDto	ΏDTO
	 * @return
	 * <p>
	 * XV̏ꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws MospException 
	 */
	protected boolean chkIdentityDto(BaseDto formerDto, BaseDto currentDto) throws MospException {
		return VariousPart.chkIdentityDto(formerDto, currentDto);
	}

	/**
	 * Ώ۔NΏ۔Nx擾
	 * @param year		Ώ۔N
	 * @param month		Ώی
	 * @param startmonth	NxJn
	 * @return	Ώ۔Nx
	 * @throws Exception
	 */
	protected int getTargetFiscalYear(int year, int month, int startmonth) throws Exception {
		return VariousPart.getTargetFiscalYear(year, month, startmonth);
	}

	/**
	 * Ώ۔NxΏ۔N擾
	 * @param fiscalyear		Ώ۔Nx
	 * @param month				Ώی
	 * @param startmonth		NxJn
	 * @return	Ώ۔N
	 */
	protected int getTargetYear(int fiscalyear, int month, int startmonth) {
		return VariousPart.getTargetYear(fiscalyear, month, startmonth);
	}

	/**
	 * Ώ۔NxJn擾
	 * @param year		Ώ۔Nx
	 * @return Ώ۔NxJn
	 */
	protected Date getFiscalStartDate(int fiscalyear, int startMonth) throws Exception {
		return DatePart.getFiscalStartDate(fiscalyear, startMonth);
	}

	/**
	 * Ώ۔NxI擾
	 * @param year		Ώ۔Nx
	 * @return Ώ۔NxI
	 */
	protected Date getFiscalEndDate(int fiscalyear, int startMonth) throws Exception {
		return DatePart.getFiscalEndDate(fiscalyear, startMonth);
	}

	/**
	 * a\ݒ
	 * @param targetDate	Ώ۔N
	 * @return	a\
	 * @throws MospException
	 * @throws Exception
	 */
	protected String getJapaneseDate(Date targetDate) throws MospException, Exception {
		return PartManager.jpdate(partInfo()).getJapaneseDate(targetDate);
	}

	/**
	 * a\ݒ
	 * @param targetDate	Ώ۔N(yyyy-mm-dd)
	 * @return	a\
	 * @throws MospException
	 * @throws Exception
	 */
	protected String getJapaneseDate(String targetDate) throws MospException, Exception {
		return PartManager.jpdate(partInfo()).getJapaneseDate(DatePart.convHyphenDateToDate(targetDate));
	}

	/**
	 * FXe[^XR[hXg擾
	 * @return FXe[^XR[hXgz
	 * @see VariousPart#getApprovalStatusCodeArray()
	 */
	protected String[] getApprovalStatusCodeArray() {
		return VariousPart.getApprovalStatusCodeArray();
	}

	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getConnection()
	 */
	protected void getConnection() throws ClassNotFoundException, SQLException {
		boolean isDefault = true;
		// DataSourcepł邩f
		if (canUseDataSource()) {
			try {
				getConnection(cfg.getProperty(MospConst.PPT_ASP_DSOURCE));
			} catch (Exception e) {
				// G[Oɏo͂B
				LogUtility.log(cfg, "", "", cmd, 5, MospConst.LOG_MOSPERR, MospConst.LOG_MSG_5003);
			} finally {
				if (conn != null) {
					isDefault = false;
				} else {
					// ݒ肪G[̏ꍇAftHg̐ڑ𗘗pB
					cfg.setProperty(CommonConst.PPT_USE_DATA_SOURCE, String.valueOf(false));
				}
			}
		}
		if (isDefault) {
			super.getConnection();
		}
	}

	/**
	 * DataSourcep۔f
	 * @return
	 * <p>
	 * DataSourcepłꍇtrueAłȂꍇfalse<br>
	 * xfAcfgɃZbg񂩂炻𗘗pB
	 * </p>
	 */
	protected boolean canUseDataSource() {
		// ݒt@C̃vpeB擾
		String pptDataSource = cfg.getProperty(CommonConst.PPT_USE_DATA_SOURCE);
		if (pptDataSource == null) {
			// vpeBɖꍇAݒ肷B
			boolean dsourceFlag = false;
			if (DataSourceUtility.canUseDataSource(cfg.getProperty(MospConst.PPT_ASP_DSOURCE))) {
				dsourceFlag = true;
				LogUtility.log(cfg, "", "", "", 4, MospConst.LOG_MOSPINF, DataSourceUtility.USE_DATA_SOURCE_MESSAGE);
			}
			cfg.setProperty(CommonConst.PPT_USE_DATA_SOURCE, String.valueOf(dsourceFlag));
			pptDataSource = String.valueOf(dsourceFlag);
		}
		return Boolean.valueOf(pptDataSource);
	}

	/**
	 * R}h擾B<br>
	 * @param invalidProcSeq V[PXstO
	 * @return R}h
	 */
	@Override
	protected String getIndexCommand(boolean invalidProcSeq) {
		try {
			// ASP[U[擾(ݒt@CASPݒŔf)
			switch (MospUtility.getAspFlag(cfg)) {
			case 0:
			case 1:
				// 0FASP(x[U[:1Av)
				// 1FASP(1[U[:1Av)
				return "C3011";
			case 2:
				// 2FASP
				return MospConst.CMD_INDEX;
			default:
				return MospConst.CMD_INDEX;
			}
		} catch (MospException e) {
			return MospConst.CMD_INDEX;
		}
	}

	/*
	 * ȉAIvV֘Ã\bh
	 */	

	/**
	 * OptionConst擾
	 * @return	OptionConst̃NXIuWFNg
	 * @throws ClassNotFoundException
	 */
	protected Class getOptionConstClass() throws ClassNotFoundException {
		return Class.forName(CommonConst.OPTION_CONST_FULLNAME);
	}

	/**
	 * IvV@\L
	 * <p>2008/12/10	m.yoshida	ǉ</p>
	 * @return useOption
	 * <p>
	 * IvV@\𗘗p邱ƂłꍇtrueA<br>
	 * łȂꍇfalse
	 * </p>
	 */
	protected boolean canUseOptionPackage() {
		// ݒt@C̃vpeB擾
		try {
			if (cfg.getProperty(CommonConst.PPT_USE_OPTION) == null) {
				// OptionConstNX݂邩mF
				Class cls = getOptionConstClass();
				// vpeBɖꍇAݒ肷B
				if (cls != null) {
					cfg.setProperty(CommonConst.PPT_USE_OPTION, String.valueOf(true));
				}
			}
		} catch (ClassNotFoundException e) {
			cfg.setProperty(CommonConst.PPT_USE_OPTION, String.valueOf(false));
		}
		return Boolean.valueOf(cfg.getProperty(CommonConst.PPT_USE_OPTION));
	}

	/**
	 * {R[hz擾
	 * @return	{R[hz
	 * <p>
	 * [0]c
	 * [1]cI𕔏
	 * [2]cS
	 * </p>
	 */
	protected int[] getManageCode() {
		return VariousPart.getManageCode();
	}

	/**
	 * {v_EXg
	 * @return	String[][]	o͔͈͔z
	 */
	protected String[][] getManageArray() {
		return VariousPart.getManageArray();
	}

	// ANZT\bh
	protected void setNeedExclusive(boolean needExclusive) { this.needExclusive = needExclusive; }

	/*Part֘A*/

	/**
	 * ςPartNXCX^X擾
	 * @param partClassName		ΏPartNX
	 * @return	ΏۏςPartNXCX^X
	 * @throws Exception
	 */
	protected BasePart getPart(String partClassName) throws Exception {
		return PartManager.getPreparedPart(partClassName, partInfo());
	}

}
