--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;
SET default_tablespace = '';
SET default_with_oids = false;


DROP TABLE IF EXISTS am_route;
CREATE TABLE am_route (
    rtcode character varying(10) NOT NULL,
    layer1 character varying(10) NOT NULL,
    layer2 character varying(10) NOT NULL,
    layer3 character varying(10) NOT NULL,
    layer4 character varying(10) NOT NULL,
    layer5 character varying(10) NOT NULL,
    lastlayer character varying(10) NOT NULL,
    deleteflag integer DEFAULT 0 NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) NOT NULL
);

COMMENT ON TABLE am_route IS '承認ルートマスタ';
COMMENT ON COLUMN am_route.rtcode IS 'ルートコード';
COMMENT ON COLUMN am_route.layer1 IS '１次承認';
COMMENT ON COLUMN am_route.layer2 IS '２次承認';
COMMENT ON COLUMN am_route.layer3 IS '３次承認';
COMMENT ON COLUMN am_route.layer4 IS '４次承認';
COMMENT ON COLUMN am_route.layer5 IS '５次承認';
COMMENT ON COLUMN am_route.lastlayer IS '最終承認';
COMMENT ON COLUMN am_route.deleteflag IS '削除フラグ';
COMMENT ON COLUMN am_route.adddt IS '登録日';
COMMENT ON COLUMN am_route.addcd IS '登録者';
COMMENT ON COLUMN am_route.upddt IS '更新日';
COMMENT ON COLUMN am_route.updcd IS '更新者';

ALTER TABLE ONLY am_route
    ADD CONSTRAINT am_route_pkey PRIMARY KEY (rtcode);

DROP TABLE IF EXISTS am_unit;
CREATE TABLE am_unit (
    unitcode character varying(10) NOT NULL,
    startdate date NOT NULL,
    main character varying(10) NOT NULL,
    agent character varying(10) NOT NULL,
    deleteflag integer DEFAULT 0 NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) NOT NULL
);

COMMENT ON TABLE am_unit IS '承認ユニットマスタ';
COMMENT ON COLUMN am_unit.unitcode IS 'ユニットコード';
COMMENT ON COLUMN am_unit.startdate IS '権限開始日';
COMMENT ON COLUMN am_unit.main IS '承認者';
COMMENT ON COLUMN am_unit.agent IS '代理';
COMMENT ON COLUMN am_unit.deleteflag IS '削除フラグ';
COMMENT ON COLUMN am_unit.adddt IS '登録日';
COMMENT ON COLUMN am_unit.addcd IS '登録者';
COMMENT ON COLUMN am_unit.upddt IS '更新日';
COMMENT ON COLUMN am_unit.updcd IS '更新者';

ALTER TABLE ONLY am_unit
    ADD CONSTRAINT am_unit_pkey PRIMARY KEY (unitcode, startdate);
--

DROP TABLE IF EXISTS cm_authority;
CREATE TABLE cm_authority (
    authcode character varying(2) NOT NULL,
    authname character varying(10) NOT NULL,
    employee character varying(10) NOT NULL,
    manager character varying(10) NOT NULL,
    payroll character varying(10) NOT NULL,
    human character varying(10) NOT NULL,
    insurance character varying(10) NOT NULL,
    bonus character varying(10) NOT NULL,
    adjustment character varying(10) NOT NULL,
    expense character varying(10) NOT NULL,
    service1 character varying(10) NOT NULL,
    service2 character varying(10) NOT NULL,
    service3 character varying(10) NOT NULL,
    service4 character varying(10) NOT NULL,
    service5 character varying(10) NOT NULL,
    deleteflag integer DEFAULT 0 NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) NOT NULL,
    CONSTRAINT cm_authority_deleteflag_check CHECK ((deleteflag >= 0))
);

COMMENT ON TABLE cm_authority IS '権限マスタ';
COMMENT ON COLUMN cm_authority.authcode IS '権限コード';
COMMENT ON COLUMN cm_authority.authname IS '権限ネーム';
COMMENT ON COLUMN cm_authority.employee IS '従業員メニュー';
COMMENT ON COLUMN cm_authority.manager IS 'マネージャーメニュー';
COMMENT ON COLUMN cm_authority.payroll IS '給与メニュー';
COMMENT ON COLUMN cm_authority.human IS '人事メニュー';
COMMENT ON COLUMN cm_authority.insurance IS '社会保険メニュー';
COMMENT ON COLUMN cm_authority.bonus IS '賞与メニュー';
COMMENT ON COLUMN cm_authority.adjustment IS '年末調整メニュー';
COMMENT ON COLUMN cm_authority.expense IS '経費メニュー';
COMMENT ON COLUMN cm_authority.service1 IS 'サービス１メニュー';
COMMENT ON COLUMN cm_authority.service2 IS 'サービス２メニュー';
COMMENT ON COLUMN cm_authority.service3 IS 'サービス３メニュー';
COMMENT ON COLUMN cm_authority.service4 IS 'サービス４メニュー';
COMMENT ON COLUMN cm_authority.service5 IS 'サービス５メニュー';
COMMENT ON COLUMN cm_authority.deleteflag IS '削除フラグ';
COMMENT ON COLUMN cm_authority.adddt IS '登録日';
COMMENT ON COLUMN cm_authority.addcd IS '登録者';
COMMENT ON COLUMN cm_authority.upddt IS '更新日';
COMMENT ON COLUMN cm_authority.updcd IS '更新者';

ALTER TABLE ONLY cm_authority
    ADD CONSTRAINT cm_authority_pkey PRIMARY KEY (authcode);

DROP TABLE IF EXISTS cm_code;
CREATE TABLE cm_code (
    t_id character varying(10) DEFAULT ''::character varying NOT NULL,
    t_code character varying(8) DEFAULT ''::character varying NOT NULL,
    t_name character varying(16) DEFAULT ''::character varying NOT NULL,
    view_index integer DEFAULT 0 NOT NULL,
    delete_flag integer DEFAULT 0 NOT NULL,
    insert_date timestamp without time zone DEFAULT '1971-01-01 00:00:00'::timestamp without time zone NOT NULL,
    insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
    update_date timestamp without time zone DEFAULT '1971-01-01 00:00:00'::timestamp without time zone NOT NULL,
    update_user character varying(10) DEFAULT ''::character varying NOT NULL
);

COMMENT ON TABLE cm_code IS 'コードマスタ';
COMMENT ON COLUMN cm_code.t_id IS 'コード区分';
COMMENT ON COLUMN cm_code.t_code IS 'コード';
COMMENT ON COLUMN cm_code.t_name IS 'コード名称';
COMMENT ON COLUMN cm_code.view_index IS '勤怠表示順';
COMMENT ON COLUMN cm_code.delete_flag IS '削除フラグ';
COMMENT ON COLUMN cm_code.insert_date IS '作成日';
COMMENT ON COLUMN cm_code.insert_user IS '作成者';
COMMENT ON COLUMN cm_code.update_date IS '更新日';
COMMENT ON COLUMN cm_code.update_user IS '更新者';

ALTER TABLE ONLY cm_code
    ADD CONSTRAINT cm_code_pkey PRIMARY KEY (t_id, t_code);

DROP TABLE IF EXISTS cm_component;
CREATE TABLE cm_component (
    compcode character varying(10) NOT NULL,
    division character varying(10) NOT NULL,
    compname character varying(10) NOT NULL,
    component text NOT NULL,
    manage integer DEFAULT 0 NOT NULL,
    deleteflag integer DEFAULT 0 NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) NOT NULL,
    CONSTRAINT cm_component_deleteflag_check CHECK ((deleteflag >= 0)),
    CONSTRAINT cm_component_manage_check CHECK ((manage >= 0))
);

COMMENT ON TABLE cm_component IS 'メニューコマンドマスタ';
COMMENT ON COLUMN cm_component.compcode IS 'コマンドユニットコード';
COMMENT ON COLUMN cm_component.division IS '分類';
COMMENT ON COLUMN cm_component.compname IS 'コマンドユニットネーム';
COMMENT ON COLUMN cm_component.component IS 'コマンド';
COMMENT ON COLUMN cm_component.manage IS '利用範囲';
COMMENT ON COLUMN cm_component.deleteflag IS '削除フラグ';
COMMENT ON COLUMN cm_component.adddt IS '登録日';
COMMENT ON COLUMN cm_component.addcd IS '登録者';
COMMENT ON COLUMN cm_component.upddt IS '更新日';
COMMENT ON COLUMN cm_component.updcd IS '更新者';

ALTER TABLE ONLY cm_component
    ADD CONSTRAINT cm_component_pkey PRIMARY KEY (compcode);

DROP TABLE IF EXISTS cm_conf;
CREATE TABLE cm_conf (
    conf_id character varying(8) DEFAULT ''::character varying NOT NULL,
    conf_code character varying(8) DEFAULT ''::character varying NOT NULL,
    conf_value character varying(8) DEFAULT ''::character varying NOT NULL,
    update_date timestamp without time zone DEFAULT '1970-12-30 21:00:00'::timestamp without time zone NOT NULL,
    update_user character varying(10) DEFAULT ''::character varying NOT NULL
);

COMMENT ON TABLE cm_conf IS '設定マスタ';
COMMENT ON COLUMN cm_conf.conf_id IS '設定区分';
COMMENT ON COLUMN cm_conf.conf_code IS '設定コード';
COMMENT ON COLUMN cm_conf.conf_value IS '設定値';
COMMENT ON COLUMN cm_conf.update_date IS '更新日';
COMMENT ON COLUMN cm_conf.update_user IS '更新者';

ALTER TABLE ONLY cm_conf
    ADD CONSTRAINT cm_conf_pkey PRIMARY KEY (conf_id, conf_code);

DROP TABLE IF EXISTS cm_menu;
CREATE TABLE cm_menu (
    authority character varying(2) DEFAULT ''::character varying NOT NULL,
    menu_id character varying(8) DEFAULT ''::character varying NOT NULL,
    update_date timestamp without time zone DEFAULT '1971-01-01 00:00:00'::timestamp without time zone NOT NULL,
    update_user character varying(10) DEFAULT ''::character varying NOT NULL
);

COMMENT ON TABLE cm_menu IS 'メニュー管理';
COMMENT ON COLUMN cm_menu.authority IS '権限';
COMMENT ON COLUMN cm_menu.menu_id IS 'メニューID';
COMMENT ON COLUMN cm_menu.update_date IS '更新日';
COMMENT ON COLUMN cm_menu.update_user IS '更新者';

ALTER TABLE ONLY cm_menu
    ADD CONSTRAINT cm_menu_pkey PRIMARY KEY (authority, menu_id);

DROP TABLE IF EXISTS cm_output;
CREATE TABLE cm_output (
    id integer DEFAULT 0 NOT NULL,
    code character varying(10) NOT NULL,
    name character varying(100) NOT NULL,
    scope character varying(10) NOT NULL,
    item character varying(500) NOT NULL,
    viewindex integer DEFAULT 0 NOT NULL,
    deleteflag integer DEFAULT 0 NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) NOT NULL,
    CONSTRAINT cm_output_deleteflag_check CHECK ((deleteflag >= 0)),
    CONSTRAINT cm_output_id_check CHECK ((id >= 0)),
    CONSTRAINT cm_output_viewindex_check CHECK ((viewindex >= 0))
);

COMMENT ON TABLE cm_output IS 'CSV出力マスタ';
COMMENT ON COLUMN cm_output.id IS 'ID';
COMMENT ON COLUMN cm_output.code IS '出力コマンド番号';
COMMENT ON COLUMN cm_output.name IS 'ボタン表示名称';
COMMENT ON COLUMN cm_output.scope IS '制限範囲';
COMMENT ON COLUMN cm_output.item IS '出力項目';
COMMENT ON COLUMN cm_output.viewindex IS '表示順';
COMMENT ON COLUMN cm_output.deleteflag IS '削除フラグ';
COMMENT ON COLUMN cm_output.adddt IS '登録日';
COMMENT ON COLUMN cm_output.addcd IS '登録者';
COMMENT ON COLUMN cm_output.upddt IS '更新日';
COMMENT ON COLUMN cm_output.updcd IS '更新者';

ALTER TABLE ONLY cm_output
    ADD CONSTRAINT cm_output_pkey PRIMARY KEY (id);

DROP TABLE IF EXISTS cm_rotation;
CREATE TABLE cm_rotation (
    kcode character varying(10) NOT NULL,
    rtcode character varying(10) NOT NULL,
    rtname character varying(100) NOT NULL,
    holidayflag integer DEFAULT 0 NOT NULL,
    day1 character varying(10) NOT NULL,
    day2 character varying(10) NOT NULL,
    day3 character varying(10) NOT NULL,
    day4 character varying(10) NOT NULL,
    day5 character varying(10) NOT NULL,
    day6 character varying(10) NOT NULL,
    day7 character varying(10) NOT NULL,
    day8 character varying(10) NOT NULL,
    day9 character varying(10) NOT NULL,
    day10 character varying(10) NOT NULL,
    deleteflag integer DEFAULT 0 NOT NULL,
    adddt timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
    addcd character varying(10) NOT NULL,
    upddt timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
    updcd character varying(10) NOT NULL
);

COMMENT ON TABLE cm_rotation IS '輪番パターンマスタ';
COMMENT ON COLUMN cm_rotation.kcode IS '社員コード';
COMMENT ON COLUMN cm_rotation.rtcode IS '輪番パターンコード';
COMMENT ON COLUMN cm_rotation.rtname IS '輪番パターン名称';
COMMENT ON COLUMN cm_rotation.holidayflag IS '祝祭日フラグ';
COMMENT ON COLUMN cm_rotation.day1 IS '1日目';
COMMENT ON COLUMN cm_rotation.day2 IS '2日目';
COMMENT ON COLUMN cm_rotation.day3 IS '3日目';
COMMENT ON COLUMN cm_rotation.day4 IS '4日目';
COMMENT ON COLUMN cm_rotation.day5 IS '5日目';
COMMENT ON COLUMN cm_rotation.day6 IS '6日目';
COMMENT ON COLUMN cm_rotation.day7 IS '7日目';
COMMENT ON COLUMN cm_rotation.day8 IS '8日目';
COMMENT ON COLUMN cm_rotation.day9 IS '9日目';
COMMENT ON COLUMN cm_rotation.day10 IS '10日目';
COMMENT ON COLUMN cm_rotation.deleteflag IS '削除フラグ';
COMMENT ON COLUMN cm_rotation.adddt IS '登録日';
COMMENT ON COLUMN cm_rotation.addcd IS '登録者';
COMMENT ON COLUMN cm_rotation.upddt IS '更新日';
COMMENT ON COLUMN cm_rotation.updcd IS '更新者';

ALTER TABLE ONLY cm_rotation
    ADD CONSTRAINT cm_rotation_pkey PRIMARY KEY (kcode, rtcode);

DROP TABLE IF EXISTS cm_user;
CREATE TABLE cm_user (
    user_id character varying(10) DEFAULT ''::character varying NOT NULL,
    password character varying(32) DEFAULT ''::character varying NOT NULL,
    k_code character varying(10) DEFAULT ''::character varying NOT NULL,
    user_name character varying(16) DEFAULT ''::character varying NOT NULL,
    authority character varying(2) DEFAULT ''::character varying NOT NULL,
    data_level integer DEFAULT 0 NOT NULL,
    change_pass date DEFAULT '1971-01-01'::date NOT NULL,
    delete_flag integer DEFAULT 0 NOT NULL,
    insert_date timestamp without time zone DEFAULT '1970-12-29 18:00:00'::timestamp without time zone NOT NULL,
    insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
    update_date timestamp without time zone DEFAULT '1970-12-29 18:00:00'::timestamp without time zone NOT NULL,
    update_user character varying(10) DEFAULT ''::character varying NOT NULL
);

COMMENT ON TABLE cm_user IS 'ユーザーマスタ';
COMMENT ON COLUMN cm_user.user_id IS 'ユーザーID';
COMMENT ON COLUMN cm_user.password IS 'パスワード';
COMMENT ON COLUMN cm_user.k_code IS '社員コード';
COMMENT ON COLUMN cm_user.user_name IS 'ユーザー名';
COMMENT ON COLUMN cm_user.authority IS 'プログラム利用権限';
COMMENT ON COLUMN cm_user.data_level IS 'データ参照レベル';
COMMENT ON COLUMN cm_user.change_pass IS 'パスワード変更日';
COMMENT ON COLUMN cm_user.delete_flag IS '削除フラグ';
COMMENT ON COLUMN cm_user.insert_date IS '作成日';
COMMENT ON COLUMN cm_user.insert_user IS '作成者';
COMMENT ON COLUMN cm_user.update_date IS '更新日';
COMMENT ON COLUMN cm_user.update_user IS '更新者';

ALTER TABLE ONLY cm_user
    ADD CONSTRAINT cm_user_pkey PRIMARY KEY (user_id);

CREATE INDEX cm_user_k_code_idx ON cm_user USING btree (k_code);

DROP TABLE IF EXISTS cm_worktype;
CREATE TABLE cm_worktype (
    shiftcode character varying(10) NOT NULL,
    shiftname character varying(100) NOT NULL,
    starttime integer DEFAULT 0 NOT NULL,
    quittime integer DEFAULT 0 NOT NULL,
    worktime integer DEFAULT 0 NOT NULL,
    breaktime integer DEFAULT 0 NOT NULL,
    overstart integer DEFAULT 0 NOT NULL,
    overbreak integer DEFAULT 0 NOT NULL,
    option1 character varying(100) NOT NULL,
    option2 character varying(100) NOT NULL,
    option3 character varying(100) NOT NULL,
    option4 character varying(100) NOT NULL,
    option5 character varying(100) NOT NULL,
    deleteflag integer DEFAULT 0 NOT NULL,
    adddt timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
    addcd character varying(10) NOT NULL,
    upddt timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
    updcd character varying(10) NOT NULL
);

COMMENT ON TABLE cm_worktype IS '勤務形態マスタ';
COMMENT ON COLUMN cm_worktype.shiftcode IS '勤務形態コード';
COMMENT ON COLUMN cm_worktype.shiftname IS '勤務形態名称';
COMMENT ON COLUMN cm_worktype.starttime IS '出勤時刻';
COMMENT ON COLUMN cm_worktype.quittime IS '退社時刻';
COMMENT ON COLUMN cm_worktype.worktime IS '勤務時間';
COMMENT ON COLUMN cm_worktype.breaktime IS '休憩時間';
COMMENT ON COLUMN cm_worktype.overstart IS '残業開始時間';
COMMENT ON COLUMN cm_worktype.overbreak IS '残業休憩時間';
COMMENT ON COLUMN cm_worktype.option1 IS 'オプション1';
COMMENT ON COLUMN cm_worktype.option2 IS 'オプション2';
COMMENT ON COLUMN cm_worktype.option3 IS 'オプション3';
COMMENT ON COLUMN cm_worktype.option4 IS 'オプション4';
COMMENT ON COLUMN cm_worktype.option5 IS 'オプション5';
COMMENT ON COLUMN cm_worktype.deleteflag IS '削除フラグ';
COMMENT ON COLUMN cm_worktype.adddt IS '登録日';
COMMENT ON COLUMN cm_worktype.addcd IS '登録者';
COMMENT ON COLUMN cm_worktype.upddt IS '更新日';
COMMENT ON COLUMN cm_worktype.updcd IS '更新者';

ALTER TABLE ONLY cm_worktype
    ADD CONSTRAINT cm_worktype_pkey PRIMARY KEY (shiftcode);

DROP TABLE IF EXISTS ct_account;
CREATE TABLE ct_account (
    user_id character varying(10) DEFAULT ''::character varying NOT NULL,
    attempt integer DEFAULT 0 NOT NULL,
    update_date timestamp without time zone DEFAULT '1971-01-01 00:00:00'::timestamp without time zone NOT NULL
);
COMMENT ON TABLE ct_account IS 'アカウント管理';
COMMENT ON COLUMN ct_account.user_id IS 'ユーザーID';
COMMENT ON COLUMN ct_account.attempt IS '試行回数';
COMMENT ON COLUMN ct_account.update_date IS '更新日';

ALTER TABLE ONLY ct_account
    ADD CONSTRAINT ct_account_pkey PRIMARY KEY (user_id);

DROP TABLE IF EXISTS ct_holidayrequest;
CREATE TABLE ct_holidayrequest (
    voucher integer DEFAULT 0 NOT NULL,
    workflow bigint DEFAULT 0::bigint NOT NULL,
    kcode character varying(10) NOT NULL,
    requestdate date NOT NULL,
    reason character varying(10) NOT NULL,
    substitutedate character varying(10) NOT NULL,
    substitutework character varying(10) NOT NULL,
    deleteflag integer DEFAULT 0 NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) NOT NULL,
    CONSTRAINT ct_holidayrequest_voucher_check CHECK ((voucher >= 0)),
    CONSTRAINT ct_holidayrequest_workflow_check CHECK ((workflow >= 0))
);

COMMENT ON TABLE ct_holidayrequest IS '休暇申請テーブル';
COMMENT ON COLUMN ct_holidayrequest.voucher IS '休暇申請伝票番号';
COMMENT ON COLUMN ct_holidayrequest.workflow IS 'ワークフロー番号';
COMMENT ON COLUMN ct_holidayrequest.kcode IS '社員コード';
COMMENT ON COLUMN ct_holidayrequest.requestdate IS '申請日';
COMMENT ON COLUMN ct_holidayrequest.reason IS '申請理由';
COMMENT ON COLUMN ct_holidayrequest.substitutedate IS '充当日';
COMMENT ON COLUMN ct_holidayrequest.substitutework IS '充当勤務形態';
COMMENT ON COLUMN ct_holidayrequest.deleteflag IS '削除フラグ';
COMMENT ON COLUMN ct_holidayrequest.adddt IS '登録日';
COMMENT ON COLUMN ct_holidayrequest.addcd IS '登録者';
COMMENT ON COLUMN ct_holidayrequest.upddt IS '更新日';
COMMENT ON COLUMN ct_holidayrequest.updcd IS '更新者';

ALTER TABLE ONLY ct_holidayrequest
    ADD CONSTRAINT ct_holidayrequest_pkey PRIMARY KEY (voucher);

DROP TABLE IF EXISTS ct_overtime_request;
CREATE TABLE ct_overtime_request (
  voucher integer NOT NULL DEFAULT 0, -- 残業申請伝票番号
  workflow bigint NOT NULL DEFAULT (0)::bigint, -- ワークフロー番号
  kcode character varying(10) NOT NULL, -- 社員コード
  requestdate date NOT NULL, -- 申請日
  workdate date NOT NULL, -- 勤務日
  overtime integer NOT NULL DEFAULT 0, -- 申請時間
  reason text NOT NULL, -- 事由
  deleteflag integer NOT NULL DEFAULT 0, -- 削除フラグ
  adddt timestamp without time zone NOT NULL, -- 登録日
  addcd character varying(10) NOT NULL, -- 登録者
  upddt timestamp without time zone NOT NULL, -- 更新日
  updcd character varying(10) NOT NULL, -- 更新者
  CONSTRAINT ct_overtime_request_pkey PRIMARY KEY (voucher),
  CONSTRAINT ct_overtime_request_voucher_check CHECK (voucher >= 0),
  CONSTRAINT ct_overtime_request_workflow_check CHECK (workflow >= 0)
);

COMMENT ON TABLE ct_overtime_request IS '残業申請テーブル';
COMMENT ON COLUMN ct_overtime_request.voucher IS '残業申請伝票番号';
COMMENT ON COLUMN ct_overtime_request.workflow IS 'ワークフロー番号';
COMMENT ON COLUMN ct_overtime_request.kcode IS '社員コード';
COMMENT ON COLUMN ct_overtime_request.requestdate IS '申請日';
COMMENT ON COLUMN ct_overtime_request.workdate IS '勤務日';
COMMENT ON COLUMN ct_overtime_request.overtime IS '申請時間';
COMMENT ON COLUMN ct_overtime_request.reason IS '事由';
COMMENT ON COLUMN ct_overtime_request.deleteflag IS '削除フラグ';
COMMENT ON COLUMN ct_overtime_request.adddt IS '登録日';
COMMENT ON COLUMN ct_overtime_request.addcd IS '登録者';
COMMENT ON COLUMN ct_overtime_request.upddt IS '更新日';
COMMENT ON COLUMN ct_overtime_request.updcd IS '更新者';

DROP TABLE IF EXISTS ct_workflow;
CREATE TABLE ct_workflow (
    workflow bigint DEFAULT 0::bigint NOT NULL,
    layernumber integer DEFAULT 0 NOT NULL,
    currentstatus character varying(10) NOT NULL,
    rtcode character varying(10) NOT NULL,
    deleteflag integer DEFAULT 0 NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) NOT NULL,
    CONSTRAINT ct_workflow_workflow_check CHECK ((workflow >= 0))
);

COMMENT ON TABLE ct_workflow IS 'ワークフローテーブル';
COMMENT ON COLUMN ct_workflow.workflow IS 'ワークフロー番号';
COMMENT ON COLUMN ct_workflow.layernumber IS '階層番号';
COMMENT ON COLUMN ct_workflow.currentstatus IS '状態';
COMMENT ON COLUMN ct_workflow.rtcode IS 'ルートコード';
COMMENT ON COLUMN ct_workflow.deleteflag IS '削除フラグ';
COMMENT ON COLUMN ct_workflow.adddt IS '登録日';
COMMENT ON COLUMN ct_workflow.addcd IS '登録者';
COMMENT ON COLUMN ct_workflow.upddt IS '更新日';
COMMENT ON COLUMN ct_workflow.updcd IS '更新者';

ALTER TABLE ONLY ct_workflow
    ADD CONSTRAINT ct_workflow_pkey PRIMARY KEY (workflow);

DROP TABLE IF EXISTS ct_workflow_comment;
CREATE TABLE ct_workflow_comment (
    commentid bigint DEFAULT 0::bigint NOT NULL,
    workflow bigint DEFAULT 0::bigint NOT NULL,
    kcode character varying(10) NOT NULL,
    target character varying(10) NOT NULL,
    authorcomment text NOT NULL,
    deleteflag integer DEFAULT 0 NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) NOT NULL,
    CONSTRAINT ct_workflow_comment_commentid_check CHECK ((commentid >= 0)),
    CONSTRAINT ct_workflow_comment_deleteflag_check CHECK ((deleteflag >= 0)),
    CONSTRAINT ct_workflow_comment_workflow_check CHECK ((workflow >= 0))
);

COMMENT ON TABLE ct_workflow_comment IS 'ワークフローコメントテーブル';
COMMENT ON COLUMN ct_workflow_comment.commentid IS 'コメントID';
COMMENT ON COLUMN ct_workflow_comment.workflow IS 'ワークフロー番号';
COMMENT ON COLUMN ct_workflow_comment.kcode IS '社員コード';
COMMENT ON COLUMN ct_workflow_comment.target IS '対象者';
COMMENT ON COLUMN ct_workflow_comment.authorcomment IS 'コメント';
COMMENT ON COLUMN ct_workflow_comment.deleteflag IS '削除フラグ';
COMMENT ON COLUMN ct_workflow_comment.adddt IS '登録日';
COMMENT ON COLUMN ct_workflow_comment.addcd IS '登録者';
COMMENT ON COLUMN ct_workflow_comment.upddt IS '更新日';
COMMENT ON COLUMN ct_workflow_comment.updcd IS '更新者';

ALTER TABLE ONLY ct_workflow_comment
    ADD CONSTRAINT ct_workflow_comment_pkey PRIMARY KEY (commentid);

DROP TABLE IF EXISTS m_code;
CREATE TABLE m_code (
    tid character varying(20) DEFAULT ''::character varying NOT NULL,
    tcode character varying(20) DEFAULT ''::character varying NOT NULL,
    tname character varying(100) DEFAULT ''::character varying NOT NULL,
    tchange character varying(100) DEFAULT ''::character varying NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) DEFAULT ''::character varying NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) DEFAULT ''::character varying NOT NULL
);

COMMENT ON TABLE m_code IS 'コード';
COMMENT ON COLUMN m_code.tid IS 'コード名';
COMMENT ON COLUMN m_code.tcode IS 'コード';
COMMENT ON COLUMN m_code.tname IS 'コード名称';
COMMENT ON COLUMN m_code.tchange IS 'コード変換';
COMMENT ON COLUMN m_code.adddt IS '登録日';
COMMENT ON COLUMN m_code.addcd IS '登録者';
COMMENT ON COLUMN m_code.upddt IS '更新日';
COMMENT ON COLUMN m_code.updcd IS '更新者';

ALTER TABLE ONLY m_code
    ADD CONSTRAINT m_code_pkey PRIMARY KEY (tid, tcode);

DROP TABLE IF EXISTS m_emergency;
CREATE TABLE m_emergency (
    emcode integer DEFAULT 0 NOT NULL,
    kcode character varying(10) NOT NULL,
    name character varying(100) NOT NULL,
    phone character varying(20) NOT NULL,
    cell character varying(20) NOT NULL,
    postalcode character varying(10) NOT NULL,
    prefectures integer DEFAULT 0 NOT NULL,
    jyuusyo1 character varying(50) NOT NULL,
    jyuusyo2 character varying(50) NOT NULL,
    jyuusyo3 character varying(50) NOT NULL,
    deleteflag integer DEFAULT 0 NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) NOT NULL,
    CONSTRAINT m_emergency_emcode_check CHECK ((emcode >= 0))
);

COMMENT ON TABLE m_emergency IS '緊急連絡先';
COMMENT ON COLUMN m_emergency.emcode IS '連番';
COMMENT ON COLUMN m_emergency.kcode IS '社員コード';
COMMENT ON COLUMN m_emergency.name IS '連絡先氏名';
COMMENT ON COLUMN m_emergency.phone IS '電話番号';
COMMENT ON COLUMN m_emergency.cell IS '携帯番号';
COMMENT ON COLUMN m_emergency.postalcode IS '郵便番号';
COMMENT ON COLUMN m_emergency.prefectures IS '都道府県コード';
COMMENT ON COLUMN m_emergency.jyuusyo1 IS '住所１';
COMMENT ON COLUMN m_emergency.jyuusyo2 IS '住所２';
COMMENT ON COLUMN m_emergency.jyuusyo3 IS '住所３';
COMMENT ON COLUMN m_emergency.deleteflag IS '削除フラグ';
COMMENT ON COLUMN m_emergency.adddt IS '登録日';
COMMENT ON COLUMN m_emergency.addcd IS '登録者';
COMMENT ON COLUMN m_emergency.upddt IS '更新日';
COMMENT ON COLUMN m_emergency.updcd IS '更新者';

ALTER TABLE ONLY m_emergency
    ADD CONSTRAINT m_emergency_pkey PRIMARY KEY (emcode);

DROP TABLE IF EXISTS m_export;
CREATE TABLE m_export (
    ename character varying(20) DEFAULT ''::character varying NOT NULL,
    efile character varying(20) DEFAULT ''::character varying NOT NULL,
    eline integer DEFAULT 0 NOT NULL,
    efid character varying(20) DEFAULT ''::character varying NOT NULL,
    eftype character varying(10) DEFAULT ''::character varying NOT NULL,
    efname character varying(50) DEFAULT ''::character varying NOT NULL,
    deleteflag integer DEFAULT 0 NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) NOT NULL
);

COMMENT ON TABLE m_export IS 'エキスポートマスタ';
COMMENT ON COLUMN m_export.ename IS '名称';
COMMENT ON COLUMN m_export.efile IS 'ファイルID';
COMMENT ON COLUMN m_export.eline IS '行';
COMMENT ON COLUMN m_export.efid IS 'フィールドID';
COMMENT ON COLUMN m_export.eftype IS 'フィールドTYPE';
COMMENT ON COLUMN m_export.efname IS 'フィールド名称';
COMMENT ON COLUMN m_export.deleteflag IS '削除フラグ';
COMMENT ON COLUMN m_export.adddt IS '登録日';
COMMENT ON COLUMN m_export.addcd IS '登録者';
COMMENT ON COLUMN m_export.upddt IS '更新日';
COMMENT ON COLUMN m_export.updcd IS '更新者';

ALTER TABLE ONLY m_export
    ADD CONSTRAINT m_export_pkey PRIMARY KEY (ename, efile, eline);

DROP TABLE IF EXISTS m_kaisya;
CREATE TABLE m_kaisya (
    id character varying(4) DEFAULT ''::character varying NOT NULL,
    kaimei character varying(25) DEFAULT ''::character varying NOT NULL,
    kaifuri character varying(50) DEFAULT ''::character varying NOT NULL,
    kjigyonusi character varying(12) DEFAULT ''::character varying NOT NULL,
    kaiyubin character varying(8) DEFAULT ''::character varying NOT NULL,
    kaijyusyo character varying(37) DEFAULT ''::character varying NOT NULL,
    kaitel character varying(20) DEFAULT ''::character varying NOT NULL,
    kaifax character varying(20) DEFAULT ''::character varying NOT NULL,
    rodoubi integer DEFAULT 0 NOT NULL,
    roudouji integer DEFAULT 0 NOT NULL,
    roudouji1 integer DEFAULT 0 NOT NULL,
    zaritu integer DEFAULT 0 NOT NULL,
    ksritu integer DEFAULT 0 NOT NULL,
    snritu integer DEFAULT 0 NOT NULL,
    zantankbn character varying(1) DEFAULT ''::character varying NOT NULL,
    ritkoyou double precision DEFAULT 0::double precision NOT NULL,
    ritkkoyou double precision DEFAULT 0::double precision NOT NULL,
    ritkenpo double precision DEFAULT 0::double precision NOT NULL,
    ritkkenpo double precision DEFAULT 0::double precision NOT NULL,
    ritkaigo double precision DEFAULT 0::double precision NOT NULL,
    ritkkaigo double precision DEFAULT 0::double precision NOT NULL,
    ritkosei double precision DEFAULT 0::double precision NOT NULL,
    ritkkosei double precision DEFAULT 0::double precision NOT NULL,
    ritkosei3 double precision DEFAULT 0::double precision NOT NULL,
    ritkkosei3 double precision DEFAULT 0::double precision NOT NULL,
    kosei3kbn character varying(1) DEFAULT ''::character varying NOT NULL,
    kikinkbn character varying(1) DEFAULT ''::character varying NOT NULL,
    ritkikin double precision DEFAULT 0::double precision NOT NULL,
    ritkkikin double precision DEFAULT 0::double precision NOT NULL,
    ritkikin3 double precision DEFAULT 0::double precision NOT NULL,
    ritkkikin3 double precision DEFAULT 0::double precision NOT NULL,
    syahofugo character varying(2) DEFAULT ''::character varying NOT NULL,
    syahokigo character varying(4) DEFAULT ''::character varying NOT NULL,
    syahobango character varying(5) DEFAULT ''::character varying NOT NULL,
    kenpojino character varying(4) DEFAULT ''::character varying NOT NULL,
    kikinjino character varying(19) DEFAULT ''::character varying NOT NULL,
    kaibank character varying(50) DEFAULT ''::character varying NOT NULL,
    server character varying(200) DEFAULT ''::character varying NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) DEFAULT ''::character varying NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) DEFAULT ''::character varying NOT NULL
);

COMMENT ON TABLE m_kaisya IS '会社基礎情報';
COMMENT ON COLUMN m_kaisya.id IS '事業所コード';
COMMENT ON COLUMN m_kaisya.kaimei IS '会社名';
COMMENT ON COLUMN m_kaisya.kaifuri IS 'ふりがな';
COMMENT ON COLUMN m_kaisya.kjigyonusi IS '事業主';
COMMENT ON COLUMN m_kaisya.kaiyubin IS '郵便番号';
COMMENT ON COLUMN m_kaisya.kaijyusyo IS '住所';
COMMENT ON COLUMN m_kaisya.kaitel IS '電話番号';
COMMENT ON COLUMN m_kaisya.kaifax IS 'ファックス番号';
COMMENT ON COLUMN m_kaisya.rodoubi IS '月間所定労働日数';
COMMENT ON COLUMN m_kaisya.roudouji IS '月間所定労働時間数';
COMMENT ON COLUMN m_kaisya.roudouji1 IS '一日所定労働時間数';
COMMENT ON COLUMN m_kaisya.zaritu IS '普通残業割増率';
COMMENT ON COLUMN m_kaisya.ksritu IS '休日残業割増率';
COMMENT ON COLUMN m_kaisya.snritu IS '深夜残業割増率';
COMMENT ON COLUMN m_kaisya.zantankbn IS '残業単価自動計算';
COMMENT ON COLUMN m_kaisya.ritkoyou IS '雇用保険率';
COMMENT ON COLUMN m_kaisya.ritkkoyou IS '雇用保険率会社';
COMMENT ON COLUMN m_kaisya.ritkenpo IS '健康保険料率';
COMMENT ON COLUMN m_kaisya.ritkkenpo IS '健康保険料率会社';
COMMENT ON COLUMN m_kaisya.ritkaigo IS '介護保険料率';
COMMENT ON COLUMN m_kaisya.ritkkaigo IS '介護保険料率会社';
COMMENT ON COLUMN m_kaisya.ritkosei IS '厚生年金料率';
COMMENT ON COLUMN m_kaisya.ritkkosei IS '厚生年金料率会社';
COMMENT ON COLUMN m_kaisya.ritkosei3 IS '厚生年金三種料率';
COMMENT ON COLUMN m_kaisya.ritkkosei3 IS '厚生年金三種料率';
COMMENT ON COLUMN m_kaisya.kosei3kbn IS '厚生年金第三種';
COMMENT ON COLUMN m_kaisya.kikinkbn IS '厚生年金基金加入';
COMMENT ON COLUMN m_kaisya.ritkikin IS '厚生年金料率基金';
COMMENT ON COLUMN m_kaisya.ritkkikin IS '厚生年金料率基金';
COMMENT ON COLUMN m_kaisya.ritkikin3 IS '厚生年金三種料率基金';
COMMENT ON COLUMN m_kaisya.ritkkikin3 IS '厚生年金三種料率基金';
COMMENT ON COLUMN m_kaisya.syahofugo IS '郡市区符号';
COMMENT ON COLUMN m_kaisya.syahokigo IS '事業所記号';
COMMENT ON COLUMN m_kaisya.syahobango IS '事業所';
COMMENT ON COLUMN m_kaisya.kenpojino IS '健康保険事業所番号';
COMMENT ON COLUMN m_kaisya.kikinjino IS '厚生年金基金事業所番号';
COMMENT ON COLUMN m_kaisya.kaibank IS '取引銀行名';
COMMENT ON COLUMN m_kaisya.server IS 'サーバー名';
COMMENT ON COLUMN m_kaisya.adddt IS '登録日';
COMMENT ON COLUMN m_kaisya.addcd IS '登録者';
COMMENT ON COLUMN m_kaisya.upddt IS '更新日';
COMMENT ON COLUMN m_kaisya.updcd IS '更新者';

ALTER TABLE ONLY m_kaisya
    ADD CONSTRAINT m_kaisya_pkey PRIMARY KEY (id);

DROP TABLE IF EXISTS m_keisan;
CREATE TABLE m_keisan (
    ktnen integer DEFAULT 0 NOT NULL,
    kttuki integer DEFAULT 0 NOT NULL,
    ksnen integer DEFAULT 0 NOT NULL,
    kstuki integer DEFAULT 0 NOT NULL,
    kshi integer DEFAULT 0 NOT NULL,
    kkanryou character varying(1) DEFAULT ''::character varying NOT NULL,
    stnen integer DEFAULT 0 NOT NULL,
    sttuki integer DEFAULT 0 NOT NULL,
    ssnen integer DEFAULT 0 NOT NULL,
    sstuki integer DEFAULT 0 NOT NULL,
    sshi integer DEFAULT 0 NOT NULL,
    skanryou character varying(1) DEFAULT ''::character varying NOT NULL,
    ntnen integer DEFAULT 0 NOT NULL,
    nkanryou character varying(1) DEFAULT ''::character varying NOT NULL,
    ttnen integer DEFAULT 0 NOT NULL,
    tttuki integer DEFAULT 0 NOT NULL,
    tkanryou character varying(1) DEFAULT ''::character varying NOT NULL,
    gtnen integer DEFAULT 0 NOT NULL,
    gttuki integer DEFAULT 0 NOT NULL,
    gkanryou character varying(1) DEFAULT ''::character varying NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) DEFAULT ''::character varying NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) DEFAULT ''::character varying NOT NULL
);

COMMENT ON TABLE m_keisan IS '計算情報';
COMMENT ON COLUMN m_keisan.ktnen IS '給与計算年';
COMMENT ON COLUMN m_keisan.kttuki IS '給与計算月';
COMMENT ON COLUMN m_keisan.ksnen IS '給与支払年';
COMMENT ON COLUMN m_keisan.kstuki IS '給与支払月';
COMMENT ON COLUMN m_keisan.kshi IS '給与支払日';
COMMENT ON COLUMN m_keisan.kkanryou IS '給与完了';
COMMENT ON COLUMN m_keisan.stnen IS '賞与計算年';
COMMENT ON COLUMN m_keisan.sttuki IS '賞与計算月';
COMMENT ON COLUMN m_keisan.ssnen IS '賞与支払年';
COMMENT ON COLUMN m_keisan.sstuki IS '賞与支払月';
COMMENT ON COLUMN m_keisan.sshi IS '賞与支払日';
COMMENT ON COLUMN m_keisan.skanryou IS '賞与完了';
COMMENT ON COLUMN m_keisan.ntnen IS '年調計算年';
COMMENT ON COLUMN m_keisan.nkanryou IS '年調完了';
COMMENT ON COLUMN m_keisan.ttnen IS '算定計算年';
COMMENT ON COLUMN m_keisan.tttuki IS '算定計算月';
COMMENT ON COLUMN m_keisan.tkanryou IS '算定完了';
COMMENT ON COLUMN m_keisan.gtnen IS '月変計算年';
COMMENT ON COLUMN m_keisan.gttuki IS '月変計算月';
COMMENT ON COLUMN m_keisan.gkanryou IS '月変完了';
COMMENT ON COLUMN m_keisan.adddt IS '登録日';
COMMENT ON COLUMN m_keisan.addcd IS '登録者';
COMMENT ON COLUMN m_keisan.upddt IS '更新日';
COMMENT ON COLUMN m_keisan.updcd IS '更新者';

ALTER TABLE ONLY m_keisan
    ADD CONSTRAINT m_keisan_pkey PRIMARY KEY (ktnen);

DROP TABLE IF EXISTS m_kihon;
CREATE TABLE m_kihon (
    kcode character varying(10) DEFAULT ''::character varying NOT NULL,
    simei character varying(12) DEFAULT ''::character varying NOT NULL,
    furigana character varying(25) DEFAULT ''::character varying NOT NULL,
    scode character varying(6) DEFAULT ''::character varying NOT NULL,
    ycode character varying(5) DEFAULT ''::character varying NOT NULL,
    tokyu character varying(4) DEFAULT ''::character varying NOT NULL,
    jcode character varying(4) NOT NULL,
    nydate integer DEFAULT 0 NOT NULL,
    tsdate integer DEFAULT 0 NOT NULL,
    knkubun character varying(1) DEFAULT ''::character varying NOT NULL,
    kykubun character varying(1) DEFAULT ''::character varying NOT NULL,
    txkubun character varying(1) DEFAULT ''::character varying NOT NULL,
    txkubunx character varying(1) DEFAULT ''::character varying NOT NULL,
    kmkubun character varying(1) DEFAULT ''::character varying NOT NULL,
    ptkubun character varying(1) DEFAULT ''::character varying NOT NULL,
    shkubun character varying(1) DEFAULT ''::character varying NOT NULL,
    siwakecd character varying(10) DEFAULT ''::character varying NOT NULL,
    haigusya character varying(1) DEFAULT ''::character varying NOT NULL,
    fuyosu integer DEFAULT 0 NOT NULL,
    yukyu double precision DEFAULT 0::double precision NOT NULL,
    nenrei integer DEFAULT 0 NOT NULL,
    kinzoku integer DEFAULT 0 NOT NULL,
    kenpono character varying(12) DEFAULT ''::character varying NOT NULL,
    kohono character varying(12) DEFAULT ''::character varying NOT NULL,
    kuser character varying(10) DEFAULT ''::character varying NOT NULL,
    passw character varying(10) DEFAULT ''::character varying NOT NULL,
    email character varying(50) DEFAULT ''::character varying NOT NULL,
    ninsyo character varying(10) DEFAULT ''::character varying NOT NULL,
    datalvl integer DEFAULT 0 NOT NULL,
    proglevel integer DEFAULT 0 NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) DEFAULT ''::character varying NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) DEFAULT ''::character varying NOT NULL
);

COMMENT ON TABLE m_kihon IS '社員マスター基本部';
COMMENT ON COLUMN m_kihon.kcode IS '社員コード';
COMMENT ON COLUMN m_kihon.simei IS '氏名';
COMMENT ON COLUMN m_kihon.furigana IS 'ふりがな';
COMMENT ON COLUMN m_kihon.scode IS '所属コード';
COMMENT ON COLUMN m_kihon.ycode IS '役職コード';
COMMENT ON COLUMN m_kihon.tokyu IS '等級';
COMMENT ON COLUMN m_kihon.jcode IS '事業所コード';
COMMENT ON COLUMN m_kihon.nydate IS '入社日';
COMMENT ON COLUMN m_kihon.tsdate IS '退職日';
COMMENT ON COLUMN m_kihon.knkubun IS '休退職区分';
COMMENT ON COLUMN m_kihon.kykubun IS '給与区分';
COMMENT ON COLUMN m_kihon.txkubun IS '税区分';
COMMENT ON COLUMN m_kihon.txkubunx IS 'その他税区分';
COMMENT ON COLUMN m_kihon.kmkubun IS '組合区分';
COMMENT ON COLUMN m_kihon.ptkubun IS 'パート区分';
COMMENT ON COLUMN m_kihon.shkubun IS '支払区分';
COMMENT ON COLUMN m_kihon.siwakecd IS '仕訳集計コード';
COMMENT ON COLUMN m_kihon.haigusya IS '扶養配偶者';
COMMENT ON COLUMN m_kihon.fuyosu IS '扶養家族数';
COMMENT ON COLUMN m_kihon.yukyu IS '有給残';
COMMENT ON COLUMN m_kihon.nenrei IS '年齢';
COMMENT ON COLUMN m_kihon.kinzoku IS '勤続年数';
COMMENT ON COLUMN m_kihon.kenpono IS '健保番号';
COMMENT ON COLUMN m_kihon.kohono IS '厚保番号';
COMMENT ON COLUMN m_kihon.kuser IS 'ユーザ';
COMMENT ON COLUMN m_kihon.passw IS 'パスワード';
COMMENT ON COLUMN m_kihon.email IS 'email';
COMMENT ON COLUMN m_kihon.ninsyo IS '認証者';
COMMENT ON COLUMN m_kihon.datalvl IS 'データ権限レベル';
COMMENT ON COLUMN m_kihon.proglevel IS 'プログラム使用権限';
COMMENT ON COLUMN m_kihon.adddt IS '登録日';
COMMENT ON COLUMN m_kihon.addcd IS '登録者';
COMMENT ON COLUMN m_kihon.upddt IS '更新日';
COMMENT ON COLUMN m_kihon.updcd IS '更新者';

ALTER TABLE ONLY m_kihon
    ADD CONSTRAINT m_kihon_pkey PRIMARY KEY (kcode);

DROP TABLE IF EXISTS m_kintai;
CREATE TABLE m_kintai (
    kcode character varying(10) DEFAULT ''::character varying NOT NULL,
    sikyuym character varying(8) DEFAULT ''::character varying NOT NULL,
    snen integer DEFAULT 0 NOT NULL,
    stuki integer DEFAULT 0 NOT NULL,
    shi integer DEFAULT 0 NOT NULL,
    snissu double precision DEFAULT 0::double precision NOT NULL,
    skaisu integer DEFAULT 0 NOT NULL,
    kinmuji integer DEFAULT 0 NOT NULL,
    kyukeiji integer DEFAULT 0 NOT NULL,
    yukyu double precision DEFAULT 0::double precision NOT NULL,
    tokukyu double precision DEFAULT 0::double precision NOT NULL,
    kekkin double precision DEFAULT 0::double precision NOT NULL,
    skekkin double precision DEFAULT 0::double precision NOT NULL,
    daikyu double precision DEFAULT 0::double precision NOT NULL,
    furikae double precision DEFAULT 0::double precision NOT NULL,
    sonota integer DEFAULT 0 NOT NULL,
    tisokai integer DEFAULT 0 NOT NULL,
    tijikan integer DEFAULT 0 NOT NULL,
    zajikan integer DEFAULT 0 NOT NULL,
    ksjikan integer DEFAULT 0 NOT NULL,
    snjikan integer DEFAULT 0 NOT NULL,
    kaikin integer DEFAULT 0 NOT NULL,
    syokujikaisu integer DEFAULT 0 NOT NULL,
    cyokukaisu1 integer DEFAULT 0 NOT NULL,
    cyokukaisu2 integer DEFAULT 0 NOT NULL,
    cyokukaisu3 integer DEFAULT 0 NOT NULL,
    hokakaisu1 integer DEFAULT 0 NOT NULL,
    hokakaisu2 integer DEFAULT 0 NOT NULL,
    hokakaisu3 integer DEFAULT 0 NOT NULL,
    hokakaisu4 integer DEFAULT 0 NOT NULL,
    hokakaisu5 integer DEFAULT 0 NOT NULL,
    sinseigaku integer DEFAULT 0 NOT NULL,
    nijikyu integer DEFAULT 0 NOT NULL,
    warimasi1 integer DEFAULT 0 NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) DEFAULT ''::character varying NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) DEFAULT ''::character varying NOT NULL
);

COMMENT ON TABLE m_kintai IS '勤怠集計';
COMMENT ON COLUMN m_kintai.kcode IS '社員コード';
COMMENT ON COLUMN m_kintai.sikyuym IS '支給年月';
COMMENT ON COLUMN m_kintai.snen IS '支給年';
COMMENT ON COLUMN m_kintai.stuki IS '支給月';
COMMENT ON COLUMN m_kintai.shi IS '支給日';
COMMENT ON COLUMN m_kintai.snissu IS '出勤日数';
COMMENT ON COLUMN m_kintai.skaisu IS '出勤回数';
COMMENT ON COLUMN m_kintai.kinmuji IS '勤務時間';
COMMENT ON COLUMN m_kintai.kyukeiji IS '休憩時間';
COMMENT ON COLUMN m_kintai.yukyu IS '有給';
COMMENT ON COLUMN m_kintai.tokukyu IS '特別休暇';
COMMENT ON COLUMN m_kintai.kekkin IS '一般欠勤日数';
COMMENT ON COLUMN m_kintai.skekkin IS '傷病欠勤日数';
COMMENT ON COLUMN m_kintai.daikyu IS '代替休暇';
COMMENT ON COLUMN m_kintai.furikae IS '振替休暇';
COMMENT ON COLUMN m_kintai.sonota IS 'その他休暇';
COMMENT ON COLUMN m_kintai.tisokai IS '遅刻早退回数';
COMMENT ON COLUMN m_kintai.tijikan IS '遅刻早退時間';
COMMENT ON COLUMN m_kintai.zajikan IS '普通残業時間';
COMMENT ON COLUMN m_kintai.ksjikan IS '休日出勤時間';
COMMENT ON COLUMN m_kintai.snjikan IS '深夜勤務時間';
COMMENT ON COLUMN m_kintai.kaikin IS '精皆勤手当支給';
COMMENT ON COLUMN m_kintai.syokujikaisu IS '食事手当支給回数';
COMMENT ON COLUMN m_kintai.cyokukaisu1 IS '1直手当支給回数';
COMMENT ON COLUMN m_kintai.cyokukaisu2 IS '2直手当支給回数';
COMMENT ON COLUMN m_kintai.cyokukaisu3 IS '3直手当支給回数';
COMMENT ON COLUMN m_kintai.hokakaisu1 IS 'その他支給回数1';
COMMENT ON COLUMN m_kintai.hokakaisu2 IS 'その他支給回数2';
COMMENT ON COLUMN m_kintai.hokakaisu3 IS 'その他支給回数3';
COMMENT ON COLUMN m_kintai.hokakaisu4 IS 'その他支給回数4';
COMMENT ON COLUMN m_kintai.hokakaisu5 IS 'その他支給回数5';
COMMENT ON COLUMN m_kintai.sinseigaku IS '支払申請額';
COMMENT ON COLUMN m_kintai.nijikyu IS '二時間年休';
COMMENT ON COLUMN m_kintai.warimasi1 IS '1.00割増';
COMMENT ON COLUMN m_kintai.adddt IS '登録日';
COMMENT ON COLUMN m_kintai.addcd IS '登録者';
COMMENT ON COLUMN m_kintai.upddt IS '更新日';
COMMENT ON COLUMN m_kintai.updcd IS '更新者';

ALTER TABLE ONLY m_kintai
    ADD CONSTRAINT m_kintai_pkey PRIMARY KEY (kcode, sikyuym);

DROP TABLE IF EXISTS m_kintaikeisan;
CREATE TABLE m_kintaikeisan (
    ktnen integer DEFAULT 0 NOT NULL,
    kttuki integer DEFAULT 0 NOT NULL,
    ksnen integer DEFAULT 0 NOT NULL,
    kstuki integer DEFAULT 0 NOT NULL,
    kshi integer DEFAULT 0 NOT NULL,
    kkanryou character varying(1) DEFAULT ''::character varying NOT NULL,
    stnen integer DEFAULT 0 NOT NULL,
    sttuki integer DEFAULT 0 NOT NULL,
    ssnen integer DEFAULT 0 NOT NULL,
    sstuki integer DEFAULT 0 NOT NULL,
    sshi integer DEFAULT 0 NOT NULL,
    skanryou character varying(1) DEFAULT ''::character varying NOT NULL,
    ntnen integer DEFAULT 0 NOT NULL,
    nkanryou character varying(1) DEFAULT ''::character varying NOT NULL,
    ttnen integer DEFAULT 0 NOT NULL,
    tttuki integer DEFAULT 0 NOT NULL,
    tkanryou character varying(1) DEFAULT ''::character varying NOT NULL,
    gtnen integer DEFAULT 0 NOT NULL,
    gttuki integer DEFAULT 0 NOT NULL,
    gkanryou character varying(1) DEFAULT ''::character varying NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) DEFAULT ''::character varying NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) DEFAULT ''::character varying NOT NULL
);

COMMENT ON TABLE m_kintaikeisan IS '勤怠計算情報';
COMMENT ON COLUMN m_kintaikeisan.ktnen IS '給与計算年';
COMMENT ON COLUMN m_kintaikeisan.kttuki IS '給与計算月';
COMMENT ON COLUMN m_kintaikeisan.ksnen IS '給与支払年';
COMMENT ON COLUMN m_kintaikeisan.kstuki IS '給与支払月';
COMMENT ON COLUMN m_kintaikeisan.kshi IS '給与支払日';
COMMENT ON COLUMN m_kintaikeisan.kkanryou IS '給与完了';
COMMENT ON COLUMN m_kintaikeisan.stnen IS '賞与計算年';
COMMENT ON COLUMN m_kintaikeisan.sttuki IS '賞与計算月';
COMMENT ON COLUMN m_kintaikeisan.ssnen IS '賞与支払年';
COMMENT ON COLUMN m_kintaikeisan.sstuki IS '賞与支払月';
COMMENT ON COLUMN m_kintaikeisan.sshi IS '賞与支払日';
COMMENT ON COLUMN m_kintaikeisan.skanryou IS '賞与完了';
COMMENT ON COLUMN m_kintaikeisan.ntnen IS '年調計算年';
COMMENT ON COLUMN m_kintaikeisan.nkanryou IS '年調完了';
COMMENT ON COLUMN m_kintaikeisan.ttnen IS '算定計算年';
COMMENT ON COLUMN m_kintaikeisan.tttuki IS '算定計算月';
COMMENT ON COLUMN m_kintaikeisan.tkanryou IS '算定完了';
COMMENT ON COLUMN m_kintaikeisan.gtnen IS '月変計算年';
COMMENT ON COLUMN m_kintaikeisan.gttuki IS '月変計算月';
COMMENT ON COLUMN m_kintaikeisan.gkanryou IS '月変完了';
COMMENT ON COLUMN m_kintaikeisan.adddt IS '登録日';
COMMENT ON COLUMN m_kintaikeisan.addcd IS '登録者';
COMMENT ON COLUMN m_kintaikeisan.upddt IS '更新日';
COMMENT ON COLUMN m_kintaikeisan.updcd IS '更新者';

ALTER TABLE ONLY m_kintaikeisan
    ADD CONSTRAINT m_kintaikeisan_pkey PRIMARY KEY (ktnen);

DROP TABLE IF EXISTS m_kintaikinmu;
CREATE TABLE m_kintaikinmu (
    kcode character varying(10) NOT NULL,
    sikyuym character varying(8) NOT NULL,
    kinmu character varying(10) NOT NULL,
    snissu double precision DEFAULT 0::double precision NOT NULL,
    zajikan integer DEFAULT 0 NOT NULL,
    szjikan integer DEFAULT 0 NOT NULL,
    hsjikan integer DEFAULT 0 NOT NULL,
    tsjikan integer DEFAULT 0 NOT NULL,
    syokuji integer DEFAULT 0 NOT NULL,
    cyoku1 integer DEFAULT 0 NOT NULL,
    cyoku2 integer DEFAULT 0 NOT NULL,
    cyoku3 integer DEFAULT 0 NOT NULL,
    hoka1 integer DEFAULT 0 NOT NULL,
    hoka2 integer DEFAULT 0 NOT NULL,
    hoka3 integer DEFAULT 0 NOT NULL,
    hoka4 integer DEFAULT 0 NOT NULL,
    hoka5 integer DEFAULT 0 NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) NOT NULL
);

COMMENT ON TABLE m_kintaikinmu IS '勤怠勤務別集計';
COMMENT ON COLUMN m_kintaikinmu.kcode IS '社員コード';
COMMENT ON COLUMN m_kintaikinmu.sikyuym IS '支給年月';
COMMENT ON COLUMN m_kintaikinmu.kinmu IS '勤務形態';
COMMENT ON COLUMN m_kintaikinmu.snissu IS '出勤日数';
COMMENT ON COLUMN m_kintaikinmu.zajikan IS '普通残業時間';
COMMENT ON COLUMN m_kintaikinmu.szjikan IS '深夜残業時間';
COMMENT ON COLUMN m_kintaikinmu.hsjikan IS '法定休日出勤時間';
COMMENT ON COLUMN m_kintaikinmu.tsjikan IS '特別出勤時間';
COMMENT ON COLUMN m_kintaikinmu.syokuji IS '食事手当支給';
COMMENT ON COLUMN m_kintaikinmu.cyoku1 IS '1直手当支給';
COMMENT ON COLUMN m_kintaikinmu.cyoku2 IS '2直手当支給';
COMMENT ON COLUMN m_kintaikinmu.cyoku3 IS '3直手当支給';
COMMENT ON COLUMN m_kintaikinmu.hoka1 IS 'その他支給1';
COMMENT ON COLUMN m_kintaikinmu.hoka2 IS 'その他支給2';
COMMENT ON COLUMN m_kintaikinmu.hoka3 IS 'その他支給3';
COMMENT ON COLUMN m_kintaikinmu.hoka4 IS 'その他支給4';
COMMENT ON COLUMN m_kintaikinmu.hoka5 IS 'その他支給5';
COMMENT ON COLUMN m_kintaikinmu.adddt IS '登録日';
COMMENT ON COLUMN m_kintaikinmu.addcd IS '登録者';
COMMENT ON COLUMN m_kintaikinmu.upddt IS '更新日';
COMMENT ON COLUMN m_kintaikinmu.updcd IS '更新者';

ALTER TABLE ONLY m_kintaikinmu
    ADD CONSTRAINT m_kintaikinmu_pkey PRIMARY KEY (kcode, sikyuym, kinmu);

DROP TABLE IF EXISTS m_kojin;
CREATE TABLE m_kojin (
    kcode character varying(10) DEFAULT ''::character varying NOT NULL,
    seinenbi integer DEFAULT 0 NOT NULL,
    seibetu character varying(1) DEFAULT ''::character varying NOT NULL,
    yubinban character varying(10) DEFAULT ''::character varying NOT NULL,
    prefectures integer DEFAULT 0 NOT NULL,
    jyuusyo1 character varying(50) DEFAULT ''::character varying NOT NULL,
    jyuusyo2 character varying(50) DEFAULT ''::character varying NOT NULL,
    jyuusyo3 character varying(50) DEFAULT ''::character varying NOT NULL,
    tel character varying(15) DEFAULT ''::character varying NOT NULL,
    fax character varying(15) DEFAULT ''::character varying NOT NULL,
    keitai character varying(15) DEFAULT ''::character varying NOT NULL,
    ketueki character varying(4) DEFAULT ''::character varying NOT NULL,
    sikaku character varying(255) DEFAULT ''::character varying NOT NULL,
    kenkou character varying(255) DEFAULT ''::character varying NOT NULL,
    tekiyou character varying(255) DEFAULT ''::character varying NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) DEFAULT ''::character varying NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) DEFAULT ''::character varying NOT NULL
);

COMMENT ON TABLE m_kojin IS '社員マスター個人部';
COMMENT ON COLUMN m_kojin.kcode IS '社員コード';
COMMENT ON COLUMN m_kojin.seinenbi IS '生年月日';
COMMENT ON COLUMN m_kojin.seibetu IS '性別';
COMMENT ON COLUMN m_kojin.yubinban IS '郵便番号';
COMMENT ON COLUMN m_kojin.prefectures IS '都道府県コード';
COMMENT ON COLUMN m_kojin.jyuusyo1 IS '住所1';
COMMENT ON COLUMN m_kojin.jyuusyo2 IS '住所2';
COMMENT ON COLUMN m_kojin.jyuusyo3 IS '住所3';
COMMENT ON COLUMN m_kojin.tel IS '電話番号';
COMMENT ON COLUMN m_kojin.fax IS 'Fax番号';
COMMENT ON COLUMN m_kojin.keitai IS '携帯番号';
COMMENT ON COLUMN m_kojin.ketueki IS '血液型';
COMMENT ON COLUMN m_kojin.sikaku IS '資格等';
COMMENT ON COLUMN m_kojin.kenkou IS '健康状態';
COMMENT ON COLUMN m_kojin.tekiyou IS '摘要';
COMMENT ON COLUMN m_kojin.adddt IS '登録日';
COMMENT ON COLUMN m_kojin.addcd IS '登録者';
COMMENT ON COLUMN m_kojin.upddt IS '更新日';
COMMENT ON COLUMN m_kojin.updcd IS '更新者';

ALTER TABLE ONLY m_kojin
    ADD CONSTRAINT m_kojin_pkey PRIMARY KEY (kcode);

DROP TABLE IF EXISTS m_schedule;
CREATE TABLE m_schedule (
    kcode character varying(10) DEFAULT ''::character varying NOT NULL,
    hizuke character varying(10) DEFAULT ''::character varying NOT NULL,
    nen integer DEFAULT 0 NOT NULL,
    tuki integer DEFAULT 0 NOT NULL,
    hi integer DEFAULT 0 NOT NULL,
    syozoku character varying(6) DEFAULT ''::character varying NOT NULL,
    ninsyo character varying(10) DEFAULT ''::character varying NOT NULL,
    syjikoku character varying(5) DEFAULT ''::character varying NOT NULL,
    kinmu character varying(10) DEFAULT ''::character varying NOT NULL,
    shankyukb character varying(1) DEFAULT ''::character varying NOT NULL,
    kyusyukb character varying(1) DEFAULT ''::character varying NOT NULL,
    tiriyuu character varying(10) DEFAULT ''::character varying NOT NULL,
    ticoment character varying(50) DEFAULT ''::character varying NOT NULL,
    tisyoumei character varying(1) DEFAULT ''::character varying NOT NULL,
    tijikan integer DEFAULT 0 NOT NULL,
    sytimes character varying(20) DEFAULT ''::character varying NOT NULL,
    tajikoku character varying(5) DEFAULT ''::character varying NOT NULL,
    kinmuji integer DEFAULT 0 NOT NULL,
    kyukeiji integer DEFAULT 0 NOT NULL,
    thankyukb character varying(1) DEFAULT ''::character varying NOT NULL,
    soriyuu character varying(10) DEFAULT ''::character varying NOT NULL,
    socoment character varying(50) DEFAULT ''::character varying NOT NULL,
    sosyoumei character varying(1) DEFAULT ''::character varying NOT NULL,
    sojikan integer DEFAULT 0 NOT NULL,
    zajikan integer DEFAULT 0 NOT NULL,
    ksjikan integer DEFAULT 0 NOT NULL,
    snjikan integer DEFAULT 0 NOT NULL,
    syokuji integer DEFAULT 0 NOT NULL,
    cyoku1 integer DEFAULT 0 NOT NULL,
    cyoku2 integer DEFAULT 0 NOT NULL,
    cyoku3 integer DEFAULT 0 NOT NULL,
    hoka1 integer DEFAULT 0 NOT NULL,
    hoka2 integer DEFAULT 0 NOT NULL,
    hoka3 integer DEFAULT 0 NOT NULL,
    hoka4 integer DEFAULT 0 NOT NULL,
    hoka5 integer DEFAULT 0 NOT NULL,
    tatimes character varying(20) DEFAULT ''::character varying NOT NULL,
    kkriyuu character varying(10) DEFAULT ''::character varying NOT NULL,
    daikyujyu character varying(10) DEFAULT ''::character varying NOT NULL,
    kkcoment character varying(50) DEFAULT ''::character varying NOT NULL,
    kksyoumei character varying(1) DEFAULT ''::character varying NOT NULL,
    kkjikan integer DEFAULT 0 NOT NULL,
    kktimes character varying(20) DEFAULT ''::character varying NOT NULL,
    snriyuu character varying(1) DEFAULT ''::character varying NOT NULL,
    sncoment character varying(50) DEFAULT ''::character varying NOT NULL,
    sntimes character varying(20) DEFAULT ''::character varying NOT NULL,
    updttimes character varying(20) DEFAULT ''::character varying NOT NULL,
    nijikyu integer DEFAULT 0 NOT NULL,
    warimasi1 integer DEFAULT 0 NOT NULL,
    zkinmu character varying(10) DEFAULT ''::character varying NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) DEFAULT ''::character varying NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) DEFAULT ''::character varying NOT NULL
);

COMMENT ON TABLE m_schedule IS '出勤予定簿';
COMMENT ON COLUMN m_schedule.kcode IS '社員コード';
COMMENT ON COLUMN m_schedule.hizuke IS '日付';
COMMENT ON COLUMN m_schedule.nen IS '年';
COMMENT ON COLUMN m_schedule.tuki IS '月';
COMMENT ON COLUMN m_schedule.hi IS '日';
COMMENT ON COLUMN m_schedule.syozoku IS '所属コード';
COMMENT ON COLUMN m_schedule.ninsyo IS '認証者';
COMMENT ON COLUMN m_schedule.syjikoku IS '出勤時刻';
COMMENT ON COLUMN m_schedule.kinmu IS '勤務形態';
COMMENT ON COLUMN m_schedule.shankyukb IS '出勤半休区分';
COMMENT ON COLUMN m_schedule.kyusyukb IS '休出区分';
COMMENT ON COLUMN m_schedule.tiriyuu IS '遅刻理由';
COMMENT ON COLUMN m_schedule.ticoment IS '遅刻コメント';
COMMENT ON COLUMN m_schedule.tisyoumei IS '遅刻証明書';
COMMENT ON COLUMN m_schedule.tijikan IS '遅刻時間';
COMMENT ON COLUMN m_schedule.sytimes IS '出勤入力日時';
COMMENT ON COLUMN m_schedule.tajikoku IS '退社時刻';
COMMENT ON COLUMN m_schedule.kinmuji IS '勤務時間';
COMMENT ON COLUMN m_schedule.kyukeiji IS '休憩時間';
COMMENT ON COLUMN m_schedule.thankyukb IS '退勤半休区分';
COMMENT ON COLUMN m_schedule.soriyuu IS '早退理由';
COMMENT ON COLUMN m_schedule.socoment IS '早退コメント';
COMMENT ON COLUMN m_schedule.sosyoumei IS '早退証明書';
COMMENT ON COLUMN m_schedule.sojikan IS '早退時間';
COMMENT ON COLUMN m_schedule.zajikan IS '残業時間';
COMMENT ON COLUMN m_schedule.ksjikan IS '休出時間';
COMMENT ON COLUMN m_schedule.snjikan IS '深夜時間';
COMMENT ON COLUMN m_schedule.syokuji IS '食事手当支給';
COMMENT ON COLUMN m_schedule.cyoku1 IS '1直手当支給';
COMMENT ON COLUMN m_schedule.cyoku2 IS '2直手当支給';
COMMENT ON COLUMN m_schedule.cyoku3 IS '3直手当支給';
COMMENT ON COLUMN m_schedule.hoka1 IS 'その他支給1';
COMMENT ON COLUMN m_schedule.hoka2 IS 'その他支給2';
COMMENT ON COLUMN m_schedule.hoka3 IS 'その他支給3';
COMMENT ON COLUMN m_schedule.hoka4 IS 'その他支給4';
COMMENT ON COLUMN m_schedule.hoka5 IS 'その他支給5';
COMMENT ON COLUMN m_schedule.tatimes IS '退社入力日時';
COMMENT ON COLUMN m_schedule.kkriyuu IS '休暇理由';
COMMENT ON COLUMN m_schedule.daikyujyu IS '代休充当日';
COMMENT ON COLUMN m_schedule.kkcoment IS '休暇コメント';
COMMENT ON COLUMN m_schedule.kksyoumei IS '休暇証明書';
COMMENT ON COLUMN m_schedule.kkjikan IS '休暇時間';
COMMENT ON COLUMN m_schedule.kktimes IS '休暇入力日時';
COMMENT ON COLUMN m_schedule.snriyuu IS '承認理由';
COMMENT ON COLUMN m_schedule.sncoment IS '承認コメント';
COMMENT ON COLUMN m_schedule.sntimes IS '承認入力日時';
COMMENT ON COLUMN m_schedule.updttimes IS '更新日時';
COMMENT ON COLUMN m_schedule.nijikyu IS '二時間年休';
COMMENT ON COLUMN m_schedule.warimasi1 IS '1.00割増';
COMMENT ON COLUMN m_schedule.zkinmu IS '前回勤務形態';
COMMENT ON COLUMN m_schedule.adddt IS '登録日';
COMMENT ON COLUMN m_schedule.addcd IS '登録者';
COMMENT ON COLUMN m_schedule.upddt IS '更新日';
COMMENT ON COLUMN m_schedule.updcd IS '更新者';

ALTER TABLE ONLY m_schedule
    ADD CONSTRAINT m_schedule_pkey PRIMARY KEY (kcode, hizuke);

DROP TABLE IF EXISTS m_syozoku;
CREATE TABLE m_syozoku (
    scode character varying(6) DEFAULT ''::character varying NOT NULL,
    sname character varying(20) DEFAULT ''::character varying NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) DEFAULT ''::character varying NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) DEFAULT ''::character varying NOT NULL
);

COMMENT ON TABLE m_syozoku IS '所属マスタ';
COMMENT ON COLUMN m_syozoku.scode IS '所属コード';
COMMENT ON COLUMN m_syozoku.sname IS '所属部課名';
COMMENT ON COLUMN m_syozoku.adddt IS '登録日';
COMMENT ON COLUMN m_syozoku.addcd IS '登録者';
COMMENT ON COLUMN m_syozoku.upddt IS '更新日';
COMMENT ON COLUMN m_syozoku.updcd IS '更新者';

ALTER TABLE ONLY m_syozoku
    ADD CONSTRAINT m_syozoku_pkey PRIMARY KEY (scode);

DROP TABLE IF EXISTS m_syukkinbo;
CREATE TABLE m_syukkinbo (
    kcode character varying(10) DEFAULT ''::character varying NOT NULL,
    hizuke character varying(10) DEFAULT ''::character varying NOT NULL,
    nen integer DEFAULT 0 NOT NULL,
    tuki integer DEFAULT 0 NOT NULL,
    hi integer DEFAULT 0 NOT NULL,
    syozoku character varying(6) DEFAULT ''::character varying NOT NULL,
    ninsyo character varying(10) DEFAULT ''::character varying NOT NULL,
    syjikoku character varying(5) DEFAULT ''::character varying NOT NULL,
    kinmu character varying(10) DEFAULT ''::character varying NOT NULL,
    shankyukb character varying(1) DEFAULT ''::character varying NOT NULL,
    kyusyukb character varying(1) DEFAULT ''::character varying NOT NULL,
    tiriyuu character varying(10) DEFAULT ''::character varying NOT NULL,
    ticoment character varying(50) DEFAULT ''::character varying NOT NULL,
    tisyoumei character varying(1) DEFAULT ''::character varying NOT NULL,
    tijikan integer DEFAULT 0 NOT NULL,
    sytimes character varying(20) DEFAULT ''::character varying NOT NULL,
    tajikoku character varying(5) DEFAULT ''::character varying NOT NULL,
    kinmuji integer DEFAULT 0 NOT NULL,
    kyukeiji integer DEFAULT 0 NOT NULL,
    thankyukb character varying(1) DEFAULT ''::character varying NOT NULL,
    soriyuu character varying(10) DEFAULT ''::character varying NOT NULL,
    socoment character varying(50) DEFAULT ''::character varying NOT NULL,
    sosyoumei character varying(1) DEFAULT ''::character varying NOT NULL,
    sojikan integer DEFAULT 0 NOT NULL,
    zajikan integer DEFAULT 0 NOT NULL,
    ksjikan integer DEFAULT 0 NOT NULL,
    snjikan integer DEFAULT 0 NOT NULL,
    syokuji integer DEFAULT 0 NOT NULL,
    cyoku1 integer DEFAULT 0 NOT NULL,
    cyoku2 integer DEFAULT 0 NOT NULL,
    cyoku3 integer DEFAULT 0 NOT NULL,
    hoka1 integer DEFAULT 0 NOT NULL,
    hoka2 integer DEFAULT 0 NOT NULL,
    hoka3 integer DEFAULT 0 NOT NULL,
    hoka4 integer DEFAULT 0 NOT NULL,
    hoka5 integer DEFAULT 0 NOT NULL,
    tatimes character varying(20) DEFAULT ''::character varying NOT NULL,
    kkriyuu character varying(10) DEFAULT ''::character varying NOT NULL,
    daikyujyu character varying(10) DEFAULT ''::character varying NOT NULL,
    kkcoment character varying(50) DEFAULT ''::character varying NOT NULL,
    kksyoumei character varying(1) DEFAULT ''::character varying NOT NULL,
    kkjikan integer DEFAULT 0 NOT NULL,
    kktimes character varying(20) DEFAULT ''::character varying NOT NULL,
    snriyuu character varying(1) DEFAULT ''::character varying NOT NULL,
    sncoment character varying(50) DEFAULT ''::character varying NOT NULL,
    sntimes character varying(20) DEFAULT ''::character varying NOT NULL,
    updttimes character varying(20) DEFAULT ''::character varying NOT NULL,
    nijikyu integer DEFAULT 0 NOT NULL,
    warimasi1 integer DEFAULT 0 NOT NULL,
    zkinmu character varying(10) DEFAULT ''::character varying NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) DEFAULT ''::character varying NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) DEFAULT ''::character varying NOT NULL
);

COMMENT ON TABLE m_syukkinbo IS '出勤簿';
COMMENT ON COLUMN m_syukkinbo.kcode IS '社員コード';
COMMENT ON COLUMN m_syukkinbo.hizuke IS '日付';
COMMENT ON COLUMN m_syukkinbo.nen IS '年';
COMMENT ON COLUMN m_syukkinbo.tuki IS '月';
COMMENT ON COLUMN m_syukkinbo.hi IS '日';
COMMENT ON COLUMN m_syukkinbo.syozoku IS '所属コード';
COMMENT ON COLUMN m_syukkinbo.ninsyo IS '認証者';
COMMENT ON COLUMN m_syukkinbo.syjikoku IS '出勤時刻';
COMMENT ON COLUMN m_syukkinbo.kinmu IS '勤務形態';
COMMENT ON COLUMN m_syukkinbo.shankyukb IS '出勤半休区分';
COMMENT ON COLUMN m_syukkinbo.kyusyukb IS '休出区分';
COMMENT ON COLUMN m_syukkinbo.tiriyuu IS '遅刻理由';
COMMENT ON COLUMN m_syukkinbo.ticoment IS '遅刻コメント';
COMMENT ON COLUMN m_syukkinbo.tisyoumei IS '遅刻証明書';
COMMENT ON COLUMN m_syukkinbo.tijikan IS '遅刻時間';
COMMENT ON COLUMN m_syukkinbo.sytimes IS '出勤入力日時';
COMMENT ON COLUMN m_syukkinbo.tajikoku IS '退社時刻';
COMMENT ON COLUMN m_syukkinbo.kinmuji IS '勤務時間';
COMMENT ON COLUMN m_syukkinbo.kyukeiji IS '休憩時間';
COMMENT ON COLUMN m_syukkinbo.thankyukb IS '退勤半休区分';
COMMENT ON COLUMN m_syukkinbo.soriyuu IS '早退理由';
COMMENT ON COLUMN m_syukkinbo.socoment IS '早退コメント';
COMMENT ON COLUMN m_syukkinbo.sosyoumei IS '早退証明書';
COMMENT ON COLUMN m_syukkinbo.sojikan IS '早退時間';
COMMENT ON COLUMN m_syukkinbo.zajikan IS '残業時間';
COMMENT ON COLUMN m_syukkinbo.ksjikan IS '休出時間';
COMMENT ON COLUMN m_syukkinbo.snjikan IS '深夜時間';
COMMENT ON COLUMN m_syukkinbo.syokuji IS '食事手当支給';
COMMENT ON COLUMN m_syukkinbo.cyoku1 IS '1直手当支給';
COMMENT ON COLUMN m_syukkinbo.cyoku2 IS '2直手当支給';
COMMENT ON COLUMN m_syukkinbo.cyoku3 IS '3直手当支給';
COMMENT ON COLUMN m_syukkinbo.hoka1 IS 'その他支給1';
COMMENT ON COLUMN m_syukkinbo.hoka2 IS 'その他支給2';
COMMENT ON COLUMN m_syukkinbo.hoka3 IS 'その他支給3';
COMMENT ON COLUMN m_syukkinbo.hoka4 IS 'その他支給4';
COMMENT ON COLUMN m_syukkinbo.hoka5 IS 'その他支給5';
COMMENT ON COLUMN m_syukkinbo.tatimes IS '退社入力日時';
COMMENT ON COLUMN m_syukkinbo.kkriyuu IS '休暇理由';
COMMENT ON COLUMN m_syukkinbo.daikyujyu IS '代休充当日';
COMMENT ON COLUMN m_syukkinbo.kkcoment IS '休暇コメント';
COMMENT ON COLUMN m_syukkinbo.kksyoumei IS '休暇証明書';
COMMENT ON COLUMN m_syukkinbo.kkjikan IS '休暇時間';
COMMENT ON COLUMN m_syukkinbo.kktimes IS '休暇入力日時';
COMMENT ON COLUMN m_syukkinbo.snriyuu IS '承認理由';
COMMENT ON COLUMN m_syukkinbo.sncoment IS '承認コメント';
COMMENT ON COLUMN m_syukkinbo.sntimes IS '承認入力日時';
COMMENT ON COLUMN m_syukkinbo.updttimes IS '更新日時';
COMMENT ON COLUMN m_syukkinbo.nijikyu IS '二時間年休';
COMMENT ON COLUMN m_syukkinbo.warimasi1 IS '1.00割増';
COMMENT ON COLUMN m_syukkinbo.zkinmu IS '前回勤務形態';
COMMENT ON COLUMN m_syukkinbo.adddt IS '登録日';
COMMENT ON COLUMN m_syukkinbo.addcd IS '登録者';
COMMENT ON COLUMN m_syukkinbo.upddt IS '更新日';
COMMENT ON COLUMN m_syukkinbo.updcd IS '更新者';

ALTER TABLE ONLY m_syukkinbo
    ADD CONSTRAINT m_syukkinbo_pkey PRIMARY KEY (kcode, hizuke);

DROP TABLE IF EXISTS m_yakusyoku;
CREATE TABLE m_yakusyoku (
    ycode character varying(5) DEFAULT ''::character varying NOT NULL,
    yname character varying(20) DEFAULT ''::character varying NOT NULL,
    tokyu character varying(4) DEFAULT ''::character varying NOT NULL,
    tkekkin character varying(1) DEFAULT ''::character varying NOT NULL,
    kekkin character varying(1) DEFAULT ''::character varying NOT NULL,
    skekkin character varying(1) DEFAULT ''::character varying NOT NULL,
    tiji character varying(1) DEFAULT ''::character varying NOT NULL,
    zaji character varying(1) DEFAULT ''::character varying NOT NULL,
    ksji character varying(1) DEFAULT ''::character varying NOT NULL,
    snji character varying(1) DEFAULT ''::character varying NOT NULL,
    kaikin character varying(1) DEFAULT ''::character varying NOT NULL,
    syokuji character varying(1) DEFAULT ''::character varying NOT NULL,
    cyoku1 character varying(1) DEFAULT ''::character varying NOT NULL,
    cyoku2 character varying(1) DEFAULT ''::character varying NOT NULL,
    cyoku3 character varying(1) DEFAULT ''::character varying NOT NULL,
    hoka1 character varying(1) DEFAULT ''::character varying NOT NULL,
    hoka2 character varying(1) DEFAULT ''::character varying NOT NULL,
    hoka3 character varying(1) DEFAULT ''::character varying NOT NULL,
    hoka4 character varying(1) DEFAULT ''::character varying NOT NULL,
    hoka5 character varying(1) DEFAULT ''::character varying NOT NULL,
    tkekkintan integer DEFAULT 0 NOT NULL,
    kekkintan integer DEFAULT 0 NOT NULL,
    skekkintan integer DEFAULT 0 NOT NULL,
    tijitan integer DEFAULT 0 NOT NULL,
    zajitan integer DEFAULT 0 NOT NULL,
    ksjitan integer DEFAULT 0 NOT NULL,
    snjitan integer DEFAULT 0 NOT NULL,
    kaikintan integer DEFAULT 0 NOT NULL,
    syokujitan integer DEFAULT 0 NOT NULL,
    cyoku1tan integer DEFAULT 0 NOT NULL,
    cyoku2tan integer DEFAULT 0 NOT NULL,
    cyoku3tan integer DEFAULT 0 NOT NULL,
    hoka1tan integer DEFAULT 0 NOT NULL,
    hoka2tan integer DEFAULT 0 NOT NULL,
    hoka3tan integer DEFAULT 0 NOT NULL,
    hoka4tan integer DEFAULT 0 NOT NULL,
    hoka5tan integer DEFAULT 0 NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) DEFAULT ''::character varying NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) DEFAULT ''::character varying NOT NULL
);

COMMENT ON TABLE m_yakusyoku IS '役職マスタ';
COMMENT ON COLUMN m_yakusyoku.ycode IS '役職コード';
COMMENT ON COLUMN m_yakusyoku.yname IS '役職名';
COMMENT ON COLUMN m_yakusyoku.tokyu IS '等級';
COMMENT ON COLUMN m_yakusyoku.tkekkin IS '特別休暇控除有無';
COMMENT ON COLUMN m_yakusyoku.kekkin IS '一般欠勤控除有無';
COMMENT ON COLUMN m_yakusyoku.skekkin IS '傷病欠勤控除有無';
COMMENT ON COLUMN m_yakusyoku.tiji IS '遅刻早退控除有無';
COMMENT ON COLUMN m_yakusyoku.zaji IS '普通残業手当有無';
COMMENT ON COLUMN m_yakusyoku.ksji IS '休日残業手当有無';
COMMENT ON COLUMN m_yakusyoku.snji IS '深夜残業手当有無';
COMMENT ON COLUMN m_yakusyoku.kaikin IS '精皆勤手当有無';
COMMENT ON COLUMN m_yakusyoku.syokuji IS '食事手当有無';
COMMENT ON COLUMN m_yakusyoku.cyoku1 IS '1直手当有無';
COMMENT ON COLUMN m_yakusyoku.cyoku2 IS '2直手当有無';
COMMENT ON COLUMN m_yakusyoku.cyoku3 IS '3直手当有無';
COMMENT ON COLUMN m_yakusyoku.hoka1 IS 'その他支給1有無';
COMMENT ON COLUMN m_yakusyoku.hoka2 IS 'その他支給2有無';
COMMENT ON COLUMN m_yakusyoku.hoka3 IS 'その他支給3有無';
COMMENT ON COLUMN m_yakusyoku.hoka4 IS 'その他支給4有無';
COMMENT ON COLUMN m_yakusyoku.hoka5 IS 'その他支給5有無';
COMMENT ON COLUMN m_yakusyoku.tkekkintan IS '特別休暇控除単価';
COMMENT ON COLUMN m_yakusyoku.kekkintan IS '一般欠勤控除単価';
COMMENT ON COLUMN m_yakusyoku.skekkintan IS '傷病欠勤控除単価';
COMMENT ON COLUMN m_yakusyoku.tijitan IS '遅刻早退控除単価';
COMMENT ON COLUMN m_yakusyoku.zajitan IS '普通残業手当単価';
COMMENT ON COLUMN m_yakusyoku.ksjitan IS '休日残業手当単価';
COMMENT ON COLUMN m_yakusyoku.snjitan IS '深夜残業手当単価';
COMMENT ON COLUMN m_yakusyoku.kaikintan IS '精皆勤手当単価';
COMMENT ON COLUMN m_yakusyoku.syokujitan IS '食事手当単価';
COMMENT ON COLUMN m_yakusyoku.cyoku1tan IS '1直手当単価';
COMMENT ON COLUMN m_yakusyoku.cyoku2tan IS '2直手当単価';
COMMENT ON COLUMN m_yakusyoku.cyoku3tan IS '3直手当単価';
COMMENT ON COLUMN m_yakusyoku.hoka1tan IS 'その他支給1単価';
COMMENT ON COLUMN m_yakusyoku.hoka2tan IS 'その他支給2単価';
COMMENT ON COLUMN m_yakusyoku.hoka3tan IS 'その他支給3単価';
COMMENT ON COLUMN m_yakusyoku.hoka4tan IS 'その他支給4単価';
COMMENT ON COLUMN m_yakusyoku.hoka5tan IS 'その他支給5単価';
COMMENT ON COLUMN m_yakusyoku.adddt IS '登録日';
COMMENT ON COLUMN m_yakusyoku.addcd IS '登録者';
COMMENT ON COLUMN m_yakusyoku.upddt IS '更新日';
COMMENT ON COLUMN m_yakusyoku.updcd IS '更新者';

ALTER TABLE ONLY m_yakusyoku
    ADD CONSTRAINT m_yakusyoku_pkey PRIMARY KEY (ycode, tokyu);

DROP TABLE IF EXISTS m_yukyu;
CREATE TABLE m_yukyu (
    kcode character varying(10) DEFAULT ''::character varying NOT NULL,
    kyuyoymd integer DEFAULT 0 NOT NULL,
    zzant double precision DEFAULT 0::double precision NOT NULL,
    zzanz double precision DEFAULT 0::double precision NOT NULL,
    syoka double precision DEFAULT 0::double precision NOT NULL,
    syutoku integer DEFAULT 0 NOT NULL,
    haiki double precision DEFAULT 0::double precision NOT NULL,
    tzant double precision DEFAULT 0::double precision NOT NULL,
    tzanz double precision DEFAULT 0::double precision NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) DEFAULT ''::character varying NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) DEFAULT ''::character varying NOT NULL
);

COMMENT ON TABLE m_yukyu IS '有給休暇ファイル';
COMMENT ON COLUMN m_yukyu.kcode IS '社員コード';
COMMENT ON COLUMN m_yukyu.kyuyoymd IS '給与計算年月日';
COMMENT ON COLUMN m_yukyu.zzant IS '前月残数（当年）';
COMMENT ON COLUMN m_yukyu.zzanz IS '前月残数（前年）';
COMMENT ON COLUMN m_yukyu.syoka IS '当月使用';
COMMENT ON COLUMN m_yukyu.syutoku IS '当月取得';
COMMENT ON COLUMN m_yukyu.haiki IS '当月廃棄';
COMMENT ON COLUMN m_yukyu.tzant IS '当月残数（当年）';
COMMENT ON COLUMN m_yukyu.tzanz IS '当月残数（前年）';
COMMENT ON COLUMN m_yukyu.adddt IS '登録日';
COMMENT ON COLUMN m_yukyu.addcd IS '登録者';
COMMENT ON COLUMN m_yukyu.upddt IS '更新日';
COMMENT ON COLUMN m_yukyu.updcd IS '更新者';

ALTER TABLE ONLY m_yukyu
    ADD CONSTRAINT m_yukyu_pkey PRIMARY KEY (kcode, kyuyoymd);

DROP TABLE IF EXISTS pm_attendance;
CREATE TABLE pm_attendance (
    routeid integer DEFAULT 0 NOT NULL,
    scode character varying(10) NOT NULL,
    kcode character varying(10) NOT NULL,
    rtcode character varying(10) NOT NULL,
    jcode character varying(4) NOT NULL,
    deleteflag integer DEFAULT 0 NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) NOT NULL,
    CONSTRAINT pm_attendance_deleteflag_check CHECK ((deleteflag >= 0)),
    CONSTRAINT pm_attendance_routeid_check CHECK ((routeid >= 0))
);

COMMENT ON TABLE pm_attendance IS '勤怠承認ルートマスタ';
COMMENT ON COLUMN pm_attendance.routeid IS 'ルートID';
COMMENT ON COLUMN pm_attendance.scode IS '所属コード';
COMMENT ON COLUMN pm_attendance.kcode IS '社員コード';
COMMENT ON COLUMN pm_attendance.rtcode IS 'ルートコード';
COMMENT ON COLUMN pm_attendance.jcode IS '事業所コード';
COMMENT ON COLUMN pm_attendance.deleteflag IS '削除フラグ';
COMMENT ON COLUMN pm_attendance.adddt IS '登録日';
COMMENT ON COLUMN pm_attendance.addcd IS '登録者';
COMMENT ON COLUMN pm_attendance.upddt IS '更新日';
COMMENT ON COLUMN pm_attendance.updcd IS '更新者';

ALTER TABLE ONLY pm_attendance
    ADD CONSTRAINT pm_attendance_pkey PRIMARY KEY (routeid);

DROP TABLE IF EXISTS pm_holidayrequest;
CREATE TABLE pm_holidayrequest (
    routeid integer DEFAULT 0 NOT NULL,
    scode character varying(10) NOT NULL,
    kcode character varying(10) NOT NULL,
    rtcode character varying(10) NOT NULL,
    deleteflag integer DEFAULT 0 NOT NULL,
    adddt timestamp without time zone NOT NULL,
    addcd character varying(10) NOT NULL,
    upddt timestamp without time zone NOT NULL,
    updcd character varying(10) NOT NULL,
    CONSTRAINT pm_holidayrequest_deleteflag_check CHECK ((deleteflag >= 0)),
    CONSTRAINT pm_holidayrequest_routeid_check CHECK ((routeid >= 0))
);

COMMENT ON TABLE pm_holidayrequest IS '休暇申請ルートマスタ';
COMMENT ON COLUMN pm_holidayrequest.routeid IS 'ルートID';
COMMENT ON COLUMN pm_holidayrequest.scode IS '所属コード';
COMMENT ON COLUMN pm_holidayrequest.kcode IS '社員コード';
COMMENT ON COLUMN pm_holidayrequest.rtcode IS 'ルートコード';
COMMENT ON COLUMN pm_holidayrequest.deleteflag IS '削除フラグ';
COMMENT ON COLUMN pm_holidayrequest.adddt IS '登録日';
COMMENT ON COLUMN pm_holidayrequest.addcd IS '登録者';
COMMENT ON COLUMN pm_holidayrequest.upddt IS '更新日';
COMMENT ON COLUMN pm_holidayrequest.updcd IS '更新者';

ALTER TABLE ONLY pm_holidayrequest
    ADD CONSTRAINT pm_holidayrequest_pkey PRIMARY KEY (routeid);


--
-- Data for Name: cm_code; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO cm_code VALUES ('AUTHORITY', '10', '従業員権限', 10, 0, '1971-01-01 09:00:00', '', '1971-01-01 09:00:00', '');
INSERT INTO cm_code VALUES ('AUTHORITY', '20', '勤怠管理権限', 20, 0, '1971-01-01 09:00:00', '', '1971-01-01 09:00:00', '');
INSERT INTO cm_code VALUES ('AUTHORITY', '30', '給与管理権限', 30, 0, '1971-01-01 09:00:00', '', '1971-01-01 09:00:00', '');
INSERT INTO cm_code VALUES ('AUTHORITY', '40', '人事管理権限', 40, 0, '1971-01-01 09:00:00', '', '1971-01-01 09:00:00', '');
INSERT INTO cm_code VALUES ('AUTHORITY', '50', '計算管理権限', 50, 0, '1971-01-01 09:00:00', '', '1971-01-01 09:00:00', '');
INSERT INTO cm_code VALUES ('AUTHORITY', '60', '人事給与管理権限', 60, 0, '1971-01-01 09:00:00', '', '1971-01-01 09:00:00', '');
INSERT INTO cm_code VALUES ('JAPANESE', 'JC_MEIJI', '明治', 1, 0, '1971-01-01 00:00:00', '', '1971-01-01 00:00:00', '');
INSERT INTO cm_code VALUES ('JAPANESE', 'JC_TAISH', '大正', 2, 0, '1971-01-01 00:00:00', '', '1971-01-01 00:00:00', '');
INSERT INTO cm_code VALUES ('JAPANESE', 'JC_SHOUW', '昭和', 3, 0, '1971-01-01 00:00:00', '', '1971-01-01 00:00:00', '');
INSERT INTO cm_code VALUES ('JAPANESE', 'JC_HEISE', '平成', 4, 0, '1971-01-01 00:00:00', '', '1971-01-01 00:00:00', '');

--
-- Data for Name: cm_conf; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO cm_conf VALUES ('CALC', '50', '', '1971-01-01 00:00:00', 'admin');
INSERT INTO cm_conf VALUES ('CALC', '99', '', '1971-01-01 00:00:00', 'admin');
INSERT INTO cm_conf VALUES ('CLOSE', '0', '0', '2008-07-10 03:41:17', 'admin');
INSERT INTO cm_conf VALUES ('HOLIDAY', '6', '12', '1971-01-01 00:00:00', '');
INSERT INTO cm_conf VALUES ('HUMAN', '40', '', '1971-01-01 00:00:00', 'admin');
INSERT INTO cm_conf VALUES ('HUMAN', '60', '', '1971-01-01 00:00:00', 'admin');
INSERT INTO cm_conf VALUES ('INITIAL', '10', 'K1010', '1971-01-01 00:00:00', 'admin');
INSERT INTO cm_conf VALUES ('INITIAL', '20', 'K2910', '1971-01-01 00:00:00', 'admin');
INSERT INTO cm_conf VALUES ('INITIAL', '50', 'P1910', '1971-01-01 00:00:00', 'admin');
INSERT INTO cm_conf VALUES ('INITIAL', '99', 'S2910', '1971-01-01 00:00:00', 'admin');
INSERT INTO cm_conf VALUES ('JC_HEISE', '19890108', '21001231', '1970-12-31 15:00:00', '');
INSERT INTO cm_conf VALUES ('JC_MEIJI', '18680908', '19120729', '1970-12-31 15:00:00', '');
INSERT INTO cm_conf VALUES ('JC_SHOUW', '19261225', '19890107', '1970-12-31 15:00:00', '');
INSERT INTO cm_conf VALUES ('JC_TAISH', '19120730', '19261224', '1970-12-31 15:00:00', '');
INSERT INTO cm_conf VALUES ('MANAGER', '20', '', '1971-01-01 18:00:00', '');
INSERT INTO cm_conf VALUES ('MANAGER', '30', '', '1971-01-01 18:00:00', '');
INSERT INTO cm_conf VALUES ('MANAGER', '60', '', '1971-01-01 18:00:00', '');
INSERT INTO cm_conf VALUES ('MISSING', '3', '-5000', '1971-01-01 00:00:00', '');
INSERT INTO cm_conf VALUES ('NIGHT', '22:00', '5:00', '1971-01-01 00:00:00', '');
INSERT INTO cm_conf VALUES ('PAYROLL', '30', '', '1971-01-01 00:00:00', 'admin');
INSERT INTO cm_conf VALUES ('PAYROLL', '50', '', '1971-01-01 00:00:00', 'admin');
INSERT INTO cm_conf VALUES ('PAYROLL', '60', '', '1971-01-01 00:00:00', 'admin');
INSERT INTO cm_conf VALUES ('RATIO', '1', '80', '1971-01-01 00:00:00', '');
INSERT INTO cm_conf VALUES ('WORKHOUR', '8', '', '1971-01-01 00:00:00', '');

--
-- Data for Name: cm_menu; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO cm_menu VALUES ('10', 'INPUT', '1971-01-02 03:00:00', 'admin');
INSERT INTO cm_menu VALUES ('20', 'INPUT', '1971-01-02 03:00:00', 'admin');
INSERT INTO cm_menu VALUES ('20', 'MANAGE', '1971-01-02 03:00:00', 'admin');
INSERT INTO cm_menu VALUES ('30', 'INPUT', '1971-01-02 03:00:00', 'admin');
INSERT INTO cm_menu VALUES ('30', 'PAYROLL', '1971-01-02 03:00:00', 'admin');
INSERT INTO cm_menu VALUES ('40', 'HUMAN', '1971-01-02 03:00:00', 'admin');
INSERT INTO cm_menu VALUES ('40', 'INPUT', '1971-01-02 03:00:00', 'admin');
INSERT INTO cm_menu VALUES ('50', 'INPUT', '1971-01-02 03:00:00', 'admin');
INSERT INTO cm_menu VALUES ('50', 'PAYROLL', '1971-01-01 18:00:00', 'admin');
INSERT INTO cm_menu VALUES ('50', 'SYSTEM', '1971-01-01 18:00:00', 'admin');
INSERT INTO cm_menu VALUES ('60', 'HUMAN', '1971-01-02 03:00:00', 'admin');
INSERT INTO cm_menu VALUES ('60', 'INPUT', '1971-01-02 03:00:00', 'admin');
INSERT INTO cm_menu VALUES ('60', 'MANAGE', '1971-01-02 03:00:00', 'admin');
INSERT INTO cm_menu VALUES ('60', 'PAYROLL', '1971-01-02 03:00:00', 'admin');
INSERT INTO cm_menu VALUES ('99', 'SYSTEM', '1971-01-02 03:00:00', 'admin');
INSERT INTO cm_menu VALUES ('99', 'SYSTEM2', '1971-01-01 18:00:00', 'admin');

--
-- Data for Name: cm_user; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO cm_user VALUES ('admin', 'c3284d0f94606de1fd2af172aba15bf3', '', 'admin', '99', 99, '1971-01-01', 0, '1970-12-31 06:00:00', '', '2008-03-01 03:35:33', 'admin');

--
-- Data for Name: m_code; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO m_code VALUES ('mail.smtp.host', '0', 'アカウントＲ', '', '2008-09-18 13:32:46', '', '2007-04-20 01:28:14', '*');
INSERT INTO m_code VALUES ('mymail.address', '0', '発信者メールアドレス', '', '2008-09-18 13:34:20', '', '2007-06-25 20:11:39', '*');
INSERT INTO m_code VALUES ('１日所定労働', '時数', '', '8.0', '2008-09-18 13:34:20', '', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('１日所定労働', '日数', '', '1.0', '2008-09-18 13:34:20', '', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('パート区分', '1', '正社員', '', '2004-10-02 01:47:06', '', '2007-06-26 18:38:34', '*');
INSERT INTO m_code VALUES ('パート区分', '2', 'パート', '', '2008-09-18 13:35:23', '', '2008-09-18 13:35:23', '');
INSERT INTO m_code VALUES ('陰暦', '1', '睦月', '', '2006-11-17 01:54:18', '', '2006-11-17 01:54:18', '');
INSERT INTO m_code VALUES ('陰暦', '10', '神無月', '', '2006-11-17 01:54:18', '', '2007-02-23 01:42:01', '*');
INSERT INTO m_code VALUES ('陰暦', '11', '霜月', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('陰暦', '12', '師走', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('陰暦', '2', '如月', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('陰暦', '3', '弥生', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('陰暦', '4', '卯月', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('陰暦', '5', '皐月', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('陰暦', '6', '水無月', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('陰暦', '7', '文月', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('陰暦', '8', '葉月', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('陰暦', '9', '長月', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('介護保険有無', '0', '無', '', '2008-09-18 13:34:20', '', '2005-07-14 00:19:26', '');
INSERT INTO m_code VALUES ('介護保険有無', '1', '有', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('学歴', '100', '中学', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('学歴', '200', '高校', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('学歴', '300', '専門学校', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('学歴', '400', '高専', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('学歴', '500', '大学', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('学歴', '600', '大学院', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('割増率', '休日出勤', 'yyyyyyyyyy', '0.10', '2007-02-13 20:05:11', '00001', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('割増率', '欠勤', 'yyyyyyyyyy', '1.50', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('割増率', '深夜勤務', 'yyyyyyyyyy', '0.25', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('割増率', '遅刻早退', 'yyyyyyyyyy', '1.50', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('割増率', '普通残業', 'yyyyyyyyyy', '1.25', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('休暇証明書', '0', '無し', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('休暇証明書', '1', '有り', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('休暇理由', '0', '有給休暇', '', '2008-09-18 13:34:20', '', '2008-06-27 02:28:37', 'admin');
INSERT INTO m_code VALUES ('休暇理由', '1', '特別休暇', '', '2008-09-18 13:34:20', '', '2008-06-27 02:28:37', 'admin');
INSERT INTO m_code VALUES ('休暇理由', '2', '欠勤', '', '2008-09-18 13:34:20', '', '2008-06-27 02:28:37', 'admin');
INSERT INTO m_code VALUES ('休暇理由', '3', '傷病欠勤', '', '2004-10-06 20:30:15', '', '2008-06-27 02:28:37', 'admin');
INSERT INTO m_code VALUES ('休暇理由', '4', '代休', '', '2005-04-04 23:23:25', '', '2008-06-27 02:28:37', 'admin');
INSERT INTO m_code VALUES ('休暇理由', '5', '振替', '', '2007-02-13 21:28:46', '00001', '2008-06-27 02:28:37', 'admin');
INSERT INTO m_code VALUES ('休暇理由', '6', '', '', '2007-06-26 02:19:27', '*', '2008-06-27 02:28:37', 'admin');
INSERT INTO m_code VALUES ('休暇理由', '7', '', '', '2007-06-26 02:19:27', '*', '2008-06-27 02:28:37', 'admin');
INSERT INTO m_code VALUES ('休暇理由', '8', '', '', '2007-06-26 02:19:27', '*', '2008-06-27 02:28:37', 'admin');
INSERT INTO m_code VALUES ('休暇理由', '9', 'その他', '', '2008-09-18 13:34:20', '', '2008-06-27 02:28:37', 'admin');
INSERT INTO m_code VALUES ('休出区分', '0', '通常', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('休出区分', '1', '休出', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('休退職区分', '1', '勤務者', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('休退職区分', '2', '休職者', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('休退職区分', '9', '退職者', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('休日', '01/02', '年始休日', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('休日', '01/03', '年始休日', '', '2008-09-18 13:34:20', '', '2008-05-20 00:41:41', '*');
INSERT INTO m_code VALUES ('休日', '01/04', '年始休日', '', '2008-07-10 03:39:05', 'admin', '2008-07-10 03:39:05', 'admin');
INSERT INTO m_code VALUES ('休日', '01/05', '年始休日', '', '2008-07-10 03:39:18', 'admin', '2008-08-22 23:29:12', 'admin');
INSERT INTO m_code VALUES ('休日', '12/30', '年末休日', '', '2008-09-18 13:34:20', '', '2008-08-22 23:29:31', 'admin');
INSERT INTO m_code VALUES ('休日', '12/31', '年末休日', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('給与区分', '1', '月給', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('給与区分', '2', '月給固定', '', '2008-09-18 13:34:20', '', '2004-10-18 23:26:10', '');
INSERT INTO m_code VALUES ('給与区分', '3', '日給', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('給与区分', '4', '時給', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('給与控除名', '01', '積立金', '', '2004-09-17 00:47:18', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '02', '貸付金返済', '', '2004-09-17 00:47:33', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '03', '控除３', '', '2004-09-17 00:47:45', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '04', '', '', '2004-10-05 22:01:54', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '05', '', '', '2004-10-05 22:02:08', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '06', '', '', '2004-10-05 22:02:18', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '07', '', '', '2004-10-05 22:02:27', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '08', '', '', '2004-10-05 22:02:35', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '09', '', '', '2004-10-05 22:02:43', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '10', '', '', '2004-10-05 22:03:04', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '11', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '12', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '13', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '14', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '15', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '16', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '17', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '18', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '19', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '20', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '21', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '22', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '23', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '24', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '25', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '26', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '27', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '28', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '29', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '30', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '31', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '32', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '33', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '34', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '35', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '36', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '37', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '38', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '39', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '40', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '41', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '42', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '43', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '44', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '45', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '46', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '47', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '48', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '49', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与控除名', '50', '', '', '2007-04-20 19:50:27', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給日', '月', 'プラスする月数', '0', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('給与支給日', '日', '支給日', '25', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('給与支給名', '01', '基本給', '', '2004-09-17 00:48:29', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '02', '職能給', '', '2004-09-17 00:48:39', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '03', '役職手当', '', '2004-09-17 00:48:48', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '04', '資格手当', '', '2004-09-17 00:48:57', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '05', '住宅手当', '', '2004-09-17 00:49:10', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '06', '其他手当', '', '2004-09-17 00:49:22', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '07', '手当7', '', '2004-09-17 00:49:32', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '08', '手当8', '', '2004-09-17 00:49:44', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '09', '', '', '2004-10-05 21:59:10', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '10', '', '', '2004-10-05 21:59:25', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '11', '', '', '2004-10-05 21:59:36', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '12', '', '', '2004-10-05 21:59:48', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '13', '', '', '2004-10-05 21:59:59', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '14', '', '', '2004-10-05 22:00:11', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '15', '', '', '2004-10-05 22:00:32', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '16', '', '', '2004-10-05 22:00:43', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '17', '', '', '2004-10-05 22:00:52', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '18', '', '', '2004-10-05 22:01:04', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '19', '', '', '2004-10-05 22:07:48', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '20', '', '', '2004-10-05 22:01:23', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '21', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '22', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '23', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '24', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '25', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '26', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '27', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '28', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '29', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '30', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '31', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '32', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '33', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '34', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '35', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '36', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '37', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '38', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '39', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '40', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '41', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '42', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '43', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '44', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '45', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '46', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '47', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '48', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '49', '', '', '2007-04-20 19:03:05', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('給与支給名', '50', '', '', '2007-04-20 18:55:50', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('勤怠管理', '休暇時間', '分の単位', '08:00/04:00/', '2008-06-03 21:34:15', '10001', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('勤怠管理', '自動計算', '分の単位', '0', '2008-06-03 21:34:15', '10001', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('勤怠管理', '深夜時間', '分の単位', '22:00/08:00/', '2008-06-03 21:34:15', '10001', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('勤怠締日', '月', 'マイナスする月数', '0', '2005-04-11 00:01:56', '', '2008-06-25 23:25:50', 'admin');
INSERT INTO m_code VALUES ('勤怠締日', '日', '締日', '0', '2005-04-11 00:02:47', '', '2008-06-25 23:25:50', 'admin');
INSERT INTO m_code VALUES ('血液型', '1', 'Ａ型', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('血液型', '2', 'ＡＢ型', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('血液型', '3', 'Ｂ型', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('血液型', '4', 'Ｏ型', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('血液型', '9', '不明', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('月間所定労働', '時数', '', '180.0', '2008-09-18 13:34:20', '', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('月間所定労働', '日数', '', '20.0', '2008-09-18 13:34:20', '', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('雇用保険有無', '0', '無', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('雇用保険有無', '1', '有', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('厚生年金基金三種', '0', '適用しない', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('厚生年金基金三種', '1', '適用する', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('厚生年金三種', '0', '適用しない', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('厚生年金三種', '1', '適用する', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('控除項目数', '給与', '', '10', '2004-10-05 00:48:35', '', '2005-03-22 22:31:35', '');
INSERT INTO m_code VALUES ('控除項目数', '賞与', '', '10', '2004-10-05 00:48:50', '', '2005-03-22 22:04:57', '');
INSERT INTO m_code VALUES ('支給計算基礎', '賞与', 'yyynnnnnnn', '1', '2007-02-08 01:20:48', '11111', '2007-02-08 01:41:45', '11111');
INSERT INTO m_code VALUES ('支給項目数', '給与', '', '20', '2004-10-05 00:47:37', '', '2005-03-22 22:31:58', '');
INSERT INTO m_code VALUES ('支給項目数', '賞与', '', '10', '2004-10-05 00:48:00', '', '2005-03-22 22:05:52', '');
INSERT INTO m_code VALUES ('支払区分', '1', '月払い', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('支払区分', '2', '日払い', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('支払方法1', '0', '無し', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('支払方法1', '1', '現金', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('支払方法1', '2', '振込', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('支払方法2', '0', '無し', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('支払方法2', '1', '現金', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('支払方法2', '2', '振込', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('支払方法3', '0', '無し', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('支払方法3', '1', '現金', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('支払方法3', '2', '振込', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('社会保険', '固定的賃金', 'yyyyyyyyyy', '', '2007-02-08 00:51:18', '11111', '2007-04-21 01:04:57', '*');
INSERT INTO m_code VALUES ('手当非課税額', '01', '皆勤手当', '1000', '2007-02-26 19:37:03', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当非課税額', '02', '食事手当', '3500', '2007-02-26 19:37:03', '*', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当非課税額', '11', '1直手当', '4000', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当非課税額', '12', '2直手当', '4000', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当非課税額', '13', '3直手当', '4300', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当非課税額', '21', 'その他1手当', '0', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当非課税額', '22', 'その他2手当', '0', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当非課税額', '23', 'その他3手当', '0', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当非課税額', '24', 'その他4手当', '0', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当非課税額', '25', 'その他5手当', '0', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当名称', '01', '普通残業', '', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当名称', '02', '休日出勤', '', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当名称', '03', '深夜割増', '', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当名称', '04', '特別欠勤', '', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当名称', '05', '傷病欠勤', '', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当名称', '06', '一般欠勤', '', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当名称', '07', '遅刻早退', '', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当名称', '08', '皆勤手当', '', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当名称', '09', '食事手当', '', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当名称', '10', '1直手当', '', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当名称', '11', '2直手当', '', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当名称', '12', '3直手当', '', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当名称', '13', 'その他手当1', '', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当名称', '14', 'その他手当2', '', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当名称', '15', 'その他手当3', '', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当名称', '16', 'その他手当4', '', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('手当名称', '17', 'その他手当5', '', '2008-09-18 13:34:20', '', '2007-06-26 19:21:02', '*');
INSERT INTO m_code VALUES ('承認理由', '0', '申請中', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('承認理由', '1', '一次済', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('承認理由', '2', '差戻', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('承認理由', '3', '二次済', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('承認理由', '4', '二次差戻', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('昇給', 'その他区分', '', '1', '2004-10-25 21:17:37', '', '2007-02-22 23:20:45', '*');
INSERT INTO m_code VALUES ('昇給', '支給項目数', '', '10', '2004-10-25 21:18:54', '', '2005-03-22 22:05:39', '');
INSERT INTO m_code VALUES ('昇給', '昇給区分', '', '2', '2004-10-25 21:17:13', '', '2007-02-22 23:20:45', '*');
INSERT INTO m_code VALUES ('昇給', '昇給年月日', '', '20060525', '2004-10-25 21:15:53', '', '2007-02-22 23:20:45', '*');
INSERT INTO m_code VALUES ('昇給', '遡及区分', '', '0', '2004-10-25 21:18:18', '', '2007-02-22 23:20:45', '*');
INSERT INTO m_code VALUES ('昇給', '遡及年月日', '', '0', '2004-10-25 21:16:26', '', '2007-02-22 23:20:45', '*');
INSERT INTO m_code VALUES ('昇給', '適用年月日', '', '20070925', '2004-10-25 21:16:49', '', '2007-02-22 23:20:45', '*');
INSERT INTO m_code VALUES ('昇給区分', '1', '定期昇給', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('昇給区分', '2', '臨時昇給', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('賞与控除名', '01', '積立金', '', '2004-09-17 00:51:04', '', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '02', '貸付金返済', '', '2004-09-17 00:51:13', '', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '03', '控除３', '', '2004-09-17 00:51:26', '', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '04', '', '', '2004-10-12 19:23:01', '', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '05', '', '', '2004-10-12 19:23:13', '', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '06', '', '', '2004-10-12 19:23:22', '', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '07', '', '', '2004-10-12 19:23:33', '', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '08', '', '', '2004-10-12 19:23:47', '', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '09', '', '', '2004-10-12 19:24:03', '', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '10', '', '', '2004-10-12 19:24:15', '', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '11', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '12', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '13', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '14', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '15', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '16', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '17', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '18', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '19', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '20', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '21', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '22', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '23', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '24', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '25', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '26', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '27', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '28', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '29', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '30', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '31', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '32', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '33', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '34', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '35', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '36', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '37', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '38', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '39', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '40', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '41', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '42', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '43', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '44', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '45', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '46', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '47', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '48', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '49', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与控除名', '50', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給月数', '0', '', '2.30', '2008-09-18 13:34:20', '', '2007-05-29 22:31:23', '00001');
INSERT INTO m_code VALUES ('賞与支給名', '01', '標準賞与', '', '2004-09-17 00:52:15', '', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '02', '報奨額', '', '2004-09-17 00:52:25', '', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '03', '特別賞与', '', '2004-09-17 00:52:51', '', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '04', '', '', '2004-10-12 19:18:52', '', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '05', '', '', '2004-10-12 19:19:02', '', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '06', '', '', '2004-10-12 19:19:15', '', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '07', '', '', '2004-10-12 19:19:24', '', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '08', '', '', '2004-10-12 19:19:33', '', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '09', '', '', '2004-10-12 19:19:43', '', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '10', '', '', '2004-10-12 19:20:31', '', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '11', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '12', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '13', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '14', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '15', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '16', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '17', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '18', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '19', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '20', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '21', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '22', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '23', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '24', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '25', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '26', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '27', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '28', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '29', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '30', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '31', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '32', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '33', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '34', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '35', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '36', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '37', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '38', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '39', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '40', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '41', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '42', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '43', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '44', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '45', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '46', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '47', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '48', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '49', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('賞与支給名', '50', '', '', '2007-04-20 22:59:50', '*', '2007-04-20 23:16:08', '*');
INSERT INTO m_code VALUES ('性別', '1', '男性', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('性別', '2', '女性', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('税区分', '1', '甲欄', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('税区分', '2', '乙欄', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('税区分', '3', '丙欄', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('組合区分', '1', '組合員', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('組合区分', '2', '非組合員', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('遡及区分', '0', '無し', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('遡及区分', '1', '遡及', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('早退証明書', '0', '無し', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('早退証明書', '1', '有り', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('早退理由', '0', '無し', '', '2005-04-23 23:19:01', '', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('早退理由', '1', '体調不良', '', '2005-04-23 23:19:20', '', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('早退理由', '2', '', '', '2007-06-26 02:19:27', '*', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('早退理由', '3', '', '', '2007-06-26 02:19:27', '*', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('早退理由', '4', '', '', '2007-06-26 02:19:27', '*', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('早退理由', '5', '', '', '2007-06-26 02:19:27', '*', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('早退理由', '6', '', '', '2007-06-26 02:19:27', '*', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('早退理由', '7', '', '', '2007-06-26 02:19:27', '*', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('早退理由', '8', '', '', '2007-06-26 02:19:27', '*', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('早退理由', '9', 'その他', '', '2005-04-23 23:19:40', '', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('続柄', '110', '夫', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('続柄', '120', '妻', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('続柄', '130', '父母', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('続柄', '140', '子', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('続柄', '210', '祖父母', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('続柄', '220', '孫', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('続柄', '250', '兄弟姉妹', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('続柄', '260', '兄姉', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('続柄', '270', '弟妹', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('続柄', '310', '祖父母', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('続柄', '320', '孫', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('続柄', '330', '伯叔父母', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('続柄', '350', '甥姪', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('遅刻証明書', '0', '無し', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('遅刻証明書', '1', '有り', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('遅刻理由', '0', '無し', '', '2005-04-23 23:21:40', '', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('遅刻理由', '1', '電車遅延', '', '2005-04-23 23:21:25', '', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('遅刻理由', '2', '無断', '', '2007-06-26 02:19:27', '*', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('遅刻理由', '3', '', '', '2007-06-26 02:19:27', '*', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('遅刻理由', '4', '', '', '2007-06-26 02:19:27', '*', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('遅刻理由', '5', '', '', '2007-06-26 02:19:27', '*', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('遅刻理由', '6', '', '', '2007-06-26 02:19:27', '*', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('遅刻理由', '7', '', '', '2007-06-26 02:19:27', '*', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('遅刻理由', '8', '', '', '2007-06-26 02:19:27', '*', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('遅刻理由', '9', 'その他', '', '2005-04-23 23:21:00', '', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('通勤手当距離区分', '0', '無し', '0', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('通勤手当距離区分', '1', '45ｋmから', '24500', '2004-10-21 22:11:08', '', '2004-10-21 22:13:28', '');
INSERT INTO m_code VALUES ('通勤手当距離区分', '2', '35ｋmから45ｋm未満', '20900', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('通勤手当距離区分', '3', '25ｋmから35ｋm未満', '16100', '2004-10-21 22:13:49', '', '2004-10-21 22:14:04', '');
INSERT INTO m_code VALUES ('通勤手当距離区分', '4', '15ｋmから25ｋm未満', '11300', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('通勤手当距離区分', '5', '10ｋmから15ｋm未満', '6500', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('通勤手当距離区分', '6', '2ｋmから10ｋm未満', '4100', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('通勤手当距離区分', '7', '2ｋm未満', '0', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('通勤手当区分', '1', '交通機関又は有料道路', '100000', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('通勤手当区分', '2', '自転車や自動車', '100000', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('通勤手当区分', '3', '定期乗車券', '100000', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('通勤手当区分', '4', 'その他定期乗車券', '100000', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('通勤手当支給サイクル', '1', '１ヶ月', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('通勤手当支給サイクル', '2', '2ヶ月', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('通勤手当支給サイクル', '3', '3ヶ月', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('通勤手当支給サイクル', '6', '6ヶ月', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('通勤手当支給サイクル', '9', '日払い', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('通勤手当支給方法', '1', '給与', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('通勤手当支給方法', '2', '現金', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('通勤手当支給方法', '3', '現物', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('等級', '0', '無し', '', '2004-10-04 19:57:13', '', '2007-02-15 18:52:44', '11111');
INSERT INTO m_code VALUES ('等級', '1', '1等級', '', '2008-09-18 13:34:20', '', '2007-05-16 20:38:38', '*');
INSERT INTO m_code VALUES ('等級', '2', '2等級', '', '2008-09-18 13:34:20', '', '2005-05-01 21:43:00', '');
INSERT INTO m_code VALUES ('等級', '3', '3等級', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('等級', '4', '4等級', '', '2008-09-18 13:34:20', '', '2005-05-01 21:38:30', '');
INSERT INTO m_code VALUES ('等級', '5', '5等級', '', '2008-09-18 13:34:20', '', '2005-05-01 21:43:10', '');
INSERT INTO m_code VALUES ('入力単位', '分', '分の単位', '15', '2008-09-18 13:34:20', '', '2008-07-10 03:41:17', 'admin');
INSERT INTO m_code VALUES ('年末調整限度額', '小規模企業共済控除', '', '999999', '2008-09-18 13:34:20', '', '2007-04-21 00:17:53', '*');
INSERT INTO m_code VALUES ('年末調整限度額', '生命保険料控除', '', '100000', '2008-09-18 13:34:20', '', '2007-04-21 00:17:53', '*');
INSERT INTO m_code VALUES ('年末調整限度額', '損害保険料控除', '', '15000', '2008-09-18 13:34:20', '', '2007-04-21 00:17:53', '*');
INSERT INTO m_code VALUES ('半休区分', '0', '通常', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('半休区分', '1', '半休', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('被保険者種別', '0', '未定義()', '', '2008-09-18 13:36:06', '11111', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('被保険者種別', '1', '坑内員以外の男子(1)', '', '2006-11-30 01:12:58', '', '2006-11-30 01:12:58', '');
INSERT INTO m_code VALUES ('被保険者種別', '2', '女子(2)', '', '2006-11-30 01:12:58', '', '2006-11-30 01:12:58', '');
INSERT INTO m_code VALUES ('被保険者種別', '3', '坑内員(3)', '', '2006-11-30 01:12:58', '', '2006-11-30 01:12:58', '');
INSERT INTO m_code VALUES ('被保険者種別', '5', '基金加入で坑内員以外の男子(5)', '', '2006-11-30 01:12:58', '', '2006-11-30 01:12:58', '');
INSERT INTO m_code VALUES ('被保険者種別', '6', '基金加入で女子(6)', '', '2006-11-30 01:12:58', '', '2006-11-30 01:12:58', '');
INSERT INTO m_code VALUES ('被保険者種別', '7', '基金加入で坑内員(7)', '', '2006-11-30 01:12:58', '', '2006-11-30 01:12:58', '');
INSERT INTO m_code VALUES ('評価タイプ', '1', '点数', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('評価タイプ', '2', '金額', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('扶養形態', '1', '控除対象配偶者', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('扶養形態', '2', '老人控除対象配偶者', '', '2008-09-18 13:34:20', '', '2006-09-28 22:33:01', '');
INSERT INTO m_code VALUES ('扶養形態', '3', '同居老親等', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('扶養形態', '4', 'その他', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('扶養形態', '5', '特定扶養親族', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('扶養形態', '9', '無し', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('有給休暇', '繰越区分', '0=当年のみ、1=合計で繰越', '1', '2004-10-28 19:00:10', '', '2008-08-04 23:02:04', 'admin');
INSERT INTO m_code VALUES ('有給休暇', '繰越月', '', '1', '2004-10-28 19:01:25', '', '2008-08-04 23:02:04', 'admin');
INSERT INTO m_code VALUES ('有給休暇', '繰越日数', '', '20', '2004-10-28 19:00:49', '', '2008-08-04 23:02:04', 'admin');
INSERT INTO m_code VALUES ('有給休暇支給', '', '', '', '2008-06-26 20:10:42', 'admin', '2008-08-04 23:02:04', 'admin');
INSERT INTO m_code VALUES ('有給休暇支給', '00', '0年', '5', '2008-08-04 23:00:02', 'admin', '2008-08-04 23:02:04', 'admin');
INSERT INTO m_code VALUES ('有給休暇支給', '01', '1年', '7', '2008-08-04 23:00:02', 'admin', '2008-08-04 23:02:04', 'admin');
INSERT INTO m_code VALUES ('有給休暇支給', '02', '2年', '8', '2008-08-04 23:00:02', 'admin', '2008-08-04 23:02:04', 'admin');
INSERT INTO m_code VALUES ('有給休暇支給', '03', '3年', '9', '2008-08-04 23:00:02', 'admin', '2008-08-04 23:02:04', 'admin');
INSERT INTO m_code VALUES ('有給休暇支給', '04', '4年', '10', '2008-08-04 23:00:02', 'admin', '2008-08-04 23:02:04', 'admin');
INSERT INTO m_code VALUES ('有給休暇支給', '05', '5年', '15', '2008-08-04 23:00:02', 'admin', '2008-08-04 23:02:04', 'admin');
INSERT INTO m_code VALUES ('有給休暇支給', '06', '6年', '15', '2008-08-04 23:00:02', 'admin', '2008-08-04 23:02:04', 'admin');
INSERT INTO m_code VALUES ('有給休暇支給', '07', '7年', '15', '2008-08-04 23:00:02', 'admin', '2008-08-04 23:02:04', 'admin');
INSERT INTO m_code VALUES ('有給休暇支給', '08', '8年', '15', '2008-08-04 23:00:02', 'admin', '2008-08-04 23:02:04', 'admin');
INSERT INTO m_code VALUES ('有給休暇支給', '09', '9年', '15', '2008-08-04 23:00:02', 'admin', '2008-08-04 23:02:04', 'admin');
INSERT INTO m_code VALUES ('有給休暇支給', '10', '10年', '20', '2008-08-04 22:47:00', 'admin', '2008-08-04 23:02:04', 'admin');
INSERT INTO m_code VALUES ('有給休暇支給', '11', '10年以上', '20', '2008-08-04 22:47:00', 'admin', '2008-08-04 23:02:04', 'admin');
INSERT INTO m_code VALUES ('有無', '0', '無', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('有無', '1', '有', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('預金種別1', '1', '普通', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('預金種別1', '2', '当座', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('預金種別2', '1', '普通', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('預金種別2', '2', '当座', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('預金種別3', '1', '普通', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
INSERT INTO m_code VALUES ('預金種別3', '2', '当座', '', '2008-09-18 13:36:06', '', '2008-09-18 13:36:06', '');
