<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "256kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.payroll.payment.vo.CityListVo"
%><%
CityListVo vo = (CityListVo)request.getAttribute(MospConst.ATT_VO);
String[] aryCityCode     = vo.getAryCityCode    ();
String[] aryCityName     = vo.getAryCityName    ();
String[] aryCityKana     = vo.getAryCityKana    ();
String[] aryDesignatedNumber = vo.getAryDesignatedNumber    ();
String[] aryCoBankCode       = vo.getAryCoBankCode    ();
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body" id="cityList">
	<%= HtmlUtility.getMessages(vo) %>
	<div class="Search">
		<table>
			<tr>
				<td id="tdCityCode">
					<span ><%= CityListVo.NAM_CITY_CODE %><%= vo.getName("C_SEPARATOR") %></span>
					<input type="text" id="<%= CityListVo.PRM_TXT_CITY_CODE %>" name="<%= CityListVo.PRM_TXT_CITY_CODE %>" value="<%= vo.getTxtCityCode() %>" />
				</td>
				<td id="tdCityName">
					<span ><%= vo.getName("P_CITY_NAME") %><%= vo.getName("C_SEPARATOR") %></span>
					<input type="text" id="<%= CityListVo.PRM_TXT_CITY_NAME %>" name="<%= CityListVo.PRM_TXT_CITY_NAME %>" value="<%= vo.getTxtCityName() %>" />
				</td>
				<td id="tdCityKana">
					<span ><%= CityListVo.NAM_CITY_KANA %><%= vo.getName("C_SEPARATOR") %></span>
					<input type="text" id="<%= CityListVo.PRM_TXT_CITY_KANA %>" name="<%= CityListVo.PRM_TXT_CITY_KANA %>" value="<%= vo.getTxtCityKana() %>" />
				</td>
				<td class="ButtonTd" rowspan="2">
					<button type="button" id="btnSearch" onclick="submitForm(document.form, 'U5261')"><%= vo.getName("C_SEARCH") %></button>

				</td>
			</tr>
			<tr>
				<td>
				</td>
				<td id="tdDesignatedNumber">
					<span ><%= vo.getName("P_DESIGNATED_NUMBER") %><%= vo.getName("C_SEPARATOR") %></span>
					<input type="text" id="<%= CityListVo.PRM_TXT_DESIGNATED_NUMBER %>" name="<%= CityListVo.PRM_TXT_DESIGNATED_NUMBER %>" value="<%= vo.getTxtDesignatedNumber() %>" />
				</td>
				<td id="tdCoBankCode">
					<span >&nbsp;&nbsp;<%= vo.getName("P_CO_BANK_CODE") %><%= vo.getName("C_SEPARATOR") %></span>
					<select id="<%= CityListVo.PRM_PLT_CO_BANK_CODE %>" name="<%= CityListVo.PRM_PLT_CO_BANK_CODE %>">
						<option value=""></option>
						<%= HtmlUtility.getSelectOption(vo.aryPltCoBankCode, vo.getPltCoBankCode()) %>
					</select>
				</td>
			</tr>
		</table>
	</div>
	<%= HtmlUtility.getListInfo(vo) %>
	<div class="List">
		<table id="list">
			<thead>
				<tr>
					<th id="thButton"></th>
					<th id="thCityCode"         onclick="doSubmitKey(document.form, 'U5263', '<%= vo.KEY_CITY_CODE        %>' , '')">&nbsp;<%= CityListVo.NAM_CITY_CODE        %>&nbsp;<%= vo.getSortMark(vo.KEY_CITY_CODE)         %></th>
					<th id="thCityName"         onclick="doSubmitKey(document.form, 'U5263', '<%= vo.KEY_CITY_NAME        %>' , '')">&nbsp;<%= vo.getName("P_CITY_NAME")        %>&nbsp;<%= vo.getSortMark(vo.KEY_CITY_NAME)         %></th>
					<th id="thCityKana"         onclick="doSubmitKey(document.form, 'U5263', '<%= vo.KEY_CITY_KANA        %>' , '')">&nbsp;<%= CityListVo.NAM_CITY_KANA        %>&nbsp;<%= vo.getSortMark(vo.KEY_CITY_KANA)         %></th>
					<th id="thDesignatedNumber" onclick="doSubmitKey(document.form, 'U5263', '<%= vo.KEY_DESIGNATED_NUMBER%>' , '')">&nbsp;<%= vo.getName("P_DESIGNATED_NUMBER")%>&nbsp;<%= vo.getSortMark(vo.KEY_DESIGNATED_NUMBER) %></th>
					<th id="thCoBankCode"       onclick="doSubmitKey(document.form, 'U5263', '<%= vo.KEY_CO_BANK_CODE     %>' , '')">&nbsp;<%= vo.getName("P_CO_BANK_CODE")     %>&nbsp;<%= vo.getSortMark(vo.KEY_CO_BANK_CODE)      %></th>
				</tr>
			</thead>
			<tbody>
<%
for (int i = vo.getStart(); i <= vo.getEnd(); i++) {
%>				<tr>
					<td class="ButtonTd">
						<button type="button" onclick="doSubmitKey(document.form, 'U5271', '<%= aryCityCode[i] %>', '')"><%= vo.getName("C_SELECT") %></button>
					</td>
					<td><%= aryCityCode        [i] %></td>
					<td><%= aryCityName        [i] %></td>
					<td><%= aryCityKana        [i] %></td>
					<td><%= aryDesignatedNumber[i] %></td>
					<td><%= aryCoBankCode      [i] %></td>
					
				</tr> 
<%
}
%>
			</tbody>
		</table>
	</div>
	<div class="ButtonDiv">
		<button type="button" class="ExecuteButton" onclick="doSubmit(document.form, 'U5270')"><%= vo.getName("P_MAKE_NEW_DATA") %></button>
	</div>
</div>

<%= HtmlUtility.getFooter(vo) %>
