<%--
MosP - Mind Open Source Project         http://www.mosp.jp/
Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "128kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.kintai.vo.AttendanceStartCardVo"
%><%
AttendanceStartCardVo vo = (AttendanceStartCardVo) request.getAttribute(MospConst.ATT_VO);
%>
<%= HtmlUtility.getHeader(vo) %>
<%= vo.getSubTitle(vo.SUB_TITLE, vo.getCmdMenuButton(), vo.getCmdListButton(), vo.getNamListButton()) %>
<div class="Body" id="startCard">
	<%=HtmlUtility.getMessages(vo)%>
	<jsp:include page="attendanceMenu.jsp" />
	<div id="divTitle"><span id="spnMode"></span></div>
	<div class="Card">
		<table id="tblStart">
			<thead>
				<tr>
					<th id="thTime" colspan="2">
						<%= CommonConst.NAM_START_TIME %><%= CommonConst.NAM_COMMON_ITEM %>
					</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td class="TitleTd">
						<%= HtmlUtility.getRequiredMark() %><%=AttendanceStartCardVo.NAM_START_TIME%><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd">
						<input type="text" class="NumberTextBox" id="<%= AttendanceStartCardVo.PRM_TXT_START_HOUR %>" name="<%= AttendanceStartCardVo.PRM_TXT_START_HOUR %>" value="<%= vo.getEscTxtStartHour() %>" />
						<%=CommonConst.STR_TIME_SEPARATOR%>
						<input type="text" class="NumberTextBox" id="<%= AttendanceStartCardVo.PRM_TXT_START_MIN %>" name="<%= AttendanceStartCardVo.PRM_TXT_START_MIN %>" value="<%=vo.getEscTxtStartMin() %>" />
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%= HtmlUtility.getRequiredMark() %><%=AttendanceStartCardVo.NAM_WORKING_TYPE%><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd">
						<select id="<%= AttendanceStartCardVo.PRM_PLT_WORK_TYPE %>" name="<%= AttendanceStartCardVo.PRM_PLT_WORK_TYPE %>">
							<%=HtmlUtility.getSelectOption(vo.aryPltWorkType, vo.getPltWorkType())%>
						</select>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%=AttendanceStartCardVo.NAM_HALF_HOLIDAY%><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd">
						<select id="<%= AttendanceStartCardVo.PRM_PLT_HALF_HOLIDAY %>" name="<%= AttendanceStartCardVo.PRM_PLT_HALF_HOLIDAY %>">
							<option value=""></option>
							<%=HtmlUtility.getSelectOption(vo.aryPltHalfHoliday, vo.getPltHalfHoliday())%>
						</select>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%=AttendanceStartCardVo.NAM_WORK_ON_HOLIDAY%><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd">
						<select id="<%= AttendanceStartCardVo.PRM_PLT_WORK_ON_HOLIDAY %>" name="<%= AttendanceStartCardVo.PRM_PLT_WORK_ON_HOLIDAY %>">
							<option value=""></option>
							<%=HtmlUtility.getSelectOption(vo.aryPltWorkOnHoliday, vo.getPltWorkOnHoliday())%>
						</select>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%=AttendanceStartCardVo.NAM_LATE_TIME%><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd">
						<input type="text" class="NumberTextBox" id="<%= AttendanceStartCardVo.PRM_TXT_LATE_HOUR %>" name="<%= AttendanceStartCardVo.PRM_TXT_LATE_HOUR %>" value="<%= vo.getEscTxtLateHour() %>" />
						<%=CommonConst.NAM_COMMON_TIME %>
						<input type="text" class="NumberTextBox" id="<%= AttendanceStartCardVo.PRM_TXT_LATE_MIN %>" name="<%= AttendanceStartCardVo.PRM_TXT_LATE_MIN %>" value="<%=vo.getEscTxtLateMin() %>" />
						<%=CommonConst.NAM_MINUTES %>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%=AttendanceStartCardVo.NAM_LATE_REASON%><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd">
						<select class="SectionSelect" id="<%= AttendanceStartCardVo.PRM_PLT_LATE_REASON %>" name="<%= AttendanceStartCardVo.PRM_PLT_LATE_REASON %>">
							<option value=""></option>
							<%=HtmlUtility.getSelectOption(vo.aryPltLateReason, vo.getPltLateReason())%>
						</select>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%=AttendanceStartCardVo.NAM_LATE_CERTIFICATE%><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd">
						<select id="<%= AttendanceStartCardVo.PRM_PLT_LATE_CERTIFICATE %>" name="<%= AttendanceStartCardVo.PRM_PLT_LATE_CERTIFICATE %>">
							<option value=""></option>
							<%=HtmlUtility.getSelectOption(vo.aryPltLateCertificate, vo.getPltLateCertificate())%>
						</select>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%=AttendanceStartCardVo.NAM_LATE_COMMENT%><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd">
						<input type="text" class="TextBox" id="<%= AttendanceStartCardVo.PRM_TXT_LATE_COMMENT %>" name="<%= AttendanceStartCardVo.PRM_TXT_LATE_COMMENT %>" value="<%= vo.getEscTxtLateComment() %>" />
					</td>
				</tr>
			</tbody>
		</table>
<!--	2009/08/19	m.yoshida	cƐ\	-->
		<table id="tblOverTime">
			<thead>
				<tr>
					<th colspan="2">
						<%= CommonConst.NAM_OVER_TIME_REQUEST %><%= CommonConst.NAM_COMMON_ITEM %>
					</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td class="TitleTd">
						<%=AttendanceStartCardVo.NAM_APPLICATION_TIME%><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd">
						<%=vo.getEscApplicationTime()%>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%=AttendanceStartCardVo.NAM_REQUEST_STATUS%><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd">
						<%= vo.getEscRequestStatus() %>
					</td>
				</tr>
			</tbody>
		</table>
	</div>
	<div class="Footer">
		<button type="button" class="ExecuteButton" id="btnRegist" onclick="submitForm(document.form)"><%=CommonConst.NAM_REGIST%></button>
		<button type="button" class="ExecuteButton" id="btnDelete" onclick="doSubmitMessage(document.form, 'K1103','QC0002' ,'')"><%= CommonConst.NAM_DELETE %></button>
	</div>
</div>
<%=HtmlUtility.getFooter(vo)%>
