/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.common.common;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class PoiUtility {
    HSSFWorkbook workbook = null;
    FileInputStream in = null;
    POIFSFileSystem fs = null;
    FileOutputStream out = null;
    HSSFSheet sheet = null;
    HSSFCellStyle style = null;
    HSSFRow row;
    HSSFCell cell;
    HSSFFont font;
    public static final short AQUA = 49;
    public static final short BLACK = 8;
    public static final short BLUE = 12;
    public static final short BLUE_GREY = 54;
    public static final short BRIGHT_GREEN = 11;
    public static final short BROWN = 60;
    public static final short CORAL = 29;
    public static final short CORNFLOWER_BLUE = 24;
    public static final short DARK_BLUE = 18;
    public static final short DARK_GREEN = 58;
    public static final short DARK_RED = 16;
    public static final short DARK_TEAL = 56;
    public static final short DARK_YELLOW = 19;
    public static final short GOLD = 51;
    public static final short GREEN = 17;
    public static final short GREY_25_PERCENT = 22;
    public static final short GREY_40_PERCENT = 55;
    public static final short GREY_50_PERCENT = 23;
    public static final short GREY_80_PERCENT = 63;
    public static final short INDIGO = 62;
    public static final short LAVENDER = 46;
    public static final short LEMON_CHIFFON = 26;
    public static final short LIGHT_BLUE = 48;
    public static final short LIGHT_CORNFLOWER_BLUE = 31;
    public static final short LIGHT_GREEN = 42;
    public static final short LIGHT_ORANGE = 52;
    public static final short LIGHT_TURQUOISE = 41;
    public static final short LIGHT_YELLOW = 43;
    public static final short LIME = 50;
    public static final short MAROON = 25;
    public static final short OLIVE_GREEN = 59;
    public static final short ORANGE = 53;
    public static final short ORCHID = 28;
    public static final short PALE_BLUE = 44;
    public static final short PINK = 14;
    public static final short PLUM = 61;
    public static final short RED = 10;
    public static final short ROSE = 45;
    public static final short ROYAL_BLUE = 30;
    public static final short SEA_GREEN = 57;
    public static final short SKY_BLUE = 40;
    public static final short TAN = 47;
    public static final short TEAL = 21;
    public static final short TURQUOISE = 15;
    public static final short VIOLET = 20;
    public static final short WHITE = 9;
    public static final short YELLOW = 13;
    public static final short NO_FILL = 0;
    public static final short SOLID_FOREGROUND = 1;
    public static final short FINE_DOTS = 2;
    public static final short ALT_BARS = 3;
    public static final short SPARSE_DOTS = 4;
    public static final short THICK_HORZ_BANDS = 5;
    public static final short THICK_VERT_BANDS = 6;
    public static final short THICK_BACKWARD_DIAG = 7;
    public static final short THICK_FORWARD_DIAG = 8;
    public static final short BIG_SPOTS = 9;
    public static final short BRICKS = 10;
    public static final short THIN_HORZ_BANDS = 11;
    public static final short THIN_VERT_BANDS = 12;
    public static final short THIN_BACKWARD_DIAG = 13;
    public static final short THIN_FORWARD_DIAG = 14;
    public static final short SQUARES = 15;
    public static final short DIAMONDS = 16;
    public static final String MS_GOTHIC = "\uff2d\uff33 \u30b4\u30b7\u30c3\u30af";
    public static final String MS_P_MINTYO = "\uff2d\uff33 \uff30\u660e\u671d";
    public static final String MS_MINTYO = "\uff2d\uff33 \u660e\u671d";
    public static final short BORDER_DOTTED = 7;
    public static final short BORDER_THIN = 1;
    public static final short DATA_FORMAT_TEXT = 49;
    public static final short DATA_FORMAT_TIME1 = 18;
    public static final short DATA_FORMAT_TIME2 = 19;
    public static final short DATA_FORMAT_TIME3 = 20;
    public static final short DATA_FORMAT_TIME4 = 21;
    public static final short DATA_FORMAT_TIME5 = 45;
    public static final short DATA_FORMAT_TIME6 = 46;
    public static final short DATA_FORMAT_TIME7 = 47;
    public static final String DATA_FORMAT_DATE1 = "yyyy mm dd";
    public static final String DATA_FORMAT_DATE2 = "yyyy/mm/dd";
    public static final String DATA_FORMAT_DATE3 = "yyyy-mm-dd";
    public static final short DATA_FORMAT_INTEGER = 1;
    public static final short DATA_FORMAT_DOUBLE = 2;
    public static final short DATA_FORMAT_PERSENT = 9;
    public static final short DATA_FORMAT_PERSENT1 = 10;

    public void crtNewDoc(int shno, String shname) throws Exception {
        this.workbook = new HSSFWorkbook();
        this.sheet = this.workbook.createSheet();
        this.workbook.setSheetName(shno, shname, (short)1);
        this.sheet.setSelected(true);
    }

    public void crtNewDocR(int shno, String file1) throws Exception {
        try {
            this.in = new FileInputStream(file1);
            this.fs = new POIFSFileSystem((InputStream)this.in);
            this.workbook = new HSSFWorkbook(this.fs);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.in.close();
        }
        this.sheet = this.workbook.getSheetAt(shno);
        this.sheet.setSelected(true);
    }

    public void selSheet(int shno) throws Exception {
        this.sheet = this.workbook.getSheetAt(shno);
        this.sheet.setSelected(true);
    }

    public void crtSheet(int newno, String shnm) throws Exception {
        this.workbook.createSheet();
        this.workbook.setSheetName(newno, shnm);
        this.sheet = this.workbook.getSheetAt(newno);
        this.sheet.setSelected(true);
    }

    public void clnSheet(int shno, int newno, String shnm) throws Exception {
        this.workbook.cloneSheet(shno);
        this.workbook.setSheetName(newno, shnm);
        this.sheet = this.workbook.getSheetAt(newno);
        this.sheet.setSelected(true);
    }

    public void rmvSheet(int shno) throws Exception {
        this.workbook.removeSheetAt(shno);
    }

    public void setColumnWidth(int columnNo, int number) {
        short width = (short)(number * 256);
        this.sheet.setColumnWidth((short)columnNo, width);
    }

    public void setDefaultColumnWidth(int number) {
        this.sheet.setDefaultColumnWidth((short)number);
    }

    public void setZoom(int magnification) {
        if (magnification > 0) {
            this.sheet.setZoom(magnification, 100);
        }
    }

    public void setSheetName(int sheetno, String sheetname) {
        this.workbook.setSheetName(sheetno, sheetname, (short)1);
    }

    public void outputDoc(String file) throws Exception {
        try {
            this.out = new FileOutputStream(file);
            this.workbook.write((OutputStream)this.out);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.out.close();
        }
    }

    public void clrCell(int rr, int cc) throws Exception {
        this.row = this.sheet.getRow(rr);
        this.cell = this.row.getCell((short)cc);
        this.cell.setCellValue("");
    }

    public void getRow(int rr) throws Exception {
        this.row = this.sheet.getRow(rr);
    }

    public void crtRow(int rr) throws Exception {
        this.row = this.sheet.createRow(rr);
    }

    public void dltRow(int rr) throws Exception {
        this.row = this.sheet.getRow(rr);
        if (this.row != null) {
            this.sheet.removeRow(this.row);
        }
    }

    public void shiftRows(int rr) throws Exception {
        this.sheet.shiftRows(rr, this.sheet.getLastRowNum(), -1);
    }

    public void prtItem(int rr, int cc, String sdata) throws Exception {
        this.row = this.sheet.getRow(rr);
        if (this.row == null) {
            this.crtRow(rr);
        }
        this.cell = this.row.getCell((short)cc);
        if (this.cell == null) {
            this.cell = this.row.createCell((short)cc);
        }
        this.cell.setEncoding((short)1);
        this.cell.setCellValue(sdata);
    }

    public void prtItem(int rr, int cc, int idata) throws Exception {
        this.row = this.sheet.getRow(rr);
        if (this.row == null) {
            this.crtRow(rr);
        }
        this.cell = this.row.getCell((short)cc);
        if (this.cell == null) {
            this.cell = this.row.createCell((short)cc);
        }
        this.cell.setCellValue((double)idata);
    }

    public void prtItem(int rr, int cc, double ddata) throws Exception {
        this.row = this.sheet.getRow(rr);
        if (this.row == null) {
            this.crtRow(rr);
        }
        this.cell = this.row.getCell((short)cc);
        if (this.cell == null) {
            this.cell = this.row.createCell((short)cc);
        }
        this.cell.setCellValue(ddata);
    }

    public String getsItem(int cc) {
        try {
            this.cell = this.row.getCell((short)cc);
            if (this.cell != null) {
                return this.cell.getStringCellValue();
            }
            return "*";
        }
        catch (Exception e) {
            return "*";
        }
    }

    public String getsItem(int rr, int cc) {
        try {
            this.row = this.sheet.getRow(rr);
            if (this.row != null) {
                this.cell = this.row.getCell((short)cc);
                if (this.cell != null) {
                    return this.cell.getStringCellValue();
                }
                return "*";
            }
            return "*";
        }
        catch (Exception e) {
            return "*";
        }
    }

    public int getiItem(int rr, int cc) {
        try {
            this.row = this.sheet.getRow(rr);
            if (this.row != null) {
                this.cell = this.row.getCell((short)cc);
                if (this.cell != null) {
                    return (int)this.cell.getNumericCellValue();
                }
                return 0;
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public double getdItem(int rr, int cc) {
        try {
            this.row = this.sheet.getRow(rr);
            if (this.row != null) {
                this.cell = this.row.getCell((short)cc);
                if (this.cell != null) {
                    return this.cell.getNumericCellValue();
                }
                return 0.0;
            }
            return 0.0;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public void wrtItem(int cc, String sdata) throws Exception {
        this.cell = this.row.createCell((short)cc);
        this.cell.setEncoding((short)1);
        this.cell.setCellValue(sdata);
    }

    public void wrtItem(int cc, int idata) throws Exception {
        this.cell = this.row.createCell((short)cc);
        this.cell.setCellValue((double)idata);
    }

    public void wrtItem(int cc, double ddata) throws Exception {
        this.cell = this.row.createCell((short)cc);
        this.cell.setCellValue(ddata);
    }

    public void clnCellStyle(int rr, int cc, int tr, int tc) throws Exception {
        this.row = this.sheet.getRow(rr);
        if (this.row != null) {
            this.cell = this.row.getCell((short)cc);
            if (this.cell != null) {
                this.style = this.cell.getCellStyle();
                this.setCellStyle(tr, tc);
            }
        }
    }

    public void setCellStyle(int rr, int cc) throws Exception {
        this.row = this.sheet.getRow(rr);
        if (this.row != null) {
            this.cell = this.row.getCell((short)cc);
            if (this.cell != null) {
                this.cell.setCellStyle(this.style);
            }
        }
    }

    public void prtBorderTop(int rr, int cc) throws Exception {
        this.row = this.sheet.getRow(rr);
        if (this.row == null) {
            this.crtRow(rr);
        }
        this.cell = this.row.getCell((short)cc);
        if (this.cell == null) {
            this.cell = this.row.createCell((short)cc);
        }
        this.style = this.workbook.createCellStyle();
        this.style.setBorderTop((short)1);
        this.cell.setCellStyle(this.style);
        this.cell.setCellValue("");
    }

    public void prtBorderBottom(int rr, int cc) throws Exception {
        this.row = this.sheet.getRow(rr);
        if (this.row == null) {
            this.crtRow(rr);
        }
        this.cell = this.row.getCell((short)cc);
        if (this.cell == null) {
            this.cell = this.row.createCell((short)cc);
        }
        this.style = this.workbook.createCellStyle();
        this.style.setBorderBottom((short)3);
    }

    public void setCellYen(int rr, int cc) throws Exception {
        this.row = this.sheet.getRow(rr);
        if (this.row == null) {
            this.crtRow(rr);
        }
        this.cell = this.row.getCell((short)cc);
        if (this.cell == null) {
            this.cell = this.row.createCell((short)cc);
        }
        this.style = this.workbook.createCellStyle();
        this.style.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"#,##0"));
        this.cell.setCellStyle(this.style);
    }

    public void setCellStyleDateFormat(int rr, int cc) throws Exception {
        this.row = this.sheet.getRow(rr);
        if (this.row == null) {
            this.crtRow(rr);
        }
        this.cell = this.row.getCell((short)cc);
        if (this.cell == null) {
            this.cell = this.row.createCell((short)cc);
        }
        this.style = this.workbook.createCellStyle();
        HSSFDataFormat dformat = this.workbook.createDataFormat();
        this.style.setDataFormat(dformat.getFormat(DATA_FORMAT_DATE1));
        this.cell.setCellStyle(this.style);
    }

    public void addMergedRegion(int rrf, int ccf, int rrt, int cct) throws Exception {
        this.sheet.addMergedRegion(new Region(rrf, (short)ccf, rrt, (short)cct));
    }

    public void setCellBgColor(short bgColor) {
        this.style.setFillForegroundColor(bgColor);
        this.style.setFillPattern((short)1);
    }

    public void setCellBgColor(short bgColor, short pattern) {
        this.style.setFillForegroundColor(bgColor);
        this.style.setFillPattern(pattern);
    }

    public void setCellFontColor(short fontColor) {
        this.font.setColor(fontColor);
    }

    public void setFontHAlignCenter() {
        this.style.setAlignment((short)6);
    }

    public void setFontHAlignLeft() {
        this.style.setAlignment((short)1);
    }

    public void setFontHAlignRight() {
        this.style.setAlignment((short)3);
    }

    public void setFontVAlighCenter() {
        this.style.setVerticalAlignment((short)1);
    }

    public void setWrapText() {
        this.style.setWrapText(true);
    }

    public void setFontSize(int size) {
        this.font.setFontHeightInPoints((short)size);
    }

    public void setFontType(String fontName) {
        this.font.setFontName(fontName);
    }

    public void setFontWeightBold() {
        this.font.setBoldweight((short)700);
    }

    public void setCellColorCoordinate(short bgColor, short fontColor) {
        this.setCellBgColor(bgColor);
        this.setCellFontColor(fontColor);
    }

    public void setCellColorCoordinate(short bgColor, short fontColor, short pattern) {
        this.setCellBgColor(bgColor, pattern);
        this.setCellFontColor(fontColor);
    }

    public void setBorderAround(short borderStyle, short borderColor) {
        this.setBorderTop(borderStyle, borderColor);
        this.setBorderRight(borderStyle, borderColor);
        this.setBorderBottom(borderStyle, borderColor);
        this.setBorderLeft(borderStyle, borderColor);
    }

    public void setBorderAroundDotted() {
        this.setBorderAround((short)7, (short)8);
    }

    public void setBorderTop(short borderStyle, short borderColor) {
        this.style.setBorderTop(borderStyle);
        this.style.setTopBorderColor(borderColor);
    }

    public void setBorderRight(short borderStyle, short borderColor) {
        this.style.setBorderRight(borderStyle);
        this.style.setRightBorderColor(borderColor);
    }

    public void setBorderBottom(short borderStyle, short borderColor) {
        this.style.setBorderBottom(borderStyle);
        this.style.setBottomBorderColor(borderColor);
    }

    public void setBorderLeft(short borderStyle, short borderColor) {
        this.style.setBorderLeft(borderStyle);
        this.style.setLeftBorderColor(borderColor);
    }

    public void createCellStyle() {
        this.style = this.workbook.createCellStyle();
    }

    private void createFont() {
        this.font = this.workbook.createFont();
    }

    public void createCellStyleAndFont() {
        this.createCellStyle();
        this.createFont();
    }

    public void prtItem(int rr, int cc, String sdata, boolean isStyle) throws Exception {
        this.row = this.sheet.getRow(rr);
        if (this.row == null) {
            this.crtRow(rr);
        }
        this.cell = this.row.getCell((short)cc);
        if (this.cell == null) {
            this.cell = this.row.createCell((short)cc);
        }
        this.cell.setEncoding((short)1);
        this.cell.setCellValue(sdata);
        if (isStyle) {
            this.createCellStyleAndFont();
        }
    }

    public void setDataFormat(short format) {
        this.style.setDataFormat(format);
    }

    public void setDataFormat(String type) {
        HSSFDataFormat dformat = this.workbook.createDataFormat();
        this.style.setDataFormat(dformat.getFormat(type));
    }

    public void reflectCellStyle() {
        this.style.setFont(this.font);
        this.cell.setCellStyle(this.style);
    }

    public void reflectCellStyleNoFont() {
        this.cell.setCellStyle(this.style);
    }

    public int getFirstRow() {
        return this.sheet.getFirstRowNum();
    }

    public int getLastRow() {
        return this.sheet.getLastRowNum();
    }

    public void setPrintArea(int shno, int strcc, int endcc, int strrr, int endrr) {
        this.workbook.removePrintArea(shno);
        this.workbook.setPrintArea(shno, strcc, endcc, strrr, endrr);
    }

    public void setPrintArea(int shno, String printa) {
        this.workbook.removePrintArea(shno);
        this.workbook.setPrintArea(shno, printa);
    }

    public HSSFWorkbook getWorkbook() {
        return this.workbook;
    }
}

