/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.NS;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.spreadsheet.Row;
import org.jopendocument.dom.spreadsheet.TableCalcNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cell<D extends ODDocument>
extends TableCalcNode<CellStyle, D> {
    private final Row row;

    static final Element createEmpty(NS nS) {
        return Cell.createEmpty(nS, 1);
    }

    static final Element createEmpty(NS nS, int n) {
        Element element = new Element("table-cell", nS.getTABLE());
        if (n > 1) {
            element.setAttribute("number-columns-repeated", n + "", nS.getTABLE());
        }
        return element;
    }

    Cell(Row<D> row, Element element) {
        super(row.getODDocument(), element);
        this.row = row;
    }

    protected final Row getRow() {
        return this.row;
    }

    protected final NS getNS() {
        return this.getODDocument().getNS();
    }

    protected final Namespace getValueNS() {
        return this.getNS().getVersion().equals("OpenDocument") ? this.getNS().getOFFICE() : this.getNS().getTABLE();
    }

    protected final String getType() {
        return this.getElement().getAttributeValue("value-type", this.getValueNS());
    }

    protected final ODValueType getValueType() {
        String string = this.getType();
        return string == null ? null : ODValueType.get(string);
    }

    @Override
    protected String getStyleName() {
        throw new UnsupportedOperationException("cannot resolve our style, use MutableCell");
    }

    String getStyleAttr() {
        return this.getElement().getAttributeValue("style-name", this.getNS().getTABLE());
    }

    private final String getValue(String string) {
        return this.getElement().getAttributeValue(string, this.getValueNS());
    }

    public Object getValue() {
        ODValueType oDValueType = this.getValueType();
        if (oDValueType == null || oDValueType == ODValueType.STRING) {
            String string;
            String string2 = string = oDValueType == null ? null : this.getValue(oDValueType.getValueAttribute());
            if (string != null) {
                return string;
            }
            Element element = this.getElement().getChild("p", this.getNS().getTEXT());
            return element == null ? "" : element.getText();
        }
        return oDValueType.parse(this.getValue(oDValueType.getValueAttribute()));
    }

    public boolean isValid() {
        return !this.getElement().getName().equals("covered-table-cell");
    }
}

