/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.legal;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class LegalHolidayUtility {
    private static final long serialVersionUID = -7341283435100183210L;
    private Calendar cal;
    private int yyyy;
    private static final int SEIJIN_MONTH = 1;
    private static final int SEIJIN_DAY_OF_WEEK_IN_MONTH = 2;
    private static final String SEIJIN_NAME = "\u6210\u4eba\u306e\u65e5";
    private static final int UMI_MONTH = 7;
    private static final int UMI_DAY_OF_WEEK_IN_MONTH = 3;
    private static final String UMI_NAME = "\u6d77\u306e\u65e5";
    private static final int KEIROU_MONTH = 9;
    private static final int KEIROU_DAY_OF_WEEK_IN_MONTH = 3;
    private static final String KEIROU_NAME = "\u656c\u8001\u306e\u65e5";
    private static final int TAIIKU_MONTH = 10;
    private static final int TAIIKU_DAY_OF_WEEK_IN_MONTH = 2;
    private static final String TAIIKU_NAME = "\u4f53\u80b2\u306e\u65e5";
    private static final int SYUNBUN_MONTH = 3;
    private static final String SYUNBUN_NAME = "\u6625\u5206\u306e\u65e5";
    private static final int SYUUBUN_MONTH = 9;
    private static final String SYUUBUN_NAME = "\u79cb\u5206\u306e\u65e5";
    private static final int GANJITSU_MONTH = 1;
    private static final int GANJITSU_DATE = 1;
    private static final String GANJITSU_NAME = "\u5143\u65e5";
    private static final int KENKOKUKINEN_MONTH = 2;
    private static final int KENKOKUKINEN_DATE = 11;
    private static final String KENKOKUKINEN_NAME = "\u5efa\u56fd\u8a18\u5ff5\u306e\u65e5";
    private static final int SYOUWA_MONTH = 4;
    private static final int SYOUWA_DATE = 29;
    private static final String SYOUWA_NAME = "\u662d\u548c\u306e\u65e5";
    private static final int KENPOUKINEN_MONTH = 5;
    private static final int KENPOUKINEN_DATE = 3;
    private static final String KENPOUKINEN_NAME = "\u61b2\u6cd5\u8a18\u5ff5\u65e5";
    private static final int MIDORI_MONTH = 5;
    private static final int MIDORI_DATE = 4;
    private static final String MIDORI_NAME = "\u307f\u3069\u308a\u306e\u65e5";
    private static final int KODOMO_MONTH = 5;
    private static final int KODOMO_DATE = 5;
    private static final String KODOMO_NAME = "\u3053\u3069\u3082\u306e\u65e5";
    private static final int BUNKA_MONTH = 11;
    private static final int BUNKA_DATE = 3;
    private static final String BUNKA_NAME = "\u6587\u5316\u306e\u65e5";
    private static final int KINROUKANSYA_MONTH = 11;
    private static final int KINROUKANSYA_DATE = 23;
    private static final String KINROUKANSYA_NAME = "\u52e4\u52b4\u611f\u8b1d\u306e\u65e5";
    private static final int TENNOUTANJOU_MONTH = 12;
    private static final int TENNOUTANJOU_DATE = 23;
    private static final String TENNOUTANJOU_NAME = "\u5929\u7687\u8a95\u751f\u65e5";
    private static final String KOKUMINNOKYUJITU_NAME = "\u56fd\u6c11\u306e\u4f11\u65e5";
    private static String[][] arySyuku = new String[15][2];
    private String[] arySyukuName = new String[]{"\u6210\u4eba\u306e\u65e5", "\u6d77\u306e\u65e5", "\u656c\u8001\u306e\u65e5", "\u4f53\u80b2\u306e\u65e5", "\u6625\u5206\u306e\u65e5", "\u79cb\u5206\u306e\u65e5", "\u5143\u65e5", "\u5efa\u56fd\u8a18\u5ff5\u306e\u65e5", "\u61b2\u6cd5\u8a18\u5ff5\u65e5", "\u3053\u3069\u3082\u306e\u65e5", "\u6587\u5316\u306e\u65e5", "\u52e4\u52b4\u611f\u8b1d\u306e\u65e5", "\u5929\u7687\u8a95\u751f\u65e5"};

    public LegalHolidayUtility() {
        this.cal = Calendar.getInstance();
        this.yyyy = 0;
    }

    public LegalHolidayUtility(int year) {
        this.cal = Calendar.getInstance();
        this.yyyy = year;
        this.createHoliday();
    }

    public LegalHolidayUtility(String y, String m, String d) {
        this.cal = Calendar.getInstance();
        this.cal.set(Integer.parseInt(y), Integer.parseInt(m) - 1, Integer.parseInt(d));
    }

    public LegalHolidayUtility(String y, String m) {
        this.cal = Calendar.getInstance();
        this.cal.set(1, Integer.parseInt(y));
        this.cal.set(1, Integer.parseInt(m) - 1);
    }

    public String retDayOfWeek() {
        int dw = this.cal.get(7);
        List list = EnumYoubi.toArray();
        String youbi = (String)list.get(dw - 1);
        return youbi;
    }

    public boolean isDayOfWeek(int youbi) {
        int dw = this.cal.get(7);
        return dw == youbi;
    }

    public int retDayOfWeekinMonth() {
        return this.cal.get(8);
    }

    public int retMaximumDay() {
        return this.cal.getActualMaximum(5);
    }

    public void setYm(int y, int m) {
        this.cal.set(1, y);
        this.cal.set(2, m - 1);
    }

    public void setYmd(int y, int m, int d) {
        this.cal.set(y, m - 1, d);
    }

    public void calClear() {
        this.cal.clear();
    }

    public void createHoliday() {
        for (int i = 1; i <= 12; ++i) {
            this.setYm(this.yyyy, i);
            int days = this.retMaximumDay();
            for (int j = 1; j <= days; ++j) {
                this.setYmd(this.yyyy, i, j);
                if (!this.isDayOfWeek(2)) continue;
                if (i == 1 && 2 == this.retDayOfWeekinMonth()) {
                    LegalHolidayUtility.arySyuku[0][0] = this.convYMD(this.yyyy, i, j);
                }
                if (i == 7 && 3 == this.retDayOfWeekinMonth()) {
                    LegalHolidayUtility.arySyuku[1][0] = this.convYMD(this.yyyy, i, j);
                }
                if (i == 9 && 3 == this.retDayOfWeekinMonth()) {
                    LegalHolidayUtility.arySyuku[2][0] = this.convYMD(this.yyyy, i, j);
                }
                if (i == 10 && 2 == this.retDayOfWeekinMonth()) {
                    LegalHolidayUtility.arySyuku[3][0] = this.convYMD(this.yyyy, i, j);
                }
                if (i == 3) {
                    LegalHolidayUtility.arySyuku[4][0] = this.getSyunbunDate();
                }
                if (i != 9) continue;
                LegalHolidayUtility.arySyuku[5][0] = this.getSyuubunDate();
            }
        }
        LegalHolidayUtility.arySyuku[6][0] = this.convYMD(this.yyyy, 1, 1);
        LegalHolidayUtility.arySyuku[7][0] = this.convYMD(this.yyyy, 2, 11);
        LegalHolidayUtility.arySyuku[8][0] = this.convYMD(this.yyyy, 5, 3);
        LegalHolidayUtility.arySyuku[9][0] = this.convYMD(this.yyyy, 5, 5);
        LegalHolidayUtility.arySyuku[10][0] = this.convYMD(this.yyyy, 11, 3);
        LegalHolidayUtility.arySyuku[11][0] = this.convYMD(this.yyyy, 11, 23);
        LegalHolidayUtility.arySyuku[12][0] = this.convYMD(this.yyyy, 12, 23);
        LegalHolidayUtility.arySyuku[13][0] = this.convYMD(this.yyyy, 4, 29);
        LegalHolidayUtility.arySyuku[14][0] = this.convYMD(this.yyyy, 5, 4);
        for (int k = 0; k < arySyuku.length; ++k) {
            if (k < this.arySyukuName.length) {
                LegalHolidayUtility.arySyuku[k][1] = this.arySyukuName[k];
                continue;
            }
            if (k == this.arySyukuName.length) {
                if (this.yyyy <= 2006) {
                    LegalHolidayUtility.arySyuku[k][1] = MIDORI_NAME;
                    continue;
                }
                LegalHolidayUtility.arySyuku[k][1] = SYOUWA_NAME;
                continue;
            }
            if (k != this.arySyukuName.length + 1) continue;
            LegalHolidayUtility.arySyuku[k][1] = this.yyyy <= 2006 ? KOKUMINNOKYUJITU_NAME : MIDORI_NAME;
        }
    }

    public String convYMD(int y, int m, int d) {
        String syy = "";
        String smm = "";
        String sdd = "";
        String yyyymmdd = "";
        syy = Integer.toString(y);
        smm = m < 10 ? "0" + m : Integer.toString(m);
        sdd = d < 10 ? "0" + d : Integer.toString(d);
        yyyymmdd = syy + "/" + smm + "/" + sdd;
        return yyyymmdd;
    }

    public String[][] getArySyuku() {
        return (String[][])arySyuku.clone();
    }

    public String getSyunbunDate() {
        double date = 20.8431 + 0.242194 * (double)(this.yyyy - 1980) - (double)(this.yyyy - 1980) / 4.0;
        int dd = (int)Math.floor(date);
        return this.convYMD(this.yyyy, 3, dd);
    }

    public String getSyuubunDate() {
        double date = 23.2488 + 0.242194 * (double)(this.yyyy - 1980) - (double)(this.yyyy - 1980) / 4.0;
        int dd = (int)Math.floor(date);
        return this.convYMD(this.yyyy, 9, dd);
    }

    public void setYyyy(int yyyy) {
        this.yyyy = yyyy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EnumYoubi {
        SUN("\u65e5"),
        MON("\u6708"),
        TUE("\u706b"),
        WED("\u6c34"),
        THU("\u6728"),
        FRI("\u91d1"),
        SAT("\u571f");

        private String dw;

        private EnumYoubi(String youbi) {
            this.dw = youbi;
        }

        public String toStringEnum() {
            return this.dw;
        }

        static List toArray() {
            ArrayList<String> array = new ArrayList<String>();
            array.add(SUN.toString());
            array.add(MON.toString());
            array.add(TUE.toString());
            array.add(WED.toString());
            array.add(THU.toString());
            array.add(FRI.toString());
            array.add(SAT.toString());
            return array;
        }
    }
}

