/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.common.action;

import java.util.Date;
import jp.mosp.common.bean.AuthBean;
import jp.mosp.common.common.BaseAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.LogUtility;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.vo.LoginVo;

public class AuthAction
extends BaseAction {
    public AuthAction() {
        this.setNeedSession(false);
        this.setNeedAspUser(false);
        this.setNeedUser(false);
        this.setCheckAuth(false);
        this.setCheckProcSeq(false);
    }

    public void action() throws Exception {
        BaseVo vo = this.getInitVo();
        this.setVo(vo);
        this.setUrl(vo.getRetUrl());
        this.createAspUser();
        this.login(vo);
        this.setNextPage(vo);
        this.setUserField();
        this.storeUserInfo();
        LogUtility.log(this.request, 4, "MosP\u60c5\u5831", "\u30ed\u30b0\u30a4\u30f3");
    }

    protected void login(BaseVo baseVo) throws Exception {
        this.chkInstance(baseVo instanceof LoginVo);
        LoginVo vo = (LoginVo)baseVo;
        vo.setParams(this.request);
        vo.validate();
        this.getConnection();
        AuthBean authBean = new AuthBean(this.cfg, this.cmd, this.aspUser, this.conn, this.hasMospSeJar());
        authBean.login(vo.getUserId(), vo.getPass());
        if (authBean.isErrMessage()) {
            this.commit();
            vo.addErrMessage(MospUtility.getMessage(this.msg, authBean.getErrMessageCode(), ""));
            throw new MospException(authBean.getMosPExceptionCode());
        }
        this.user = authBean.getCmUserDto();
    }

    protected void setNextPage(BaseVo vo) throws Exception {
        String nextCmd = "C1010";
        int passTerm = this.getPasswordTerm();
        if (this.isExpirePassWord(passTerm, this.user.getChangePass())) {
            nextCmd = "C1052";
        }
        if (this.isDefaultPassWord(this.user.getUserId(), this.user.getPassword())) {
            nextCmd = "C1052";
        }
        this.setNextCmd(nextCmd);
        this.setUrl("/srv/");
    }

    protected int getPasswordTerm() throws Exception {
        String days = this.cfg.getProperty("acc.validity");
        if (days == null) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(days);
    }

    private boolean isExpirePassWord(int passTerm, Date updateDate) {
        return passTerm > 0 && MospUtility.getSystemDate().compareTo(MospUtility.addDay(updateDate, passTerm)) > 0;
    }

    private boolean isDefaultPassWord(String userid, String passWord) throws Exception {
        return MospUtility.encrypt(MospUtility.getDigest(userid), this.hasMospSeJar()).equals(passWord);
    }

    protected BaseVo getInitVo() {
        return new LoginVo(this.cfg, this.msg, this.nam, this.cmd, this.aspUser, this.user);
    }

    protected void createAspUser() {
        this.aspUser = new CmAspUserDto();
        this.aspUser.setAspUserId(this.cfg.getProperty("asp.aspuser"));
        this.aspUser.setAspName(this.cfg.getProperty("asp.aspname"));
        this.aspUser.setDbDriver(this.cfg.getProperty("asp.dbdriver"));
        this.aspUser.setDbUrl(this.cfg.getProperty("asp.dburl"));
        this.aspUser.setDbUser(this.cfg.getProperty("asp.dbuser"));
        this.aspUser.setDbPass(this.cfg.getProperty("asp.dbpass"));
    }

    protected void setUserField() {
        this.user.setPassword("");
    }

    protected void storeUserInfo() {
        if (this.session != null) {
            this.session.invalidate();
        }
        this.session = this.request.getSession(true);
        this.session.setAttribute("aspUser", (Object)this.aspUser);
        this.session.setAttribute("user", (Object)this.user);
        this.request.setAttribute("user", (Object)this.user);
    }
}

