<?php
require 'DB.php';   // PEAR::DB

/**
 * ǡ١饹Ǥ
 * PEAR::DBѤޤ
 * 
 * @access public
 * @author YAMAOKA Hiroyuki
 * @package moony.util
 */
class Dao {

	/** @var object PEAR::DB饹Υ󥹥 */
	var $db;

	/**
	 * 󥹥ȥ饯Ǥ
	 * 줿DSN򸵤DB³Ωޤ
	 * 
	 * @access public
	 */
    function Dao() {
		$this->connect(DSN);
	}

	/**
	 * ꤵ줿SQL¹Ԥޤ
	 * ̤󼡸ϢȤưޤ
	 * 
	 * @access public
	 * @param string $sql ץ졼ۥޤSQL
	 * @param array $params ѥ᡼
	 * @return array ̤󼡸Ϣ
	 */
	function query($sql, $params = null) {
		
		$result = $this->db->getAll($sql, $params, DB_FETCHMODE_ASSOC);
		
		if (DB::isError($result)) {
			$this->rollback();
			ErrorHandler::forward(ERROR_DB_QUERY, __FILE__, __LINE__);
		}

		return $result;
	}

	/**
	 * ꤵ줿SQL¹Ԥޤ
	 * 
	 * @access public
	 * @param string $sql ץ졼ۥޤSQL
	 * @param array $params ѥ᡼
	 * @return int Կ
	 */
	function execute($sql, $params = null) {

		$result = $this->db->query($sql, $params);

		if (DB::isError($result)) {
			$this->rollback();
			ErrorHandler::forward(ERROR_DB_QUERY, __FILE__, __LINE__);
		}

		return $this->db->affectedRows();
	}
	
	/**
	 * ȥ󥶥򳫻Ϥޤ
	 * ưߥåȤOFFˤޤ
	 * 
	 * @access public
	 */
	function begin() {
		$this->db->autoCommit(false);
	}

	/**
	 * ߥåȽԤޤ
	 * 
	 * @access public
	 */
	function commit() {
		$this->db->commit();
	}

	/**
	 * ХåԤޤ
	 * 
	 * @access public
	 */
	function rollback() {
		$this->db->rollback();
	}

	/**
	 * ꤵ줿DSN򸵤DB³Ԥޤ
	 * 
	 * @access private
	 * @param string $dsn ³DBξ
	 */
	function connect($dsn) {
		
		$this->db =& DB::connect($dsn);
		
		if (DB::isError($this->db)) {
			ErrorHandler::forward(ERROR_DB_CONN, __FILE__, __LINE__);
		}
	}
}
?>