/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.win32.NOTIFYICONDATA;
import org.eclipse.swt.internal.win32.NOTIFYICONDATAA;
import org.eclipse.swt.internal.win32.NOTIFYICONDATAW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TypedListener;

public class TrayItem
extends Item {
    Tray parent;
    int id;
    Image image2;
    String toolTipText;
    boolean visible = true;

    public TrayItem(Tray parent, int style) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
        if (OS.IsWinCE) {
            return;
        }
        NOTIFYICONDATA iconData = OS.IsUnicode ? new NOTIFYICONDATAW() : new NOTIFYICONDATAA();
        iconData.cbSize = NOTIFYICONDATA.sizeof;
        this.id = this.display.nextTrayId++;
        iconData.uID = this.id;
        iconData.hWnd = this.display.hwndMessage;
        iconData.uFlags = 1;
        iconData.uCallbackMessage = 32773;
        OS.Shell_NotifyIcon(0, iconData);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.visible;
    }

    int messageProc(int hwnd, int msg, int wParam, int lParam) {
        switch (lParam) {
            case 513: {
                if (!this.hooks(13)) break;
                OS.SetForegroundWindow(hwnd);
                this.postEvent(13);
                break;
            }
            case 515: 
            case 518: {
                if (!this.hooks(14)) break;
                OS.SetForegroundWindow(hwnd);
                this.postEvent(14);
                break;
            }
            case 517: {
                if (!this.hooks(35)) break;
                OS.SetForegroundWindow(hwnd);
                this.sendEvent(35);
                if (!this.isDisposed()) break;
                return 0;
            }
        }
        this.display.wakeThread();
        return 0;
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.image2 != null) {
            this.image2.dispose();
        }
        this.image2 = null;
        this.toolTipText = null;
        if (OS.IsWinCE) {
            return;
        }
        NOTIFYICONDATA iconData = OS.IsUnicode ? new NOTIFYICONDATAW() : new NOTIFYICONDATAA();
        iconData.cbSize = NOTIFYICONDATA.sizeof;
        iconData.uID = this.id;
        iconData.hWnd = this.display.hwndMessage;
        OS.Shell_NotifyIcon(2, iconData);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        if (OS.IsWinCE) {
            return;
        }
        if (this.image2 != null) {
            this.image2.dispose();
        }
        this.image2 = null;
        int hIcon = 0;
        Image icon = image;
        if (icon != null) {
            switch (icon.type) {
                case 0: {
                    ImageData data = icon.getImageData();
                    ImageData mask = data.getTransparencyMask();
                    this.image2 = new Image((Device)this.display, data, mask);
                    hIcon = this.image2.handle;
                    break;
                }
                case 1: {
                    hIcon = icon.handle;
                }
            }
        }
        NOTIFYICONDATA iconData = OS.IsUnicode ? new NOTIFYICONDATAW() : new NOTIFYICONDATAA();
        iconData.cbSize = NOTIFYICONDATA.sizeof;
        iconData.uID = this.id;
        iconData.hWnd = this.display.hwndMessage;
        iconData.hIcon = hIcon;
        iconData.uFlags = 2;
        OS.Shell_NotifyIcon(1, iconData);
    }

    public void setToolTipText(String value) {
        int length;
        this.checkWidget();
        this.toolTipText = value;
        if (OS.IsWinCE) {
            return;
        }
        NOTIFYICONDATA iconData = OS.IsUnicode ? new NOTIFYICONDATAW() : new NOTIFYICONDATAA();
        TCHAR buffer = new TCHAR(0, this.toolTipText == null ? "" : this.toolTipText, true);
        int n = length = OS.SHELL32_MAJOR < 5 ? 64 : 128;
        if (OS.IsUnicode) {
            char[] szTip = iconData.szTip;
            length = Math.min(length - 1, buffer.length());
            System.arraycopy(buffer.chars, 0, szTip, 0, length);
        } else {
            byte[] szTip = ((NOTIFYICONDATAA)iconData).szTip;
            length = Math.min(length - 1, buffer.length());
            System.arraycopy(buffer.bytes, 0, szTip, 0, length);
        }
        iconData.cbSize = NOTIFYICONDATA.sizeof;
        iconData.uID = this.id;
        iconData.hWnd = this.display.hwndMessage;
        iconData.uFlags = 4;
        OS.Shell_NotifyIcon(1, iconData);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (this.visible == visible) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        this.visible = visible;
        if (!OS.IsWinCE) {
            NOTIFYICONDATA iconData = OS.IsUnicode ? new NOTIFYICONDATAW() : new NOTIFYICONDATAA();
            iconData.cbSize = NOTIFYICONDATA.sizeof;
            iconData.uID = this.id;
            iconData.hWnd = this.display.hwndMessage;
            if (OS.SHELL32_MAJOR < 5) {
                if (visible) {
                    iconData.uFlags = 1;
                    iconData.uCallbackMessage = 32773;
                    OS.Shell_NotifyIcon(0, iconData);
                    this.setImage(this.image);
                    this.setToolTipText(this.toolTipText);
                } else {
                    OS.Shell_NotifyIcon(2, iconData);
                }
            } else {
                iconData.uFlags = 8;
                iconData.dwState = visible ? 0 : 1;
                iconData.dwStateMask = 1;
                OS.Shell_NotifyIcon(1, iconData);
            }
        }
        if (!visible) {
            this.sendEvent(23);
        }
    }
}

