/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;

public abstract class Device
implements Drawable {
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    public int hPalette = 0;
    int[] colorRefCount;
    int systemFont;
    int nFonts = 256;
    LOGFONT[] logFonts;
    int[] scripts;
    LOGFONT[] logFontsCache;
    boolean disposed;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;

    static {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    static Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device(DeviceData data) {
        if (data != null) {
            this.debug = data.debug;
            this.tracking = data.tracking;
        }
        this.create(data);
        this.init();
        if (this.tracking) {
            this.errors = new Error[128];
            this.objects = new Object[128];
        }
        this.systemFont = this.getSystemFont().handle;
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData data) {
    }

    int computePixels(int height) {
        int hDC = this.internal_new_GC(null);
        int pixels = -Compatibility.round(height * OS.GetDeviceCaps(hDC, 90), 72);
        this.internal_dispose_GC(hDC, null);
        return pixels;
    }

    int computePoints(LOGFONT logFont) {
        int hDC = this.internal_new_GC(null);
        int logPixelsY = OS.GetDeviceCaps(hDC, 90);
        int pixels = 0;
        if (logFont.lfHeight > 0) {
            int hFont = OS.CreateFontIndirect(logFont);
            int oldFont = OS.SelectObject(hDC, hFont);
            TEXTMETRIC lptm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(hDC, lptm);
            OS.SelectObject(hDC, oldFont);
            OS.DeleteObject(hFont);
            pixels = logFont.lfHeight - lptm.tmInternalLeading;
        } else {
            pixels = -logFont.lfHeight;
        }
        this.internal_dispose_GC(hDC, null);
        return Compatibility.round(pixels * 72, logPixelsY);
    }

    protected void destroy() {
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.checkDevice();
        this.release();
        this.destroy();
        this.disposed = true;
        if (this.tracking) {
            this.objects = null;
            this.errors = null;
        }
    }

    void dispose_Object(Object object) {
        int i = 0;
        while (i < this.objects.length) {
            if (this.objects[i] == object) {
                this.objects[i] = null;
                this.errors[i] = null;
                return;
            }
            ++i;
        }
    }

    int EnumFontFamProc(int lpelfe, int lpntme, int FontType, int lParam) {
        boolean scalable;
        boolean isScalable = (FontType & 1) == 0;
        boolean bl = scalable = lParam == 1;
        if (isScalable == scalable) {
            LOGFONT logFont;
            if (this.nFonts == this.logFonts.length) {
                LOGFONT[] newLogFonts = new LOGFONT[this.logFonts.length + 128];
                System.arraycopy(this.logFonts, 0, newLogFonts, 0, this.nFonts);
                this.logFonts = newLogFonts;
            }
            if ((logFont = this.logFonts[this.nFonts]) == null) {
                logFont = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            }
            OS.MoveMemory(logFont, lpelfe, LOGFONT.sizeof);
            this.logFonts[this.nFonts++] = logFont;
        }
        return 1;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        int hDC = this.internal_new_GC(null);
        int width = OS.GetDeviceCaps(hDC, 8);
        int height = OS.GetDeviceCaps(hDC, 10);
        this.internal_dispose_GC(hDC, null);
        return new Rectangle(0, 0, width, height);
    }

    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData data = new DeviceData();
        data.debug = this.debug;
        data.tracking = this.tracking;
        int count = 0;
        int length = 0;
        if (this.tracking) {
            length = this.objects.length;
        }
        int i = 0;
        while (i < length) {
            if (this.objects[i] != null) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        data.objects = new Object[count];
        data.errors = new Error[count];
        int i2 = 0;
        while (i2 < length) {
            if (this.objects[i2] != null) {
                data.objects[index] = this.objects[i2];
                data.errors[index] = this.errors[i2];
                ++index;
            }
            ++i2;
        }
        return data;
    }

    public Rectangle getClientArea() {
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        int hDC = this.internal_new_GC(null);
        int bits = OS.GetDeviceCaps(hDC, 12);
        int planes = OS.GetDeviceCaps(hDC, 14);
        this.internal_dispose_GC(hDC, null);
        return bits * planes;
    }

    public Point getDPI() {
        this.checkDevice();
        int hDC = this.internal_new_GC(null);
        int dpiX = OS.GetDeviceCaps(hDC, 88);
        int dpiY = OS.GetDeviceCaps(hDC, 90);
        this.internal_dispose_GC(hDC, null);
        return new Point(dpiX, dpiY);
    }

    public FontData[] getFontList(String faceName, boolean scalable) {
        this.checkDevice();
        Callback callback = new Callback(this, "EnumFontFamProc", 4);
        int lpEnumFontFamProc = callback.getAddress();
        this.logFonts = new LOGFONT[this.nFonts];
        int i = 0;
        while (i < this.logFonts.length) {
            this.logFonts[i] = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            ++i;
        }
        this.nFonts = 0;
        int offset = 0;
        int hDC = this.internal_new_GC(null);
        if (faceName == null) {
            OS.EnumFontFamilies(hDC, null, lpEnumFontFamProc, scalable ? 1 : 0);
            offset = this.nFonts;
            int i2 = 0;
            while (i2 < offset) {
                LOGFONT lf = this.logFonts[i2];
                if (OS.IsUnicode) {
                    OS.EnumFontFamiliesW(hDC, ((LOGFONTW)lf).lfFaceName, lpEnumFontFamProc, scalable ? 1 : 0);
                } else {
                    OS.EnumFontFamiliesA(hDC, ((LOGFONTA)lf).lfFaceName, lpEnumFontFamProc, scalable ? 1 : 0);
                }
                ++i2;
            }
        } else {
            TCHAR lpFaceName = new TCHAR(0, faceName, true);
            OS.EnumFontFamilies(hDC, lpFaceName, lpEnumFontFamProc, scalable ? 1 : 0);
        }
        this.internal_dispose_GC(hDC, null);
        int count = this.nFonts - offset;
        FontData[] result = new FontData[count];
        int i3 = 0;
        while (i3 < count) {
            LOGFONT logFont = this.logFonts[i3 + offset];
            result[i3] = FontData.win32_new(logFont, this.computePoints(logFont));
            ++i3;
        }
        callback.dispose();
        this.logFonts = null;
        return result;
    }

    String getLastError() {
        int error = OS.GetLastError();
        if (error == 0) {
            return "";
        }
        return " [GetLastError=0x" + Integer.toHexString(error) + "]";
    }

    String getLastErrorText() {
        int error = OS.GetLastError();
        if (error == 0) {
            return "";
        }
        int dwFlags = 4864;
        int[] buffer = new int[1];
        int length = OS.FormatMessage(dwFlags, 0, error, 1024, buffer, 0, 0);
        if (length == 0) {
            return " [GetLastError=0x" + Integer.toHexString(error) + "]";
        }
        TCHAR buffer1 = new TCHAR(0, length);
        OS.MoveMemory(buffer1, buffer[0], length * TCHAR.sizeof);
        if (buffer[0] != 0) {
            OS.LocalFree(buffer[0]);
        }
        return buffer1.toString(0, length);
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        int pixel = 0x2000000;
        switch (id) {
            case 1: {
                pixel = 0x2FFFFFF;
                break;
            }
            case 2: {
                pixel = 0x2000000;
                break;
            }
            case 3: {
                pixel = 0x20000FF;
                break;
            }
            case 4: {
                pixel = 0x2000080;
                break;
            }
            case 5: {
                pixel = 0x200FF00;
                break;
            }
            case 6: {
                pixel = 0x2008000;
                break;
            }
            case 7: {
                pixel = 0x200FFFF;
                break;
            }
            case 8: {
                pixel = 0x2008080;
                break;
            }
            case 9: {
                pixel = 0x2FF0000;
                break;
            }
            case 10: {
                pixel = 0x2800000;
                break;
            }
            case 11: {
                pixel = 0x2FF00FF;
                break;
            }
            case 12: {
                pixel = 0x2800080;
                break;
            }
            case 13: {
                pixel = 0x2FFFF00;
                break;
            }
            case 14: {
                pixel = 0x2808000;
                break;
            }
            case 15: {
                pixel = 0x2C0C0C0;
                break;
            }
            case 16: {
                pixel = 0x2808080;
            }
        }
        return Color.win32_new(this, pixel);
    }

    public Font getSystemFont() {
        this.checkDevice();
        int hFont = OS.GetStockObject(13);
        return Font.win32_new(this, hFont);
    }

    public boolean getWarnings() {
        this.checkDevice();
        return false;
    }

    protected void init() {
        if (this.debug && !OS.IsWinCE) {
            OS.GdiSetBatchLimit(1);
        }
        if (!OS.IsWinCE) {
            int[] ppSp = new int[1];
            int[] piNumScripts = new int[1];
            OS.ScriptGetProperties(ppSp, piNumScripts);
            this.scripts = new int[piNumScripts[0]];
            OS.MoveMemory(this.scripts, ppSp[0], this.scripts.length * 4);
        }
        int hDC = this.internal_new_GC(null);
        int rc = OS.GetDeviceCaps(hDC, 38);
        int bits = OS.GetDeviceCaps(hDC, 12);
        int planes = OS.GetDeviceCaps(hDC, 14);
        if ((rc & 0x100) == 0 || (bits *= planes) != 8) {
            this.internal_dispose_GC(hDC, null);
            return;
        }
        int numReserved = OS.GetDeviceCaps(hDC, 106);
        int numEntries = OS.GetDeviceCaps(hDC, 104);
        if (OS.IsWinCE && numReserved == 0 && numEntries >= 20) {
            numReserved = 20;
        }
        this.colorRefCount = new int[numEntries];
        byte[] logPalette = new byte[4 + 4 * numEntries];
        logPalette[0] = 0;
        logPalette[1] = 3;
        logPalette[2] = 0;
        logPalette[3] = 1;
        byte[] lppe = new byte[4 * numEntries];
        OS.GetSystemPaletteEntries(hDC, 0, numEntries, lppe);
        System.arraycopy(lppe, 0, logPalette, 4, 4 * numEntries);
        int i = 0;
        while (i < numReserved / 2) {
            this.colorRefCount[i] = 1;
            this.colorRefCount[numEntries - 1 - i] = 1;
            ++i;
        }
        this.internal_dispose_GC(hDC, null);
        this.hPalette = OS.CreatePalette(logPalette);
    }

    public abstract int internal_new_GC(GCData var1);

    public abstract void internal_dispose_GC(int var1, GCData var2);

    public boolean isDisposed() {
        return this.disposed;
    }

    void new_Object(Object object) {
        int i = 0;
        while (i < this.objects.length) {
            if (this.objects[i] == null) {
                this.objects[i] = object;
                this.errors[i] = new Error();
                return;
            }
            ++i;
        }
        Object[] newObjects = new Object[this.objects.length + 128];
        System.arraycopy(this.objects, 0, newObjects, 0, this.objects.length);
        newObjects[this.objects.length] = object;
        this.objects = newObjects;
        Error[] newErrors = new Error[this.errors.length + 128];
        System.arraycopy(this.errors, 0, newErrors, 0, this.errors.length);
        newErrors[this.errors.length] = new Error();
        this.errors = newErrors;
    }

    protected void release() {
        this.scripts = null;
        this.logFontsCache = null;
        if (this.hPalette != 0) {
            OS.DeleteObject(this.hPalette);
        }
        this.hPalette = 0;
        this.colorRefCount = null;
        this.logFonts = null;
        this.nFonts = 0;
    }

    public void setWarnings(boolean warnings) {
        this.checkDevice();
    }
}

