package monalipse.server;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;

public class RendererResource
{
	public static final int COLOR_BLACK = 0;
	public static final int COLOR_RED = 1;
	public static final int COLOR_BLUE = 2;
	public static final int COLOR_FORESTGREEN = 3;
	public static final int COLOR_BACKGROUND_GRAD = 4;
	public static final int FONT_NORMAL = 0;
	public static final int FONT_BOLD = 1;

	public Color black;
	public Color red;
	public Color blue;
	public Color forestgreen;
	public Color backgroundGray;
	private Color[] colors = new Color[5];
	public Font font;
	public Font boldFont;
	private Font[] fonts = new Font[2];
	public int lineSkip;
	
	public RendererResource(Device device)
	{
		colors[COLOR_BLACK] = black = new Color(device, 0x00, 0x00, 0x00);
		colors[COLOR_RED] = red = new Color(device, 0xff, 0x00, 0x00);
		colors[COLOR_BLUE] = blue = new Color(device, 0x00, 0x00, 0xff);
		colors[COLOR_FORESTGREEN] = forestgreen = new Color(device, 0x22, 0x8b, 0x22);
		colors[COLOR_BACKGROUND_GRAD] = backgroundGray = new Color(device, 0xef, 0xef, 0xef);
		fonts[FONT_NORMAL] = font = new Font(device, "MS P Gothic", 12, 0);
		fonts[FONT_BOLD] = boldFont = new Font(device, "MS P Gothic", 12, SWT.BOLD);
		lineSkip = 18;
	}
	
	public Color getColor(int key)
	{
		if(0 <= key && key < colors.length)
			return colors[key];
		else
			return colors[0];
	}
	
	public int getKey(Color color)
	{
		for(int i = 0; i < colors.length; i++)
		{
			if(colors[i] == color)
				return i;
		}
		return 0;
	}
	
	public Font getFont(int key)
	{
		if(0 <= key && key < fonts.length)
			return fonts[key];
		else
			return fonts[0];
	}
	
	public int getKey(Font font)
	{
		for(int i = 0; i < fonts.length; i++)
		{
			if(fonts[i] == font)
				return i;
		}
		return 0;
	}
	
	public void dispose()
	{
		for(int i = 0; i < colors.length ; i++)
		{
			if(colors[i] != null)
				colors[i].dispose();
			colors[i] = null;
		}
		for(int i = 0; i < fonts.length ; i++)
		{
			if(fonts[i] != null)
				fonts[i].dispose();
			fonts[i] = null;
		}
	}
}
