package monalipse.editors;

import java.net.MalformedURLException;
import java.net.URL;

import monalipse.MonalipsePlugin;
import monalipse.part.CancelableRunner;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.internal.IWorkbenchGraphicConstants;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class ThreadViewerEditorActionBarContributor extends EditorActionBarContributor
{
	private CancelableRunner cancelable;
	private SubStatusLineManager statusLineManager;
	private IAction reloadAction;
	private IAction abortAction;
	private IAction browserAction;
	private IAction lockToolTipAction;
	private IAction fullReloadAction;
	private IAction copyAction;
	private IAction selectAllAction;
	private IContributionItem urlContribution;
	
	public ThreadViewerEditorActionBarContributor()
	{
		makeActions();
	}
	
	public void contributeToContextMenu(IMenuManager manager)
	{
		manager.add(reloadAction);
		manager.add(fullReloadAction);
		manager.add(abortAction);
		manager.add(browserAction);
		manager.add(lockToolTipAction);

		manager.add(new Separator(ITextEditorActionConstants.GROUP_EDIT));
		manager.appendToGroup(ITextEditorActionConstants.GROUP_EDIT, copyAction);

		manager.add(new Separator(ITextEditorActionConstants.GROUP_MANAGING));
		manager.appendToGroup(ITextEditorActionConstants.GROUP_MANAGING, selectAllAction);
	}
	
	public void contributeToStatusLine(IStatusLineManager manager)
	{
		cancelable = new CancelableRunner(manager, null, abortAction);
	}

	public void contributeToToolBar(IToolBarManager manager)
	{
		manager.add(reloadAction);
		manager.add(abortAction);
		manager.add(browserAction);
	}
	
	public void setActiveEditor(IEditorPart targetEditor)
	{
		copyAction = createAction(IWorkbenchActionConstants.COPY, ITextOperationTarget.COPY, IWorkbenchGraphicConstants.IMG_CTOOL_COPY_EDIT, targetEditor);
		selectAllAction = createAction(IWorkbenchActionConstants.SELECT_ALL, ITextOperationTarget.SELECT_ALL, null, targetEditor);
	}
	
	private void makeActions()
	{
		String iconPath = "icons/"; //$NON-NLS-1$		
		URL installURL = Platform.getPlugin(MonalipsePlugin.PLUGIN_ID).getDescriptor().getInstallURL();

		reloadAction = new Action()
			{
				public void run()
				{
					IEditorPart part = getPage().getActiveEditor();
					if(part instanceof ThreadViewerEditor)
						((ThreadViewerEditor)part).updateThread();
				}
			};
		reloadAction.setText("Reload");
		reloadAction.setToolTipText("Reload thread");
		try
		{
			reloadAction.setImageDescriptor(ImageDescriptor.createFromURL(new URL(installURL, iconPath + "refresh_nav.gif"))); //$NON-NLS-1$
		}
		catch (MalformedURLException e)
		{
		}

		abortAction = new Action()
			{
				public void run()
				{
					cancelable.cancel();
				}
			};
		abortAction.setText("Abort");
		abortAction.setToolTipText("Abort all downloading thread");
		abortAction.setEnabled(false);
		try
		{
			abortAction.setImageDescriptor(ImageDescriptor.createFromURL(new URL(installURL, iconPath + "stop_nav.gif"))); //$NON-NLS-1$
		}
		catch (MalformedURLException e)
		{
		}

		browserAction = new Action()
			{
				public void run()
				{
					IEditorInput input = getPage().getActiveEditor().getEditorInput();
					if(input instanceof ThreadEditorInput)
						Program.launch(((ThreadEditorInput)input).getURLHint());
				}
			};
		browserAction.setText("Open With Web Browser");
		browserAction.setToolTipText("Open With Web Browser");
		try
		{
			browserAction.setImageDescriptor(ImageDescriptor.createFromURL(new URL(installURL, iconPath + "webbrowser_nav.gif"))); //$NON-NLS-1$
		}
		catch (MalformedURLException e)
		{
		}

		lockToolTipAction = new Action()
			{
				public void run()
				{
					IEditorPart part = getPage().getActiveEditor();
					if(part instanceof ThreadViewerEditor)
						((ThreadViewerEditor)part).lockToolTip();
				}
			};
		lockToolTipAction.setText("Lock ToolTip");
		lockToolTipAction.setToolTipText("Lock ToolTip");
		lockToolTipAction.setEnabled(false);

		fullReloadAction = new Action()
			{
				public void run()
				{
					IEditorPart part = getPage().getActiveEditor();
					if(part instanceof ThreadViewerEditor)
					{
						((ThreadViewerEditor)part).disposeCache();
						((ThreadViewerEditor)part).updateThread();
					}
				}
			};
		fullReloadAction.setText("Full Reload");
		fullReloadAction.setToolTipText("Full Reload thread");
	}
	
	private IAction createAction(final String id, final int action, String image, final IEditorPart part)
	{
		Action act = new Action(WorkbenchMessages.getString("Workbench." + id))
			{
				public void run()
				{
					if(part instanceof ThreadViewerEditor)
						((ThreadViewerEditor)part).getTextOperationTarget().doOperation(action);
				}
			};
		if(image != null)
		{
			act.setImageDescriptor(WorkbenchImages.getImageDescriptor(image));
			act.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor(image + "_DISABLED"));
			act.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor(image + "_HOVER"));
		}
		
		
		if(part instanceof ThreadViewerEditor)
			act.setEnabled(((ThreadViewerEditor)part).getTextOperationTarget().canDoOperation(action));

		getActionBars().setGlobalActionHandler(id, act);
		return act;
	}

	public void updateToolTipDependentActions()
	{
		IEditorPart part = getPage().getActiveEditor();
		if(part instanceof ThreadViewerEditor)
			lockToolTipAction.setEnabled(((ThreadViewerEditor)part).isToolTipActive());
		else
			lockToolTipAction.setEnabled(false);
	}

	public void updateSelectionDependentActions()
	{
		if(copyAction != null)
		{
			IEditorPart part = getPage().getActiveEditor();
			if(part instanceof ThreadViewerEditor)
			{
				copyAction.setEnabled(((ThreadViewerEditor)part).getTextOperationTarget().canDoOperation(ITextOperationTarget.COPY));
				selectAllAction.setEnabled(((ThreadViewerEditor)part).getTextOperationTarget().canDoOperation(ITextOperationTarget.SELECT_ALL));
			}
			else
			{
				copyAction.setEnabled(false);
				selectAllAction.setEnabled(false);
			}
		}
	}
	
	public CancelableRunner getCancelable()
	{
		return cancelable;
	}

}
