/*
 * Decompiled with CFR 0.152.
 */
package monalipse.server.giko;

import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebConversation;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import monalipse.MonalipsePlugin;
import monalipse.server.AbstractBBSServer;
import monalipse.server.IBoardListContentProvider;
import monalipse.server.IThreadContentProvider;
import monalipse.server.IThreadListContentProvider;
import monalipse.server.giko.Board;
import monalipse.server.giko.BoardListContentProvider;
import monalipse.server.giko.ThreadContentProvider;
import monalipse.server.giko.ThreadListContentProvider;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbenchWindow;

public class GikoServer
extends AbstractBBSServer {
    public static final String PREF_BBSMENU_URL = "bbsmenu.url";
    public static final String DEFAULT_BBSMENU_URL = "http://www.ff.iij4u.or.jp/~ch2/bbsmenu.html";
    public static final String PREF_OYSTER_ID = "oyster.id";
    public static final String DEFAULT_OYSTER_ID = "";
    public static final String PREF_OYSTER_PASSWORD = "oyster.password";
    public static final String DEFAULT_OYSTER_PASSWORD = "";
    public static final String USER_AGENT;
    private static final long LOGIN_INTERVAL = 3600000L;
    private static final WebConversation wc;
    private static String sessionID;
    private static long loginTime;
    private IWorkbenchWindow workbenchWindow;
    private BoardListContentProvider boardListContentProvider;
    private ThreadListContentProvider threadListContentProvider;
    static /* synthetic */ Class class$0;

    static {
        wc = new WebConversation();
        HttpUnitOptions.setDefaultCharacterSet("Windows-31J");
        HttpUnitOptions.setAutoRedirect(false);
        HttpUnitOptions.setLoggingHttpHeaders(true);
        PluginVersionIdentifier versionID = Platform.getPluginRegistry().getPluginDescriptor("monalipse").getVersionIdentifier();
        USER_AGENT = "monalipse/" + versionID;
        wc.setHeaderField("User-Agent", "Monazilla/1.00 (" + USER_AGENT + ")");
    }

    public IBoardListContentProvider getBoardListContentProvider() {
        return this.boardListContentProvider;
    }

    public void initialize(IWorkbenchWindow workbenchWindow, IProject project) {
        super.initialize(workbenchWindow, project);
        this.workbenchWindow = workbenchWindow;
        this.boardListContentProvider = new BoardListContentProvider(this.getWorkbenchWindow());
        this.threadListContentProvider = new ThreadListContentProvider(this.getWorkbenchWindow());
        IPreferenceStore pref = MonalipsePlugin.getDefault().getPreferenceStore();
        pref.setDefault(PREF_BBSMENU_URL, DEFAULT_BBSMENU_URL);
        pref.setDefault(PREF_OYSTER_ID, "");
        pref.setDefault(PREF_OYSTER_PASSWORD, "");
    }

    public String getTargetName() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("monalipse.server.giko.GikoServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getName();
    }

    public IFolder getLogFolderOf(Object board) {
        if (board instanceof Board) {
            return ((Board)board).getLogFolder();
        }
        return null;
    }

    public IThreadListContentProvider getThreadListContentProvider() {
        return this.threadListContentProvider;
    }

    public IThreadContentProvider getThreadContentProviderOf(String baseURL, IFolder logFolder, String id, String name) {
        return new ThreadContentProvider(this.workbenchWindow, baseURL, logFolder, id, 0, name, 0);
    }

    public IThreadContentProvider getThreadContentProviderOf(IProject project, URL url) {
        if (url.getProtocol().equals("http")) {
            String[] domains = BoardListContentProvider.BBS_DOMAINS;
            int i = 0;
            while (i < domains.length) {
                if (url.getHost().endsWith(domains[i])) {
                    String readCgi = "/test/read.cgi";
                    String kako = "/kako/";
                    String html = ".html";
                    String bbs = "bbs=";
                    String key = "key=";
                    String dir = url.getFile();
                    String baseURL = null;
                    IFolder logFolder = null;
                    String id = null;
                    if (dir.startsWith(readCgi)) {
                        int s = (dir = dir.substring(readCgi.length(), dir.length())).indexOf(47, 1);
                        if (s == -1) {
                            StringTokenizer tk = new StringTokenizer(dir, "?&");
                            while (tk.hasMoreTokens()) {
                                String t = tk.nextToken().toLowerCase();
                                if (t.indexOf(bbs) != -1) {
                                    baseURL = "http://" + url.getHost() + "/" + t.substring(t.indexOf(bbs) + bbs.length(), t.length()) + "/";
                                    logFolder = BoardListContentProvider.getLogFolderOf(project, baseURL);
                                    continue;
                                }
                                if (t.indexOf(key) == -1) continue;
                                id = String.valueOf(t.substring(t.indexOf(key) + key.length(), t.length())) + ".dat";
                            }
                        } else {
                            baseURL = "http://" + url.getHost() + dir.substring(0, s + 1);
                            logFolder = BoardListContentProvider.getLogFolderOf(project, baseURL);
                            int t = dir.indexOf(47, s + 1);
                            if (t == -1) {
                                t = dir.length();
                            }
                            id = String.valueOf(dir.substring(s + 1, t)) + ".dat";
                        }
                    } else if (dir.indexOf(kako) != -1 && dir.endsWith(html)) {
                        baseURL = "http://" + url.getHost() + dir.substring(0, dir.indexOf(kako) + 1);
                        logFolder = BoardListContentProvider.getLogFolderOf(project, baseURL);
                        int h = dir.indexOf(html);
                        int t = dir.lastIndexOf(47, h);
                        if (t == -1) {
                            return null;
                        }
                        id = String.valueOf(dir.substring(t + 1, h)) + ".dat";
                    }
                    if (baseURL != null && logFolder != null && id != null) {
                        return this.getThreadContentProviderOf(baseURL, logFolder, id, "?");
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public static WebConversation getWebConversation() {
        return wc;
    }

    public static void asyncExec(final IWorkbenchWindow workbenchWindow, final IRunnableWithProgress run) {
        workbenchWindow.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    workbenchWindow.run(false, false, run);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void syncExec(final IWorkbenchWindow workbenchWindow, final IRunnableWithProgress run) {
        workbenchWindow.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    workbenchWindow.run(false, false, run);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getOysterSessionID() {
        IPreferenceStore store = MonalipsePlugin.getDefault().getPreferenceStore();
        String id = store.getString(PREF_OYSTER_ID);
        String password = store.getString(PREF_OYSTER_PASSWORD);
        if (id.length() == 0) return null;
        if (password.length() == 0) return null;
        if (System.currentTimeMillis() - loginTime < 3600000L) {
            return sessionID;
        }
        try {
            BufferedReader r;
            block6: {
                String string;
                String body = "ID=" + id + "&PW=" + password;
                URLConnection conn = new URL("https://tiger2.he.net/~tora3n2c/futen.cgi").openConnection();
                conn.setRequestProperty("User-Agent", "DOLIB/1.00");
                conn.setRequestProperty("X-2ch-UA", USER_AGENT);
                conn.setRequestProperty("Content-Length", String.valueOf(body.length()));
                conn.setDoInput(true);
                conn.setDoOutput(true);
                OutputStream out = conn.getOutputStream();
                out.write(body.getBytes());
                r = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                try {
                    String res = r.readLine();
                    res = res.substring("SESSION-ID=".length(), res.length());
                    String ua = res.substring(0, res.indexOf(58));
                    if (ua.equals("ERROR")) break block6;
                    sessionID = res;
                    wc.setHeaderField("User-Agent", String.valueOf(ua) + " (" + USER_AGENT + ")");
                    loginTime = System.currentTimeMillis();
                    string = sessionID;
                    Object var9_10 = null;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    r.close();
                    throw throwable;
                }
                r.close();
                return string;
            }
            Object var9_12 = null;
            r.close();
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (IOException iOException) {}
        return null;
    }
}

