/*
 * Decompiled with CFR 0.152.
 */
package monalipse.server;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;

public class RendererResource {
    public static final int COLOR_BLACK = 0;
    public static final int COLOR_RED = 1;
    public static final int COLOR_BLUE = 2;
    public static final int COLOR_FORESTGREEN = 3;
    public static final int COLOR_BACKGROUND_GRAD = 4;
    public static final int FONT_NORMAL = 0;
    public static final int FONT_BOLD = 1;
    public Color black;
    public Color red;
    public Color blue;
    public Color forestgreen;
    public Color backgroundGray;
    private Color[] colors = new Color[5];
    public Font font;
    public Font boldFont;
    private Font[] fonts = new Font[2];
    public int lineSkip;

    public RendererResource(Device device) {
        this.colors[0] = this.black = new Color(device, 0, 0, 0);
        this.colors[1] = this.red = new Color(device, 255, 0, 0);
        this.colors[2] = this.blue = new Color(device, 0, 0, 255);
        this.colors[3] = this.forestgreen = new Color(device, 34, 139, 34);
        this.colors[4] = this.backgroundGray = new Color(device, 239, 239, 239);
        this.fonts[0] = this.font = new Font(device, "MS P Gothic", 12, 0);
        this.fonts[1] = this.boldFont = new Font(device, "MS P Gothic", 12, 1);
        this.lineSkip = 18;
    }

    public Color getColor(int key) {
        if (key >= 0 && key < this.colors.length) {
            return this.colors[key];
        }
        return this.colors[0];
    }

    public int getKey(Color color) {
        int i = 0;
        while (i < this.colors.length) {
            if (this.colors[i] == color) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public Font getFont(int key) {
        if (key >= 0 && key < this.fonts.length) {
            return this.fonts[key];
        }
        return this.fonts[0];
    }

    public int getKey(Font font) {
        int i = 0;
        while (i < this.fonts.length) {
            if (this.fonts[i] == font) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void dispose() {
        int i = 0;
        while (i < this.colors.length) {
            if (this.colors[i] != null) {
                this.colors[i].dispose();
            }
            this.colors[i] = null;
            ++i;
        }
        i = 0;
        while (i < this.fonts.length) {
            if (this.fonts[i] != null) {
                this.fonts[i].dispose();
            }
            this.fonts[i] = null;
            ++i;
        }
    }
}

