package monalipse.server.giko;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;

import monalipse.MonalipsePlugin;
import monalipse.editors.IThreadViewerEditor;
import monalipse.part.CancelableRunner;
import monalipse.server.IResponseEnumeration;
import monalipse.server.IThreadContentProvider;
import monalipse.server.ResponseData;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.xml.sax.SAXException;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpException;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;

class ThreadContentProvider implements IAdaptable, IThreadContentProvider
{
	private static final int LOG_FILE_VERSION = 3;

	private IWorkbenchWindow workbenchWindow;
	private ThreadListFragment fragment;
	private String baseURL;
	private String urlHint;
	private IFolder logFolder;
	private String id;
	private int index;
	private String name;
	private int responses;

	public ThreadContentProvider(IWorkbenchWindow workbenchWindow, String baseURL, IFolder logFolder, String id, int index, String name, int responses)
	{
		this.workbenchWindow = workbenchWindow;
		this.baseURL = baseURL;
		this.logFolder = logFolder;
		this.id = id;
		this.index = index;
		this.name = name;
		this.responses = responses;
if(logFolder == null || id == null)
{
Thread.dumpStack();
System.err.println(logFolder);
System.err.println(id);
}

		int ss = baseURL.indexOf("//");
		if(ss != -1 && id.endsWith(".dat"))
		{
			int s = baseURL.indexOf('/', ss + 2);
			urlHint = baseURL.substring(0, s) + "/test/read.cgi" +
						baseURL.substring(s, baseURL.length()) +
						id.substring(0, id.length() - 4) + "/l50";
		}
	}
	
	public void setThreadListFragment(ThreadListFragment fragment)
	{
		this.fragment = fragment;
	}

	public ThreadListFragment getThreadListFragment()
	{
		return fragment;
	}
	
	public String getBaseURL()
	{
		return baseURL;
	}
	
	public String getURLHint()
	{
		return urlHint;
	}

	public IFolder getLogFolder()
	{
		return logFolder;
	}

	public String getID()
	{
		return id;
	}
	
	public int getIndex()
	{
		return index;
	}

	public String getName()
	{
		return name;
	}
	
	public int getResponseCountHint()
	{
		return responses;
	}
	
	public Object getAdapter(Class adapter)
	{
		return null;
	}
	
	public int hashCode()
	{
		return id.hashCode();
	}
	
	public boolean equals(Object obj)
	{
		if(obj instanceof ThreadContentProvider)
		{
			ThreadContentProvider thread = (ThreadContentProvider) obj;
			return thread.logFolder.equals(logFolder) && thread.id.equals(id);
		}
		return false;
	}
	
	// int version
	// int sequence (for "a bone")
	// UTF title
	// int HTTP range start
	// int <count>
	// {
	//  UTF name
	//  UTF mail
	//  UTF date
	//  UTF body
	// }*
	public IResponseEnumeration getResponses(int sequence, int rangeStart)
	{
		DataInputStream in = null;
		try
		{
			IFile file = logFolder.getFile(id);
			MonalipsePlugin.ensureSynchronized(file);
			if(file.exists())
			{
				in = new DataInputStream(file.getContents());
				DataInputStream din = in;
				if(din.readInt() == LOG_FILE_VERSION)
				{
					int seq = din.readInt();
					String title = din.readUTF();
					boolean partial = seq == sequence;
					din.skipBytes(4);
					int count = din.readInt();
					if(partial)
					{
						try
						{
							if(count < rangeStart)
								throw new IOException();
							for(int i = 0; i < rangeStart; i++)
								skipResponseLog(din);
						}
						catch(IOException e)
						{
							din.close();
							din = new DataInputStream(file.getContents());
							din.readInt();
							din.readInt();
							din.readInt();
							return new ThreadLogReader(title, din, false, seq);
						}
					}
					return new ThreadLogReader(title, din, partial, seq);
				}
			}
		}
		catch (CoreException e)
		{
			e.printStackTrace();
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
		
		try
		{
			if(in != null)
				in.close();
		}
		catch(IOException e)
		{
			e.printStackTrace();
		}

		return new NullResponseEnumeration("?", sequence);
	}
	
	public IResponseEnumeration updateResponses(CancelableRunner cancelable, int sequence, int rangeStart)
	{
		WebConversation wc = GikoServer.getWebConversation();
		WebRequest req = new GetMethodWebRequest(baseURL + "dat/" + id);
//		req.setHeaderField("User-Agent", "Monazilla/1.00 (monalipse/0.01)");
		IFile file = logFolder.getFile(id);
		
		try
		{
			MonalipsePlugin.ensureSynchronized(file);
			if(file.exists())
			{
				DataInputStream din = new DataInputStream(file.getContents());
				try
				{
					if(din.readInt() == LOG_FILE_VERSION)
					{
						int seq = din.readInt();
						String title = din.readUTF();
						boolean partial = seq == sequence;
						if(partial)
						{
							int rangeStartByte = din.readInt();
							int count = din.readInt();
							ResponseData lastResp = null;
							List log = new ArrayList();

							if(rangeStart <= count)
							{
								while(0 < din.available())
								{
									lastResp = readResponseLog(din);
									log.add(lastResp);
								}
							}

							if(lastResp != null && rangeStart <= log.size())
							{
								req.setHeaderField("Range", "bytes=" + rangeStartByte + "-");
								WebResponse wr = wc.getResponse(req);
								if(wr.getResponseCode() == 206)
								{
									RangeAnalyzeInputStream cin = new RangeAnalyzeInputStream(rangeStartByte, wr.getInputStream());
									InputStreamReader r = new InputStreamReader(cin, "Windows-31J");
									int contentLength = 0;
									try
									{
										contentLength = Integer.parseInt(wr.getHeaderField("Content-Length"));
									}
									catch(RuntimeException e)
									{
									}
									if(lastResp.equals(readResponse(r)))
										return new ThreadDownloader(title, cancelable, r, cin, true, seq, log, rangeStart, contentLength, file);
									else
										r.close();
								}
							}
						}
					}
				}
				finally
				{
					try
					{
						din.close();
					}
					catch(IOException e)
					{
						e.printStackTrace();
					}
				}
			}
		}
		catch (MalformedURLException e)
		{
			e.printStackTrace();
		}
		catch (CoreException e)
		{
			e.printStackTrace();
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
		catch (SAXException e)
		{
			e.printStackTrace();
		}
		catch (HttpException e)
		{
			e.printStackTrace();
		}
		
		sequence++;
		
		try
		{
			req.removeHeaderField("Range");
			WebResponse wr = wc.getResponse(req);
			
			if(wr.getResponseCode() == 200)
			{
				RangeAnalyzeInputStream cin = new RangeAnalyzeInputStream(0, wr.getInputStream());
				InputStreamReader r = new InputStreamReader(cin, "Windows-31J");
				int contentLength = 0;
				try
				{
					contentLength = Integer.parseInt(wr.getHeaderField("Content-Length"));
				}
				catch(RuntimeException e)
				{
				}
				return new ThreadDownloader("?", cancelable, r, cin, false, sequence, new ArrayList(), 0, contentLength, file);
			}
		}
		catch (MalformedURLException e)
		{
			e.printStackTrace();
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
		catch (SAXException e)
		{
			e.printStackTrace();
		}
		catch (HttpException e)
		{
			e.printStackTrace();
		}
		
		return new NullResponseEnumeration("?", sequence);
	}

	private static void skipResponseLog(DataInputStream din) throws IOException
	{
		din.skipBytes(din.readShort());
		din.skipBytes(din.readShort());
		din.skipBytes(din.readShort());
		din.skipBytes(din.readShort());
	}

	private static ResponseData readResponseLog(DataInputStream din) throws IOException
	{
		return new ResponseData(din.readUTF(), din.readUTF(), din.readUTF(), din.readUTF());
	}

	private static GikoResponseData readResponse(Reader r) throws IOException
	{
		String name = readToken(r);
		String mail = readToken(r);
		String date = readToken(r);
		String body = readToken(r);
		String title = null;
		int ch = r.read();
		if(ch != -1 && ch != '\n')
		{
			StringBuffer buf = new StringBuffer();
			while(ch != -1 && ch != '\n')
			{
				buf.append((char)ch);
				ch = r.read();
			}
			title = buf.toString();
		}
		if(name != null && mail != null && date != null && body != null)
			return new GikoResponseData(name, mail, date, body, title);
		else
			return null;
	}
	
	private static String readToken(Reader r) throws IOException
	{
		StringBuffer buf = new StringBuffer(64);
		while(true)
		{
			int ch = r.read();
			if(ch == -1)
				return null;

			if(ch == '<')
			{
				ch = r.read();
				if(ch == '>')
					return buf.toString();
				
				StringBuffer tagBuf = new StringBuffer(32);
				while(ch != '>')
				{
					tagBuf.append((char)ch);
					ch = r.read();
					if(ch == -1)
						return null;
				}
				
				if(!(1 < tagBuf.length() &&
					(tagBuf.charAt(0) == 'a' || tagBuf.charAt(0) == 'A') &&
					Character.isWhitespace(tagBuf.charAt(1))))
					buf.append('<').append(tagBuf).append('>');
			}
			else
			{
				buf.append((char)ch);
			}
		}
	}
	
	private class ThreadDownloader implements IResponseEnumeration, IRunnableWithProgress
	{
		private String title;
		private Reader r;
		private RangeAnalyzeInputStream cin;
		private boolean partial;
		private int sequence;
		private List log;
		private IFile logFile;
		private int position;
		private int contentRange;
		private int contentLength;
		private boolean closed;

		public ThreadDownloader(String title, CancelableRunner cancelable, Reader r, RangeAnalyzeInputStream cin, boolean partial, int sequence, List log, int position, int contentLength, IFile logFile)
		{
			this.title = title;
			this.r = r;
			this.cin = cin;
			this.partial = partial;
			this.sequence = sequence;
			this.log = log;
			this.position = position;
			this.contentLength = contentLength;
			this.logFile = logFile;
			contentRange = cin.getRange();
			cancelable.run(null, this);
		}

		public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException
		{
			try
			{
				try
				{
					boolean get = false;
					while(true)
					{
						GikoResponseData resp = readResponse(r);
						if(resp == null)
							break;
						get = true;
						log.add(resp);
						if(log.size() == 1)
							title = resp.getTitle();
						synchronized(this)
						{
							notifyAll();
						}
						Thread.yield();
					}
					if(get)
						setLog(cin.getRange());
				}
				catch (IOException e)
				{
				}
			}
			finally
			{
				synchronized(this)
				{
					notifyAll();
					closed = true;
					try
					{
						r.close();
					}
					catch (IOException e)
					{
					}
				}
			}
		}

		private void setLog(int pos) throws IOException
		{
			ByteArrayOutputStream bout = new ByteArrayOutputStream();
			DataOutputStream dout = new DataOutputStream(bout);
			dout.writeInt(LOG_FILE_VERSION);
			dout.writeInt(sequence);
			dout.writeUTF(title);
			dout.writeInt(pos);
			dout.writeInt(log.size());
			for(int i = 0; i < log.size(); i++)
			{
				ResponseData resp = (ResponseData)log.get(i);
				dout.writeUTF(resp.getName());
				dout.writeUTF(resp.getMail());
				dout.writeUTF(resp.getDate());
				dout.writeUTF(resp.getBody());
			}
			dout.close();
			final byte[] bytes = bout.toByteArray();
			GikoServer.asyncExec(workbenchWindow, new WorkspaceModifyOperation()
				{
					protected void execute(IProgressMonitor monitor) throws InvocationTargetException
					{
						try
						{
							IFile cache = logFolder.getFile(id);
							MonalipsePlugin.ensureSynchronized(cache);
							if(cache.exists())
								cache.setContents(new ByteArrayInputStream(bytes), false, false, monitor);
							else
								cache.create(new ByteArrayInputStream(bytes), false, monitor);
						}
						catch (CoreException e)
						{
							throw new InvocationTargetException(e);
						}
					}
				});
		}
		
		public int getSequenceNumber()
		{
			return sequence;
		}
		
		public String getTitle()
		{
			return title;
		}
	
		public boolean isPartialContent()
		{
			return partial;
		}

		public boolean isReady()
		{
			return !closed && position < log.size();
		}

		public boolean hasNextResponse()
		{
			return !closed || position < log.size();
		}

		public ResponseData getNextResponse() throws InterruptedException
		{
			synchronized(this)
			{
				while(!closed && position == log.size())
					wait();
			}
			if(position < log.size())
				return (ResponseData)log.get(position++);
			else
				return null;
		}
		
		public int getProgressHint()
		{
			if(contentLength == 0)
				return 100;
			else
				return Math.max((cin.getRange() - contentRange) * 100 / contentLength, 100);
		}
		
		public void close()
		{
		}
	}
	
	private static class RangeAnalyzeInputStream extends InputStream
	{
		private int range;
		private int lf;
		private int count;
		private InputStream in;

		public RangeAnalyzeInputStream(int range, InputStream in)
		{
			this.range = range;
			this.in = in;
			lf = range;
			count = range;
		}
		
		public int getRange()
		{
			return range;
		}
		
		public int read() throws IOException
		{
			int r = in.read();
			if(r == '\n')
			{
				range = lf;
				lf = count + 1;
			}
			count++;
			return r;
		}
		
		public int read(byte[] b) throws IOException
		{
			int r = in.read(b);
			for(int i = 0; i < r; i++)
			{
				if(b[i] == '\n')
				{
					range = lf;
					lf = count + i + 1;
				}
			}
			count += r;
			return r;
		}
		
		public int read(byte[] b, int off, int len) throws IOException
		{
			int r = in.read(b, off, len);
			int end = off + len;
			for(int i = off; i < end; i++)
			{
				if(b[i] == '\n')
				{
					range = lf;
					lf = count + i - off + 1;
				}
			}
			count += r;
			return r;
		}
	}
	
	private static class ThreadLogReader implements IResponseEnumeration
	{
		private String title;
		private DataInputStream din;
		private int sequence;
		private boolean partial;
		
		public ThreadLogReader(String title, DataInputStream din, boolean partial, int sequence)
		{
			this.title = title;
			this.din = din;
			this.sequence = sequence;
			this.partial = partial;
		}
		
		public int getSequenceNumber()
		{
			return sequence;
		}
		
		public String getTitle()
		{
			return title;
		}
		
		public boolean isPartialContent()
		{
			return partial;
		}

		public boolean isReady()
		{
			return hasNextResponse();
		}

		public boolean hasNextResponse()
		{
			try
			{
				return 0 < din.available();
			}
			catch (IOException e)
			{
				try
				{
					din.close();
				}
				catch (IOException e2)
				{
				}
				return false;
			}
		}

		public ResponseData getNextResponse()
		{
			try
			{
				return readResponseLog(din);
			}
			catch (IOException e)
			{
				try
				{
					din.close();
				}
				catch (IOException e2)
				{
				}
				return null;
			}
		}
		
		public int getProgressHint()
		{
			return 100;
		}
		
		public void close()
		{
			try
			{
				din.close();
			}
			catch (IOException e)
			{
			}
		}
	}
	
	private static class NullResponseEnumeration implements IResponseEnumeration
	{
		private String title;
		private int sequence;

		public NullResponseEnumeration(String title, int sequence)
		{
			this.title = title;
			this.sequence = sequence;
		}

		public int getSequenceNumber()
		{
			return sequence;
		}
		
		public String getTitle()
		{
			return title;
		}

		public boolean isPartialContent()
		{
			return true;
		}

		public boolean isReady()
		{
			return false;
		}

		public boolean hasNextResponse()
		{
			return false;
		}

		public ResponseData getNextResponse()
		{
			return null;
		}
		
		public int getProgressHint()
		{
			return 100;
		}
		
		public void close()
		{
		}
	}
	
	private static class GikoResponseData extends ResponseData
	{
		private String title;

		public GikoResponseData(String name, String mail, String date, String body, String title)
		{
			super(name, mail, date, body);
			this.title = title;
		}
		
		public String getTitle()
		{
			return title;
		}
	}

}
