package monalipse.server.giko;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;

import monalipse.server.AbstractBBSServer;
import monalipse.server.IBoardListContentProvider;
import monalipse.server.IThreadContentProvider;
import monalipse.server.IThreadListContentProvider;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IWorkbenchWindow;

import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebConversation;

public class GikoServer extends AbstractBBSServer
{
	static
	{
		HttpUnitOptions.setDefaultCharacterSet("Windows-31J");
		HttpUnitOptions.setAutoRedirect(false);
		HttpUnitOptions.setLoggingHttpHeaders(true);
	}

	private static WebConversation wc = new WebConversation();
	
	private IWorkbenchWindow workbenchWindow;
	private BoardListContentProvider boardListContentProvider;
	private ThreadListContentProvider threadListContentProvider;

	public IBoardListContentProvider getBoardListContentProvider()
	{
		return boardListContentProvider;
	}
	
	public void initialize(IWorkbenchWindow workbenchWindow, IProject project)
	{
		super.initialize(workbenchWindow, project);
		this.workbenchWindow = workbenchWindow;
		boardListContentProvider = new BoardListContentProvider(getWorkbenchWindow());
		threadListContentProvider = new ThreadListContentProvider(getWorkbenchWindow());
	}
	
	public String getTargetName()
	{
		return GikoServer.class.getName();
	}
	
	public IFolder getLogFolderOf(Object board)
	{
		if(board instanceof Board)
			return ((Board)board).getLogFolder();
		else
			return null;
	}

	public IThreadListContentProvider getThreadListContentProvider()
	{
		return threadListContentProvider;
	}
	
	public boolean isSupported(URL url)
	{
		if(url.getProtocol().equals("http"))
		{
			String[] domains = BoardListContentProvider.BBS_DOMAINS;
			for(int i = 0; i < domains.length; i++)
			{
				if(url.getHost().endsWith(domains[i]))
				{
					return url.getFile().startsWith("/test/read.cgi");
				}
			}
		}
		return false;
	}
	
	public IThreadContentProvider getThreadContentProviderOf(String baseURL, IFolder logFolder, String id, String name)
	{
		return new ThreadContentProvider(workbenchWindow, baseURL, logFolder, id, 0, name, 0);
	}
	
	public IThreadContentProvider getThreadContentProviderOf(IProject project, URL url)
	{
		String readCgi = "/test/read.cgi";
		String dir = url.getFile();
		if(dir.startsWith(readCgi))
		{
			dir = dir.substring(readCgi.length(), dir.length());
			int s = dir.indexOf('/', 1);
			if(s != -1)
			{
				String baseURL = "http://" + url.getHost() + dir.substring(0, s + 1);
				IFolder logFolder = BoardListContentProvider.getLogFolderOf(project, baseURL);
				if(logFolder == null)
					return null;
				int t = dir.indexOf('/', s + 1);
				if(t == -1)
					t = dir.length();
				String id = dir.substring(s + 1, t) + ".dat";
				return getThreadContentProviderOf(baseURL, logFolder, id, "?");
			}
		}
		return null;
	}
	
	public static WebConversation getWebConversation()
	{
		return wc;
	}

	public static void asyncExec(final IWorkbenchWindow workbenchWindow, final IRunnableWithProgress run)
	{
		workbenchWindow.getShell().getDisplay().asyncExec(new Runnable()
			{
				public void run()
				{
					try
					{
						workbenchWindow.run(false, false, run);
					}
					catch(InterruptedException e)
					{
						e.printStackTrace();
					}
					catch(InvocationTargetException e)
					{
						e.printStackTrace();
					}
				}
			});
	}

	public static void syncExec(final IWorkbenchWindow workbenchWindow, final IRunnableWithProgress run)
	{
		workbenchWindow.getShell().getDisplay().syncExec(new Runnable()
			{
				public void run()
				{
					try
					{
						workbenchWindow.run(false, false, run);
					}
					catch(InterruptedException e)
					{
						e.printStackTrace();
					}
					catch(InvocationTargetException e)
					{
						e.printStackTrace();
					}
				}
			});
	}

}
