package monalipse.editors.win32;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import monalipse.MonalipsePlugin;
import monalipse.editors.IThreadViewerEditor;
import monalipse.editors.ThreadEditorInput;
import monalipse.editors.ThreadViewerEditorActionBarContributor;
import monalipse.part.CancelableRunner;
import monalipse.server.BBSServerManager;
import monalipse.server.IBBSServer;
import monalipse.server.IResponseEnumeration;
import monalipse.server.IThreadContentProvider;
import monalipse.server.ResponseData;
import monalipse.views.ThreadListView;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class ThreadViewerEditorWin32 extends EditorPart implements IThreadViewerEditor
{
	private ThreadEditorInput input;
	private IThreadContentProvider content;
//	private String tooltipText;
	private Display display;
	private boolean oleActivated;
	private OleFrame webFrame;
	private OleControlSite webControlSite;
	private OleWebBrowser webBrowser;
	private Object navigateSignal = new Object();
	private boolean navigateCompleted;
	private String header;
	private String bodyWithoutBorder;
	private String bodyWithBorder;
	private int sequence;
	private int markKey = -1;
	private int responseCount;
	private Pattern numRefPattern = Pattern.compile("((&gt;)|\uff1e)+(([0-9]+)(->*([0-9]+))?)");
	private Pattern urlRefPattern = Pattern.compile("(((h?t)?t)?p)?(s?://[\\p{Alnum}\\.\\-_]+(/[\\p{Alnum}!#%&'*+,-./:;=?@\\\\^_`\\|~]*)?)");
	private OleHTMLPopup popup;
	private OleListener linkListener = new LinkListener();
	private Image reloadImage;
	
	public ThreadViewerEditorWin32()
	{
		StringBuffer buf = new StringBuffer();
		buf.append("<html>").append("\n");
		buf.append("<style type='text/css'>").append("\n");
		buf.append("<!--").append("\n");
		buf.append("BODY{").append("\n");
		buf.append(" font-size: 12pt;").append("\n");
		buf.append(" font-family: 'MS PGothic'").append("\n");
		buf.append("}").append("\n");
		buf.append("SPAN.link{").append("\n");
		buf.append(" color: blue;").append("\n");
		buf.append(" text-decoration: underline;").append("\n");
		buf.append(" cursor: pointer;").append("\n");
		buf.append("}").append("\n");
		buf.append("-->").append("\n");
		buf.append("</style>").append("\n");
		header = buf.toString();

		bodyWithoutBorder = "<body bgcolor='#efefef' text='black' link='blue' alink='red' vlink='#660099' style='border:none' onContextMenu='return false;'><dl>\n";
		bodyWithBorder = "<body bgcolor='#efefef' text='black' link='blue' alink='red' vlink='#660099' style='border:solid gray 1px' onContextMenu='return false;'><dl>\n";
	}

	public void doSave(IProgressMonitor monitor)
	{
	}

	public void doSaveAs()
	{
	}

	public void gotoMarker(IMarker marker)
	{
	}

	public void init(IEditorSite site, IEditorInput input) throws PartInitException
	{
		setSite(site);
		setInput(input);
		
		if(input instanceof ThreadEditorInput)
			this.input = (ThreadEditorInput)input;
	}

	public boolean isDirty()
	{
		return false;
	}

	public boolean isSaveAsAllowed()
	{
		return false;
	}
	
//	public String getTitleToolTip()
//	{
//		if(tooltipText == null)
//			return super.getTitleToolTip();
//		else
//			return tooltipText;
//	}
	
	public void createPartControl(Composite parent)
	{
		display = parent.getShell().getDisplay();

		webFrame = new OleFrame(parent, SWT.NONE);
		try
		{
			webControlSite = new OleControlSite(webFrame, SWT.NONE, "Shell.Explorer");
			OleAutomation oleAutomation = new OleAutomation(webControlSite);
			webBrowser = new OleWebBrowser(oleAutomation);
		}
		catch (SWTException ex)
		{
			Label label = new Label(webFrame, SWT.BORDER);
			label.setText(MonalipsePlugin.getResourceString("error.CouldNotCreateBrowserControl"));
			return;
		}

		webControlSite.addPropertyListener(OleWebBrowser.DISPID_READYSTATE, new OleListener()
			{
				public void handleEvent(OleEvent event)
				{
					if(event.detail == OLE.PROPERTY_CHANGING)
						return;
					if(webBrowser.getReadyState() == OleWebBrowser.READYSTATE_COMPLETE)
					{
						synchronized(navigateSignal)
						{
							navigateSignal.notifyAll();
						}
					}
				}
			});

		oleActivated = (webControlSite.doVerb(OLE.OLEIVERB_INPLACEACTIVATE) == OLE.S_OK);

		if(oleActivated)
		{
			display.asyncExec(new Runnable()
				{
					public void run()
					{
						CancelableRunner cancelable = ((ThreadViewerEditorActionBarContributor)getEditorSite().getActionBarContributor()).getCancelable();
						cancelable.setDisplay(display);
						cancelable.run(ThreadViewerEditorWin32.this, new IRunnableWithProgress()
							{
								public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException
								{
									navigateBlank();
									updateThread(false);
									getSite().getPage().addPartListener(new PartActivationListener());
									loadScrollPosition();
								}
							});
					}
				});
			
			hookContextMenu();
		}

		String iconPath = "icons/"; //$NON-NLS-1$		
		URL installURL = Platform.getPlugin(MonalipsePlugin.PLUGIN_ID).getDescriptor().getInstallURL();
		try
		{
			reloadImage = new Image(display, new URL(installURL, iconPath + "refresh_nav.gif").openStream());
		}
		catch (MalformedURLException e)
		{
		}
		catch (IOException e)
		{
		}

	}

	private void hookContextMenu()
	{
		MenuManager menuMgr = new MenuManager("#PopupMenu");
		menuMgr.setRemoveAllWhenShown(true);
		menuMgr.addMenuListener(new IMenuListener()
			{
				public void menuAboutToShow(IMenuManager manager)
				{
					ThreadViewerEditorActionBarContributor cont = (ThreadViewerEditorActionBarContributor)getEditorSite().getActionBarContributor();
					cont.contributeToContextMenu(manager);
				}
			});
		Menu menu = menuMgr.createContextMenu(webFrame);
		webFrame.setMenu(menu);
	}

	private void navigateBlank() throws InterruptedException
	{
		synchronized(navigateSignal)
		{
			navigateCompleted = false;
			display.asyncExec(new Runnable()
				{
					public void run()
					{
						webBrowser.navigate("about:blank");
					}
				});
			navigateSignal.wait();
			navigateCompleted = true;
		}
		display.asyncExec(new Runnable()
			{
				public void run()
				{
					OleHTMLDocument document = webBrowser.getDocument();
					document.write(header);
					document.write(bodyWithoutBorder);
					document.dispose();
				}
			});
	}

	public void updateThread()
	{
		display.asyncExec(new Runnable()
			{
				public void run()
				{
					CancelableRunner cancelable = ((ThreadViewerEditorActionBarContributor)getEditorSite().getActionBarContributor()).getCancelable();
					cancelable.run(null, new IRunnableWithProgress()
						{
							public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException
							{
								synchronized(navigateSignal)
								{
									try
									{
										if(!navigateCompleted)
											navigateSignal.wait();
									}
									catch (InterruptedException e)
									{
									}
								}
								
								CancelableRunner cancelable = ((ThreadViewerEditorActionBarContributor)getEditorSite().getActionBarContributor()).getCancelable();
								cancelable.run(ThreadViewerEditorWin32.this, new IRunnableWithProgress()
									{
										public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException
										{
											updateThread(true);
										}
									});
							}
						});
				}
			});
	}

	private IThreadContentProvider getContentProvider()
	{
		if(content == null)
		{
			IBBSServer server = BBSServerManager.getInstanceOf(input.getLogFolder().getProject(), getSite().getWorkbenchWindow());
			content = server.getThreadContentProviderOf(input.getBaseURL(), input.getLogFolder(), input.getID(), input.getName());
		}
		return content;
	}
	
	private void updateThread(final boolean download)
	{
		if(oleActivated)
		{
			final CancelableRunner cancelable = ((ThreadViewerEditorActionBarContributor)getEditorSite().getActionBarContributor()).getCancelable();
			cancelable.runAndJoin(null, new IRunnableWithProgress()
				{
					public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException
					{
						monitor.beginTask("getting thread", 130);
						IThreadContentProvider thread = getContentProvider();
						final OleHTMLDocument document = webBrowser.getDocument();
						IResponseEnumeration e;
						monitor.worked(10);
						if(download)
							e = thread.updateResponses(cancelable, sequence, responseCount);
						else
							e = thread.getResponses(sequence, responseCount);
						monitor.worked(10);
						try
						{
							StringBuffer buf = new StringBuffer(10240);
							if(e == null)
								return;
							try
							{
								if(!e.isPartialContent())
								{
									responseCount = 0;
									getSite().getShell().getDisplay().syncExec(new Runnable()
										{
											public void run()
											{
												document.open("about:blank", "_blank");
												document.write(header);
												document.write(bodyWithoutBorder);
												OleHTMLElement html = document.getDocumentElement();
												OleAutomation automation = html.getAutomation();
												webControlSite.addEventListener(automation, OleWebBrowser.OnClick, linkListener);
												webControlSite.addEventListener(automation, OleWebBrowser.OnMouseMove, linkListener);
												webControlSite.addEventListener(automation, OleWebBrowser.OnMouseOver, linkListener);
												webControlSite.addEventListener(automation, OleWebBrowser.OnMouseUp, linkListener);
												html.dispose();
											}
										});
								}

								monitor.worked(10);
								
								boolean showNew = false;
								
								if(download)
								{
									buf.append("<style type='text/css'>");
									buf.append("<!--");
									buf.append("SPAN.mark").append(markKey).append("{");
									buf.append(" color: black; ");
									buf.append("} ");
									buf.append("SPAN.mark").append(responseCount).append("{");
									buf.append(" color: red; ");
									buf.append("}");
									buf.append("-->");
									buf.append("</style>").append("\n");
									markKey = responseCount;
									
									if(responseCount != 0 && saveScrollPosition() == responseCount - 1)
										showNew = true;
								}
								
								final int scrollTo = showNew ? (responseCount - 1) : -1;

								long bulkWrite = System.currentTimeMillis();
								try
								{
									int respWork = 0;
									while(e.hasNextResponse())
									{
										int newWork = e.getProgressHint();
										if(respWork < newWork)
										{
											monitor.worked(newWork - respWork);
											respWork = newWork;
										}
										ResponseData resp = e.getNextResponse();
										if(resp != null)
										{
											if(responseCount == 0)
											{
												input.setTitle(e.getTitle());
												getSite().getShell().getDisplay().syncExec(new Runnable()
													{
														public void run()
														{
															setTitle(input.getTitle());
														}
													});
												buf.append("<font size='+1' color='red'>");
												buf.append(input.getTitle());
												buf.append("</font><p>\n");
											}

											responseCount++;
											buf.append("<span id='n").append(responseCount).append("'><dt><a name='a").append(responseCount);
											buf.append("'></a>").append(responseCount).append("&nbsp;");
											buf.append("&nbsp;<font color='forestgreen'><b>").append(resp.getName()).append("</b></font>");
											buf.append("&nbsp;<font color='blue'><b>").append(resp.getMail()).append("</b></font>");
											buf.append("&nbsp;<span class='mark").append(markKey).append("'>").append(resp.getDate()).append("</span>");
											buf.append("<dd>").append(filterLink(resp.getBody())).append("</span><br><br>\n");
											if(responseCount < 10 || 100 < System.currentTimeMillis() - bulkWrite)
											{
												final String fragment = buf.toString();
												buf = new StringBuffer(10240);
												bulkWrite = System.currentTimeMillis();
												getSite().getShell().getDisplay().syncExec(new Runnable()
													{
														public void run()
														{
															document.write(fragment);
														}
													});
											}
											
											if(responseCount == 1)
											{
												String bodyText = resp.getBody();
												Matcher m;
												m = Pattern.compile("<br>").matcher(bodyText);
												bodyText = m.replaceAll("\n");
												String tooltipText = input.getTitle() + "\n" + input.getURLHint() + "\n" + resp.getName() + " <" + resp.getMail() + "> " + resp.getDate() + "\n" + bodyText;
												input.setToolTipText(tooltipText);
												getSite().getShell().getDisplay().syncExec(new Runnable()
													{
														public void run()
														{
															setTitleToolTip(input.getToolTipText());
															setTitle(input.getTitle());
														}
													});
											}
										}
									}
								}
								catch (InterruptedException ex)
								{
								}
								finally
								{
									if(0 < buf.length())
									{
										final String fragment = buf.toString();
										getSite().getShell().getDisplay().syncExec(new Runnable()
											{
												public void run()
												{
													document.write(fragment);
												}
											});
									}
								}

								sequence = e.getSequenceNumber();
								
								if(showNew)
								{
									webFrame.getDisplay().asyncExec(new Runnable()
										{
											public void run()
											{
												OleHTMLDocument document = webBrowser.getDocument();
												OleHTMLElement body = document.getDocumentElement();
												OleHTMLElementCollection c = body.getElementsByTagName("dt");
												if(0 <= scrollTo && scrollTo < c.getLength())
												{
													OleHTMLElement item = c.getItem(scrollTo);
													document.setScrollTop(item.getOffsetTop());
													document.setScrollLeft(0);
													item.dispose();
												}
												c.dispose();
												body.dispose();
												document.dispose();
											}
										});
								}
							}
							finally
							{
								e.close();
							}
						}
						finally
						{
							document.dispose();
							monitor.done();
						}
					}
				});
		}
	}

	private String filterLink(String body)
	{
		Matcher m;
		StringBuffer buf = new StringBuffer();

		m = numRefPattern.matcher(body);
		buf = new StringBuffer();
		while(m.find())
			m.appendReplacement(buf, "<span class='link' href='#" + m.group(4) + "-" + m.group(6) + "'>" + m.group() + "</span>");
		m.appendTail(buf);

		m = urlRefPattern.matcher(buf.toString());
		buf = new StringBuffer();
		while(m.find())
			m.appendReplacement(buf, "<span class='link' href='http" + m.group(4) + "'>" + m.group() + "</span>");
		m.appendTail(buf);

		return buf.toString();
	}
	

	private int saveScrollPosition()
	{
		final int[] res = new int[]{-1};
		if(oleActivated)
		{
			webFrame.getDisplay().syncExec(new Runnable()
				{
					public void run()
					{
						int read = -1;
						OleHTMLDocument document = webBrowser.getDocument();
						OleHTMLElement body = document.getDocumentElement();
						OleHTMLElementCollection c = body.getElementsByTagName("dd");
						int bottom = document.getScrollTop() + webFrame.getSize().y;
						int start = 0;
						int end = c.getLength();
						while(1 < end - start)
						{
							int mid = start + (end - start) / 2;
							OleHTMLElement dd = c.getItem(mid);
							int offsetTop = dd.getOffsetTop();
							int offsetHeight = dd.getOffsetHeight();
							dd.dispose();
							if(offsetTop < bottom && bottom < offsetTop + offsetHeight)
							{
								read = mid;
								break;
							}
							else if(offsetTop < bottom)
							{
								start = mid;
							}
							else
							{
								end = mid;
							}
						}
						if(read == -1)
							read = start;
						c.dispose();
						body.dispose();
						document.dispose();
			
						try
						{
							if(read != -1)
								input.getLogFolder().setPersistentProperty(new QualifiedName(IThreadViewerEditor.class.getName(), input.getID() + ".read"), String.valueOf(read + 1));
						}
						catch (CoreException e)
						{
							e.printStackTrace();
						}
						
						res[0] = read;
					}
				});
		}
		return res[0];
	}
	
	private void loadScrollPosition()
	{
		if(oleActivated)
		{
			try
			{
				final int read = Integer.parseInt(input.getLogFolder().getPersistentProperty(new QualifiedName(IThreadViewerEditor.class.getName(), input.getID() + ".read"))) - 1;
				webFrame.getDisplay().asyncExec(new Runnable()
					{
						public void run()
						{
							OleHTMLDocument document = webBrowser.getDocument();
							OleHTMLElement body = document.getDocumentElement();
							OleHTMLElementCollection c = body.getElementsByTagName("dd");
							if(0 <= read && read < c.getLength())
							{
								OleHTMLElement item = c.getItem(read);
								item.scrollIntoView(false);
								document.setScrollLeft(0);
								item.dispose();
							}
							c.dispose();
							body.dispose();
							document.dispose();
						}
					});
			}
			catch(CoreException e)
			{
			}
			catch(RuntimeException e)
			{
			}
		}
	}

	public void setFocus()
	{
		webFrame.setFocus();
	}
	
	public void dispose()
	{
		if(oleActivated)
		{
			webControlSite.deactivateInPlaceClient();
			oleActivated = false;
		}
		if(webBrowser != null)
			webBrowser.dispose();
		webBrowser = null;
		if(webControlSite != null)
			webControlSite.dispose();
		webControlSite = null;
		if(webFrame != null)
			webFrame.dispose();
		webFrame = null;
		if(reloadImage != null)
			reloadImage.dispose();
		reloadImage = null;
		super.dispose();
	}
	
	private class PartActivationListener implements IPartListener
	{
		private boolean active = true;

		public void partActivated(IWorkbenchPart part)
		{
			active = true;
		}

		public void partBroughtToTop(IWorkbenchPart part)
		{
		}

		public void partClosed(IWorkbenchPart part)
		{
		}

		public void partDeactivated(IWorkbenchPart part)
		{
			if(part == ThreadViewerEditorWin32.this && active)
			{
				saveScrollPosition();
				active = false;
			}
		}

		public void partOpened(IWorkbenchPart part)
		{
		}
	}

	private class LinkListener implements OleListener
	{
		private Rectangle anchorRect = new Rectangle(0, 0, 0, 0);
		private boolean popupPin;

		public void handleEvent(OleEvent event)
		{
			Point pt = webFrame.toControl(webFrame.getDisplay().getCursorLocation());
			OleHTMLDocument document = webBrowser.getDocument();
			OleHTMLElement e = document.elementFromPoint(pt.x, pt.y);
//if(e != null)
//System.err.println(e.getTagName() + " " + e.getAttribute("id"));
			switch(event.type)
			{
			case OleWebBrowser.OnClick:
				onClick(document, e);
				break;

			case OleWebBrowser.OnMouseMove:
				onMouseMove(document, e);
				break;

			case OleWebBrowser.OnMouseOver:
				onMouseOver(document, e);
				break;

			case OleWebBrowser.OnMouseOut:
				onMouseOut(document, e);
				break;
			
			case OleWebBrowser.OnMouseUp:
				OleHTMLWindow window = document.getParentWindow();
				OleHTMLEvent eventObj = window.getEvent();
				onMouseUp(document, e, eventObj);
				eventObj.dispose();
				window.dispose();
				break;
			}
			e.dispose();
			document.dispose();

		}
		
		private void onMouseUp(OleHTMLDocument document, OleHTMLElement e, OleHTMLEvent event)
		{
			if(event.getInt("button") == 2)
			{
				Menu menu = webFrame.getMenu();
				Point pt = webFrame.getDisplay().getCursorLocation();
				menu.setLocation(pt.x + 2, pt.y + 2);
				menu.setVisible(true);
			}
		}
		
		private void onClick(OleHTMLDocument document, OleHTMLElement e)
		{
			String href = getLink(e);
			if(href != null)
			{
				if(href.startsWith("#"))
				{
					try
					{
						int ref = Integer.parseInt(href.substring(1, href.indexOf('-'))) - 1;
						OleHTMLElement html = document.getDocumentElement();
						OleHTMLElementCollection c = html.getElementsByTagName("dt");
						if(0 <= ref && ref < c.getLength())
						{
							OleHTMLElement dt = c.getItem(ref);
							dt.scrollIntoView(true);
							dt.dispose();
						}
						c.dispose();
						html.dispose();
					}
					catch (RuntimeException ex)
					{
					}
				}
				else if(0 < href.length())
				{
					try
					{
						IThreadContentProvider thread = BBSServerManager.getThreadContentProviderOf(new URL(href), getSite().getWorkbenchWindow());
						if(thread != null)
						{
							IWorkbenchPage page = getSite().getWorkbenchWindow().getActivePage();
							try
							{
								IEditorPart part = page.openEditor(new ThreadEditorInput(thread), ThreadViewerEditorWin32.class.getName());
								if(part instanceof IThreadViewerEditor)
									((IThreadViewerEditor)part).updateThread();
							}
							catch(PartInitException ex)
							{
								ex.printStackTrace();
							}
						}
						else
						{
							Program.launch(href);
						}
					}
					catch (MalformedURLException ex)
					{
						ex.printStackTrace();
					}
				}
			}
		}
		
		private void onMouseMove(OleHTMLDocument document, OleHTMLElement e)
		{
			Point pt = webFrame.toControl(webFrame.getDisplay().getCursorLocation());
			if(!anchorRect.contains(pt))
				closePopup();
		}
		
		private boolean onMouseOver(OleHTMLDocument document, OleHTMLElement e)
		{
			String href = getLink(e);
			if(href != null)
			{
				if(href.startsWith("#"))
				{
					int start = Integer.parseInt(href.substring(1, href.indexOf('-')));
					int end = start;
					try
					{
						end = Integer.parseInt(href.substring(href.indexOf('-') + 1, href.length()));
					}
					catch(RuntimeException ex)
					{
					}

					if(popup != null)
						popup.hide();
					popupPin = false;

					OleHTMLScript script = document.getScript();
					popup = script.createPopup();
					script.dispose();

					OleHTMLDocument popupDocument = popup.getDocument();
					popupDocument.write(header);
					popupDocument.write(bodyWithBorder);

					OleHTMLElement popupBody = popupDocument.getBody();

					if(1 <= start && start <= responseCount)
					{
						OleHTMLElement span = document.getElementById("n" + start);
						if(span != null)
						{
							popupDocument.write(span.getInnerHTML());
							span.dispose();
						}
					}
					for(int i = start + 1; 1 <= i && i <= responseCount && i <= end; i++)
					{
						OleHTMLElement span = document.getElementById("n" + i);
						if(span != null)
						{
							popupDocument.write("<br><br>");
							popupDocument.write(span.getInnerHTML());
							span.dispose();
						}
					}
					
					popupDocument.dispose();

					final Point pt = webFrame.toControl(webFrame.getDisplay().getCursorLocation());
					pt.x += 8;
					pt.y += 8;
					int width = Math.min(webFrame.getSize().x, 640);
					OleHTMLElement body = document.getBody();
					popup.show(pt.x, pt.y, width, 50, body.getAutomation());
					OleHTMLElementCollection dls = popupBody.getElementsByTagName("dl");
					OleHTMLElement dl = dls.getItem(0);
					if(dl != null)
					{
						popup.show(pt.x, pt.y, width, Math.min(dl.getOffsetHeight() + 50, 400), body.getAutomation());
						dl.dispose();
					}
					dls.dispose();
					body.dispose();

					popupBody.dispose();

					Point scrollLocation = document.getScrollLocation();
					anchorRect = new Rectangle(e.getOffsetLeft() - scrollLocation.x, e.getOffsetTop() - scrollLocation.y, e.getOffsetWidth() + 1, e.getOffsetHeight() + 1);

					webControlSite.addEventListener(popup.getDocument().getDocumentElement().getAutomation(), OleWebBrowser.OnMouseMove, this);
//					webControlSite.addEventListener(popup.getDocument().getDocumentElement().getAutomation(), OleWebBrowser.OnMouseOver, new OleListener()
//						{
//							public void handleEvent(OleEvent event)
//							{
//								Point pt = webFrame.toControl(webFrame.getDisplay().getCursorLocation());
//								OleHTMLDocument document = popup.getDocument();
//								OleHTMLWindow window = document.getParentWindow();
//								OleHTMLEvent eventObj = window.getEvent();
//								OleHTMLElement e = document.elementFromPoint(eventObj.getInt("x"), eventObj.getInt("y"));
//								if(e != null)
//								{
//System.err.println(e.getTagName());
//									if(onMouseOver(document, e))
//										popupPin = true;
//								}
//								eventObj.dispose();
//								window.dispose();
//								document.dispose();
//							}
//						});
					webControlSite.addEventListener(popup.getDocument().getDocumentElement().getAutomation(), OleWebBrowser.OnClick, new OleListener()
						{
							public void handleEvent(OleEvent event)
							{
								popupPin = true;
							}
						});
						
					return true;
				}
			}
			
			return false;
		}
		
		private void onMouseOut(OleHTMLDocument document, OleHTMLElement e)
		{
//			closePopup();
		}
		
		private String getLink(OleHTMLElement e)
		{
			String tag = e.getTagName();
			if(tag != null && tag.equalsIgnoreCase("span"))
				return e.getAttribute("href");
			else
				return null;
		}

		private void closePopup()
		{
			if(!popupPin && popup != null)
			{
				popup.hide();
				popup = null;
			}
		}
	}
}
