package monalipse.editors.win32;

import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.Variant;

public class OleWebBrowser extends OleAutomationDelegate
{
	// Constants for WebBrowser CommandStateChange
	public static final int CSC_UPDATECOMMANDS = -1;
	public static final int CSC_NAVIGATEFORWARD = 1;
	public static final int CSC_NAVIGATEBACK = 2;

	// COnstants for Web Browser ReadyState
	public static final int READYSTATE_UNINITIALIZED = 0;
	public static final int READYSTATE_LOADING = 1;
	public static final int READYSTATE_LOADED = 2;
	public static final int READYSTATE_INTERACTIVE = 3;
	public static final int READYSTATE_COMPLETE = 4;

	// Web Browser Control Events 
	public static final int BeforeNavigate = 100; // Fired when a new hyperlink is being navigated to.
	public static final int NavigateComplete = 101; // Fired when the document being navigated to becomes visible and enters the navigation stack.
	public static final int StatusTextChange = 102; // Statusbar text changed.
	public static final int ProgressChange = 108; // Fired when download progress is updated.
	public static final int DownloadComplete = 104; // Download of page complete.
	public static final int CommandStateChange = 105; // The enabled state of a command changed
	public static final int DownloadBegin = 106; // Download of a page started.
	public static final int NewWindow = 107; // Fired when a new window should be created.
	public static final int TitleChange = 113; // Document title changed.
	public static final int FrameBeforeNavigate = 200; // Fired when a new hyperlink is being navigated to in a frame.
	public static final int FrameNavigateComplete = 201; // Fired when a new hyperlink is being navigated to in a frame.
	public static final int FrameNewWindow = 204; // Fired when a new window should be created.
	public static final int Quit = 103; // Fired when application is quiting.
	public static final int WindowMove = 109; // Fired when window has been moved.
	public static final int WindowResize = 110; // Fired when window has been sized.
	public static final int WindowActivate = 111; // Fired when window has been activated.
	public static final int PropertyChange = 112; // Fired when the PutProperty method has been called
	public static final int BeforeNavigate2 = 250;

	public static final int OnClick = -600;
	public static final int OnMouseMove = -606;
	public static final int OnMouseOver = 0x80010000 + 8;
	public static final int OnMouseOut = 0x80010000 + 9;
	public static final int OnMouseUp = -607;

	// Web Browser properties
	public static final int DISPID_READYSTATE = -525;
	public static final int DISPID_SCROLL = -531;

	public OleWebBrowser(OleAutomation oleAutomation)
	{
		super(oleAutomation);
	}

	public OleHTMLDocument getDocument()
	{
		return new OleHTMLDocument(getAutomation("Document"));
	}

	public String getLocationName()
	{
		return getString("LocationName");
	}

	public String getLocationURL()
	{
		return getString("LocationURL");
	}

	public int getReadyState()
	{
		return getInt("ReadyState");
	}

	public int goBack()
	{
		return invokeInt("GoBack");
	}

	public int goForward()
	{
		return invokeInt("GoForward");
	}

	public int goHome()
	{
		return invokeInt("GoHome");
	}

	public int goSearch()
	{
		return invokeInt("GoSearch");
	}

	public int navigate(String url)
	{
		int[] rgdispid = getAutomation().getIDsOfNames(new String[]{"Navigate", "URL"});
		Variant pVarResult = getAutomation().invoke(rgdispid[0], new Variant[]{new Variant(url)}, new int[]{rgdispid[1]});
		if (pVarResult == null)
			return 0;
		return pVarResult.getInt();
	}

	public void refresh()
	{
		invokeNoReply("Refresh");
	}

	public void stop()
	{
		invokeNoReply("Stop");
	}
}
