package monalipse.editors.win32;

import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.Variant;

public class OleHTMLPopup extends OleAutomationDelegate
{

	public OleHTMLPopup(OleAutomation oleAutomation)
	{
		super(oleAutomation);
	}
	
	public void show(int x, int y, int width, int height, OleAutomation element)
	{
		int[] rgdispid = getAutomation().getIDsOfNames(new String[]{"show", "x", "y", "w", "h", "pElement"});
		getAutomation().invoke(rgdispid[0], new Variant[]{new Variant(x), new Variant(y), new Variant(width), new Variant(height), new Variant(element)}, new int[]{rgdispid[1], rgdispid[2], rgdispid[3], rgdispid[4], rgdispid[5]});
	}
	
	public void hide()
	{
		invoke("hide");
	}

	public OleHTMLDocument getDocument()
	{
		OleAutomation a = getAutomation("Document");
		if(a == null)
			return null;
		return new OleHTMLDocument(a);
	}
}
