package monalipse.editors.win32;

import org.eclipse.swt.SWTError;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.Variant;

public class OleHTMLElement extends OleAutomationDelegate
{

	public OleHTMLElement(OleAutomation oleAutomation)
	{
		super(oleAutomation);
	}

	public String getTagName()
	{
		return getString("tagName");
	}

	public String getOuterHTML()
	{
		return getString("outerHTML");
	}

	public String getInnerHTML()
	{
		return getString("innerHTML");
	}

	public String getAttribute(String name)
	{
		int[] rgdispid = getAutomation().getIDsOfNames(new String[]{"getAttribute", "strAttributeName", "lFlags"});
		try
		{
			Variant pVarResult = getAutomation().invoke(rgdispid[0], new Variant[]{ new Variant(name), new Variant(0), }, new int[]{ rgdispid[1], rgdispid[2], });
			if(pVarResult != null)
				return pVarResult.getString();
		}
		catch(SWTError e)
		{
		}
		return "";
	}

	public int getOffsetLeft()
	{
		return getInt("offsetLeft");
	}

	public int getOffsetTop()
	{
		return getInt("offsetTop");
	}

	public int getOffsetWidth()
	{
		return getInt("offsetWidth");
	}

	public int getOffsetHeight()
	{
		return getInt("offsetHeight");
	}

	public OleHTMLElementCollection getElementsByTagName(String name)
	{
		int[] rgdispid = getAutomation().getIDsOfNames(new String[]{"getElementsByTagName", "v"});
		Variant pVarResult = getAutomation().invoke(rgdispid[0], new Variant[]{new Variant(name)}, new int[]{rgdispid[1]});
		if(pVarResult == null)
			return null;
		return new OleHTMLElementCollection(pVarResult.getAutomation());
	}

	public void scrollIntoView(boolean varargStart)
	{
		int[] rgdispid = getAutomation().getIDsOfNames(new String[]{"scrollIntoView", "varargStart"});
		getAutomation().invoke(rgdispid[0], new Variant[]{new Variant(varargStart)}, new int[]{rgdispid[1]});
	}

	public OleHTMLElement cloneNode(boolean deep)
	{
		int[] rgdispid = getAutomation().getIDsOfNames(new String[]{"cloneNode", "deep"});
		Variant pVarResult = getAutomation().invoke(rgdispid[0], new Variant[]{new Variant(deep)}, new int[]{rgdispid[1]});
		if(pVarResult == null)
			return null;
		return new OleHTMLElement(pVarResult.getAutomation());
	}

	public OleHTMLElement appendChild(OleHTMLElement newChild)
	{
		int[] rgdispid = getAutomation().getIDsOfNames(new String[]{"appendChild", "newChild"});
		Variant pVarResult = getAutomation().invoke(rgdispid[0], new Variant[]{new Variant(newChild.getAutomation())}, new int[]{rgdispid[1]});
		if(pVarResult == null)
			return null;
		return new OleHTMLElement(pVarResult.getAutomation());
	}

	public OleHTMLElement getParentNode()
	{
		OleAutomation a = getAutomation("parentNode");
		if(a == null)
			return null;
		return new OleHTMLElement(a);
	}

	public void removeChild(OleHTMLElement oldChild)
	{
		int[] rgdispid = getAutomation().getIDsOfNames(new String[]{"removeChild", "oldChild"});
		Variant pVarResult = getAutomation().invoke(rgdispid[0], new Variant[]{new Variant(oldChild.getAutomation())}, new int[]{rgdispid[1]});
		pVarResult.getAutomation().dispose();
	}

}
