package monalipse.editors.win32;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.Variant;

public class OleHTMLDocument extends OleAutomationDelegate
{
	public OleHTMLDocument(OleAutomation oleAutomation)
	{
		super(oleAutomation);
	}

	public void close()
	{
		invoke("close");
	}

	public void clear()
	{
		invoke("clear");
	}

	public void open(String url, String name)
	{
		int[] rgdispid = getAutomation().getIDsOfNames(new String[]{"open", "url", "name"});
		getAutomation().invoke(rgdispid[0], new Variant[]{new Variant(url), new Variant(name)}, new int[]{rgdispid[1], rgdispid[2]});
	}

	public OleHTMLScript getScript()
	{
		OleAutomation a = getAutomation("Script");
		if(a == null)
			return null;
		return new OleHTMLScript(a);
	}

	public OleHTMLElement getBody()
	{
		return new OleHTMLElement(getAutomation("Body"));
	}

	public OleHTMLWindow getParentWindow()
	{
		return new OleHTMLWindow(getAutomation("parentWindow"));
	}

	public void setLocation(String url)
	{
		set("location", url);
	}

	public String getLocation()
	{
		return getString("location");
	}

	public void setScrollLocation(Point location)
	{
		setScrollLeft(location.x);
		setScrollTop(location.y);
	}

	public void setScrollLeft(int val)
	{
		getBody().set("scrollLeft", val);
	}

	public void setScrollTop(int val)
	{
		getBody().set("scrollTop", val);
	}

	public Point getScrollLocation()
	{
		return new Point(getScrollLeft(), getScrollTop());
	}

	public int getScrollLeft()
	{
		return getBody().getInt("scrollLeft");
	}

	public int getScrollTop()
	{
		return getBody().getInt("scrollTop");
	}

	public int write(String text)
	{
		int[] rgdispid = getAutomation().getIDsOfNames(new String[]{"write", "psarray"});
		Variant pVarResult = getAutomation().invoke(rgdispid[0], new Variant[]{new Variant(text)}, new int[]{rgdispid[1]});
		if(pVarResult == null)
			return 0;
		return pVarResult.getInt();
	}

	public OleHTMLElement elementFromPoint(long x, long y)
	{
		int[] rgdispid = getAutomation().getIDsOfNames(new String[]{"elementFromPoint", "x", "y"});
		Variant pVarResult = getAutomation().invoke(rgdispid[0], new Variant[]{new Variant(x), new Variant(y)}, new int[]{rgdispid[1], rgdispid[2]});
		if(pVarResult == null)
			return null;
		return new OleHTMLElement(pVarResult.getAutomation());
	}

	public OleHTMLElementCollection getElementsByName(String name)
	{
		int[] rgdispid = getAutomation().getIDsOfNames(new String[]{"getElementsByName", "v"});
		Variant pVarResult = getAutomation().invoke(rgdispid[0], new Variant[]{new Variant(name)}, new int[]{rgdispid[1]});
		if(pVarResult == null)
			return null;
		return new OleHTMLElementCollection(pVarResult.getAutomation());
	}

	public OleHTMLElement getElementById(String id)
	{
		int[] rgdispid = getAutomation().getIDsOfNames(new String[]{"getElementById", "v"});
		Variant pVarResult = getAutomation().invoke(rgdispid[0], new Variant[]{new Variant(id)}, new int[]{rgdispid[1]});
		if(pVarResult == null)
			return null;
		return new OleHTMLElement(pVarResult.getAutomation());
	}

	public OleHTMLElement getDocumentElement()
	{
		OleAutomation a = getAutomation("documentElement");
		if(a == null)
			return null;
		return new OleHTMLElement(a);
	}
	
	public OleHTMLElement importNode(OleHTMLElement importedNode, boolean deep)
	{
		int[] rgdispid = getAutomation().getIDsOfNames(new String[]{"importNode", "importedNode", "deep"});
		Variant pVarResult = getAutomation().invoke(rgdispid[0], new Variant[]{new Variant(importedNode.getAutomation()), new Variant(deep)}, new int[]{rgdispid[1], rgdispid[2]});
		if(pVarResult == null)
			return null;
		return new OleHTMLElement(pVarResult.getAutomation());
	}
}
