package monalipse.editors.win32;

import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleFunctionDescription;
import org.eclipse.swt.ole.win32.Variant;

public class OleAutomationDelegate
{
	private OleAutomation oleAutomation;

	public OleAutomationDelegate(OleAutomation oleAutomation)
	{
		this.oleAutomation = oleAutomation;
	}
	
	public void dispose()
	{
		if (oleAutomation != null)
			oleAutomation.dispose();
		oleAutomation = null;
	}

	public OleAutomation getAutomation()
	{
		return oleAutomation;
	}
	
	protected int getID(String name)
	{
		return getAutomation().getIDsOfNames(new String[]{name})[0];
	}

	public int getInt(String name)
	{
		Variant pVarResult = getAutomation().getProperty(getID(name));
		if (pVarResult == null)
			return 0;
		return pVarResult.getInt();
	}

	public void set(String name, int value)
	{
		getAutomation().setProperty(getID(name), new Variant(value));
	}

	public String getString(String name)
	{
		Variant pVarResult = getAutomation().getProperty(getID(name));
		if (pVarResult == null)
			return null;
		return pVarResult.getString();
	}

	public void set(String name, String value)
	{
		getAutomation().setProperty(getID(name), new Variant(value));
	}

	public OleAutomation getAutomation(String name)
	{
		Variant pVarResult = getAutomation().getProperty(getID(name));
		if (pVarResult == null)
			return null;
		return pVarResult.getAutomation();
	}

	public int invokeInt(String name)
	{
		Variant pVarResult = getAutomation().invoke(getID(name));
		if (pVarResult == null)
			return 0;
		return pVarResult.getInt();
	}

	public void invoke(String name)
	{
		getAutomation().invoke(getID(name));
	}

	public void invokeNoReply(String name)
	{
		getAutomation().invokeNoReply(getID(name));
	}

	public void dump()
	{
		int i = 0;
		while(true)
		{
			OleFunctionDescription fd = getAutomation().getFunctionDescription(i);
			if(fd == null)
				break;
				
//			int[] rgdispid = getAutomation().getIDsOfNames(new String[] { "fd.name" });

			System.err.print(fd.name + " " + fd.id + " (");
				
			for(int j = 0; j < fd.args.length; j++)
			{
				System.err.print(fd.args[j].name + ", ");
			}
			System.err.println(")");
				
			i++;
		}
	}

}
