package monalipse.editors;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;

import monalipse.MonalipsePlugin;
import monalipse.part.CancelableRunner;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.EditorActionBarContributor;

public class ThreadViewerEditorActionBarContributor extends EditorActionBarContributor
{
	private CancelableRunner cancelable;
	private SubStatusLineManager statusLineManager;
	private IAction browserAction;
	private IAction reloadAction;
	private IAction abortAction;
	private IContributionItem urlContribution;
	
	public ThreadViewerEditorActionBarContributor()
	{
		makeActions();
	}
	
	public void contributeToContextMenu(IMenuManager manager)
	{
		manager.add(reloadAction);
		manager.add(abortAction);
		manager.add(browserAction);
	}
	
	public void contributeToStatusLine(IStatusLineManager manager)
	{
		cancelable = new CancelableRunner(manager, null, abortAction);
	}

	public void contributeToToolBar(IToolBarManager manager)
	{
		manager.add(reloadAction);
		manager.add(abortAction);
		manager.add(browserAction);
	}
	
	private void makeActions()
	{
		String iconPath = "icons/"; //$NON-NLS-1$		
		URL installURL = Platform.getPlugin(MonalipsePlugin.PLUGIN_ID).getDescriptor().getInstallURL();

		browserAction = new Action()
			{
				public void run()
				{
					IEditorInput input = getPage().getActiveEditor().getEditorInput();
					if(input instanceof ThreadEditorInput)
						Program.launch(((ThreadEditorInput)input).getURLHint());
				}
			};
		browserAction.setText("Open By Web Browser");
		browserAction.setToolTipText("Open By Web Browser");
		try
		{
			browserAction.setImageDescriptor(ImageDescriptor.createFromURL(new URL(installURL, iconPath + "webbrowser_nav.gif"))); //$NON-NLS-1$
		}
		catch (MalformedURLException e)
		{
		}

		reloadAction = new Action()
			{
				public void run()
				{
					IEditorPart part = getPage().getActiveEditor();
					IEditorInput input = part.getEditorInput();
					if(part instanceof IThreadViewerEditor)
						((IThreadViewerEditor)part).updateThread();
				}
			};
		reloadAction.setText("Reload");
		reloadAction.setToolTipText("Reload thread");
		try
		{
			reloadAction.setImageDescriptor(ImageDescriptor.createFromURL(new URL(installURL, iconPath + "refresh_nav.gif"))); //$NON-NLS-1$
		}
		catch (MalformedURLException e)
		{
		}

		abortAction = new Action()
			{
				public void run()
				{
					cancelable.cancel();
				}
			};
		abortAction.setText("Abort");
		abortAction.setToolTipText("Abort all downloading thread");
		abortAction.setEnabled(false);
		try
		{
			abortAction.setImageDescriptor(ImageDescriptor.createFromURL(new URL(installURL, iconPath + "stop_nav.gif"))); //$NON-NLS-1$
		}
		catch (MalformedURLException e)
		{
		}
	}
	
	public CancelableRunner getCancelable()
	{
		return cancelable;
	}

}
