/*
 * Decompiled with CFR 0.152.
 */
package monalipse.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;

public class ColoredText
extends Canvas
implements ITextOperationTarget,
ISelectionProvider {
    private List lines = new ArrayList();
    private VisualLines visualLines = new VisualLines();
    private GC gc;
    private Color selectionDark;
    private Color selectionLight;
    private Cursor handCursor;
    private Cursor ibeamCursor;
    private int width = Integer.MAX_VALUE;
    private int lineSkip = 10;
    private int[] insets = new int[]{10, 10, 10, 10};
    private TextPosition selectionStart = TextPosition.INVALID;
    private TextPosition selectionEnd = TextPosition.INVALID;
    private List textTrackListeners = new ArrayList();
    private ToolTipProvider toolTipProvider;
    private Shell toolTipShell;
    private boolean toolTipLocked;
    private ColoredText toolTipSource = this;
    private List selectionChangedListeners = new ArrayList();

    public ColoredText(Composite parent, int style) {
        super(parent, style | 0x40000 | 0x10000);
        this.selectionDark = new Color(null, 0, 0, 0);
        this.selectionLight = new Color(null, 143, 153, 166);
        this.handCursor = new Cursor((Device)parent.getDisplay(), 21);
        this.ibeamCursor = new Cursor((Device)parent.getDisplay(), 19);
        this.gc = new GC((Drawable)this);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ColoredText.this.paintControl(e);
            }
        });
        this.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                ColoredText.this.controlResized(e);
            }
        });
        this.addKeyListener(new PageMoveKeyListener());
        MouseDragListener dsl = new MouseDragListener();
        this.addMouseListener(dsl);
        this.addMouseMoveListener(dsl);
        this.addMouseTrackListener(dsl);
        this.addTextTrackListener(new TextTrackListener(){

            public void textEnter(TextEvent e) {
                if (e.fragment instanceof LinkTarget) {
                    ColoredText.this.setCursor(ColoredText.this.handCursor);
                } else {
                    ColoredText.this.setCursor(ColoredText.this.ibeamCursor);
                }
            }

            public void textExit(TextEvent e) {
                ColoredText.this.setCursor(null);
                if (!ColoredText.this.toolTipLocked) {
                    ColoredText.this.setCapture(false);
                    ColoredText.this.disposeHover();
                }
            }

            public void textHover(TextEvent e) {
                if (ColoredText.this.toolTipProvider != null && e.fragment instanceof ToolTipTarget) {
                    ColoredText.this.disposeHover();
                    ColoredText.this.toolTipShell = new Shell(ColoredText.this.getShell(), 0);
                    Point pt = ColoredText.this.toDisplay(new Point(e.x, e.y));
                    Rectangle scr = ColoredText.this.getShell().getDisplay().getClientArea();
                    int cursorSize = 16;
                    scr.x += cursorSize;
                    scr.y += cursorSize;
                    scr.width -= cursorSize * 2;
                    scr.height -= cursorSize * 2;
                    int maxWidth = Math.max(pt.x - scr.x, scr.x + scr.width - pt.x) - 2;
                    Composite content = new Composite((Composite)ColoredText.this.toolTipShell, 0);
                    content.setLayout((Layout)new FillLayout(768));
                    Point size = ColoredText.this.toolTipProvider.fillToolTip(content, ColoredText.this.toolTipSource, maxWidth, (ToolTipTarget)((Object)e.fragment));
                    size.x += 2;
                    size.y += 2;
                    pt.x = scr.x + scr.width < pt.x + size.x ? (pt.x -= size.x + cursorSize) : (pt.x += cursorSize);
                    if (scr.y + scr.height < pt.y + size.y) {
                        if (scr.height / 2 < pt.y - scr.y) {
                            size.y = Math.min(size.y, pt.y - scr.y);
                            pt.y -= size.y + cursorSize;
                        } else {
                            size.y = scr.y + scr.height - pt.y;
                            pt.y += cursorSize;
                        }
                    } else {
                        pt.y += cursorSize;
                    }
                    content.setSize(size.x - 2, size.y - 2);
                    content.setLocation(0, 0);
                    ColoredText.this.toolTipShell.setLocation(pt);
                    ColoredText.this.toolTipShell.setSize(size.x, size.y);
                    ColoredText.this.toolTipShell.setVisible(true);
                    ColoredText.this.setCapture(true);
                    ColoredText.this.toolTipProvider.toolTipActivated(ColoredText.this);
                }
            }
        });
        this.getVerticalBar().setMinimum(0);
        this.getVerticalBar().setMaximum(0);
        this.getVerticalBar().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColoredText.this.redraw();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void disposeHover() {
        this.toolTipLocked = false;
        if (this.toolTipShell != null) {
            try {
                this.toolTipProvider.toolTipDeactivated(this);
                this.toolTipShell.setVisible(false);
                this.toolTipShell.dispose();
            }
            catch (RuntimeException runtimeException) {}
            this.toolTipShell = null;
        }
    }

    public void dispose() {
        this.disposeHover();
        if (this.gc != null) {
            this.gc.dispose();
        }
        this.gc = null;
        if (this.selectionDark != null) {
            this.selectionDark.dispose();
        }
        this.selectionDark = null;
        if (this.selectionLight != null) {
            this.selectionLight.dispose();
        }
        this.selectionLight = null;
        super.dispose();
    }

    public void lockToolTip() {
        if (!this.toolTipLocked && this.toolTipShell != null) {
            this.toolTipLocked = true;
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int width = 0;
        int i = 0;
        while (i < this.getLineCount()) {
            width = Math.max(width, this.getLineAt(i).getPreferredLineWidth(this.gc));
            ++i;
        }
        if (width == 0) {
            return super.computeSize(wHint, hHint);
        }
        return new Point(width + this.insets[1] + this.insets[3] + this.getVerticalBar().getSize().x, this.lineSkip * this.getLineCount() + this.insets[0] + this.insets[2] + 1);
    }

    private void controlResized(ControlEvent e) {
        this.wrapLines(this.getClientArea().width - this.insets[1] - this.insets[3]);
        ScrollBar vertical = this.getVerticalBar();
        int height = this.getClientArea().height;
        vertical.setIncrement(this.lineSkip);
        vertical.setPageIncrement(height * 9 / 10);
        this.updateScrollThumb();
    }

    private void paintControl(PaintEvent e) {
        int clientHeight;
        GC gc = e.gc;
        int pos = this.getVerticalBar().getSelection();
        int originX = this.insets[1];
        int originY = this.insets[0] - pos;
        int startLine = Math.max(0, (e.y - originY) / this.lineSkip);
        int endLine = Math.min(this.visualLines.getLineCount(), (e.y + e.height - originY) / this.lineSkip + 1);
        int lineWidth = this.width + this.insets[1] + this.insets[3];
        gc.setBackground(this.getBackground());
        if (originY > 0) {
            gc.fillRectangle(0, 0, lineWidth, originY);
        }
        int i = startLine;
        while (i < endLine) {
            int logicalLine = this.visualLines.getLogicalLineAt(i);
            Line line = this.getLineAt(logicalLine);
            if (this.selectionStart.row <= logicalLine && logicalLine <= this.selectionEnd.row) {
                int selStart = this.selectionStart.row < logicalLine ? 0 : this.selectionStart.column;
                int selEnd = logicalLine < this.selectionEnd.row ? line.getTextLength() : this.selectionEnd.column;
                line.paintSelected(gc, originX, originY + this.lineSkip * i, this.visualLines.getOffsetAt(i), this.visualLines.getLengthAt(i), lineWidth, this.lineSkip, selStart, selEnd - selStart, this.selectionDark, this.selectionLight);
            } else {
                line.paint(gc, originX, originY + this.lineSkip * i, this.visualLines.getOffsetAt(i), this.visualLines.getLengthAt(i), lineWidth, this.lineSkip);
            }
            ++i;
        }
        int bottom = originY + this.lineSkip * this.visualLines.getLineCount();
        if (bottom < (clientHeight = this.getClientArea().height)) {
            gc.setBackground(this.getBackground());
            gc.fillRectangle(0, bottom, lineWidth, clientHeight - bottom);
        }
    }

    public void setLineSkip(int lineSkip) {
        this.lineSkip = lineSkip;
    }

    public int getLineSkip() {
        return this.lineSkip;
    }

    public void setInsets(int top, int left, int bottom, int right) {
        this.insets[0] = top;
        this.insets[1] = left;
        this.insets[2] = bottom;
        this.insets[3] = right;
    }

    public void addLine(Line line) {
        Point bottom = this.getPointFromVisualLine(this.visualLines.getLineCount(), 0);
        line.wrapLine(this.visualLines, this.width, this.lines.size(), this.gc);
        this.lines.add(line);
        this.recalcScrollMaximum();
        int h = this.getClientArea().height;
        if (bottom.y < h) {
            this.redraw(0, bottom.y, this.width, h - bottom.y, true);
        }
    }

    public void addLines(Collection colection) {
        Point bottom = this.getPointFromVisualLine(this.visualLines.getLineCount(), 0);
        Iterator i = colection.iterator();
        while (i.hasNext()) {
            Line line = (Line)i.next();
            line.wrapLine(this.visualLines, this.width, this.lines.size(), this.gc);
            this.lines.add(line);
        }
        this.recalcScrollMaximum();
        int h = this.getClientArea().height;
        if (bottom.y < h) {
            this.redraw(0, bottom.y, this.width, h - bottom.y, true);
        }
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public Line getLineAt(int index) {
        return (Line)this.lines.get(index);
    }

    public void clear() {
        this.lines.clear();
        this.visualLines.clear();
        this.getVerticalBar().setMaximum(this.insets[0] + this.insets[2]);
        this.setSelection(TextPosition.INVALID, TextPosition.INVALID, false);
        this.redraw();
    }

    public boolean canDoOperation(int operation) {
        if (operation == 4) {
            return !this.getSelection().isEmpty();
        }
        return operation == 7;
    }

    public void doOperation(int operation) {
        if (operation == 4) {
            this.copyToClipboard();
        } else if (operation == 7) {
            this.selectAll();
        }
    }

    public void copyToClipboard() {
        if (this.selectionStart.isValid() && this.selectionEnd.isValid()) {
            new Clipboard(this.getDisplay()).setContents(new Object[]{this.getText(this.selectionStart, this.selectionEnd)}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    public String getText(TextPosition from, TextPosition to) {
        if (from.row == to.row) {
            return this.getLineAt(from.row).toString().substring(from.column, to.column);
        }
        StringBuffer buf = new StringBuffer();
        String f = this.getLineAt(from.row).toString();
        buf.append(f.substring(from.column, f.length())).append('\n');
        int i = from.row + 1;
        while (i < to.row - 1) {
            buf.append(this.getLineAt(i).toString()).append('\n');
            ++i;
        }
        buf.append(this.getLineAt(to.row).toString().substring(0, to.column));
        return buf.toString();
    }

    public void selectAll() {
        this.setSelection(new TextPosition(0, 0), new TextPosition(this.getLineCount() - 1, this.getLineAt(this.getLineCount() - 1).getTextLength()), true);
        this.redraw();
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof TextSelection) {
            TextSelection sel = (TextSelection)selection;
            this.setSelection(sel.from, sel.to, true);
            this.redraw();
        }
    }

    public ISelection getSelection() {
        return new TextSelection(this.selectionStart, this.selectionEnd);
    }

    public void setSelection(TextPosition selectionStart, TextPosition selectionEnd, boolean redraw) {
        if (selectionEnd.row < selectionStart.row || selectionEnd.row == selectionStart.row && selectionEnd.column < selectionStart.column) {
            TextPosition t = selectionStart;
            selectionStart = selectionEnd;
            selectionEnd = t;
        }
        if (this.selectionStart.equals(selectionStart) && this.selectionEnd.equals(selectionEnd)) {
            redraw = false;
        }
        if (redraw) {
            this.redrawSelection();
        }
        this.selectionStart = selectionStart;
        this.selectionEnd = selectionEnd;
        if (redraw) {
            this.redrawSelection();
        }
        this.fireSelectionChangedEvent(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    public void setSelection(LineFragment fragment, boolean redraw) {
        int i = 0;
        while (i < this.getLineCount()) {
            Line line = this.getLineAt(i);
            int col = 0;
            int j = 0;
            while (j < line.getLineFragmentCount()) {
                LineFragment f = line.getLineFragmentAt(j);
                if (f == fragment) {
                    this.setSelection(new TextPosition(i, col), new TextPosition(i, col + f.getTextLength()), redraw);
                    return;
                }
                col += f.getTextLength();
                ++j;
            }
            ++i;
        }
    }

    private void redrawSelection() {
        if (this.selectionStart.isValid()) {
            Point top = this.getPointFromIndex(this.selectionStart);
            Point bottom = this.getPointFromIndex(this.selectionEnd);
            this.redraw(0, top.y - this.lineSkip, this.width, bottom.y - top.y + this.lineSkip * 2, true);
        }
    }

    public void scrollTo(TextPosition index, int side) {
        int hit = this.findVisualLineOf(index);
        if (side == 1024) {
            this.getVerticalBar().setSelection(this.lineSkip * (hit + 1) + this.insets[0] - this.getVerticalBar().getThumb());
        } else {
            this.getVerticalBar().setSelection(this.lineSkip * hit + this.insets[0]);
        }
        this.redraw();
    }

    public TextPosition getIndexFromPoint(Point point) {
        if (this.lineSkip == 0) {
            return TextPosition.INVALID;
        }
        int vline = Math.min(this.visualLines.getLineCount() - 1, Math.max(0, (point.y + this.getVerticalBar().getSelection() - this.insets[0]) / this.lineSkip));
        if (vline == -1) {
            return TextPosition.INVALID;
        }
        int line = this.visualLines.getLogicalLineAt(vline);
        int col = this.getLineAt(line).getColumnIndexOf(point.x - this.insets[1], this.visualLines.getOffsetAt(vline), this.visualLines.getLengthAt(vline), this.gc);
        return new TextPosition(line, col);
    }

    public Point getPointFromIndex(TextPosition index) {
        return this.getPointFromVisualLine(this.findVisualLineOf(index), index.column);
    }

    public LineFragment getLineFragmentFromIndex(TextPosition index) {
        if (index.row < 0 || this.getLineCount() <= index.row) {
            return null;
        }
        return this.getLineAt(index.row).getLineFragmentFromIndex(index.column);
    }

    private Point getPointFromVisualLine(int visualLineIndex, int logicalColumn) {
        if (visualLineIndex < 0 || this.visualLines.getLineCount() <= visualLineIndex) {
            return new Point(this.insets[1], this.insets[0]);
        }
        return new Point(this.insets[1] + this.getLineAt(this.visualLines.getLogicalLineAt(visualLineIndex)).getPointFromIndex(logicalColumn, this.visualLines.getOffsetAt(visualLineIndex), this.visualLines.getLengthAt(visualLineIndex), this.gc), this.insets[0] + this.lineSkip * visualLineIndex - this.getVerticalBar().getSelection());
    }

    private int findVisualLineOf(TextPosition index) {
        int logicalLine = index.row;
        int offset = index.column;
        int start = 0;
        int end = this.visualLines.getLineCount();
        int hit = -1;
        while (1 < end - start) {
            int mid = start + (end - start) / 2;
            int log = this.visualLines.getLogicalLineAt(mid);
            if (log == logicalLine) {
                int off = this.visualLines.getOffsetAt(mid);
                int len = this.visualLines.getLengthAt(mid);
                if (off <= offset && offset < off + len) {
                    hit = mid;
                    break;
                }
                if (off + len < off) {
                    start = mid;
                    continue;
                }
                end = mid;
                continue;
            }
            if (log < logicalLine) {
                start = mid;
                continue;
            }
            end = mid;
        }
        if (hit == -1) {
            hit = end;
        }
        return hit;
    }

    private void recalcScrollMaximum() {
        this.getVerticalBar().setMaximum(this.lineSkip * this.visualLines.getLineCount() + this.insets[0] + this.insets[2]);
        this.updateScrollThumb();
    }

    private void updateScrollThumb() {
        ScrollBar vertical = this.getVerticalBar();
        if (vertical.getMaximum() < this.getSize().y) {
            vertical.setEnabled(false);
            vertical.setThumb(this.getVerticalBar().getMaximum());
        } else {
            vertical.setEnabled(true);
            vertical.setThumb(this.getSize().y);
        }
    }

    public int setWrapWidth(int width) {
        this.wrapLines(width - this.getVerticalBar().getSize().x - this.insets[1] - this.insets[3]);
        return this.lineSkip * this.visualLines.getLineCount() + this.insets[0] + this.insets[2];
    }

    private void wrapLines(int width) {
        if (this.width != width) {
            TextPosition scroll = this.getIndexFromPoint(new Point(0, 0));
            this.visualLines.clear();
            this.wrapLines(width, this.lines, 0);
            this.width = width;
            this.recalcScrollMaximum();
            if (scroll.row == 0) {
                this.getVerticalBar().setSelection(0);
                this.redraw();
            } else {
                this.scrollTo(scroll, 128);
            }
        }
    }

    private void wrapLines(int width, List lines, int lineNumberOffset) {
        int lc = lines.size();
        int i = 0;
        while (i < lc) {
            ((Line)lines.get(i)).wrapLine(this.visualLines, width, lineNumberOffset + i, this.gc);
            ++i;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    private void fireSelectionChangedEvent(SelectionChangedEvent e) {
        int i = 0;
        while (i < this.selectionChangedListeners.size()) {
            ISelectionChangedListener l = (ISelectionChangedListener)this.selectionChangedListeners.get(i);
            l.selectionChanged(e);
            ++i;
        }
    }

    public void addTextTrackListener(TextTrackListener listener) {
        this.textTrackListeners.add(listener);
    }

    public void removeTextTrackListener(TextTrackListener listener) {
        this.textTrackListeners.remove(listener);
    }

    public void setToolTipSource(ColoredText toolTipSource) {
        this.toolTipSource = toolTipSource;
    }

    private void fireTextEvent(TextEvent e, int event) {
        int i = 0;
        while (i < this.textTrackListeners.size()) {
            TextTrackListener l = (TextTrackListener)this.textTrackListeners.get(i);
            switch (event) {
                case 0: {
                    l.textEnter(e);
                    break;
                }
                case 1: {
                    l.textExit(e);
                    break;
                }
                case 2: {
                    l.textHover(e);
                }
            }
            ++i;
        }
    }

    public void setToolTipProvider(ToolTipProvider toolTipProvider) {
        this.toolTipProvider = toolTipProvider;
    }

    public ToolTipProvider getToolTipProvider() {
        return this.toolTipProvider;
    }

    private static class TextSelection
    implements ISelection {
        public TextPosition from;
        public TextPosition to;

        public TextSelection(TextPosition from, TextPosition to) {
            this.from = from;
            this.to = to;
        }

        public boolean isEmpty() {
            return !this.from.isValid() || !this.to.isValid() || this.from.equals(this.to);
        }
    }

    private static final class VisualLines {
        private int[] lines = new int[30000];
        private int count;

        VisualLines() {
        }

        public final void addLine(int logicalLine, int offset, int length) {
            if (this.count * 3 == this.lines.length) {
                int[] newLines = new int[this.lines.length * 2];
                System.arraycopy(this.lines, 0, newLines, 0, this.lines.length);
                this.lines = newLines;
            }
            this.lines[this.count * 3] = logicalLine;
            this.lines[this.count * 3 + 1] = offset;
            this.lines[this.count * 3 + 2] = length;
            ++this.count;
        }

        public final void clear() {
            this.count = 0;
        }

        public final int getLogicalLineAt(int visualLine) {
            return this.lines[visualLine * 3];
        }

        public final int getOffsetAt(int visualLine) {
            return this.lines[visualLine * 3 + 1];
        }

        public final int getLengthAt(int visualLine) {
            return this.lines[visualLine * 3 + 2];
        }

        public final int getLineCount() {
            return this.count;
        }
    }

    public static interface LinkTarget {
        public void linkClicked(ColoredText var1);
    }

    public static interface ToolTipTarget {
    }

    public static interface ToolTipProvider {
        public Point fillToolTip(Composite var1, ColoredText var2, int var3, ToolTipTarget var4);

        public void toolTipActivated(ColoredText var1);

        public void toolTipDeactivated(ColoredText var1);
    }

    public static interface TextTrackListener
    extends EventListener {
        public void textEnter(TextEvent var1);

        public void textExit(TextEvent var1);

        public void textHover(TextEvent var1);
    }

    public static class TextEvent
    extends TypedEvent {
        static final int EVENT_TEXT_ENTER = 0;
        static final int EVENT_TEXT_EXIT = 1;
        static final int EVENT_TEXT_HOVER = 2;
        public ColoredText text;
        public LineFragment fragment;
        public int x;
        public int y;

        private TextEvent(ColoredText source, MouseEvent e, LineFragment frag) {
            super((Object)source);
            this.display = e.display;
            this.widget = source;
            this.time = e.time;
            this.text = source;
            this.fragment = frag;
            this.x = e.x;
            this.y = e.y;
        }
    }

    public static class TextPosition {
        public static final TextPosition INVALID = new TextPosition(-1, -1);
        public int row;
        public int column;

        public TextPosition(int row, int column) {
            this.row = row;
            this.column = column;
        }

        public boolean isValid() {
            return this != INVALID;
        }

        public int hashCode() {
            return this.row + this.column;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TextPosition) {
                return ((TextPosition)obj).row == this.row && ((TextPosition)obj).column == this.column;
            }
            return false;
        }
    }

    public static class Line {
        private LineFragment fragment;
        private List fragments;
        private int charsCount;
        private int extentCache = -1;
        private int indent;

        public Line(int indent) {
            this.indent = indent;
        }

        public int getTextLength() {
            return this.charsCount;
        }

        public LineFragment getLineFragmentFromIndex(int col) {
            int fc = this.getLineFragmentCount();
            int i = 0;
            while (i < fc) {
                LineFragment f = this.getLineFragmentAt(i);
                if (f.getTextLength() <= col) {
                    col -= f.getTextLength();
                } else {
                    return f;
                }
                ++i;
            }
            return null;
        }

        public int getPointFromIndex(int index, int off, int len, GC gc) {
            if (off <= index && index < off + len) {
                len = index - off;
            }
            int x = this.indent;
            int fc = this.getLineFragmentCount();
            int i = 0;
            while (i < fc && len > 0) {
                LineFragment f = this.getLineFragmentAt(i);
                if (f.getTextLength() <= off) {
                    off -= f.getTextLength();
                } else {
                    int l = Math.min(f.getTextLength() - off, len);
                    x = off == 0 && l == f.getTextLength() ? (x += f.getExtent(gc)) : (x += TextMeasurer.getTextExtent(f.getText(), off, l, gc));
                    off = 0;
                    len -= l;
                }
                ++i;
            }
            return x;
        }

        public int getColumnIndexOf(int x, int off, int len, GC gc) {
            x -= this.indent;
            int col = 0;
            int fc = this.getLineFragmentCount();
            int i = 0;
            while (i < fc && len > 0) {
                LineFragment f = this.getLineFragmentAt(i);
                if (f.getTextLength() <= off) {
                    off -= f.getTextLength();
                    col += f.getTextLength();
                } else {
                    int l = Math.min(f.getTextLength() - off, len);
                    int index = f.getColumnIndexOf(x, off, l, gc);
                    if (index == -1) {
                        col += f.getTextLength();
                    } else {
                        return col + off + index;
                    }
                    x = off == 0 && l == f.getTextLength() ? (x -= f.getExtent(gc)) : (x -= TextMeasurer.getTextExtent(f.getText(), off, l, gc));
                    off = 0;
                    len -= l;
                }
                ++i;
            }
            return col;
        }

        public void paint(GC gc, int x, int y, int off, int len, int lineWidth, int lineHeight) {
            gc.fillRectangle(0, y, x += this.indent, lineHeight);
            int fontHeight = gc.getFontMetrics().getHeight();
            gc.fillRectangle(0, y + fontHeight, lineWidth, lineHeight - fontHeight);
            int fc = this.getLineFragmentCount();
            int i = 0;
            while (i < fc && len > 0) {
                LineFragment f = this.getLineFragmentAt(i);
                if (f.getTextLength() <= off) {
                    off -= f.getTextLength();
                } else {
                    int l = Math.min(f.getTextLength() - off, len);
                    f.paint(gc, x, y, off, l);
                    x = off == 0 && l == f.getTextLength() ? (x += f.getExtent(gc)) : (x += TextMeasurer.getTextExtent(f.getText(), off, l, gc));
                    off = 0;
                    len -= l;
                }
                ++i;
            }
            gc.fillRectangle(x, y, lineWidth - x, lineHeight);
        }

        public void paintSelected(GC gc, int x, int y, int off, int len, int lineWidth, int lineHeight, int selectionOffset, int selectionLength, Color selectionDark, Color selectionLight) {
            if (selectionOffset < off) {
                selectionLength -= off - selectionOffset;
                selectionOffset = off;
            }
            if (off + len <= selectionOffset || selectionOffset + selectionLength <= off) {
                this.paint(gc, x, y, off, len, lineWidth, lineHeight);
                return;
            }
            gc.fillRectangle(0, y, x += this.indent, lineHeight);
            int fontHeight = gc.getFontMetrics().getHeight();
            gc.fillRectangle(0, y + fontHeight, lineWidth, lineHeight - fontHeight);
            int fc = this.getLineFragmentCount();
            int i = 0;
            while (i < fc && len > 0) {
                LineFragment f = this.getLineFragmentAt(i);
                if (f.getTextLength() <= off) {
                    off -= f.getTextLength();
                    selectionOffset -= f.getTextLength();
                } else {
                    int l = Math.min(f.getTextLength() - off, len);
                    int sl = Math.min(f.getTextLength() - selectionOffset, selectionLength);
                    f.paintSelected(gc, x, y, off, l, selectionOffset, sl, selectionDark, selectionLight);
                    x = off == 0 && l == f.getTextLength() ? (x += f.getExtent(gc)) : (x += TextMeasurer.getTextExtent(f.getText(), off, l, gc));
                    if (selectionOffset < off + l) {
                        selectionOffset = 0;
                        selectionLength -= sl;
                    } else {
                        selectionOffset -= l;
                    }
                    off = 0;
                    len -= l;
                }
                ++i;
            }
            gc.fillRectangle(x, y, lineWidth - x, lineHeight);
        }

        public void wrapLine(VisualLines visualLines, int width, int lineNumber, GC gc) {
            int extent = this.getExtent(gc);
            if (extent < (width -= this.indent)) {
                visualLines.addLine(lineNumber, 0, this.charsCount);
            } else {
                int off = 0;
                int len = 0;
                int w = 0;
                int fc = this.getLineFragmentCount();
                int i = 0;
                while (i < fc) {
                    LineFragment f = this.getLineFragmentAt(i);
                    int ext = f.getExtent(gc);
                    if (w + ext <= width) {
                        len += f.getTextLength();
                        w += ext;
                    } else {
                        int br = 0;
                        while (br < f.getTextLength()) {
                            int next = TextMeasurer.getWrap(f.getText(), br, width - w, gc);
                            if (w == 0 && next == br) {
                                next = br + 1;
                            }
                            len += next - br;
                            if (next < f.getTextLength()) {
                                visualLines.addLine(lineNumber, off, len);
                                off += len;
                                len = 0;
                                w = 0;
                            } else {
                                w = TextMeasurer.getTextExtent(f.getText(), br, next - br, gc);
                            }
                            br = next;
                        }
                    }
                    ++i;
                }
                if (len != 0) {
                    visualLines.addLine(lineNumber, off, len);
                }
            }
        }

        public int getPreferredLineWidth(GC gc) {
            return this.indent + this.getExtent(gc);
        }

        public int getExtent(GC gc) {
            if (this.extentCache == -1) {
                this.extentCache = 0;
                int fc = this.getLineFragmentCount();
                int i = 0;
                while (i < fc) {
                    this.extentCache += this.getLineFragmentAt(i).getExtent(gc);
                    ++i;
                }
            }
            return this.extentCache;
        }

        public void addLineFragment(LineFragment lineFragment) {
            this.charsCount += lineFragment.getText().length();
            switch (this.getLineFragmentCount()) {
                case 0: {
                    this.fragment = lineFragment;
                    break;
                }
                case 1: {
                    this.fragments = new ArrayList();
                    this.fragments.add(this.fragment);
                    this.fragments.add(lineFragment);
                    this.fragment = null;
                    break;
                }
                default: {
                    this.fragments.add(lineFragment);
                }
            }
        }

        public int getLineFragmentCount() {
            if (this.fragment != null) {
                return 1;
            }
            if (this.fragments != null) {
                return this.fragments.size();
            }
            return 0;
        }

        public LineFragment getLineFragmentAt(int index) {
            switch (this.getLineFragmentCount()) {
                case 0: {
                    throw new IndexOutOfBoundsException();
                }
                case 1: {
                    if (index == 0) {
                        return this.fragment;
                    }
                    throw new IndexOutOfBoundsException();
                }
            }
            return (LineFragment)this.fragments.get(index);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.getLineFragmentCount()) {
                buf.append(this.getLineFragmentAt(i).toString());
                ++i;
            }
            return buf.toString();
        }
    }

    public static class LineFragment {
        private String text;
        private Color color;
        private Font font;
        private boolean underline;
        private int extentCache = -1;

        public LineFragment(String text, Color color, Font font, boolean underline) {
            this.text = text;
            this.color = color;
            this.font = font;
            this.underline = underline;
        }

        public int getColumnIndexOf(int x, int off, int len, GC gc) {
            if (this.getExtent(gc) < x) {
                return -1;
            }
            return TextMeasurer.getColumnIndexOf(x, this.text, off, len, gc);
        }

        public void paint(GC gc, int x, int y, int off, int len) {
            if (gc.getFont() != this.font) {
                gc.setFont(this.font);
            }
            if (gc.getForeground() != this.color) {
                gc.setForeground(this.color);
            }
            gc.drawString(this.text.substring(off, off + len), x, y, false);
            if (this.underline) {
                int ascent = gc.getFontMetrics().getAscent();
                gc.drawLine(x, y + ascent, x + this.getExtent(gc), y + ascent);
            }
        }

        public void paintSelected(GC gc, int x, int y, int off, int len, int selectionOffset, int selectionLength, Color selectionDark, Color selectionLight) {
            if (off + len <= selectionOffset || selectionOffset + selectionLength <= off) {
                this.paint(gc, x, y, off, len);
                return;
            }
            if (gc.getFont() != this.font) {
                gc.setFont(this.font);
            }
            if (gc.getForeground() != this.color) {
                gc.setForeground(this.color);
            }
            int ascent = this.underline ? gc.getFontMetrics().getAscent() : 0;
            int ulx = x;
            if (off < selectionOffset) {
                String f = this.text.substring(off, selectionOffset);
                gc.drawString(f, x, y, false);
                int ext = TextMeasurer.getTextExtent(f, 0, f.length(), gc);
                x += ext;
                if (this.underline) {
                    gc.drawLine(ulx, y + ascent, ulx + ext, y + ascent);
                    ulx += ext;
                }
            }
            int postLen = off + len - (selectionOffset + selectionLength);
            Color bg = gc.getBackground();
            Color fg = gc.getForeground();
            if (fg.getRed() + fg.getGreen() + fg.getGreen() < 256) {
                gc.setBackground(selectionDark);
                gc.setForeground(selectionLight);
            } else {
                gc.setBackground(selectionLight);
                gc.setForeground(selectionDark);
            }
            String f = this.text.substring(selectionOffset, selectionOffset + selectionLength);
            gc.drawString(f, x, y, false);
            if (postLen > 0) {
                int ext = TextMeasurer.getTextExtent(f, 0, f.length(), gc);
                x += ext;
                if (this.underline) {
                    gc.drawLine(ulx, y + ascent, ulx + ext, y + ascent);
                    ulx += ext;
                }
            } else if (this.underline) {
                gc.drawLine(ulx, y + ascent, x + this.getExtent(gc), y + ascent);
            }
            gc.setBackground(bg);
            gc.setForeground(fg);
            if (postLen > 0) {
                int o = selectionOffset + selectionLength;
                f = this.text.substring(o, o + postLen);
                gc.drawString(f, x, y, false);
                if (this.underline) {
                    gc.drawLine(ulx, y + ascent, x + this.getExtent(gc), y + ascent);
                }
            }
        }

        public int getExtent(GC gc) {
            if (gc.getFont() != this.font) {
                gc.setFont(this.font);
            }
            if (this.extentCache == -1) {
                this.extentCache = TextMeasurer.getTextExtent(this.text, 0, this.text.length(), gc);
            }
            return this.extentCache;
        }

        public String toString() {
            return this.text;
        }

        public String getText() {
            return this.text;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public Font getFont() {
            return this.font;
        }

        private int getTextLength() {
            return this.text.length();
        }

        public boolean getUnderline() {
            return this.underline;
        }
    }

    private static class TextMeasurer {
        private static final Map CHAR_ADVANCE_CACHE = new HashMap();

        TextMeasurer() {
        }

        public static int getColumnIndexOf(int x, String text, int off, int len, GC gc) {
            int extent = 0;
            int[] cache = TextMeasurer.getCharAdvanceCache(gc.getFont());
            int i = 0;
            while (i < len) {
                int adv = TextMeasurer.getAdvanceWidth(cache, text.charAt(off + i), gc);
                if (x < extent + adv / 2) {
                    return i;
                }
                extent += adv;
                ++i;
            }
            return len;
        }

        public static int getTextExtent(String text, int off, int len, GC gc) {
            int extent = 0;
            int[] cache = TextMeasurer.getCharAdvanceCache(gc.getFont());
            int i = 0;
            while (i < len) {
                extent += TextMeasurer.getAdvanceWidth(cache, text.charAt(off + i), gc);
                ++i;
            }
            return extent;
        }

        private static int getAdvanceWidth(int[] cache, char ch, GC gc) {
            int w = cache[ch];
            if (w == 0) {
                cache[ch] = w = gc.getAdvanceWidth(ch);
            }
            return w;
        }

        private static int[] getCharAdvanceCache(Font font) {
            if (CHAR_ADVANCE_CACHE.containsKey(font)) {
                return (int[])CHAR_ADVANCE_CACHE.get(font);
            }
            int[] cache = new int[65536];
            CHAR_ADVANCE_CACHE.put(font, cache);
            return cache;
        }

        private static int getWrap(String text, int off, int width, GC gc) {
            int br = off;
            int len = text.length();
            int w = 0;
            int[] cache = TextMeasurer.getCharAdvanceCache(gc.getFont());
            int i = off;
            while (i < len) {
                int chw = TextMeasurer.getAdvanceWidth(cache, text.charAt(i), gc);
                if (width < w + chw) break;
                w += chw;
                ++br;
                ++i;
            }
            return br;
        }
    }

    private class PageMoveKeyListener
    implements KeyListener {
        private int keyRepeat;
        private boolean repeating;
        private long baseTime;

        PageMoveKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (this.keyRepeat == 0) {
                switch (e.keyCode) {
                    case 0x1000001: 
                    case 0x1000002: 
                    case 0x1000005: 
                    case 0x1000006: {
                        this.keyRepeat = e.keyCode;
                    }
                }
                if (e.character == ' ' || e.character == '\b') {
                    this.keyRepeat = e.character;
                }
                if (this.keyRepeat != 0) {
                    this.repeating = false;
                    long pressedTime = this.baseTime = System.currentTimeMillis();
                    int keyRepeat = this.keyRepeat;
                    ColoredText.this.getShell().getDisplay().timerExec(10, new Runnable(this, pressedTime, keyRepeat){
                        private static final int FIRST_MOVE = 70;
                        private final /* synthetic */ long val$pressedTime;
                        private final /* synthetic */ PageMoveKeyListener this$1;
                        private final /* synthetic */ int val$keyRepeat;
                        {
                            this.this$1 = pageMoveKeyListener;
                            this.val$pressedTime = l;
                            this.val$keyRepeat = n;
                        }

                        public void run() {
                            long curTime = System.currentTimeMillis();
                            if (curTime - this.val$pressedTime < 70L && !PageMoveKeyListener.access$0(this.this$1)) {
                                PageMoveKeyListener.access$5(this.this$1).getShell().getDisplay().timerExec(10, (Runnable)this);
                            }
                            if (!PageMoveKeyListener.access$0(this.this$1)) {
                                long firstPeriod = Math.min(this.val$pressedTime + 70L, curTime);
                                PageMoveKeyListener.access$2(this.this$1, this.val$keyRepeat, PageMoveKeyListener.access$5(this.this$1).getVerticalBar().getThumb() / 8 * (int)(firstPeriod - PageMoveKeyListener.access$1(this.this$1)) / 70);
                                PageMoveKeyListener.access$3(this.this$1, firstPeriod);
                            }
                        }
                    });
                } else if (e.keyCode == 0x1000007) {
                    ColoredText.this.getVerticalBar().setSelection(0);
                    ColoredText.this.redraw();
                } else if (e.keyCode == 0x1000008) {
                    ColoredText.this.getVerticalBar().setSelection(ColoredText.this.getVerticalBar().getMaximum());
                    ColoredText.this.redraw();
                }
            } else if (!this.repeating) {
                this.repeating = true;
                this.baseTime = System.currentTimeMillis();
                ColoredText.this.getShell().getDisplay().timerExec(10, new Runnable(this){
                    private static final int FIRST_MOVE = 100;
                    private final /* synthetic */ PageMoveKeyListener this$1;
                    {
                        this.this$1 = pageMoveKeyListener;
                    }

                    public void run() {
                        if (PageMoveKeyListener.access$0(this.this$1)) {
                            PageMoveKeyListener.access$5(this.this$1).getShell().getDisplay().timerExec(10, (Runnable)this);
                            long curTime = System.currentTimeMillis();
                            PageMoveKeyListener.access$2(this.this$1, PageMoveKeyListener.access$4(this.this$1), (int)((double)(curTime - PageMoveKeyListener.access$1(this.this$1)) * 1.5));
                            PageMoveKeyListener.access$3(this.this$1, curTime);
                        }
                    }
                });
            }
        }

        private void keyAction(int keyCode, int increment) {
            switch (keyCode) {
                case 0x1000002: {
                    break;
                }
                case 0x1000001: {
                    increment = -increment;
                    break;
                }
                case 32: 
                case 0x1000006: {
                    increment *= 7;
                    break;
                }
                case 8: 
                case 0x1000005: {
                    increment *= -7;
                }
            }
            ColoredText.this.getVerticalBar().setSelection(Math.min(Math.max(ColoredText.this.getVerticalBar().getSelection() + increment, 0), ColoredText.this.getVerticalBar().getMaximum()));
            ColoredText.this.redraw();
        }

        public void keyReleased(KeyEvent e) {
            this.keyRepeat = 0;
            this.repeating = false;
        }

        static /* synthetic */ boolean access$0(PageMoveKeyListener pageMoveKeyListener) {
            return pageMoveKeyListener.repeating;
        }

        static /* synthetic */ long access$1(PageMoveKeyListener pageMoveKeyListener) {
            return pageMoveKeyListener.baseTime;
        }

        static /* synthetic */ void access$2(PageMoveKeyListener pageMoveKeyListener, int n, int n2) {
            pageMoveKeyListener.keyAction(n, n2);
        }

        static /* synthetic */ void access$3(PageMoveKeyListener pageMoveKeyListener, long l) {
            pageMoveKeyListener.baseTime = l;
        }

        static /* synthetic */ int access$4(PageMoveKeyListener pageMoveKeyListener) {
            return pageMoveKeyListener.keyRepeat;
        }

        static /* synthetic */ ColoredText access$5(PageMoveKeyListener pageMoveKeyListener) {
            return pageMoveKeyListener.ColoredText.this;
        }
    }

    private class MouseDragListener
    implements MouseListener,
    MouseMoveListener,
    MouseTrackListener {
        private TextPosition selectionStart = TextPosition.INVALID;
        private TextPosition selectionEnd = TextPosition.INVALID;
        private int increment;
        private Point lastMouseLocation;
        private TextPosition lastTextPosition = TextPosition.INVALID;
        private LineFragment lastLineFragment;
        private LineFragment lastHoverLineFragment;
        private LinkTarget lastLinkTarget;

        MouseDragListener() {
        }

        public void mouseDown(MouseEvent e) {
            if (e.button == 1) {
                LineFragment f;
                ColoredText.this.toolTipLocked = false;
                ColoredText.this.disposeHover();
                ColoredText.this.setCapture(true);
                this.selectionStart = ColoredText.this.getIndexFromPoint(new Point(e.x, e.y));
                this.selectionEnd = TextPosition.INVALID;
                ColoredText.this.setSelection(TextPosition.INVALID, this.selectionEnd, true);
                ColoredText.this.getShell().getDisplay().timerExec(10, new Runnable(this){
                    private final /* synthetic */ MouseDragListener this$1;
                    {
                        this.this$1 = mouseDragListener;
                    }

                    public void run() {
                        if (MouseDragListener.access$0(this.this$1) != 0) {
                            MouseDragListener.access$5(this.this$1).getVerticalBar().setSelection(Math.min(Math.max(MouseDragListener.access$5(this.this$1).getVerticalBar().getSelection() + MouseDragListener.access$0(this.this$1), 0), MouseDragListener.access$5(this.this$1).getVerticalBar().getMaximum()));
                            MouseDragListener.access$2(this.this$1, MouseDragListener.access$5(this.this$1).getIndexFromPoint(MouseDragListener.access$1(this.this$1)));
                            MouseDragListener.access$5(this.this$1).setSelection(MouseDragListener.access$3(this.this$1), MouseDragListener.access$4(this.this$1), false);
                            MouseDragListener.access$5(this.this$1).redraw();
                        }
                        if (MouseDragListener.access$3(this.this$1).isValid()) {
                            MouseDragListener.access$5(this.this$1).getShell().getDisplay().timerExec(10, (Runnable)this);
                        }
                    }
                });
                if (this.selectionStart.isValid() && (f = ColoredText.this.getLineFragmentFromIndex(this.selectionStart)) instanceof LinkTarget) {
                    ColoredText.this.setSelection(f, true);
                    this.lastLinkTarget = (LinkTarget)((Object)f);
                }
            }
        }

        public void mouseUp(MouseEvent e) {
            LineFragment f;
            TextPosition position;
            if (e.button == 1 && this.selectionStart.equals(position = ColoredText.this.getIndexFromPoint(new Point(e.x, e.y))) && this.selectionStart.isValid() && (f = ColoredText.this.getLineFragmentFromIndex(this.selectionStart)) != null && f == this.lastLinkTarget) {
                ColoredText.this.setSelection(TextPosition.INVALID, TextPosition.INVALID, true);
                this.lastLinkTarget.linkClicked(ColoredText.this);
                this.lastLinkTarget = null;
            }
            ColoredText.this.setCapture(false);
            this.selectionStart = TextPosition.INVALID;
            this.selectionEnd = TextPosition.INVALID;
            this.increment = 0;
        }

        public void mouseDoubleClick(MouseEvent e) {
            TextPosition position = ColoredText.this.getIndexFromPoint(new Point(e.x, e.y));
            if (position.isValid()) {
                Line line = ColoredText.this.getLineAt(position.row);
                String s = line.toString();
                if (s.length() == 0) {
                    return;
                }
                if (position.column == s.length()) {
                    --position.column;
                }
                TextPosition start = new TextPosition(position.row, position.column);
                TextPosition end = new TextPosition(position.row, position.column);
                Character.UnicodeBlock block = Character.UnicodeBlock.of(s.charAt(position.column));
                while (start.column > 0 && Character.UnicodeBlock.of(s.charAt(start.column - 1)) == block) {
                    --start.column;
                }
                while (end.column < s.length() && Character.UnicodeBlock.of(s.charAt(end.column)) == block) {
                    ++end.column;
                }
                ColoredText.this.setSelection(start, end, true);
            }
        }

        public void mouseMove(MouseEvent e) {
            LineFragment f;
            Point mouseLocation = new Point(e.x, e.y);
            TextPosition position = ColoredText.this.getIndexFromPoint(mouseLocation);
            if (position.isValid() && this.lastLineFragment != (f = ColoredText.this.getLineFragmentFromIndex(position))) {
                if (this.lastLineFragment != null) {
                    ColoredText.this.fireTextEvent(new TextEvent(ColoredText.this, e, this.lastLineFragment), 1);
                }
                if (f != null) {
                    ColoredText.this.fireTextEvent(new TextEvent(ColoredText.this, e, f), 0);
                }
                this.lastLineFragment = f;
                this.lastHoverLineFragment = null;
            }
            if (this.selectionStart.isValid()) {
                this.lastMouseLocation = mouseLocation;
                this.selectionEnd = position;
                ScrollBar vertical = ColoredText.this.getVerticalBar();
                this.increment = 0;
                int h = ColoredText.this.getSize().y;
                int grad = h / 16;
                int base = h / 8;
                if (e.y < 0) {
                    this.increment = -base;
                } else if (e.y < grad && grad != 0) {
                    this.increment = -base * (grad - e.y) / grad;
                } else if (h < e.y) {
                    this.increment = base;
                } else if (h - grad < e.y && grad != 0) {
                    this.increment = base * (grad - (h - e.y)) / grad;
                }
                ColoredText.this.setSelection(this.selectionStart, this.selectionEnd, this.increment == 0);
                if (this.increment != 0) {
                    vertical.setSelection(vertical.getSelection() + this.increment);
                    ColoredText.this.redraw();
                }
            }
        }

        public void mouseEnter(MouseEvent e) {
        }

        public void mouseExit(MouseEvent e) {
        }

        public void mouseHover(MouseEvent e) {
            LineFragment f;
            Point mouseLocation;
            TextPosition position;
            if (this.lastHoverLineFragment == null && (position = ColoredText.this.getIndexFromPoint(mouseLocation = new Point(e.x, e.y))).isValid() && (f = ColoredText.this.getLineFragmentFromIndex(position)) != null) {
                this.lastHoverLineFragment = f;
                ColoredText.this.fireTextEvent(new TextEvent(ColoredText.this, e, f), 2);
            }
        }

        static /* synthetic */ int access$0(MouseDragListener mouseDragListener) {
            return mouseDragListener.increment;
        }

        static /* synthetic */ Point access$1(MouseDragListener mouseDragListener) {
            return mouseDragListener.lastMouseLocation;
        }

        static /* synthetic */ void access$2(MouseDragListener mouseDragListener, TextPosition textPosition) {
            mouseDragListener.selectionEnd = textPosition;
        }

        static /* synthetic */ TextPosition access$3(MouseDragListener mouseDragListener) {
            return mouseDragListener.selectionStart;
        }

        static /* synthetic */ TextPosition access$4(MouseDragListener mouseDragListener) {
            return mouseDragListener.selectionEnd;
        }

        static /* synthetic */ ColoredText access$5(MouseDragListener mouseDragListener) {
            return mouseDragListener.ColoredText.this;
        }
    }
}

