/*
 * Decompiled with CFR 0.152.
 */
package monalipse.editors;

import java.net.MalformedURLException;
import java.net.URL;
import monalipse.editors.ThreadEditorInput;
import monalipse.editors.ThreadViewerEditor;
import monalipse.part.CancelableRunner;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.part.EditorActionBarContributor;

public class ThreadViewerEditorActionBarContributor
extends EditorActionBarContributor {
    private CancelableRunner cancelable;
    private SubStatusLineManager statusLineManager;
    private IAction reloadAction;
    private IAction abortAction;
    private IAction browserAction;
    private IAction lockToolTipAction;
    private IAction fullReloadAction;
    private IAction copyAction;
    private IAction selectAllAction;
    private IContributionItem urlContribution;

    public ThreadViewerEditorActionBarContributor() {
        this.makeActions();
    }

    public void contributeToContextMenu(IMenuManager manager) {
        manager.add(this.reloadAction);
        manager.add(this.abortAction);
        manager.add(this.browserAction);
        manager.add(this.lockToolTipAction);
        manager.add((IContributionItem)new Separator("group.edit"));
        manager.appendToGroup("group.edit", this.copyAction);
        manager.add((IContributionItem)new Separator("group.managing"));
        manager.appendToGroup("group.managing", this.selectAllAction);
    }

    public void contributeToStatusLine(IStatusLineManager manager) {
        this.cancelable = new CancelableRunner(manager, null, this.abortAction);
    }

    public void contributeToToolBar(IToolBarManager manager) {
        manager.add(this.reloadAction);
        manager.add(this.abortAction);
        manager.add(this.browserAction);
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        this.copyAction = this.createAction("copy", 4, "IMG_CTOOL_COPY_EDIT", targetEditor);
        this.selectAllAction = this.createAction("selectAll", 7, null, targetEditor);
    }

    private void makeActions() {
        String iconPath = "icons/";
        URL installURL = Platform.getPlugin((String)"monalipse").getDescriptor().getInstallURL();
        this.reloadAction = new Action(){

            public void run() {
                IEditorPart part = ThreadViewerEditorActionBarContributor.this.getPage().getActiveEditor();
                if (part instanceof ThreadViewerEditor) {
                    ((ThreadViewerEditor)part).updateThread();
                }
            }
        };
        this.reloadAction.setText("Reload");
        this.reloadAction.setToolTipText("Reload thread");
        try {
            this.reloadAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "refresh_nav.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
        this.abortAction = new Action(){

            public void run() {
                ThreadViewerEditorActionBarContributor.this.cancelable.cancel();
            }
        };
        this.abortAction.setText("Abort");
        this.abortAction.setToolTipText("Abort all downloading thread");
        this.abortAction.setEnabled(false);
        try {
            this.abortAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "stop_nav.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
        this.browserAction = new Action(){

            public void run() {
                IEditorInput input = ThreadViewerEditorActionBarContributor.this.getPage().getActiveEditor().getEditorInput();
                if (input instanceof ThreadEditorInput) {
                    Program.launch((String)((ThreadEditorInput)input).getURLHint());
                }
            }
        };
        this.browserAction.setText("Open With Web Browser");
        this.browserAction.setToolTipText("Open With Web Browser");
        try {
            this.browserAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "webbrowser_nav.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
        this.lockToolTipAction = new Action(){

            public void run() {
                IEditorPart part = ThreadViewerEditorActionBarContributor.this.getPage().getActiveEditor();
                if (part instanceof ThreadViewerEditor) {
                    ((ThreadViewerEditor)part).lockToolTip();
                }
            }
        };
        this.lockToolTipAction.setText("Lock ToolTip");
        this.lockToolTipAction.setToolTipText("Lock ToolTip");
        this.lockToolTipAction.setEnabled(false);
        this.fullReloadAction = new Action(){

            public void run() {
                IEditorPart part = ThreadViewerEditorActionBarContributor.this.getPage().getActiveEditor();
                if (part instanceof ThreadViewerEditor) {
                    ((ThreadViewerEditor)part).disposeCache();
                    ((ThreadViewerEditor)part).updateThread();
                }
            }
        };
        this.fullReloadAction.setText("Full Reload");
        this.fullReloadAction.setToolTipText("Full Reload thread");
        try {
            this.fullReloadAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "refresh_nav.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private IAction createAction(String id, final int action, String image, final IEditorPart part) {
        Action act = new Action(WorkbenchMessages.getString((String)("Workbench." + id))){

            public void run() {
                if (part instanceof ThreadViewerEditor) {
                    ((ThreadViewerEditor)part).getTextOperationTarget().doOperation(action);
                }
            }
        };
        if (image != null) {
            act.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)image));
            act.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)(String.valueOf(image) + "_DISABLED")));
            act.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)(String.valueOf(image) + "_HOVER")));
        }
        if (part instanceof ThreadViewerEditor) {
            act.setEnabled(((ThreadViewerEditor)part).getTextOperationTarget().canDoOperation(action));
        }
        this.getActionBars().setGlobalActionHandler(id, (IAction)act);
        return act;
    }

    public void updateToolTipDependentActions() {
        IEditorPart part = this.getPage().getActiveEditor();
        if (part instanceof ThreadViewerEditor) {
            this.lockToolTipAction.setEnabled(((ThreadViewerEditor)part).isToolTipActive());
        } else {
            this.lockToolTipAction.setEnabled(false);
        }
    }

    public void updateSelectionDependentActions() {
        if (this.copyAction != null) {
            IEditorPart part = this.getPage().getActiveEditor();
            if (part instanceof ThreadViewerEditor) {
                this.copyAction.setEnabled(((ThreadViewerEditor)part).getTextOperationTarget().canDoOperation(4));
                this.selectAllAction.setEnabled(((ThreadViewerEditor)part).getTextOperationTarget().canDoOperation(7));
            } else {
                this.copyAction.setEnabled(false);
                this.selectAllAction.setEnabled(false);
            }
        }
    }

    public CancelableRunner getCancelable() {
        return this.cancelable;
    }
}

