/*
 * Decompiled with CFR 0.152.
 */
package monalipse.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import monalipse.editors.ThreadEditorInput;
import monalipse.editors.ThreadViewerEditorActionBarContributor;
import monalipse.part.CancelableRunner;
import monalipse.server.BBSServerManager;
import monalipse.server.IBBSServer;
import monalipse.server.INewResponseLineFragment;
import monalipse.server.IResponseEnumeration;
import monalipse.server.IResponseHeaderLine;
import monalipse.server.IThreadContentProvider;
import monalipse.server.IThreadToolTipProvider;
import monalipse.server.RendererResource;
import monalipse.widgets.ColoredText;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class ThreadViewerEditor
extends EditorPart
implements ColoredText.ToolTipProvider {
    private ThreadEditorInput input;
    private IThreadContentProvider content;
    private Display display;
    private ColoredText text;
    private RendererResource rendererResource;
    private int sequence;
    private int responseCount;
    private boolean writable;
    private boolean toolTipActive;
    static /* synthetic */ Class class$0;

    public void updateThread() {
        final CancelableRunner cancelable = ((ThreadViewerEditorActionBarContributor)this.getEditorSite().getActionBarContributor()).getCancelable();
        cancelable.run(this, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ThreadViewerEditor.this.updateThread(monitor, cancelable, true);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateThread(IProgressMonitor monitor, CancelableRunner cancelable, final boolean download) {
        block21: {
            block19: {
                monitor.beginTask("getting thread", 130);
                try {
                    IThreadContentProvider thread = this.getContentProvider();
                    this.display.syncExec(new Runnable(){

                        public void run() {
                            int i = 0;
                            while (i < ThreadViewerEditor.this.text.getLineCount()) {
                                ThreadViewerEditor.this.unmarkNewResponse(ThreadViewerEditor.this.text.getLineAt(i));
                                ++i;
                            }
                            ThreadViewerEditor.this.text.redraw();
                        }
                    });
                    monitor.worked(10);
                    IResponseEnumeration e = download ? thread.updateResponses(cancelable, this.sequence, this.responseCount, this.rendererResource) : thread.getResponses(this.sequence, this.responseCount, this.rendererResource);
                    this.writable = e.isWritable();
                    monitor.worked(10);
                    if (e == null) {
                        Object var20_6 = null;
                        break block19;
                    }
                    try {
                        if (!e.isPartialContent()) {
                            this.responseCount = 0;
                            this.display.syncExec(new Runnable(){

                                public void run() {
                                    ThreadViewerEditor.this.text.clear();
                                }
                            });
                        }
                        monitor.worked(10);
                        boolean showNew = false;
                        if (download) {
                            final boolean[] showNewRes = new boolean[1];
                            this.display.syncExec(new Runnable(){

                                public void run() {
                                    if (ThreadViewerEditor.this.responseCount != 0 && ThreadViewerEditor.this.saveScrollPosition() == ThreadViewerEditor.this.responseCount) {
                                        showNewRes[0] = true;
                                    }
                                }
                            });
                            showNew = showNewRes[0];
                        }
                        final int scrollTo = showNew ? this.responseCount : -1;
                        final ArrayList lines = new ArrayList();
                        long bulkWrite = System.currentTimeMillis();
                        try {
                            try {
                                int respWork = 0;
                                block8: while (e.hasNextResponse()) {
                                    int newWork = e.getProgressHint();
                                    if (respWork < newWork) {
                                        monitor.worked(newWork - respWork);
                                        respWork = newWork;
                                    }
                                    if (!e.getNextResponse(lines)) continue;
                                    if (this.responseCount == 0) {
                                        this.input.setTitle(e.getTitle());
                                        this.display.syncExec(new Runnable(){

                                            public void run() {
                                                ThreadViewerEditor.this.setTitle(ThreadViewerEditor.this.input.getTitle());
                                            }
                                        });
                                    }
                                    ++this.responseCount;
                                    if (this.responseCount < 10 || 300L < System.currentTimeMillis() - bulkWrite) {
                                        bulkWrite = System.currentTimeMillis();
                                        this.display.syncExec(new Runnable(){

                                            public void run() {
                                                if (!download) {
                                                    int i = 0;
                                                    while (i < lines.size()) {
                                                        ThreadViewerEditor.this.unmarkNewResponse((ColoredText.Line)lines.get(i));
                                                        ++i;
                                                    }
                                                }
                                                ThreadViewerEditor.this.text.addLines(lines);
                                                lines.clear();
                                            }
                                        });
                                    }
                                    if (this.responseCount != 1) continue;
                                    StringBuffer buf = new StringBuffer();
                                    int i = 0;
                                    while (true) {
                                        if (i >= lines.size()) {
                                            String tooltipText = String.valueOf(this.input.getTitle()) + "\n" + this.input.getURLHint() + "\n" + buf.toString();
                                            this.input.setToolTipText(tooltipText);
                                            this.display.syncExec(new Runnable(){

                                                public void run() {
                                                    ThreadViewerEditor.this.setTitleToolTip(ThreadViewerEditor.this.input.getToolTipText());
                                                    ThreadViewerEditor.this.setTitle(ThreadViewerEditor.this.input.getTitle());
                                                }
                                            });
                                            continue block8;
                                        }
                                        ColoredText.Line line = (ColoredText.Line)lines.get(i);
                                        buf.append(line.toString());
                                        ++i;
                                    }
                                }
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        catch (Throwable throwable) {
                            Object var16_21 = null;
                            if (lines.size() <= 0) throw throwable;
                            this.display.syncExec(new Runnable(download, lines){
                                private final /* synthetic */ boolean val$download;
                                private final /* synthetic */ List val$lines;
                                {
                                    this.val$download = bl;
                                    this.val$lines = list;
                                }

                                public void run() {
                                    if (!this.val$download) {
                                        int i = 0;
                                        while (i < this.val$lines.size()) {
                                            ThreadViewerEditor.this.unmarkNewResponse((ColoredText.Line)this.val$lines.get(i));
                                            ++i;
                                        }
                                    }
                                    ThreadViewerEditor.this.text.addLines(this.val$lines);
                                    this.val$lines.clear();
                                }
                            });
                            throw throwable;
                        }
                        Object var16_22 = null;
                        if (lines.size() > 0) {
                            this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                        }
                        this.sequence = e.getSequenceNumber();
                        if (showNew) {
                            this.display.syncExec(new Runnable(){

                                public void run() {
                                    ThreadViewerEditor.this.scrollTo(scrollTo);
                                }
                            });
                        }
                    }
                    catch (Throwable throwable) {
                        Object var18_24 = null;
                        e.close();
                        throw throwable;
                    }
                    Object var18_25 = null;
                    e.close();
                    break block21;
                }
                catch (Throwable throwable) {
                    Object var20_7 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return;
        }
        Object var20_8 = null;
        monitor.done();
    }

    private void unmarkNewResponse(ColoredText.Line line) {
        int j = 0;
        while (j < line.getLineFragmentCount()) {
            ColoredText.LineFragment f = line.getLineFragmentAt(j);
            if (f instanceof INewResponseLineFragment) {
                ((INewResponseLineFragment)((Object)f)).unmark(this.rendererResource);
            }
            ++j;
        }
    }

    public void disposeCache() {
        try {
            this.getContentProvider().getLogFile().delete(true, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
    }

    public void lockToolTip() {
        this.text.lockToolTip();
    }

    public ITextOperationTarget getTextOperationTarget() {
        return this.text;
    }

    private void scrollTo(int responseNumber) {
        int i = 0;
        while (i < this.text.getLineCount()) {
            ColoredText.Line line = this.text.getLineAt(i);
            if (line instanceof IResponseHeaderLine && ((IResponseHeaderLine)((Object)line)).getReponseNumber() == responseNumber) {
                this.text.scrollTo(new ColoredText.TextPosition(i, 0), 128);
            }
            ++i;
        }
    }

    private int saveScrollPosition() {
        ColoredText.TextPosition bottomLine = this.text.getIndexFromPoint(new Point(0, this.text.getSize().y - 1));
        if (bottomLine.isValid()) {
            int i = bottomLine.row;
            while (i >= 0) {
                ColoredText.Line line = this.text.getLineAt(i);
                if (line instanceof IResponseHeaderLine) {
                    int read = ((IResponseHeaderLine)((Object)line)).getReponseNumber();
                    try {
                        IFolder iFolder = this.input.getLogFolder();
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("monalipse.editors.ThreadViewerEditor");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        iFolder.setPersistentProperty(new QualifiedName(clazz.getName(), String.valueOf(this.input.getID()) + ".read"), String.valueOf(read));
                        IFolder iFolder2 = this.input.getLogFolder();
                        Class<?> clazz2 = class$0;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$0 = Class.forName("monalipse.editors.ThreadViewerEditor");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        iFolder2.setPersistentProperty(new QualifiedName(clazz2.getName(), String.valueOf(this.input.getID()) + ".readLine"), String.valueOf(bottomLine.row));
                    }
                    catch (CoreException coreException) {}
                    return read;
                }
                --i;
            }
        }
        return 0;
    }

    private void loadScrollPosition() {
        try {
            IFolder iFolder = this.input.getLogFolder();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("monalipse.editors.ThreadViewerEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ColoredText.TextPosition read = new ColoredText.TextPosition(Integer.parseInt(iFolder.getPersistentProperty(new QualifiedName(clazz.getName(), String.valueOf(this.input.getID()) + ".readLine"))), 0);
            this.text.scrollTo(read, 1024);
        }
        catch (CoreException coreException) {
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public IThreadContentProvider getContentProvider() {
        if (this.content == null) {
            IBBSServer server = BBSServerManager.getInstanceOf(this.input.getLogFolder().getProject(), this.getSite().getWorkbenchWindow());
            this.content = server.getThreadContentProviderOf(this.input.getBaseURL(), this.input.getLogFolder(), this.input.getID(), this.input.getName());
        }
        return this.content;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input instanceof ThreadEditorInput) {
            this.input = (ThreadEditorInput)input;
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getShell().getDisplay();
        this.rendererResource = new RendererResource((Device)this.display);
        this.text = new ColoredText(parent, 512);
        this.text.setLineSkip(this.rendererResource.lineSkip);
        this.text.setBackground(this.rendererResource.backgroundGray);
        this.text.setForeground(this.rendererResource.black);
        this.text.setToolTipProvider(this);
        this.text.addTextTrackListener(new ColoredText.TextTrackListener(){

            public void textEnter(ColoredText.TextEvent e) {
                if (e.fragment instanceof IThreadToolTipProvider) {
                    ((IThreadToolTipProvider)((Object)e.fragment)).prefetchToolTip();
                }
            }

            public void textExit(ColoredText.TextEvent e) {
            }

            public void textHover(ColoredText.TextEvent e) {
            }
        });
        this.text.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ((ThreadViewerEditorActionBarContributor)ThreadViewerEditor.this.getEditorSite().getActionBarContributor()).updateSelectionDependentActions();
            }
        });
        this.hookContextMenu();
        this.getSite().getPage().addPartListener((IPartListener)new PartActivationListener());
        CancelableRunner cancelable = ((ThreadViewerEditorActionBarContributor)this.getEditorSite().getActionBarContributor()).getCancelable();
        cancelable.setDisplay(this.display);
        this.updateThread((IProgressMonitor)new NullProgressMonitor(), cancelable, false);
        new Thread(new Runnable(){

            public void run() {
                ThreadViewerEditor.this.display.asyncExec(new Runnable(this){
                    private final /* synthetic */ 12 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        ThreadViewerEditor.access$10(12.access$0(this.this$1));
                    }
                });
            }

            static /* synthetic */ ThreadViewerEditor access$0(12 var0) {
                return var0.ThreadViewerEditor.this;
            }
        }).start();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ThreadViewerEditorActionBarContributor cont = (ThreadViewerEditorActionBarContributor)ThreadViewerEditor.this.getEditorSite().getActionBarContributor();
                cont.contributeToContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.text);
        this.text.setMenu(menu);
    }

    public Point fillToolTip(Composite parent, ColoredText text, int maxWidth, ColoredText.ToolTipTarget target) {
        if (target instanceof IThreadToolTipProvider) {
            return ((IThreadToolTipProvider)target).fillToolTip(parent, text, maxWidth);
        }
        return new Point(0, 0);
    }

    public void toolTipActivated(ColoredText text) {
        this.toolTipActive = true;
        ((ThreadViewerEditorActionBarContributor)this.getEditorSite().getActionBarContributor()).updateToolTipDependentActions();
    }

    public void toolTipDeactivated(ColoredText text) {
        this.toolTipActive = false;
        ((ThreadViewerEditorActionBarContributor)this.getEditorSite().getActionBarContributor()).updateToolTipDependentActions();
    }

    public boolean isToolTipActive() {
        return this.toolTipActive;
    }

    public void setFocus() {
        this.text.setFocus();
    }

    public void dispose() {
        if (this.text != null) {
            this.text.dispose();
        }
        this.text = null;
        if (this.rendererResource != null) {
            this.rendererResource.dispose();
        }
        this.rendererResource = null;
        super.dispose();
    }

    static /* synthetic */ void access$10(ThreadViewerEditor threadViewerEditor) {
        threadViewerEditor.loadScrollPosition();
    }

    private class PartActivationListener
    implements IPartListener {
        private boolean active = true;

        PartActivationListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            this.active = true;
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part == ThreadViewerEditor.this && this.active) {
                ThreadViewerEditor.this.saveScrollPosition();
                this.active = false;
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }
}

