/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.DisabledSubmitButtonException;
import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.FormParameter;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.IllegalSubmitButtonException;
import com.meterware.httpunit.IllegalUnnamedSubmitButtonException;
import com.meterware.httpunit.NoSuchParameterException;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.ParameterProcessor;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.PresetFormParameter;
import com.meterware.httpunit.ScriptableObject;
import com.meterware.httpunit.SubmitButton;
import com.meterware.httpunit.UploadFileSpec;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebRequestSource;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebForm
extends WebRequestSource {
    private static final FormParameter UNKNOWN_PARAMETER = new FormParameter();
    private static final String[] NO_VALUES = new String[0];
    private FormControl[] _parameters;
    private SubmitButton[] _submitButtons;
    private String _characterSet;
    private Map _formParameters;
    private Vector _buttonVector;
    private FormControl[] _presetParameters;
    private ArrayList _presets;
    private String _action;

    public String getMethod() {
        return NodeUtils.getNodeAttribute(this.getNode(), "method", "GET");
    }

    public String getAction() {
        if (this._action == null) {
            this._action = this.getDestination();
        }
        return this._action;
    }

    public boolean hasParameterNamed(String soughtName) {
        return this.getFormParameters().containsKey(soughtName);
    }

    public boolean hasParameterStartingWithPrefix(String prefix) {
        String[] names = this.getParameterNames();
        int i = 0;
        while (i < names.length) {
            if (names[i].startsWith(prefix)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public SubmitButton[] getSubmitButtons() {
        if (this._submitButtons == null) {
            Vector buttons = this.getSubmitButtonVector();
            this._submitButtons = new SubmitButton[buttons.size()];
            buttons.copyInto(this._submitButtons);
        }
        return this._submitButtons;
    }

    public SubmitButton getSubmitButton(String name) {
        SubmitButton[] buttons = this.getSubmitButtons();
        int i = 0;
        while (i < buttons.length) {
            if (buttons[i].getName().equals(name)) {
                return buttons[i];
            }
            ++i;
        }
        return null;
    }

    public SubmitButton getSubmitButton(String name, String value) {
        SubmitButton[] buttons = this.getSubmitButtons();
        int i = 0;
        while (i < buttons.length) {
            if (buttons[i].getName().equals(name) && buttons[i].getValue().equals(value)) {
                return buttons[i];
            }
            ++i;
        }
        return null;
    }

    public SubmitButton getSubmitButtonWithID(String ID) {
        SubmitButton[] buttons = this.getSubmitButtons();
        int i = 0;
        while (i < buttons.length) {
            if (buttons[i].getID().equals(ID)) {
                return buttons[i];
            }
            ++i;
        }
        return null;
    }

    public WebRequest getRequest(String submitButtonName, String submitButtonValue) {
        SubmitButton sb = this.getSubmitButton(submitButtonName, submitButtonValue);
        if (sb == null) {
            throw new IllegalSubmitButtonException(submitButtonName, submitButtonValue);
        }
        return this.getRequest(sb);
    }

    public WebRequest getRequest(String submitButtonName) {
        SubmitButton sb = this.getSubmitButton(submitButtonName);
        if (sb == null) {
            throw new IllegalSubmitButtonException(submitButtonName, "");
        }
        return this.getRequest(sb);
    }

    public WebRequest getRequest(SubmitButton button) {
        return this.getRequest(button, 0, 0);
    }

    public WebRequest getRequest(SubmitButton button, int x, int y) {
        if (button == null) {
            button = this.getDefaultButton();
        }
        if (HttpUnitOptions.getParameterValuesValidated()) {
            if (button == null) {
                throw new IllegalUnnamedSubmitButtonException();
            }
            if (!this.getSubmitButtonVector().contains(button)) {
                throw new IllegalSubmitButtonException(button);
            }
            if (button.isDisabled()) {
                throw new DisabledSubmitButtonException(button);
            }
        }
        SubmitButton[] buttons = this.getSubmitButtons();
        int i = 0;
        while (i < buttons.length) {
            buttons[i].setPressed(false);
            ++i;
        }
        button.setPressed(true);
        if (this.getMethod().equalsIgnoreCase("post")) {
            return new PostMethodWebRequest(this, button, x, y);
        }
        return new GetMethodWebRequest(this, button, x, y);
    }

    public String getParameterValue(String name) {
        String[] values = this.getParameterValues(name);
        return values.length == 0 ? null : values[0];
    }

    public String[] getOptions(String name) {
        return this.getParameter(name).getOptions();
    }

    public String[] getOptionValues(String name) {
        return this.getParameter(name).getOptionValues();
    }

    public boolean isMultiValuedParameter(String name) {
        return this.getParameter(name).isMultiValuedParameter();
    }

    public int getNumTextParameters(String name) {
        return this.getParameter(name).getNumTextParameters();
    }

    public boolean isTextParameter(String name) {
        return this.getParameter(name).isTextParameter();
    }

    void setSubmitAsMime(boolean mimeEncoded) {
        throw new IllegalStateException("May not change the encoding for a validated request created from a form");
    }

    public boolean isSubmitAsMime() {
        return "multipart/form-data".equalsIgnoreCase(NodeUtils.getNodeAttribute(this.getNode(), "enctype"));
    }

    public void reset() {
        FormControl[] controls = this.getFormControls();
        int i = 0;
        while (i < controls.length) {
            controls[i].reset();
            ++i;
        }
    }

    public Scriptable getScriptableObject() {
        return new Scriptable();
    }

    public String getCharacterSet() {
        return this._characterSet;
    }

    public boolean isFileParameter(String name) {
        return this.getParameter(name).isFileParameter();
    }

    public String[] getParameterNames() {
        ArrayList parameterNames = new ArrayList(this.getFormParameters().keySet());
        return parameterNames.toArray(new String[parameterNames.size()]);
    }

    public String[] getParameterValues(String name) {
        FormParameter parameter = this.getParameter(name);
        return parameter.getValues();
    }

    public WebRequest getRequest() {
        return this.getRequest((SubmitButton)null);
    }

    protected void addPresetParameter(String name, String value) {
        this._presets.add(new PresetFormParameter(name, value));
    }

    public void selectImageButtonPosition(SubmitButton imageButton, int x, int y) {
        imageButton.setLocation(x, y);
    }

    void recordPredefinedParameters(ParameterProcessor processor) throws IOException {
        FormControl[] controls = this.getPresetParameters();
        int i = 0;
        while (i < controls.length) {
            controls[i].addValues(processor, this.getCharacterSet());
            ++i;
        }
    }

    void recordParameters(ParameterProcessor processor) throws IOException {
        FormControl[] controls = this.getFormControls();
        int i = 0;
        while (i < controls.length) {
            controls[i].addValues(processor, this.getCharacterSet());
            ++i;
        }
    }

    public void removeParameter(String name) {
        this.setParameter(name, NO_VALUES);
    }

    public void setParameter(String name, UploadFileSpec[] files) {
        FormParameter parameter = this.getParameter(name);
        if (parameter == null) {
            throw new NoSuchParameterException(name);
        }
        parameter.setFiles(files);
    }

    public void setParameter(String name, String value) {
        this.setParameter(name, new String[]{value});
    }

    public void setParameter(String name, String[] values) {
        FormParameter parameter = this.getParameter(name);
        if (parameter == null) {
            throw new NoSuchParameterException(name);
        }
        parameter.setValues(values);
    }

    WebForm(URL baseURL, String frameName, Node node, String characterSet) {
        super(node, baseURL, NodeUtils.getNodeAttribute(node, "action"), frameName);
        this._characterSet = characterSet;
    }

    private Object getObject(String name) {
        return this.getParameter(name).getScriptableObject();
    }

    private SubmitButton getDefaultButton() {
        if (this.getSubmitButtons().length == 1) {
            return this.getSubmitButtons()[0];
        }
        if (this.getSubmitButtonVector().contains(SubmitButton.UNNAMED_BUTTON)) {
            return this.getSubmitButton("");
        }
        return null;
    }

    private Vector getSubmitButtonVector() {
        if (this._buttonVector == null) {
            this._buttonVector = new Vector();
            FormControl[] controls = this.getFormControls();
            int i = 0;
            while (i < controls.length) {
                FormControl control = controls[i];
                if (control instanceof SubmitButton) {
                    this._buttonVector.add(control);
                }
                ++i;
            }
            if (this._buttonVector.isEmpty()) {
                this._buttonVector.addElement(SubmitButton.UNNAMED_BUTTON);
            }
        }
        return this._buttonVector;
    }

    private FormControl[] getPresetParameters() {
        if (this._presetParameters == null) {
            this._presets = new ArrayList();
            this.loadDestinationParameters();
            this._presetParameters = this._presets.toArray(new FormControl[this._presets.size()]);
        }
        return this._presetParameters;
    }

    private FormControl[] getFormControls() {
        if (this._parameters == null) {
            Vector list = new Vector();
            if (this.getNode().hasChildNodes()) {
                this.addFormParametersToList(this.getNode().getChildNodes(), list);
            }
            this._parameters = new FormControl[list.size()];
            list.copyInto(this._parameters);
        }
        return this._parameters;
    }

    private FormParameter getParameter(String name) {
        FormParameter parameter = (FormParameter)this.getFormParameters().get(name);
        return parameter != null ? parameter : UNKNOWN_PARAMETER;
    }

    private Map getFormParameters() {
        if (this._formParameters == null) {
            this._formParameters = new HashMap();
            this.loadFormParameters(this.getPresetParameters());
            this.loadFormParameters(this.getFormControls());
        }
        return this._formParameters;
    }

    private void loadFormParameters(FormControl[] controls) {
        int i = 0;
        while (i < controls.length) {
            if (controls[i].getName().length() != 0) {
                FormParameter parameter = (FormParameter)this._formParameters.get(controls[i].getName());
                if (parameter == null) {
                    parameter = new FormParameter();
                    this._formParameters.put(controls[i].getName(), parameter);
                }
                parameter.addControl(controls[i]);
            }
            ++i;
        }
    }

    private void addFormParametersToList(NodeList children, Vector list) {
        int i = 0;
        while (i < children.getLength()) {
            this.addFormParametersToList(children.item(i), list);
            ++i;
        }
    }

    private void addFormParametersToList(Node child, Vector list) {
        FormControl formParameter = FormControl.newFormParameter(this, child);
        if (formParameter != null) {
            list.addElement(formParameter);
        } else if (child.hasChildNodes()) {
            this.addFormParametersToList(child.getChildNodes(), list);
        }
    }

    public class Scriptable
    implements ScriptableObject {
        public String getAction() {
            return WebForm.this.getAction();
        }

        public void setAction(String newAction) {
            WebForm.this._action = newAction;
        }

        public void setParameterValue(String name, String value) {
            WebForm.this.getParameter(name).getScriptableObject().set("value", value);
        }

        public void set(String propertyName, Object value) {
        }

        public Object get(String propertyName) {
            return null;
        }
    }
}

