/*!
    \file  Fat12File.h
    \brief Fat12File

    Copyright (c) 2005 HigePon
    WITHOUT ANY WARRANTY

    \author  HigePon
    \version $Revision: 1.2 $
    \date   create:2005/03/26 update:$Date$
*/

#ifndef _FAT12_FILE_
#define _FAT12_FILE_

#include "File.h"
#include "Fat12Directory.h"
#include "Fat12FileSystem.h"

namespace FatFS
{

class Fat12FileSystem;

/*----------------------------------------------------------------------
    Fat12File
----------------------------------------------------------------------*/
class Fat12File : public File
{
public:
    Fat12File(Fat12FileSystem* fs);
    virtual ~Fat12File();

public:
    virtual bool IsDirectory() {return false;}
    virtual dword GetSize() {return this->size;}
    virtual MonAPI::CString GetName() {return this->name;}
    virtual FileDate* GetCreateDate() {return &this->createDate;}
    virtual FileDate* GetModifiedDate() {return &this->modifiedDate;}
    virtual dword Read(void* buffer, dword size);
    virtual dword Write(void* buffer, dword size);
    virtual bool Seek(dword offset, dword origin);

public:
    virtual void SetName(MonAPI::CString name) {this->name = name;}
    virtual void SetSize(dword size) {this->size = size;}
    virtual void SetCluster(dword cluster) {this->cluster = cluster;}
    virtual dword GetCluster() const {return this->cluster;}
    virtual void SetParentEntryCluster(dword parentEntryCluster) {this->parentEntryCluster = parentEntryCluster;}
    virtual dword GetParentEntryCluster() const {return this->parentEntryCluster;}

public:
    Fat12Directory* parent;

private:
    MonAPI::CString name;
    FileDate createDate;
    FileDate modifiedDate;
    dword pointer;
    dword size;
    dword cluster;
    dword parentEntryCluster;
    Fat12FileSystem* fs;
};

} /* namespace FatFS */

#endif
